/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.docking.scoring;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.docking.LigandPose;
import com.actelion.research.chem.io.pdb.converter.MoleculeGrid;
import com.actelion.research.chem.potentialenergy.PotentialEnergyTerm;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractScoringEngine {
    private double BUMP_PENALTY = 500.0;
    private int BUMP_RADIUS = 3;
    protected Conformer receptorConf;
    protected Set<Integer> bindingSiteAtoms;
    protected LigandPose candidatePose;
    protected MoleculeGrid grid;
    protected List<PotentialEnergyTerm> constraints;

    public AbstractScoringEngine(StereoMolecule stereoMolecule, Set<Integer> set, MoleculeGrid moleculeGrid) {
        this.receptorConf = new Conformer(stereoMolecule);
        this.bindingSiteAtoms = set;
        this.grid = moleculeGrid;
        this.constraints = new ArrayList<PotentialEnergyTerm>();
    }

    public LigandPose getCandidatePose() {
        return this.candidatePose;
    }

    public double getBumpTerm() {
        double d = 0.0;
        int[] nArray = this.grid.getGridSize();
        for (int i = 0; i < this.candidatePose.getLigConf().getMolecule().getAllAtoms(); ++i) {
            Coordinates coordinates = this.candidatePose.getLigConf().getCoordinates(i);
            int[] nArray2 = this.grid.getGridCoordinates(coordinates);
            int n = nArray2[0];
            int n2 = nArray2[1];
            int n3 = nArray2[2];
            if (n < this.BUMP_RADIUS || n > nArray[0] - this.BUMP_RADIUS) {
                d = this.BUMP_PENALTY;
                break;
            }
            if (n2 < this.BUMP_RADIUS || n2 > nArray[1] - this.BUMP_RADIUS) {
                d = this.BUMP_PENALTY;
                break;
            }
            if (n3 >= this.BUMP_RADIUS && n3 <= nArray[2] - this.BUMP_RADIUS) continue;
            d = this.BUMP_PENALTY;
            break;
        }
        return d;
    }

    public void addConstraint(PotentialEnergyTerm potentialEnergyTerm) {
        this.constraints.add(potentialEnergyTerm);
    }

    public void removeConstraints() {
        this.constraints = new ArrayList<PotentialEnergyTerm>();
    }

    public abstract void init(LigandPose var1, double var2);

    public abstract void updateState();

    public abstract double getFGValue(double[] var1);

    public abstract double getScore();

    public abstract Map<String, Double> getContributions();

    public Conformer getReceptorConf() {
        return this.receptorConf;
    }
}

