/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.pharmacophoretree;

import com.actelion.research.chem.descriptor.pharmacophoretree.PharmacophoreTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TreeUtils {
    private static void binaryInsert(double[] dArray, int[][] nArray, double d, int[] nArray2) {
        int n = dArray.length;
        int n2 = Arrays.binarySearch(dArray, d);
        if (n2 < 0 && (n2 = -n2 - 1) < n) {
            double d2 = dArray[n2];
            int[] nArray3 = nArray[n2];
            dArray[n2] = d;
            nArray[n2] = nArray2;
            for (int i = n2 + 1; i < n; ++i) {
                double d3 = dArray[i];
                int[] nArray4 = nArray[i];
                dArray[i] = d2;
                nArray[i] = nArray3;
                d2 = d3;
                nArray3 = nArray4;
            }
        }
    }

    public static void retrieveHighestValuesFrom2DArray(double[][] dArray, double[] dArray2, int[][] nArray) {
        Arrays.fill(dArray2, 1.0);
        int[][] nArray2 = nArray;
        int n = nArray2.length;
        for (int i = 0; i < n; ++i) {
            int[] nArray3 = nArray2[i];
            Arrays.fill(nArray3, -1);
        }
        for (int i = 0; i < dArray.length; ++i) {
            for (n = i; n < dArray[0].length; ++n) {
                TreeUtils.binaryInsert(dArray2, nArray, -dArray[i][n], new int[]{i, n});
            }
        }
    }

    public static Map<Integer, List<Integer>> getAdjacencyList(int n, List<int[]> list) {
        HashMap<Integer, List<Integer>> hashMap = new HashMap<Integer, List<Integer>>();
        for (int i = 0; i < n; ++i) {
            hashMap.putIfAbsent(i, new ArrayList());
        }
        for (int[] nArray : list) {
            int n2 = nArray[0];
            int n3 = nArray[1];
            ((List)hashMap.get(n2)).add(n3);
            ((List)hashMap.get(n3)).add(n2);
        }
        return hashMap;
    }

    public static Map<Integer, Map<Integer, Integer>> getAdjacencyListWithBondOrders(int n, List<PharmacophoreTree.BiGramInt> list) {
        HashMap<Integer, Map<Integer, Integer>> hashMap = new HashMap<Integer, Map<Integer, Integer>>();
        for (int i = 0; i < n; ++i) {
            hashMap.putIfAbsent(i, new HashMap());
        }
        for (PharmacophoreTree.BiGramInt biGramInt : list) {
            int n2 = biGramInt.edge[0];
            int n3 = biGramInt.edge[1];
            ((Map)hashMap.get(n2)).put(n3, biGramInt.order);
            ((Map)hashMap.get(n3)).put(n2, biGramInt.order);
        }
        return hashMap;
    }
}

