/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.pharmacophoretree;

import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.BondLengthSet;
import com.actelion.research.chem.conf.VDWRadii;
import com.actelion.research.chem.descriptor.pharmacophoretree.FeatureCalculator;
import com.actelion.research.chem.descriptor.pharmacophoretree.Graph;
import com.actelion.research.chem.descriptor.pharmacophoretree.PharmacophoreNode;
import com.actelion.research.chem.descriptor.pharmacophoretree.PharmacophoreTree;
import com.actelion.research.chem.descriptor.pharmacophoretree.TreeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openmolecules.chem.conf.gen.ConformerGenerator;

public class PharmacophoreTreeGenerator {
    public static final int MAX_RING_SIZE = 50;
    public static final Set<String> RGROUPS = new HashSet<String>(Arrays.asList("R1", "R2", "R3", "R4"));

    private PharmacophoreTreeGenerator() {
    }

    public static PharmacophoreTree generate(StereoMolecule stereoMolecule) {
        return PharmacophoreTreeGenerator.generate(stereoMolecule, new HashMap<Integer, List<Integer>>(), new ArrayList<Set<Integer>>());
    }

    public static PharmacophoreTree generate(StereoMolecule stereoMolecule, Map<Integer, List<Integer>> map, List<Set<Integer>> list) {
        Object object;
        Object object2;
        int n;
        stereoMolecule.ensureHelperArrays(31);
        ConformerGenerator.addHydrogenAtoms(stereoMolecule);
        stereoMolecule.ensureHelperArrays(31);
        double[] dArray = PharmacophoreTreeGenerator.getAtomVolumes(stereoMolecule);
        ArrayList<PharmacophoreNode> arrayList = new ArrayList<PharmacophoreNode>();
        ArrayList<PharmacophoreTree.BiGramInt> arrayList2 = new ArrayList<PharmacophoreTree.BiGramInt>();
        ArrayList<Set<Integer>> arrayList3 = new ArrayList<Set<Integer>>();
        ArrayList<int[]> arrayList4 = new ArrayList<int[]>();
        PharmacophoreTreeGenerator.createRingGraphs(stereoMolecule, arrayList3, arrayList4, list);
        FeatureCalculator featureCalculator = new FeatureCalculator(stereoMolecule);
        featureCalculator.calculate();
        int[][] nArray = featureCalculator.getAtomFunctionalities();
        for (n = 0; n < arrayList3.size(); ++n) {
            object2 = (Set)arrayList3.get(n);
            object = new PharmacophoreNode(new ArrayList<Integer>((Collection<Integer>)object2), nArray, dArray, false, false);
            PharmacophoreTreeGenerator.addNode((PharmacophoreNode)object, arrayList, map);
        }
        for (n = 0; n < arrayList4.size(); ++n) {
            object2 = new PharmacophoreTree.BiGramInt((int[])arrayList4.get(n));
            if (arrayList2.contains(object2)) continue;
            arrayList2.add((PharmacophoreTree.BiGramInt)object2);
        }
        PharmacophoreTreeGenerator.treeWalk(0, stereoMolecule, map, arrayList, arrayList2, nArray, dArray);
        Map<Integer, List<Integer>> map2 = TreeUtils.getAdjacencyList(arrayList.size(), arrayList2.stream().map(biGramInt -> biGramInt.edge).collect(Collectors.toList()));
        object2 = new Graph(map2);
        object = new HashSet();
        List<List<int[]>> list2 = ((Graph)object2).bcc();
        for (List<int[]> list3 : list2) {
            if (list3.size() <= 1) continue;
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int[] nArray2 : list3) {
                hashSet.add(nArray2[0]);
                hashSet.add(nArray2[1]);
                object.add(new PharmacophoreTree.BiGramInt(nArray2));
            }
            PharmacophoreNode pharmacophoreNode = new PharmacophoreNode(new ArrayList<Integer>(), nArray, dArray, 1, false, false);
            PharmacophoreTreeGenerator.addNode(pharmacophoreNode, arrayList, map);
            int n2 = arrayList.size() - 1;
            for (Integer n3 : hashSet) {
                arrayList2.add(new PharmacophoreTree.BiGramInt(new int[]{n3, n2}));
            }
        }
        arrayList2.removeAll((Collection<?>)object);
        for (PharmacophoreNode pharmacophoreNode : arrayList) {
            pharmacophoreNode.updateWeights(map);
        }
        return new PharmacophoreTree(arrayList, arrayList2.stream().map(biGramInt -> biGramInt.edge).collect(Collectors.toList()));
    }

    private static void treeWalk(int n, StereoMolecule stereoMolecule, Map<Integer, List<Integer>> map, List<PharmacophoreNode> list, List<PharmacophoreTree.BiGramInt> list2, int[][] nArray, double[] dArray) {
        boolean[] blArray = new boolean[stereoMolecule.getAtoms()];
        int[] nArray2 = new int[stereoMolecule.getAtoms()];
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        linkedList.add(n);
        nArray2[n] = -1;
        blArray[n] = true;
        while (!linkedList.isEmpty()) {
            PharmacophoreTree.BiGramInt biGramInt;
            int n2;
            Iterator<Object> iterator;
            Object object;
            Object object2;
            int n3 = (Integer)linkedList.poll();
            blArray[n3] = true;
            if (!stereoMolecule.isRingAtom(n3) && map.get(n3) == null) {
                object2 = stereoMolecule.getAtomLabel(n3);
                if (RGROUPS.contains(object2)) {
                    object = new PharmacophoreNode(Arrays.asList(n3), nArray, dArray, 7, false, false);
                    ((PharmacophoreNode)object).getFunctionalities()[0] = Integer.parseInt(((String)object2).split("R")[1]);
                } else {
                    object = new PharmacophoreNode(Arrays.asList(n3), nArray, dArray, false, false);
                }
                PharmacophoreTreeGenerator.addNode((PharmacophoreNode)object, list, map);
                int n4 = list.size() - 1;
                if (nArray2[n3] != -1) {
                    List<Integer> list3 = map.get(nArray2[n3]);
                    iterator = list3.iterator();
                    while (iterator.hasNext()) {
                        n2 = (Integer)iterator.next();
                        biGramInt = new PharmacophoreTree.BiGramInt(new int[]{n2, n4});
                        if (list2.contains(biGramInt)) continue;
                        list2.add(biGramInt);
                    }
                }
            } else {
                object2 = map.get(n3);
                if (nArray2[n3] != -1) {
                    object = map.get(nArray2[n3]);
                    Iterator iterator2 = object2.iterator();
                    while (iterator2.hasNext()) {
                        int n5 = (Integer)iterator2.next();
                        iterator = object.iterator();
                        while (iterator.hasNext()) {
                            n2 = (Integer)iterator.next();
                            if (n2 == n5 || list2.contains(biGramInt = new PharmacophoreTree.BiGramInt(new int[]{n2, n5}))) continue;
                            list2.add(biGramInt);
                        }
                    }
                }
            }
            for (int i = 0; i < stereoMolecule.getConnAtoms(n3); ++i) {
                int n6 = stereoMolecule.getConnAtom(n3, i);
                if (blArray[n6]) continue;
                linkedList.add(n6);
                nArray2[n6] = n3;
            }
        }
    }

    public static void addNode(PharmacophoreNode pharmacophoreNode, List<PharmacophoreNode> list, Map<Integer, List<Integer>> map) {
        int n = list.size();
        list.add(pharmacophoreNode);
        for (int n2 : pharmacophoreNode.getAtoms()) {
            map.putIfAbsent(n2, new ArrayList());
            map.get(n2).add(n);
        }
    }

    private static void createRingGraphs(StereoMolecule stereoMolecule, List<Set<Integer>> list, List<int[]> list2, List<Set<Integer>> list3) {
        Object object;
        Object object2;
        int n2;
        RingCollection ringCollection = new RingCollection(stereoMolecule, 3, 50);
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (n2 = 0; n2 < stereoMolecule.getAtoms(); ++n2) {
            object2 = PharmacophoreTreeGenerator.getSmallestRingsOfAtom(ringCollection, n2);
            Iterator<Integer> iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                Set set = Arrays.stream(ringCollection.getRingAtoms((Integer)object)).boxed().collect(Collectors.toSet());
                if (list3.contains(set)) continue;
                list3.add(set);
            }
        }
        for (n2 = 0; n2 < list3.size(); ++n2) {
            object2 = list3.get(n2);
            for (int i = n2 + 1; i < list3.size(); ++i) {
                object = list3.get(i);
                long l = object2.stream().filter(arg_0 -> PharmacophoreTreeGenerator.lambda$createRingGraphs$2((Set)object, arg_0)).count();
                if (l <= 0L) continue;
                arrayList.add(new int[]{n2, i});
            }
        }
        Map<Integer, List<Integer>> map = TreeUtils.getAdjacencyList(list3.size(), arrayList);
        object2 = new Graph(map);
        List<List<int[]>> list4 = ((Graph)object2).bcc();
        object = new ArrayList();
        for (List<int[]> collection : list4) {
            if (collection.size() <= 1) continue;
            HashSet hashSet = new HashSet();
            for (int[] nArray : collection) {
                hashSet.addAll(list3.get(nArray[0]));
                hashSet.addAll(list3.get(nArray[1]));
                object.add(list3.get(nArray[0]));
                object.add(list3.get(nArray[1]));
            }
            list.add(hashSet);
        }
        list3.removeAll((Collection<?>)object);
        for (Set set : list3) {
            list.add(set);
        }
        for (int i = 0; i < list.size(); ++i) {
            Set<Integer> set = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                Set<Integer> set2 = list.get(j);
                long l = set.stream().filter(n -> set.contains(n)).count();
                if (l <= 0L) continue;
                list2.add(new int[]{i, j});
            }
        }
    }

    public static List<Integer> getSmallestRingsOfAtom(RingCollection ringCollection, int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = ringCollection.getAtomRingSize(n);
        for (int i = 0; i < ringCollection.getSize(); ++i) {
            Set set = Arrays.stream(ringCollection.getRingAtoms(i)).boxed().collect(Collectors.toSet());
            if (set.size() > n2 || !set.contains(n)) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    public static double[] getAtomVolumes(StereoMolecule stereoMolecule) {
        int n;
        double[] dArray = new double[stereoMolecule.getAtoms()];
        for (n = 0; n < stereoMolecule.getAtoms(); ++n) {
            dArray[n] = PharmacophoreTreeGenerator.getAtomicVdWVolume(stereoMolecule.getAtomicNo(n));
        }
        for (n = 0; n < stereoMolecule.getBonds(); ++n) {
            int n2 = stereoMolecule.getBondAtom(0, n);
            int n3 = stereoMolecule.getBondAtom(1, n);
            double[] dArray2 = PharmacophoreTreeGenerator.calculateCapVolumesIntersectingAtomSpheres(stereoMolecule, n2, n3);
            int n4 = n2;
            dArray[n4] = dArray[n4] - dArray2[0];
            int n5 = n3;
            dArray[n5] = dArray[n5] - dArray2[1];
        }
        return dArray;
    }

    private static double getAtomicVdWVolume(int n) {
        double d = 0.0;
        if (n < VDWRadii.VDW_RADIUS.length) {
            d = VDWRadii.VDW_RADIUS[n];
        }
        return 4.1887902047863905 * Math.pow(d, 3.0);
    }

    private static double[] calculateCapVolumesIntersectingAtomSpheres(StereoMolecule stereoMolecule, int n, int n2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (stereoMolecule.getAtomicNo(n) < VDWRadii.VDW_RADIUS.length && stereoMolecule.getAtomicNo(n2) < VDWRadii.VDW_RADIUS.length) {
            double d5;
            d = VDWRadii.VDW_RADIUS[stereoMolecule.getAtomicNo(n)];
            d2 = VDWRadii.VDW_RADIUS[stereoMolecule.getAtomicNo(n2)];
            int n3 = stereoMolecule.getBond(n, n2);
            double d6 = BondLengthSet.lookupBondLength(stereoMolecule, n3);
            double d7 = d5 = (d6 * d6 - d * d + d2 * d2) / (2.0 * d6);
            double d8 = d6 - d5;
            double d9 = d - d7;
            double d10 = d2 - d8;
            d3 = 1.0471975511965976 * d9 * d9 + (3.0 * d - d9);
            d4 = 1.0471975511965976 * d10 * d10 + (3.0 * d2 - d10);
        }
        return new double[]{d3, d4};
    }

    private static /* synthetic */ boolean lambda$createRingGraphs$2(Set set, Integer n) {
        return set.contains(n);
    }
}

