/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore.generator;

import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.coords.CoordinateInventor;
import com.actelion.research.chem.descriptor.flexophore.MolDistHistViz;
import com.actelion.research.chem.descriptor.flexophore.UnparametrizedAtomTypeException;
import com.actelion.research.chem.descriptor.flexophore.generator.CreatorMolDistHistViz;
import com.actelion.research.util.datamodel.IDCodeCoord;

public class FlexophoreCreateFunctions {
    public static MolDistHistViz create(String string) throws UnparametrizedAtomTypeException {
        IDCodeParser iDCodeParser = new IDCodeParser();
        StereoMolecule stereoMolecule = iDCodeParser.getCompactMolecule(string);
        CoordinateInventor coordinateInventor = new CoordinateInventor();
        coordinateInventor.invent(stereoMolecule);
        return FlexophoreCreateFunctions.createDescriptor(stereoMolecule);
    }

    public static MolDistHistViz create(String string, String string2) throws UnparametrizedAtomTypeException {
        IDCodeParser iDCodeParser = new IDCodeParser();
        StereoMolecule stereoMolecule = iDCodeParser.getCompactMolecule(string, string2);
        if (string2 == null) {
            CoordinateInventor coordinateInventor = new CoordinateInventor();
            coordinateInventor.invent(stereoMolecule);
        }
        return FlexophoreCreateFunctions.createDescriptor(stereoMolecule);
    }

    public static MolDistHistViz create(IDCodeCoord iDCodeCoord) throws UnparametrizedAtomTypeException {
        return FlexophoreCreateFunctions.create(iDCodeCoord.getIdcode(), iDCodeCoord.getCoordinates());
    }

    public static MolDistHistViz createDescriptor(StereoMolecule stereoMolecule) {
        StereoMolecule stereoMolecule2 = stereoMolecule;
        stereoMolecule2.stripSmallFragments();
        stereoMolecule2.ensureHelperArrays(31);
        MolDistHistViz molDistHistViz = null;
        try {
            molDistHistViz = CreatorMolDistHistViz.getInstance().create(stereoMolecule);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return molDistHistViz;
    }
}

