/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore.generator;

import com.actelion.research.calc.ThreadMaster;
import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.ExtendedMoleculeFunctions;
import com.actelion.research.chem.Molecule3D;
import com.actelion.research.chem.MoleculeStandardizer;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.descriptor.flexophore.ExceptionConformationGenerationFailed;
import com.actelion.research.chem.descriptor.flexophore.MolDistHistViz;
import com.actelion.research.chem.descriptor.flexophore.PPNodeViz;
import com.actelion.research.chem.descriptor.flexophore.generator.MultCoordFragIndex;
import com.actelion.research.chem.descriptor.flexophore.redgraph.SubGraphExtractor;
import com.actelion.research.chem.descriptor.flexophore.redgraph.SubGraphIndices;
import com.actelion.research.chem.interactionstatistics.InteractionAtomTypeCalculator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.openmolecules.chem.conf.gen.ConformerGenerator;
import org.openmolecules.chem.conf.gen.RigidFragmentCache;

public class CreatorMolDistHistViz {
    private static final boolean DEBUG = false;
    public static final long SEED = 123456789L;
    private static final int MAX_NUM_TRIES = 10000;
    private static final int MAX_NUM_ATOMS = 1000;
    private static final int CONF_GEN_TS = 0;
    public static final int CONF_GIVEN_SINGLE_CONFORMATION = 1;
    public static final int SINGLE_CONFORMATION = 2;
    private static CreatorMolDistHistViz INSTANCE;
    private SubGraphExtractor subGraphExtractor = new SubGraphExtractor();
    private ConformerGenerator conformerGenerator = new ConformerGenerator(this.seed, false);
    private int conformationMode;
    private long seed = 123456789L;
    private boolean onlyOneConformer;
    private int[] arrIndexAtomNewTmp;

    public CreatorMolDistHistViz() {
        RigidFragmentCache.getDefaultInstance().loadDefaultCache();
        this.conformationMode = 0;
        this.arrIndexAtomNewTmp = new int[1000];
    }

    public void setThreadMaster(ThreadMaster threadMaster) {
        this.conformerGenerator.setThreadMaster(threadMaster);
    }

    public void setConformationMode(int n) {
        this.conformationMode = n;
    }

    public MolDistHistViz create(StereoMolecule stereoMolecule) throws Exception {
        MolDistHistViz molDistHistViz = null;
        switch (this.conformationMode) {
            case 0: {
                molDistHistViz = this.createMultipleConformations(stereoMolecule, 250);
                break;
            }
            case 1: {
                molDistHistViz = this.createFromGivenConformation(stereoMolecule);
                break;
            }
            case 2: {
                molDistHistViz = this.createMultipleConformations(stereoMolecule, 1);
                break;
            }
            default: {
                throw new RuntimeException("Invalid conformation mode");
            }
        }
        return molDistHistViz;
    }

    public MolDistHistViz createMultipleConformations(StereoMolecule stereoMolecule, int n) throws Exception {
        StereoMolecule stereoMolecule2 = stereoMolecule.getCompactCopy();
        MoleculeStandardizer.standardize(stereoMolecule2, 1);
        stereoMolecule2.ensureHelperArrays(7);
        Molecule3D molecule3D = new Molecule3D(stereoMolecule2);
        molecule3D.ensureHelperArrays(7);
        this.conformerGenerator.initializeConformers(molecule3D, 3, 10000, false);
        InteractionAtomTypeCalculator.setInteractionTypes(molecule3D);
        List<SubGraphIndices> list = this.subGraphExtractor.extract(molecule3D);
        list = CreatorMolDistHistViz.handleCarbonConnected2Hetero(list, molecule3D);
        int n2 = molecule3D.getAtoms();
        ArrayList<MultCoordFragIndex> arrayList = new ArrayList<MultCoordFragIndex>();
        for (SubGraphIndices subGraphIndices : list) {
            arrayList.add(new MultCoordFragIndex(subGraphIndices.getAtomIndices()));
        }
        Molecule3D molecule3D2 = CreatorMolDistHistViz.createConformations(molecule3D, arrayList, n, this.conformerGenerator);
        int n3 = this.conformerGenerator.getPotentialConformerCount();
        this.onlyOneConformer = false;
        if (n3 > 1 && ((MultCoordFragIndex)arrayList.get(0)).getCoordinates().size() == 1) {
            this.onlyOneConformer = true;
        }
        MolDistHistViz molDistHistViz = CreatorMolDistHistViz.create(arrayList, molecule3D2);
        return molDistHistViz;
    }

    public static Molecule3D createConformations(Molecule3D molecule3D, List<MultCoordFragIndex> list, int n, ConformerGenerator conformerGenerator) {
        boolean bl;
        int n2 = molecule3D.getAtoms();
        int n3 = 0;
        Molecule3D molecule3D2 = null;
        for (int i = 0; i < n && (bl = CreatorMolDistHistViz.generateConformerAndSetCoordinates(conformerGenerator, n2, molecule3D)); ++i) {
            ++n3;
            CreatorMolDistHistViz.calcFragmentCenter(molecule3D, list);
            if (i != 0) continue;
            molecule3D2 = CreatorMolDistHistViz.createPharmacophorePoints(molecule3D, list);
        }
        if (n3 == 0) {
            throw new ExceptionConformationGenerationFailed("Impossible to generate one conformer!");
        }
        return molecule3D2;
    }

    public static List<SubGraphIndices> handleCarbonConnected2Hetero(List<SubGraphIndices> list, StereoMolecule stereoMolecule) {
        ArrayList<SubGraphIndices> arrayList = new ArrayList<SubGraphIndices>();
        for (SubGraphIndices subGraphIndices : list) {
            int[] nArray = subGraphIndices.getAtomIndices();
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int n2 : nArray) {
                if (!ExtendedMoleculeFunctions.isCarbonConnected2Hetero(stereoMolecule, n2) || !ExtendedMoleculeFunctions.isIsolatedCarbon(stereoMolecule, n2, nArray)) continue;
                hashSet.add(n2);
            }
            Object object = new SubGraphIndices();
            if (hashSet.size() > 0) {
                int[] nArray2 = nArray;
                int n = nArray2.length;
                for (int n2 = 0; n2 < n; ++n2) {
                    int n3 = nArray2[n2];
                    if (hashSet.contains(n3)) continue;
                    ((SubGraphIndices)object).addIndex(n3);
                }
            } else {
                ((SubGraphIndices)object).addIndex(nArray);
            }
            if (((SubGraphIndices)object).getNumIndices() <= 0) continue;
            arrayList.add((SubGraphIndices)object);
        }
        return arrayList;
    }

    public static MolDistHistViz create(List<MultCoordFragIndex> list, Molecule3D molecule3D) {
        Object[] objectArray;
        int n;
        MolDistHistViz molDistHistViz = new MolDistHistViz(list.size(), molecule3D);
        ArrayList<PPNodeViz> arrayList = new ArrayList<PPNodeViz>();
        for (n = 0; n < list.size(); ++n) {
            MultCoordFragIndex multCoordFragIndex = list.get(n);
            objectArray = multCoordFragIndex.getArrIndexFrag();
            PPNodeViz pPNodeViz = new PPNodeViz();
            pPNodeViz.setIndex(n);
            pPNodeViz.setCoordinates(list.get(n).getCoordinates().get(0));
            for (int n2 : objectArray) {
                int n3 = molecule3D.getInteractionAtomType(n2);
                pPNodeViz.add(n3);
                pPNodeViz.addIndexOriginalAtom(n2);
            }
            arrayList.add(pPNodeViz);
        }
        molDistHistViz.set(arrayList);
        for (n = 0; n < list.size(); ++n) {
            for (int i = n + 1; i < list.size(); ++i) {
                objectArray = MultCoordFragIndex.getDistHist(list.get(n), list.get(i));
                molDistHistViz.setDistHist(n, i, (byte[])objectArray);
            }
        }
        molDistHistViz.realize();
        return molDistHistViz;
    }

    private static Molecule3D createPharmacophorePoints(Molecule3D molecule3D, List<MultCoordFragIndex> list) {
        Molecule3D molecule3D2 = new Molecule3D(molecule3D);
        molecule3D2.ensureHelperArrays(7);
        for (MultCoordFragIndex multCoordFragIndex : list) {
            int[] nArray = multCoordFragIndex.getArrIndexFrag();
            Coordinates coordinates = ExtendedMolecule.getCenterGravity(molecule3D2, nArray);
            for (int i = 0; i < nArray.length; ++i) {
                int n = molecule3D2.getInteractionAtomType(nArray[i]);
                if (n == -1) continue;
                int n2 = molecule3D2.getAtomicNo(nArray[i]);
                molecule3D2.setAtomFlag(nArray[i], 8, true);
                int n3 = nArray[i];
                int n4 = molecule3D2.addAtom(n2);
                molecule3D2.setInteractionAtomType(n4, n);
                String string = Integer.toString(n3);
                molecule3D2.setAtomChainId(n4, string);
                molecule3D2.setCoordinates(n4, coordinates);
                molecule3D2.setAtomFlag(n4, 16, true);
                molecule3D2.setPPP(n4, nArray);
            }
        }
        molecule3D2.ensureHelperArrays(7);
        return molecule3D2;
    }

    public void injectNewSeed() {
        this.seed = new Date().getTime();
        this.conformerGenerator = new ConformerGenerator(this.seed, false);
    }

    public boolean isOnlyOneConformer() {
        return this.onlyOneConformer;
    }

    public MolDistHistViz createFromGivenConformation(StereoMolecule stereoMolecule) {
        Molecule3D molecule3D = new Molecule3D(stereoMolecule);
        molecule3D.ensureHelperArrays(7);
        InteractionAtomTypeCalculator.setInteractionTypes(molecule3D);
        Molecule3D molecule3D2 = new Molecule3D(molecule3D);
        molecule3D2.ensureHelperArrays(7);
        List<SubGraphIndices> list = this.subGraphExtractor.extract(molecule3D2);
        list = CreatorMolDistHistViz.handleCarbonConnected2Hetero(list, molecule3D2);
        ArrayList<MultCoordFragIndex> arrayList = new ArrayList<MultCoordFragIndex>();
        for (SubGraphIndices subGraphIndices : list) {
            arrayList.add(new MultCoordFragIndex(subGraphIndices.getAtomIndices()));
        }
        CreatorMolDistHistViz.calcFragmentCenter(molecule3D, arrayList);
        MolDistHistViz molDistHistViz = CreatorMolDistHistViz.create(arrayList, molecule3D);
        return molDistHistViz;
    }

    public static boolean generateConformerAndSetCoordinates(ConformerGenerator conformerGenerator, int n, Molecule3D molecule3D) {
        boolean bl = false;
        Conformer conformer = conformerGenerator.getNextConformer();
        if (conformer != null) {
            for (int i = 0; i < n; ++i) {
                double d = conformer.getX(i);
                double d2 = conformer.getY(i);
                double d3 = conformer.getZ(i);
                molecule3D.setAtomX(i, d);
                molecule3D.setAtomY(i, d2);
                molecule3D.setAtomZ(i, d3);
            }
            bl = true;
        }
        return bl;
    }

    public static void calcFragmentCenter(Molecule3D molecule3D, List<MultCoordFragIndex> list) {
        for (MultCoordFragIndex multCoordFragIndex : list) {
            int[] nArray = multCoordFragIndex.getArrIndexFrag();
            Coordinates coordinates = ExtendedMolecule.getCenterGravity(molecule3D, nArray);
            multCoordFragIndex.addCoord(coordinates);
        }
    }

    public static CreatorMolDistHistViz getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CreatorMolDistHistViz();
        }
        return INSTANCE;
    }
}

