/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore.entity;

import com.actelion.research.util.datamodel.ByteVec;
import com.actelion.research.util.datamodel.IntArray;

public class Linker {
    private static final int CAPACITY_ATOMINDEX = 12;
    private int id;
    private byte[] arrDistanceHistogram;
    private String idcode;
    private IntArray iaOriginalAtomIndex;
    private int idFlexophorePoint1;
    private int idFlexophorePoint2;
    private int hash;

    public Linker(int n) {
        this.id = n;
        this.hash = -1;
        this.iaOriginalAtomIndex = new IntArray(12);
    }

    public void calculateHashCode() {
        if (this.arrDistanceHistogram == null || this.idcode == null) {
            this.hash = -1;
            return;
        }
        int n = ByteVec.getHashCode(this.arrDistanceHistogram);
        int n2 = this.idcode.hashCode();
        this.hash = n ^ n2;
    }

    public int getId() {
        return this.id;
    }

    public int hashCode() {
        return this.hash;
    }

    public void addOriginalAtomIndex(int n) {
        this.iaOriginalAtomIndex.add(n);
    }

    public void addOriginalAtomIndex(int[] nArray) {
        this.iaOriginalAtomIndex.add(nArray);
    }

    public int[] getOriginalAtomIndex() {
        return this.iaOriginalAtomIndex.get();
    }

    public byte[] getDistanceHistogram() {
        return this.arrDistanceHistogram;
    }

    public void setDistanceHistogram(byte[] byArray) {
        this.arrDistanceHistogram = byArray;
        this.calculateHashCode();
    }

    public String getIdCode() {
        return this.idcode;
    }

    public void setIdCode(String string) {
        this.idcode = string;
        this.calculateHashCode();
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (!(object instanceof Linker)) {
            return false;
        }
        Linker linker = (Linker)object;
        if (this.arrDistanceHistogram == null && linker.arrDistanceHistogram != null) {
            return false;
        }
        if (this.arrDistanceHistogram != null && linker.arrDistanceHistogram == null) {
            return false;
        }
        if (this.idcode == null && linker.idcode != null) {
            return false;
        }
        if (this.idcode != null && linker.idcode == null) {
            return false;
        }
        if (this.arrDistanceHistogram != null && linker.arrDistanceHistogram != null && this.arrDistanceHistogram.length == linker.arrDistanceHistogram.length) {
            for (int i = 0; i < this.arrDistanceHistogram.length; ++i) {
                if (this.arrDistanceHistogram[i] == linker.arrDistanceHistogram[i]) continue;
                bl = false;
                break;
            }
        }
        if (this.idcode != null && linker.idcode != null && !this.idcode.equals(linker.idcode)) {
            bl = false;
        }
        return bl;
    }

    public int getIdFlexophorePoint1() {
        return this.idFlexophorePoint1;
    }

    public void setIdFlexophorePoint1(int n) {
        this.idFlexophorePoint1 = n;
    }

    public int getIdFlexophorePoint2() {
        return this.idFlexophorePoint2;
    }

    public void setIdFlexophorePoint2(int n) {
        this.idFlexophorePoint2 = n;
    }
}

