/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore.entity;

import com.actelion.research.chem.descriptor.flexophore.entity.AtomIndexLinkerId;
import com.actelion.research.util.datamodel.IntArray;
import java.util.ArrayList;
import java.util.List;

public class FlexophorePoint {
    private static final int CAPACITY_IATYPE = 6;
    private static final int CAPACITY_ATOMINDEX = 12;
    private IntArray iaInteractionType;
    private IntArray iaOriginalAtomIndex;
    private List<AtomIndexLinkerId> liAtomIndexLinkerId;
    private String idcode;
    public int id;
    public int hash;

    public FlexophorePoint(int n) {
        this.id = n;
        this.hash = -1;
        this.iaInteractionType = new IntArray(6);
        this.iaOriginalAtomIndex = new IntArray(12);
        this.liAtomIndexLinkerId = new ArrayList<AtomIndexLinkerId>();
    }

    public int getId() {
        return this.id;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (!(object instanceof FlexophorePoint)) {
            return false;
        }
        FlexophorePoint flexophorePoint = (FlexophorePoint)object;
        if (!this.idcode.equals(flexophorePoint.idcode)) {
            bl = false;
        } else if (!this.iaInteractionType.equals(flexophorePoint.iaInteractionType)) {
            bl = false;
        }
        return bl;
    }

    public void calculateHashCode() {
        if (this.idcode == null) {
            this.hash = -1;
            return;
        }
        int n = this.idcode.hashCode();
        int n2 = this.iaInteractionType.hashCode();
        this.hash = n2 ^ n;
    }

    public int hashCode() {
        return this.hash;
    }

    public void setInteractionType(byte[] byArray) {
        this.iaInteractionType.clear();
        this.iaInteractionType.add(byArray);
        this.iaInteractionType.calculateHashCode();
        this.calculateHashCode();
    }

    public IntArray getInteractionTypes() {
        return this.iaInteractionType;
    }

    public List<Integer> getOriginalAtomIndex() {
        return this.iaOriginalAtomIndex.toList();
    }

    public void clearOriginalAtomIndex() {
        this.iaOriginalAtomIndex.clear();
    }

    public void addOriginalAtomIndex(int n) {
        this.iaOriginalAtomIndex.add(n);
    }

    public List<AtomIndexLinkerId> getAtomIndexLinkerId() {
        return this.liAtomIndexLinkerId;
    }

    public void addArrOriginalAtomIndexRGroups(AtomIndexLinkerId atomIndexLinkerId) {
        this.liAtomIndexLinkerId.add(atomIndexLinkerId);
    }

    public String getIdCode() {
        return this.idcode;
    }

    public void setIdCode(String string) {
        this.idcode = string;
        this.calculateHashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("FlexophorePoint [iaInteractionType=");
        stringBuilder.append(this.iaInteractionType);
        stringBuilder.append(", iaOriginalAtomIndex=");
        stringBuilder.append(this.iaOriginalAtomIndex);
        stringBuilder.append(", liAtomIndexLinkerId=");
        stringBuilder.append(this.liAtomIndexLinkerId);
        stringBuilder.append(", idcode=");
        stringBuilder.append(this.idcode);
        stringBuilder.append(", id=");
        stringBuilder.append(this.id);
        stringBuilder.append(", hash=");
        stringBuilder.append(this.hash);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public String toStringInteractionTypes() {
        int n = this.iaInteractionType.length();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.iaInteractionType.get(i));
            if (i >= n - 1) continue;
            stringBuilder.append("; ");
        }
        return stringBuilder.toString();
    }
}

