/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore.completegraphmatcher;

import com.actelion.research.calc.Matrix;
import com.actelion.research.calc.statistics.median.MedianStatisticFunctions;
import com.actelion.research.chem.descriptor.flexophore.IPPNode;
import com.actelion.research.chem.descriptor.flexophore.PPNode;
import com.actelion.research.chem.descriptor.flexophore.completegraphmatcher.IPPNodeSimilarity;
import com.actelion.research.chem.interactionstatistics.InteractionAtomTypeCalculator;
import com.actelion.research.chem.interactionstatistics.InteractionDistanceStatistics;
import com.actelion.research.chem.interactionstatistics.InteractionSimilarityTable;
import com.actelion.research.util.Formatter;
import com.actelion.research.util.datamodel.table.TableModelString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PPNodeSimilarity
implements IPPNodeSimilarity {
    public static final int SIMILARITY_MODE_SIMPLE = 0;
    public static final int SIMILARITY_MODE_HARD_THRESH = 1;
    public static final int SIMILARITY_MODE_HARD_THRESH_AVR = 2;
    public static final int SIMILARITY_MODE_HARD_THRESH_OPTIMISTIC = 3;
    public static final int SIMILARITY_MODE_CARBON = 4;
    public static final double THRESH_SIMILARITY_HARD_MATCH = 0.9;
    public static final double HARD_MATCH_OPTIMISTIC_PERCENTILE = 0.75;
    private static final double TINY = 1.0E-7;
    private static final int SIZE_SIM_MATRIX = 20;
    private static final double THRESH_CARBON_INTERACTIONS = 0.6;
    private static PPNodeSimilarity INSTANCE = null;
    private InteractionSimilarityTable interactionSimilarityTable;
    private Matrix maSimilarity = new Matrix(20, 20);
    private int similarityMode;
    private double threshSimilarityHardMatch;
    private boolean verbose;

    public PPNodeSimilarity(int n, int n2) {
        this.interactionSimilarityTable = InteractionSimilarityTable.getInstance();
        this.similarityMode = n2;
        this.threshSimilarityHardMatch = 0.9;
    }

    public void setThreshSimilarityHardMatch(double d) {
        this.threshSimilarityHardMatch = d;
    }

    public String toStringParameter() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ObjectiveFlexophoreHardMatchUncovered, similarity mode ");
        switch (this.similarityMode) {
            case 0: {
                stringBuilder.append("simple");
                break;
            }
            case 1: {
                stringBuilder.append("hard thresh multiplicative");
                stringBuilder.append(", threshold=");
                stringBuilder.append(this.threshSimilarityHardMatch);
                break;
            }
            case 2: {
                stringBuilder.append("hard thresh average");
                stringBuilder.append(", threshold=");
                stringBuilder.append(this.threshSimilarityHardMatch);
                break;
            }
            case 3: {
                stringBuilder.append("hard thresh optimistic");
                stringBuilder.append(", percentile=");
                stringBuilder.append(0.75);
                stringBuilder.append(", threshold=");
                stringBuilder.append(this.threshSimilarityHardMatch);
                break;
            }
            case 4: {
                stringBuilder.append("carbon");
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PPNodeSimilarity getInstance(int n, int n2) {
        if (INSTANCE != null) return INSTANCE;
        Class<PPNodeSimilarity> clazz = PPNodeSimilarity.class;
        synchronized (PPNodeSimilarity.class) {
            INSTANCE = new PPNodeSimilarity(n, n2);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @Override
    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    @Override
    public double getSimilarity(IPPNode iPPNode, IPPNode iPPNode2) {
        double d = 0.0;
        switch (this.similarityMode) {
            case 0: {
                d = this.getSimilaritySimple((PPNode)iPPNode, (PPNode)iPPNode2);
                break;
            }
            case 1: {
                d = this.getSimilarityHardMatchMultiplicative((PPNode)iPPNode, (PPNode)iPPNode2);
                break;
            }
            case 2: {
                d = this.getSimilarityHardMatchAverage((PPNode)iPPNode, (PPNode)iPPNode2);
                break;
            }
            case 3: {
                d = this.getSimilarityHardMatchOptimistic((PPNode)iPPNode, (PPNode)iPPNode2);
                break;
            }
            case 4: {
                d = this.getSimilarityExtraCarbonConsideration((PPNode)iPPNode, (PPNode)iPPNode2);
            }
        }
        return d;
    }

    public double getSimilaritySimple(PPNode pPNode, PPNode pPNode2) {
        int n;
        int n2;
        this.maSimilarity.set(0.0);
        for (int i = 0; i < pPNode.getInteractionTypeCount(); ++i) {
            n2 = pPNode.getInteractionType(i);
            for (n = 0; n < pPNode2.getInteractionTypeCount(); ++n) {
                int n3 = pPNode2.getInteractionType(n);
                double d = 1.0 - this.interactionSimilarityTable.getDistance(n2, n3);
                this.maSimilarity.set(i, n, d);
            }
        }
        if (this.verbose) {
            System.out.println("PPNodeSimilarityMultiplicative");
            TableModelString tableModelString = new TableModelString(pPNode.getInteractionTypeCount(), pPNode2.getInteractionTypeCount());
            for (n2 = 0; n2 < pPNode.getInteractionTypeCount(); ++n2) {
                n = pPNode.getInteractionType(n2);
                String string = InteractionAtomTypeCalculator.getString(n);
                tableModelString.setRowName(n2, string);
            }
            for (n2 = 0; n2 < pPNode2.getInteractionTypeCount(); ++n2) {
                n = pPNode2.getInteractionType(n2);
                String string = InteractionAtomTypeCalculator.getString(n);
                tableModelString.setColName(n2, string);
            }
            tableModelString.set(this.maSimilarity, 2);
            System.out.println(tableModelString.toString());
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (pPNode2.getInteractionTypeCount() > pPNode.getInteractionTypeCount()) {
            for (n2 = 0; n2 < pPNode2.getInteractionTypeCount(); ++n2) {
                double d = 0.0;
                for (int i = 0; i < pPNode.getInteractionTypeCount(); ++i) {
                    if (!(this.maSimilarity.get(i, n2) > d)) continue;
                    d = this.maSimilarity.get(i, n2);
                }
                arrayList.add(d);
            }
        } else {
            for (n2 = 0; n2 < pPNode.getInteractionTypeCount(); ++n2) {
                double d = 0.0;
                for (int i = 0; i < pPNode2.getInteractionTypeCount(); ++i) {
                    if (!(this.maSimilarity.get(n2, i) > d)) continue;
                    d = this.maSimilarity.get(n2, i);
                }
                arrayList.add(d);
            }
        }
        double d = 0.0;
        if (arrayList.size() > 0) {
            d = 1.0;
            for (Double d2 : arrayList) {
                d *= d2.doubleValue();
            }
        }
        if (this.verbose) {
            System.out.println("Sim " + Formatter.format2(d));
            System.out.println();
        }
        return d;
    }

    public double getSimilarityHardMatchMultiplicative(PPNode pPNode, PPNode pPNode2) {
        PPNode pPNode3 = pPNode;
        PPNode pPNode4 = pPNode2;
        if (pPNode2.hasHeteroAtom() && pPNode.hasHeteroAtom()) {
            pPNode3 = PPNode.getHeteroOnlyNode(pPNode);
            pPNode4 = PPNode.getHeteroOnlyNode(pPNode2);
        }
        List<Double> list = this.getSimilarityList(pPNode3, pPNode4);
        double d = 0.0;
        if (list.size() > 0) {
            d = 1.0;
            for (double d2 : list) {
                if (d2 < this.threshSimilarityHardMatch) {
                    d = 0.0;
                    break;
                }
                d *= d2;
            }
        }
        if (this.verbose) {
            System.out.println("Sim " + Formatter.format2(d));
            System.out.println();
        }
        return d;
    }

    public List<Double> getSimilarityList(PPNode pPNode, PPNode pPNode2) {
        int n;
        int n2;
        this.maSimilarity.set(0.0);
        for (int i = 0; i < pPNode.getInteractionTypeCount(); ++i) {
            n2 = pPNode.getInteractionType(i);
            for (n = 0; n < pPNode2.getInteractionTypeCount(); ++n) {
                int n3 = pPNode2.getInteractionType(n);
                try {
                    double d = 1.0 - this.interactionSimilarityTable.getDistance(n2, n3);
                    this.maSimilarity.set(i, n, d);
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("Error in PPNodeSimilarity");
                    System.err.println("interactionTypeQuery " + n2);
                    System.err.println("interactionTypeBase " + n3);
                    throw new RuntimeException(exception);
                }
            }
        }
        if (this.verbose) {
            System.out.println("PPNodeSimilarity");
            TableModelString tableModelString = new TableModelString(pPNode.getInteractionTypeCount(), pPNode2.getInteractionTypeCount());
            for (n2 = 0; n2 < pPNode.getInteractionTypeCount(); ++n2) {
                n = pPNode.getInteractionType(n2);
                String string = InteractionAtomTypeCalculator.getString(n);
                tableModelString.setRowName(n2, string);
            }
            for (n2 = 0; n2 < pPNode2.getInteractionTypeCount(); ++n2) {
                n = pPNode2.getInteractionType(n2);
                String string = InteractionAtomTypeCalculator.getString(n);
                tableModelString.setColName(n2, string);
            }
            tableModelString.set(this.maSimilarity, 2);
            System.out.println(tableModelString.toString());
        }
        double[] dArray = PPNodeSimilarity.getTopValues(this.maSimilarity, pPNode.getInteractionTypeCount(), pPNode2.getInteractionTypeCount(), this.threshSimilarityHardMatch);
        ArrayList<Double> arrayList = new ArrayList<Double>(dArray.length);
        for (double d : dArray) {
            arrayList.add(d);
        }
        return arrayList;
    }

    private static double[] getTopValues(Matrix matrix, int n, int n2, double d) {
        double[] dArray = new double[Math.max(n, n2)];
        if (n == 1 && n2 == 1) {
            dArray[0] = matrix.get(0, 0);
            return dArray;
        }
        if (n2 > n) {
            for (int i = 0; i < n2; ++i) {
                double d2 = 0.0;
                for (int j = 0; j < n; ++j) {
                    if (!(matrix.get(j, i) > d2)) continue;
                    d2 = matrix.get(j, i);
                }
                dArray[i] = d2;
            }
        } else if (n2 < n) {
            for (int i = 0; i < n; ++i) {
                double d3 = 0.0;
                for (int j = 0; j < n2; ++j) {
                    if (!(matrix.get(i, j) > d3)) continue;
                    d3 = matrix.get(i, j);
                }
                dArray[i] = d3;
            }
        } else {
            boolean bl = false;
            double d4 = 0.0;
            double[] dArray2 = new double[n2];
            for (int i = 0; i < n2; ++i) {
                double d5 = 0.0;
                for (int j = 0; j < n; ++j) {
                    double d6 = matrix.get(j, i);
                    if (!(d6 > d5)) continue;
                    d5 = d6;
                }
                dArray2[i] = d5;
                d4 += d5;
                if (!(d5 < d)) continue;
                bl = true;
            }
            double[] dArray3 = new double[n];
            boolean bl2 = false;
            double d7 = 0.0;
            for (int i = 0; i < n; ++i) {
                double d8 = 0.0;
                for (int j = 0; j < n2; ++j) {
                    double d9 = matrix.get(i, j);
                    if (!(d9 > d8)) continue;
                    d8 = d9;
                }
                dArray3[i] = d8;
                d7 += d8;
                if (!(d8 < d)) continue;
                bl2 = true;
            }
            dArray = bl && bl2 ? (d4 > d7 ? dArray2 : dArray3) : (bl ? dArray3 : (bl2 ? dArray2 : (d4 > d7 ? dArray2 : dArray3)));
        }
        return dArray;
    }

    public double getSimilarityHardMatchAverage(PPNode pPNode, PPNode pPNode2) {
        List<Double> list = this.getSimilarityList(pPNode, pPNode2);
        double d = 0.0;
        if (list.size() > 0) {
            for (double d2 : list) {
                if (d2 < this.threshSimilarityHardMatch) {
                    d = 0.0;
                    break;
                }
                d += d2;
            }
        }
        double d3 = d / (double)list.size();
        if (this.verbose) {
            System.out.println("Sim " + Formatter.format2(d3));
            System.out.println();
        }
        return d3;
    }

    public double getSimilarityHardMatchOptimistic(PPNode pPNode, PPNode pPNode2) {
        List<Double> list = this.getSimilarityList(pPNode, pPNode2);
        double d = 0.0;
        if (list.size() > 0) {
            if (list.size() == 1) {
                d = list.get(0);
            } else {
                Collections.sort(list);
                d = MedianStatisticFunctions.getPercentileFromSorted(list, 0.75);
            }
        }
        if (this.verbose) {
            System.out.println("Sim " + Formatter.format2(d));
            System.out.println();
        }
        return d;
    }

    public double getSimilarityExtraCarbonConsideration(PPNode pPNode, PPNode pPNode2) {
        int n;
        int n2;
        int n3;
        this.maSimilarity.set(0.0);
        boolean bl = pPNode.getFractionCarbonInteractions() < 0.6;
        boolean bl2 = pPNode2.getFractionCarbonInteractions() < 0.6;
        for (int i = 0; i < pPNode.getInteractionTypeCount(); ++i) {
            int n4;
            n3 = pPNode.getInteractionType(i);
            n2 = InteractionAtomTypeCalculator.isCarbonInteraction(n3);
            if (n2 != 0 && bl) {
                for (n4 = 0; n4 < pPNode2.getInteractionTypeCount(); ++n4) {
                    this.maSimilarity.set(i, n4, -1.0);
                }
                continue;
            }
            for (n4 = 0; n4 < pPNode2.getInteractionTypeCount(); ++n4) {
                int n5 = pPNode2.getInteractionType(n4);
                int n6 = InteractionAtomTypeCalculator.isCarbonInteraction(n5);
                if (n6 != 0 && bl2) {
                    this.maSimilarity.set(i, n4, -1.0);
                    continue;
                }
                double d = -1.0;
                if (n6 == n2) {
                    d = 1.0 - this.interactionSimilarityTable.getDistance(n3, n5);
                }
                this.maSimilarity.set(i, n4, d);
            }
        }
        if (this.verbose) {
            System.out.println("PPNodeSimilarityMultiplicative");
            TableModelString tableModelString = new TableModelString(pPNode.getInteractionTypeCount(), pPNode2.getInteractionTypeCount());
            for (n3 = 0; n3 < pPNode.getInteractionTypeCount(); ++n3) {
                n2 = pPNode.getInteractionType(n3);
                String string = InteractionAtomTypeCalculator.getString(n2);
                tableModelString.setRowName(n3, string);
            }
            for (n3 = 0; n3 < pPNode2.getInteractionTypeCount(); ++n3) {
                n2 = pPNode2.getInteractionType(n3);
                String string = InteractionAtomTypeCalculator.getString(n2);
                tableModelString.setColName(n3, string);
            }
            tableModelString.set(this.maSimilarity, 2);
            System.out.println(tableModelString.toString());
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (pPNode2.getInteractionTypeCount() > pPNode.getInteractionTypeCount()) {
            for (n3 = 0; n3 < pPNode2.getInteractionTypeCount(); ++n3) {
                n2 = -1;
                n = -1;
                double d = -1.0;
                for (int i = 0; i < pPNode.getInteractionTypeCount(); ++i) {
                    if (!(this.maSimilarity.get(i, n3) > d)) continue;
                    d = this.maSimilarity.get(i, n3);
                    n = pPNode2.getInteractionType(n3);
                    n2 = pPNode.getInteractionType(i);
                }
                if (Math.abs(d - -1.0) < 1.0E-7) continue;
                arrayList.add(d);
            }
        } else {
            for (n3 = 0; n3 < pPNode.getInteractionTypeCount(); ++n3) {
                n2 = -1;
                n = -1;
                double d = -1.0;
                for (int i = 0; i < pPNode2.getInteractionTypeCount(); ++i) {
                    if (!(this.maSimilarity.get(n3, i) > d)) continue;
                    d = this.maSimilarity.get(n3, i);
                    n = pPNode2.getInteractionType(i);
                    n2 = pPNode.getInteractionType(n3);
                }
                if (Math.abs(d - -1.0) < 1.0E-7) continue;
                arrayList.add(d);
            }
        }
        double d = 0.0;
        if (arrayList.size() > 0) {
            d = 1.0;
            for (Double d2 : arrayList) {
                d *= d2.doubleValue();
            }
        }
        if (this.verbose) {
            System.out.println("Sim " + Formatter.format2(d));
            System.out.println();
        }
        return d;
    }

    public boolean isValidType(int n) {
        boolean bl = true;
        try {
            int n2 = InteractionDistanceStatistics.getInstance().getKey(n);
            this.interactionSimilarityTable.getDistance(n2, n2);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }
}

