/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.descriptor.flexophore.PPNode;
import com.actelion.research.util.ArrayUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class PPNodeViz
extends PPNode
implements Serializable {
    private static final long serialVersionUID = 22022013L;
    private static final double LIM_EQUAL_COORD = 1.0E-5;
    private static final float SIMILARITY_NODES = -1.0f;
    private HashSet<Integer> hsIndexOriginalAtoms;
    private Coordinates coordinates;
    private float similarityMappingNodes;
    private int mappingIndex;
    private byte index;
    private int indexSphereViz;
    private boolean marked;

    public PPNodeViz() {
        super(new PPNode());
        this.init();
    }

    public PPNodeViz(PPNodeViz pPNodeViz) {
        this.copy(pPNodeViz);
    }

    public PPNodeViz(PPNode pPNode) {
        super(pPNode);
        this.init();
    }

    private void init() {
        this.coordinates = new Coordinates();
        this.hsIndexOriginalAtoms = new HashSet();
        this.mappingIndex = -1;
        this.index = (byte)-1;
        this.similarityMappingNodes = -1.0f;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = (byte)n;
    }

    public void addAtoms(PPNodeViz pPNodeViz) {
        super.addAtoms(pPNodeViz);
        this.hsIndexOriginalAtoms.addAll(pPNodeViz.hsIndexOriginalAtoms);
    }

    public void addIndexOriginalAtom(int n) {
        if (this.hsIndexOriginalAtoms == null) {
            this.hsIndexOriginalAtoms = new HashSet();
        }
        this.hsIndexOriginalAtoms.add(n);
    }

    public void copy(PPNodeViz pPNodeViz) {
        super.copy(pPNodeViz);
        this.coordinates = new Coordinates(pPNodeViz.coordinates);
        this.mappingIndex = pPNodeViz.mappingIndex;
        this.hsIndexOriginalAtoms = new HashSet();
        this.hsIndexOriginalAtoms.addAll(pPNodeViz.hsIndexOriginalAtoms);
        this.index = pPNodeViz.index;
        this.indexSphereViz = pPNodeViz.indexSphereViz;
        this.similarityMappingNodes = pPNodeViz.similarityMappingNodes;
        this.marked = pPNodeViz.marked;
        this.heteroAtom = pPNodeViz.heteroAtom;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void setMarked(boolean bl) {
        this.marked = bl;
    }

    @Override
    public PPNodeViz getCopy() {
        return new PPNodeViz(this);
    }

    public List<Integer> getListIndexOriginalAtoms() {
        return new ArrayList<Integer>(this.hsIndexOriginalAtoms);
    }

    public int[] getArrayIndexOriginalAtoms() {
        return ArrayUtils.toIntArray(this.hsIndexOriginalAtoms);
    }

    public HashSet<Integer> getIndexOriginalAtoms() {
        return this.hsIndexOriginalAtoms;
    }

    public int getMappingIndex() {
        return this.mappingIndex;
    }

    public void setMappingIndex(int n) {
        this.mappingIndex = n;
    }

    public void clearInfo() {
        this.mappingIndex = -1;
    }

    public boolean hasSamePosition(PPNodeViz pPNodeViz) {
        return this.equal(this.coordinates, pPNodeViz.coordinates);
    }

    private boolean equal(Coordinates coordinates, Coordinates coordinates2) {
        boolean bl = true;
        if (Math.abs(coordinates.x - coordinates2.x) > 1.0E-5) {
            bl = false;
        } else if (Math.abs(coordinates.y - coordinates2.y) > 1.0E-5) {
            bl = false;
        } else if (Math.abs(coordinates.z - coordinates2.z) > 1.0E-5) {
            bl = false;
        }
        return bl;
    }

    public void resetInfoColor() {
        this.mappingIndex = -1;
    }

    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(double d, double d2, double d3) {
        this.coordinates.x = d;
        this.coordinates.y = d2;
        this.coordinates.z = d3;
    }

    public void setCoordinates(Coordinates coordinates) {
        this.coordinates.x = coordinates.x;
        this.coordinates.y = coordinates.y;
        this.coordinates.z = coordinates.z;
    }

    public void setCoordinatesNull() {
        this.coordinates = null;
    }

    public double getX() {
        return this.coordinates.x;
    }

    public double getY() {
        return this.coordinates.y;
    }

    public double getZ() {
        return this.coordinates.z;
    }

    public void setX(double d) {
        this.coordinates.x = d;
    }

    public void setY(double d) {
        this.coordinates.y = d;
    }

    public void setZ(double d) {
        this.coordinates.z = d;
    }

    public int getIndexSphereVisualization() {
        return this.indexSphereViz;
    }

    protected void setIndexSphereVisualization(int n) {
        this.indexSphereViz = n;
    }

    public float getSimilarityMappingNodes() {
        return this.similarityMappingNodes;
    }

    public void setSimilarityMappingNodes(float f) {
        this.similarityMappingNodes = f;
    }

    public String toStringPPNodeText() {
        return super.toStringText();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        if (this.modeFlexophore == 0) {
            stringBuilder.append(super.toStringText());
        } else if (this.modeFlexophore == 1) {
            stringBuilder.append(super.toStringLongHardPPPoint());
        } else {
            throw new RuntimeException("Unknown Flexophore mode " + this.modeFlexophore + "!");
        }
        stringBuilder.append(", coord ");
        stringBuilder.append(this.coordinates.toString());
        stringBuilder.append(", mapping color ");
        stringBuilder.append(this.mappingIndex);
        stringBuilder.append(", index ");
        stringBuilder.append(this.index);
        stringBuilder.append(", indexAtom viz ");
        stringBuilder.append(this.indexSphereViz);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String toStringShort() {
        return super.toString();
    }
}

