/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore;

import com.actelion.research.chem.descriptor.flexophore.DistHistHelper;
import com.actelion.research.chem.descriptor.flexophore.MolDistHist;
import com.actelion.research.chem.descriptor.flexophore.generator.SubFlexophoreGenerator;
import com.actelion.research.util.ArrayUtils;
import java.util.Arrays;

public class MolDistHistHelper {
    public static MolDistHist assemble(MolDistHist ... molDistHistArray) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (MolDistHist molDistHist : molDistHistArray) {
            n2 = molDistHist.getNumPPNodes();
            n3 += n2;
            if (n2 <= n4) continue;
            n4 = n2;
        }
        MolDistHist molDistHist = new MolDistHist(n3);
        int[][] nArray = new int[molDistHistArray.length][n4];
        int n5 = 0;
        for (n = 0; n < molDistHistArray.length; ++n) {
            n2 = molDistHistArray[n].getNumPPNodes();
            for (int i = 0; i < n2; ++i) {
                nArray[n][i] = n5++;
                molDistHist.addNode(molDistHistArray[n].getNode(i));
            }
        }
        for (n = 0; n < molDistHistArray.length; ++n) {
            n2 = molDistHistArray[n].getNumPPNodes();
            MolDistHist molDistHist2 = molDistHistArray[n];
            for (int i = 0; i < n2; ++i) {
                for (int j = i + 1; j < n2; ++j) {
                    byte[] byArray = molDistHist2.getDistHist(i, j);
                    int n6 = nArray[n][i];
                    int n7 = nArray[n][j];
                    molDistHist.setDistHist(n6, n7, byArray);
                }
            }
        }
        for (n = 0; n < n3; ++n) {
            for (n2 = n + 1; n2 < n3; ++n2) {
                byte[] byArray = molDistHist.getDistHist(n, n2);
                if (!MolDistHistHelper.isZero(byArray)) continue;
                Arrays.fill(byArray, (byte)1);
                molDistHist.setDistHist(n, n2, byArray);
            }
        }
        return molDistHist;
    }

    public static boolean isZero(byte[] byArray) {
        boolean bl = true;
        for (byte by : byArray) {
            if (by == 0) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static String toStringDistHist(MolDistHist molDistHist) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = molDistHist.getNumPPNodes();
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                byte[] byArray = molDistHist.getDistHist(i, j);
                stringBuilder.append(ArrayUtils.toString(byArray));
                stringBuilder.append("\n");
            }
        }
        return stringBuilder.toString();
    }

    public static void setDistHistToOne(MolDistHist molDistHist) {
        int n = molDistHist.getNumPPNodes();
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                byte[] byArray = molDistHist.getDistHist(i, j);
                Arrays.fill(byArray, (byte)1);
                molDistHist.setDistHist(i, j, byArray);
            }
        }
    }

    public static MolDistHist getMostDistantPairOfNodes(MolDistHist molDistHist) {
        int n = molDistHist.getNumPPNodes();
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                byte[] byArray = molDistHist.getDistHist(i, j);
                int n5 = DistHistHelper.getMedianBin(byArray);
                if (n5 <= n2) continue;
                n2 = n5;
                n3 = i;
                n4 = j;
            }
        }
        int[] nArray = new int[]{n3, n4};
        MolDistHist molDistHist2 = SubFlexophoreGenerator.getSubFragment(molDistHist, nArray);
        return molDistHist2;
    }

    public static MolDistHist getMostDistantPairOfNodesOneHeteroAtom(MolDistHist molDistHist) {
        int n;
        int n2 = molDistHist.getNumPPNodes();
        int n3 = 0;
        int n4 = -1;
        int n5 = -1;
        boolean[] blArray = new boolean[n2];
        for (n = 0; n < n2; ++n) {
            blArray[n] = molDistHist.getNode(n).containsHetero();
        }
        for (n = 0; n < n2; ++n) {
            for (int i = n + 1; i < n2; ++i) {
                byte[] byArray;
                int n6;
                if (!blArray[n] && !blArray[i] || (n6 = DistHistHelper.getMedianBin(byArray = molDistHist.getDistHist(n, i))) <= n3) continue;
                n3 = n6;
                n4 = n;
                n5 = i;
            }
        }
        int[] nArray = new int[]{n4, n5};
        MolDistHist molDistHist2 = SubFlexophoreGenerator.getSubFragment(molDistHist, nArray);
        return molDistHist2;
    }
}

