/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore;

import com.actelion.research.chem.descriptor.DescriptorHandlerFlexophore;
import com.actelion.research.chem.descriptor.flexophore.ModelSolutionSimilarity;
import com.actelion.research.chem.descriptor.flexophore.MolDistHist;
import com.actelion.research.chem.descriptor.flexophore.completegraphmatcher.ObjectiveBlurFlexophoreHardMatchUncovered;
import java.awt.Color;

public class FlexophoreAtomContributionColors {
    private static final int[] cDiverseColor = new int[]{4784383, 16711722, 44390, 0xFFFF00, 5231096, 14524662, 16755481, 12648400, 16711896, 11168600, 0xBCBCBC, 6187814, 7143168, 16759959, 11847474, 0xA60000};
    private MolDistHist mMolFlexophore;
    private MolDistHist mRefFlexophore;
    private int[] mRefARGB;
    private int[] mMolARGB;
    private float[] mRefRadius;
    private float[] mMolRadius;

    public FlexophoreAtomContributionColors(MolDistHist molDistHist, MolDistHist molDistHist2, int n, int n2) {
        this.mMolFlexophore = molDistHist;
        this.mRefFlexophore = molDistHist2;
        if (n != 0 && n2 != 0 && molDistHist != null && molDistHist2 != null) {
            int[][] nArray = molDistHist.getNodeAtoms();
            int[][] nArray2 = molDistHist2.getNodeAtoms();
            if (nArray != null && nArray2 != null) {
                DescriptorHandlerFlexophore descriptorHandlerFlexophore = new DescriptorHandlerFlexophore();
                ObjectiveBlurFlexophoreHardMatchUncovered objectiveBlurFlexophoreHardMatchUncovered = descriptorHandlerFlexophore.getObjectiveCompleteGraph();
                ModelSolutionSimilarity modelSolutionSimilarity = descriptorHandlerFlexophore.getBestMatch(molDistHist, molDistHist2);
                if (modelSolutionSimilarity != null) {
                    this.mMolARGB = new int[n];
                    this.mRefARGB = new int[n2];
                    this.mMolRadius = new float[n];
                    this.mRefRadius = new float[n2];
                    int n3 = modelSolutionSimilarity.getSizeHeap();
                    objectiveBlurFlexophoreHardMatchUncovered.setBase(molDistHist);
                    objectiveBlurFlexophoreHardMatchUncovered.setQuery(molDistHist2);
                    int[] nArray3 = this.createDiverseColorList(n3);
                    for (int i = 0; i < n3; ++i) {
                        int n4;
                        byte by = modelSolutionSimilarity.getIndexBaseFromHeap(i);
                        byte by2 = modelSolutionSimilarity.getIndexQueryFromHeap(i);
                        float f = modelSolutionSimilarity.getSimilarityNode(i);
                        float f2 = objectiveBlurFlexophoreHardMatchUncovered.getSimilarityHistogramsForNode(modelSolutionSimilarity, i);
                        if (!(f > 0.0f)) continue;
                        f = Math.max(0.0f, Math.min(1.0f, (float)Math.round(f * 4.0f - 4.0f + 1.0f)));
                        for (int n5 : nArray[by]) {
                            n4 = Math.round(f * 255.0f);
                            this.mMolARGB[n5] = n4 << 24 | nArray3[i];
                            this.mMolRadius[n5] = f2;
                        }
                        for (int n5 : nArray2[by2]) {
                            n4 = Math.round(f * 255.0f);
                            this.mRefARGB[n5] = n4 << 24 | nArray3[i];
                            this.mRefRadius[n5] = f2;
                        }
                    }
                }
            }
        }
    }

    public MolDistHist getMolFlexophore() {
        return this.mMolFlexophore;
    }

    public MolDistHist getRefFlexophore() {
        return this.mRefFlexophore;
    }

    public int[] getMolARGB() {
        return this.mMolARGB;
    }

    public int[] getRefARGB() {
        return this.mRefARGB;
    }

    public float[] getMolRadius() {
        return this.mMolRadius;
    }

    public float[] getRefRadius() {
        return this.mRefRadius;
    }

    private int[] createDiverseColorList(int n) {
        if (n <= cDiverseColor.length) {
            return cDiverseColor;
        }
        int n2 = (n & 1) == 0 ? n : n + 1;
        float[] fArray = new float[]{1.0f, 0.4f, 0.8f, 1.0f, 1.0f, 0.6f, 0.8f, 1.0f};
        float[] fArray2 = new float[]{0.8f, 1.0f, 1.0f, 0.6f, 0.8f, 1.0f, 1.0f, 0.4f};
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            float f = (float)i / (float)n2;
            nArray[i] = Color.HSBtoRGB(f, fArray[i & 7], fArray2[i & 7]);
        }
        return nArray;
    }
}

