/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.descriptor.DescriptorEncoder;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import com.actelion.research.chem.descriptor.DescriptorInfo;
import com.actelion.research.util.BurtleHasher;
import java.util.Arrays;

public class DescriptorHandlerSkeletonSpheres
implements DescriptorHandler<byte[], StereoMolecule> {
    private static final double CORRECTION_FACTOR = 0.7;
    private static final byte[] FAILED_OBJECT = new byte[0];
    private static final int MAX_SPHERE_COUNT = 5;
    private static final int EXACT_SPHERE_COUNT = 4;
    private static final int SKELETON_SPHERE_COUNT = 5;
    private static final int HASH_BITS = 10;
    private static final int HASH_INIT = 13;
    private static final int DESCRIPTOR_SIZE = 1024;
    private static DescriptorHandlerSkeletonSpheres sDefaultInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DescriptorHandlerSkeletonSpheres getDefaultInstance() {
        Class<DescriptorHandlerSkeletonSpheres> clazz = DescriptorHandlerSkeletonSpheres.class;
        synchronized (DescriptorHandlerSkeletonSpheres.class) {
            if (sDefaultInstance == null) {
                sDefaultInstance = new DescriptorHandlerSkeletonSpheres();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sDefaultInstance;
        }
    }

    @Override
    public boolean calculationFailed(byte[] byArray) {
        return byArray == null || byArray.length == 0;
    }

    @Override
    public byte[] createDescriptor(StereoMolecule stereoMolecule) {
        if (stereoMolecule == null) {
            return null;
        }
        stereoMolecule.ensureHelperArrays(7);
        StereoMolecule stereoMolecule2 = new StereoMolecule(stereoMolecule.getAtoms(), stereoMolecule.getBonds());
        byte[] byArray = new byte[1024];
        int[] nArray = new int[stereoMolecule.getAtoms()];
        boolean[] blArray = new boolean[stereoMolecule.getAtoms()];
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            if (i != 0) {
                Arrays.fill(blArray, false);
            }
            int n = 0;
            int n2 = 0;
            for (int j = 0; j < 5 && n2 < stereoMolecule.getAtoms(); ++j) {
                int n3;
                int n4;
                if (n2 == 0) {
                    nArray[0] = i;
                    blArray[i] = true;
                    n2 = 1;
                } else {
                    n4 = n2;
                    for (n3 = n; n3 < n2; ++n3) {
                        int n5 = nArray[n3];
                        for (int k = 0; k < stereoMolecule.getConnAtoms(n5); ++k) {
                            int n6 = stereoMolecule.getConnAtom(n5, k);
                            if (blArray[n6]) continue;
                            blArray[n6] = true;
                            nArray[n4++] = n6;
                        }
                    }
                    n = n2;
                    n2 = n4;
                }
                stereoMolecule.copyMoleculeByAtoms(stereoMolecule2, blArray, true, null);
                if (j < 4) {
                    String string = new Canonizer(stereoMolecule2).getIDCode();
                    n3 = BurtleHasher.hashlittle(string, 13L);
                    if (byArray[n3 &= BurtleHasher.hashmask(10)] < 63) {
                        int n7 = n3;
                        byArray[n7] = (byte)(byArray[n7] + 1);
                    }
                }
                if (j >= 5) continue;
                for (n4 = 0; n4 < stereoMolecule2.getAllAtoms(); ++n4) {
                    stereoMolecule2.setAtomicNo(n4, 6);
                }
                String string = new Canonizer(stereoMolecule2).getIDCode();
                n3 = BurtleHasher.hashlittle(string, 13L);
                if (byArray[n3 &= BurtleHasher.hashmask(10)] >= 63) continue;
                int n8 = n3;
                byArray[n8] = (byte)(byArray[n8] + 1);
            }
        }
        return byArray;
    }

    @Override
    public byte[] decode(String string) {
        return string == null ? null : (string.equals("Calculation Failed") ? FAILED_OBJECT : new DescriptorEncoder().decodeCounts(string));
    }

    @Override
    public byte[] decode(byte[] byArray) {
        return byArray == null ? null : (Arrays.equals(byArray, FAILED_BYTES) ? FAILED_OBJECT : new DescriptorEncoder().decodeCounts(byArray));
    }

    @Override
    public String encode(byte[] byArray) {
        return this.calculationFailed(byArray) ? "Calculation Failed" : new String(new DescriptorEncoder().encodeCounts(byArray));
    }

    @Override
    public DescriptorInfo getInfo() {
        return DescriptorConstants.DESCRIPTOR_SkeletonSpheres;
    }

    @Override
    public String getVersion() {
        return DescriptorConstants.DESCRIPTOR_SkeletonSpheres.version;
    }

    @Override
    public float getSimilarity(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null) {
            return Float.NaN;
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            byte by2 = byArray2[i];
            n += Math.max(by, by2);
            n2 += Math.min(by, by2);
        }
        return this.normalizeValue((double)n2 / (double)n);
    }

    public float normalizeValue(double d) {
        return d <= 0.0 ? 0.0f : (d >= 1.0 ? 1.0f : (float)(1.0 - Math.pow(1.0 - Math.pow(d, 0.7), 1.4285714285714286)));
    }

    @Override
    public DescriptorHandler<byte[], StereoMolecule> getThreadSafeCopy() {
        return this;
    }
}

