/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.contrib;

import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;

public class HydrogenHandler {
    static final double cos30 = Math.cos(0.5235987755982988);
    static final double sin30 = Math.sin(0.5235987755982988);
    static final double cos330 = Math.cos(-0.5235987755982988);
    static final double sin330 = Math.sin(-0.5235987755982988);
    static final double cos60 = Math.cos(1.0471975511965976);
    static final double sin60 = Math.sin(1.0471975511965976);
    static final double cos300 = Math.cos(-1.0471975511965976);
    static final double sin300 = Math.sin(-1.0471975511965976);
    static final double cos45 = Math.cos(0.7853981633974483);
    static final double sin45 = Math.sin(0.7853981633974483);
    static final double cos315 = Math.cos(-0.7853981633974483);
    static final double sin315 = Math.sin(-0.7853981633974483);
    static final double H_BOND_RATIO = 0.7;

    public static void addImplicitHydrogens(StereoMolecule stereoMolecule, int n) {
        int n2 = stereoMolecule.getImplicitHydrogens(n);
        double d = stereoMolecule.getAtomX(n);
        double d2 = stereoMolecule.getAtomY(n);
        switch (n2) {
            case 1: {
                int n3;
                double d3;
                double d4;
                int n4;
                int n5 = stereoMolecule.getConnAtoms(n);
                if (n5 == 0) {
                    double d5 = Double.MAX_VALUE;
                    n4 = -1;
                    for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
                        double d6;
                        double d7;
                        double d8;
                        if (i == n || !(d5 > (d8 = Math.sqrt((d7 = d - stereoMolecule.getAtomX(i)) * d7 + (d6 = d2 - stereoMolecule.getAtomY(i)) * d6)))) continue;
                        d5 = d8;
                        n4 = i;
                    }
                    d4 = d - stereoMolecule.getAtomX(n4);
                    d3 = d2 - stereoMolecule.getAtomY(n4);
                } else {
                    d4 = d - stereoMolecule.getAtomX(stereoMolecule.getConnAtom(n, 0));
                    d3 = d2 - stereoMolecule.getAtomY(stereoMolecule.getConnAtom(n, 0));
                }
                if (n5 == 1) {
                    n3 = stereoMolecule.addAtom((float)(d + cos45 * d4 + sin45 * d3), (float)(d2 - sin45 * d4 + cos45 * d3));
                } else if (n5 == 2) {
                    d4 = d - 0.5 * (stereoMolecule.getAtomX(stereoMolecule.getConnAtom(n, 0)) + stereoMolecule.getAtomX(stereoMolecule.getConnAtom(n, 1)));
                    d3 = d2 - 0.5 * (stereoMolecule.getAtomY(stereoMolecule.getConnAtom(n, 0)) + stereoMolecule.getAtomY(stereoMolecule.getConnAtom(n, 1)));
                    n3 = stereoMolecule.addAtom((float)(d + d4), (float)(d2 + d3));
                } else if (n5 == 3) {
                    int n6 = stereoMolecule.getConnAtom(n, 0);
                    for (int i = 1; i < 3; ++i) {
                        n4 = stereoMolecule.getConnBond(n, i);
                        if (stereoMolecule.getBondType(n4) != 129 && stereoMolecule.getBondType(n4) != 257) continue;
                        n6 = stereoMolecule.getConnAtom(n, i);
                    }
                    double d9 = Math.abs(Molecule.getAngleDif(Molecule.getAngle(stereoMolecule.getAtomX(n), stereoMolecule.getAtomY(n), stereoMolecule.getAtomX(stereoMolecule.getConnAtom(n, 0)), stereoMolecule.getAtomY(stereoMolecule.getConnAtom(n, 0))), Molecule.getAngle(stereoMolecule.getAtomX(n), stereoMolecule.getAtomY(n), stereoMolecule.getAtomX(stereoMolecule.getConnAtom(n, 1)), stereoMolecule.getAtomY(stereoMolecule.getConnAtom(n, 1)))));
                    double d10 = Math.abs(Molecule.getAngleDif(Molecule.getAngle(stereoMolecule.getAtomX(n), stereoMolecule.getAtomY(n), stereoMolecule.getAtomX(stereoMolecule.getConnAtom(n, 0)), stereoMolecule.getAtomY(stereoMolecule.getConnAtom(n, 0))), Molecule.getAngle(stereoMolecule.getAtomX(n), stereoMolecule.getAtomY(n), stereoMolecule.getAtomX(stereoMolecule.getConnAtom(n, 2)), stereoMolecule.getAtomY(stereoMolecule.getConnAtom(n, 2)))));
                    double d11 = Math.abs(Molecule.getAngleDif(Molecule.getAngle(stereoMolecule.getAtomX(n), stereoMolecule.getAtomY(n), stereoMolecule.getAtomX(stereoMolecule.getConnAtom(n, 1)), stereoMolecule.getAtomY(stereoMolecule.getConnAtom(n, 1))), Molecule.getAngle(stereoMolecule.getAtomX(n), stereoMolecule.getAtomY(n), stereoMolecule.getAtomX(stereoMolecule.getConnAtom(n, 2)), stereoMolecule.getAtomY(stereoMolecule.getConnAtom(n, 2)))));
                    boolean bl = true;
                    if (d9 > d10 && d9 > d11) {
                        if (d10 + d11 < Math.PI) {
                            bl = false;
                            d4 = d - 0.5 * (stereoMolecule.getAtomX(stereoMolecule.getConnAtom(n, 0)) + stereoMolecule.getAtomX(stereoMolecule.getConnAtom(n, 1)));
                            d3 = d2 - 0.5 * (stereoMolecule.getAtomY(stereoMolecule.getConnAtom(n, 0)) + stereoMolecule.getAtomY(stereoMolecule.getConnAtom(n, 1)));
                        }
                    } else if (d10 > d9 && d10 > d11) {
                        if (d9 + d11 < Math.PI) {
                            bl = false;
                            d4 = d - 0.5 * (stereoMolecule.getAtomX(stereoMolecule.getConnAtom(n, 0)) + stereoMolecule.getAtomX(stereoMolecule.getConnAtom(n, 2)));
                            d3 = d2 - 0.5 * (stereoMolecule.getAtomY(stereoMolecule.getConnAtom(n, 0)) + stereoMolecule.getAtomY(stereoMolecule.getConnAtom(n, 2)));
                        }
                    } else if (d9 + d10 < Math.PI) {
                        bl = false;
                        d4 = d - 0.5 * (stereoMolecule.getAtomX(stereoMolecule.getConnAtom(n, 1)) + stereoMolecule.getAtomX(stereoMolecule.getConnAtom(n, 2)));
                        d3 = d2 - 0.5 * (stereoMolecule.getAtomY(stereoMolecule.getConnAtom(n, 1)) + stereoMolecule.getAtomY(stereoMolecule.getConnAtom(n, 2)));
                    }
                    if (bl) {
                        int n7 = stereoMolecule.getConnAtom(n, 0);
                        double d12 = Double.MAX_VALUE;
                        for (int i = 0; i < 3; ++i) {
                            double d13;
                            int n8 = stereoMolecule.getConnAtom(n, i);
                            if (n8 == n6 || !((d13 = Math.pow(stereoMolecule.getAtomX(n) - stereoMolecule.getAtomX(n8), 2.0) + Math.pow(stereoMolecule.getAtomY(n) - stereoMolecule.getAtomY(n8), 2.0)) < d12)) continue;
                            n7 = n8;
                            d12 = d13;
                            System.out.println("Minimal distance: " + n6 + " - " + n7 + " - " + d12 + " - " + stereoMolecule.getAtomicNo(n7));
                        }
                        n3 = stereoMolecule.addAtom((stereoMolecule.getAtomX(n6) + stereoMolecule.getAtomX(n7)) / 2.0, (stereoMolecule.getAtomY(n6) + stereoMolecule.getAtomY(n7)) / 2.0);
                    } else {
                        n3 = stereoMolecule.addAtom((float)(d + d4), (float)(d2 + d3));
                    }
                } else {
                    n3 = stereoMolecule.addAtom((float)(d + d4), (float)(d2 + d3));
                }
                stereoMolecule.setAtomicNo(n3, 1);
                stereoMolecule.addBond(n, n3, 1);
                break;
            }
            case 2: {
                int n9 = stereoMolecule.getConnAtoms(n);
                if (n9 == 1) {
                    double d14 = d - stereoMolecule.getAtomX(stereoMolecule.getConnAtom(n, 0));
                    double d15 = d2 - stereoMolecule.getAtomY(stereoMolecule.getConnAtom(n, 0));
                    int n10 = stereoMolecule.addAtom((float)(d + (cos60 * d14 - sin60 * d15) * 0.7), (float)(d2 + (sin60 * d14 + cos60 * d15) * 0.7));
                    stereoMolecule.setAtomicNo(n10, 1);
                    stereoMolecule.addBond(n, n10, 1);
                    n10 = stereoMolecule.addAtom((float)(d + (cos300 * d14 - sin300 * d15) * 0.7), (float)(d2 + (sin300 * d14 + cos300 * d15) * 0.7));
                    stereoMolecule.setAtomicNo(n10, 1);
                    stereoMolecule.addBond(n, n10, 1);
                    break;
                }
                if (n9 == 2) {
                    double d16 = d - stereoMolecule.getAtomX(stereoMolecule.getConnAtom(n, 0));
                    double d17 = d2 - stereoMolecule.getAtomY(stereoMolecule.getConnAtom(n, 0));
                    double d18 = d - stereoMolecule.getAtomX(stereoMolecule.getConnAtom(n, 1));
                    double d19 = d2 - stereoMolecule.getAtomY(stereoMolecule.getConnAtom(n, 1));
                    double d20 = Math.sqrt(d16 * d16 + d17 * d17) * 0.7;
                    double d21 = Math.sqrt(d18 * d18 + d19 * d19) * 0.7;
                    double d22 = d16 + d18;
                    double d23 = d17 + d19;
                    double d24 = Math.sqrt(d22 * d22 + d23 * d23);
                    double d25 = (d20 + d21) / 2.0;
                    d22 = d22 / d24 * d25;
                    d23 = d23 / d24 * d25;
                    int n11 = stereoMolecule.getStereoBond(n);
                    int n12 = stereoMolecule.addAtom((float)(d + cos30 * d22 - sin30 * d23), (float)(d2 + sin30 * d22 + cos30 * d23));
                    stereoMolecule.setAtomicNo(n12, 1);
                    if (n11 > -1) {
                        stereoMolecule.addBond(n, n12, 1);
                    } else {
                        stereoMolecule.addBond(n, n12, 257);
                    }
                    n12 = stereoMolecule.addAtom((float)(d + cos330 * d22 - sin330 * d23), (float)(d2 + sin330 * d22 + cos330 * d23));
                    stereoMolecule.setAtomicNo(n12, 1);
                    stereoMolecule.addBond(n, n12, 1);
                    break;
                }
                for (int i = 0; i < n2; ++i) {
                    int n13 = stereoMolecule.addAtom((float)d, (float)d2);
                    stereoMolecule.setAtomicNo(n13, 1);
                    stereoMolecule.addBond(n, n13, 1);
                }
                break;
            }
            case 3: {
                if (stereoMolecule.getConnAtoms(n) > 0) {
                    double d26 = (d - stereoMolecule.getAtomX(stereoMolecule.getConnAtom(n, 0))) * 0.7;
                    double d27 = (d2 - stereoMolecule.getAtomY(stereoMolecule.getConnAtom(n, 0))) * 0.7;
                    int n14 = stereoMolecule.addAtom((float)(d + d26), (float)(d2 + d27));
                    stereoMolecule.setAtomicNo(n14, 1);
                    stereoMolecule.addBond(n, n14, 1);
                    n14 = stereoMolecule.addAtom((float)(d - d27), (float)(d2 + d26));
                    stereoMolecule.setAtomicNo(n14, 1);
                    stereoMolecule.addBond(n, n14, 1);
                    n14 = stereoMolecule.addAtom((float)(d + d27), (float)(d2 - d26));
                    stereoMolecule.setAtomicNo(n14, 1);
                    stereoMolecule.addBond(n, n14, 1);
                    break;
                }
                double d28 = stereoMolecule.getAverageBondLength(true);
                double d29 = stereoMolecule.getAverageBondLength(true);
                int n15 = stereoMolecule.addAtom((float)(d + d28), (float)(d2 + d29));
                stereoMolecule.setAtomicNo(n15, 1);
                stereoMolecule.addBond(n, n15, 1);
                n15 = stereoMolecule.addAtom((float)(d - d29 * cos60), (float)(d2 + d28 * sin60));
                stereoMolecule.setAtomicNo(n15, 1);
                stereoMolecule.addBond(n, n15, 1);
                n15 = stereoMolecule.addAtom((float)(d - d29 * cos60), (float)(d2 - d28 * sin60));
                stereoMolecule.setAtomicNo(n15, 1);
                stereoMolecule.addBond(n, n15, 1);
                break;
            }
            default: {
                for (int i = 0; i < n2; ++i) {
                    int n16 = stereoMolecule.addAtom((float)d, (float)d2);
                    stereoMolecule.setAtomicNo(n16, 1);
                    stereoMolecule.addBond(n, n16, 1);
                }
            }
        }
    }

    public static void addImplicitHydrogens(StereoMolecule stereoMolecule) {
        stereoMolecule.ensureHelperArrays(1);
        int n = stereoMolecule.getAtoms();
        for (int i = 0; i < n; ++i) {
            HydrogenHandler.addImplicitHydrogens(stereoMolecule, i);
        }
    }

    public static int getNumberOfHydrogens(StereoMolecule stereoMolecule) {
        stereoMolecule.ensureHelperArrays(1);
        int n = 0;
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            if (stereoMolecule.getAtomicNo(i) == 1) {
                ++n;
                continue;
            }
            n += stereoMolecule.getPlainHydrogens(i);
        }
        return n;
    }
}

