/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.contrib;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.SortedStringList;
import com.actelion.research.chem.StereoMolecule;

public class DiastereotopicAtomID {
    private static int xAtomicNumber = Molecule.getAtomicNoFromLabel("X", 32);

    public static String[] getAtomIds(StereoMolecule stereoMolecule) {
        DiastereotopicAtomID.addMissingChirality(stereoMolecule);
        int n = stereoMolecule.getAllAtoms();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            StereoMolecule stereoMolecule2 = stereoMolecule.getCompactCopy();
            DiastereotopicAtomID.changeAtom(stereoMolecule2, i);
            DiastereotopicAtomID.makeRacemic(stereoMolecule2);
            stringArray[i] = new Canonizer(stereoMolecule2, 8).getIDCode();
        }
        return stringArray;
    }

    public static void addMissingChirality(StereoMolecule stereoMolecule, int n) {
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            StereoMolecule stereoMolecule2 = stereoMolecule.getCompactCopy();
            DiastereotopicAtomID.changeAtomForStereo(stereoMolecule2, i);
            stereoMolecule2.ensureHelperArrays(15);
            for (int j = 0; j < stereoMolecule2.getAtoms(); ++j) {
                int n2;
                if (!stereoMolecule2.isAtomStereoCenter(j) || stereoMolecule2.getStereoBond(j) != -1 || (n2 = stereoMolecule2.getAtomPreferredStereoBond(j)) == -1) continue;
                stereoMolecule.setBondType(n2, 257);
                if (stereoMolecule.getBondAtom(1, n2) == j) {
                    int n3 = stereoMolecule.getBondAtom(0, n2);
                    stereoMolecule.setBondAtom(0, n2, j);
                    stereoMolecule.setBondAtom(1, n2, n3);
                }
                stereoMolecule.setAtomESR(j, n, 0);
            }
        }
    }

    public static void addMissingChirality(StereoMolecule stereoMolecule) {
        DiastereotopicAtomID.addMissingChirality(stereoMolecule, 1);
    }

    private static void changeAtomForStereo(StereoMolecule stereoMolecule, int n) {
        stereoMolecule.setAtomicNo(n, xAtomicNumber);
    }

    private static void changeAtom(StereoMolecule stereoMolecule, int n) {
        stereoMolecule.setAtomCustomLabel(n, stereoMolecule.getAtomLabel(n) + "*");
        if (stereoMolecule.getAtomicNo(n) == 1) {
            stereoMolecule.setAtomicNo(n, xAtomicNumber);
        } else {
            stereoMolecule.setAtomMass(n, stereoMolecule.getAtomMass(n) + 5);
        }
    }

    private static void makeRacemic(StereoMolecule stereoMolecule) {
        stereoMolecule.ensureHelperArrays(15);
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            if (stereoMolecule.getAtomParity(i) == 0) continue;
            stereoMolecule.setAtomESR(i, 1, 0);
        }
    }

    public static String test(StereoMolecule stereoMolecule) {
        String[] stringArray = DiastereotopicAtomID.getAtomIds(stereoMolecule);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(Integer.toString(i)).append(" - ").append(stringArray[i]).append("\n");
        }
        return stringBuilder.toString();
    }

    public static void markDiastereotopicAtoms(StereoMolecule stereoMolecule) {
        String[] stringArray = DiastereotopicAtomID.getAtomIds(stereoMolecule);
        SortedStringList sortedStringList = new SortedStringList();
        int n = 0;
        for (String string : stringArray) {
            System.out.println(string + " - " + n);
            if (sortedStringList.contains(string)) continue;
            sortedStringList.addString(string);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                stereoMolecule.setAtomCustomLabel(i, Integer.toString(n));
            }
            ++n;
        }
    }
}

