/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.conf;

import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.StereoMolecule;

public class TorsionDetail {
    public static final int SYMMETRY_C1C1_OR_C1D1 = 0;
    public static final int SYMMETRY_C1D2 = 1;
    public static final int SYMMETRY_D1D1 = 2;
    public static final int SYMMETRY_D1D2_OR_D2D2 = 3;
    private static final int HALF_SYMMETRY_C1 = 0;
    private static final int HALF_SYMMETRY_D1 = 1;
    private static final int HALF_SYMMETRY_D2 = 2;
    private static final int[][] SYMMETRY = new int[][]{{0, 0, 1}, {0, 2, 3}, {1, 3, 3}};
    private static final int MAX_TRIPLE_BONDS = 8;
    private static final int FRAGMENT_ATOMS = 24;
    private static final int FRAGMENT_BONDS = 29;
    private StereoMolecule mFragment = new StereoMolecule(24, 29);
    private int[] mCentralAtom;
    private int[] mRearAtom;
    private int[] mRefAtom;
    private int[] mToFragmentAtom;
    private int[] mToMoleculeAtom = new int[24];
    private int mAlkyneAtomCount;
    private String mID;

    public TorsionDetail() {
        this.mCentralAtom = new int[2];
        this.mRearAtom = new int[2];
        this.mRefAtom = new int[2];
    }

    public boolean isValid() {
        return this.mID != null;
    }

    public String getID() {
        return this.mID;
    }

    public int getCentralAtom(int n) {
        return this.mCentralAtom[n];
    }

    public int getRearAtom(int n) {
        return this.mRearAtom[n];
    }

    public int getReferenceAtom(int n) {
        return this.mRefAtom[n];
    }

    public int getAlkyneAtomCount() {
        return this.mAlkyneAtomCount;
    }

    public StereoMolecule getFragment() {
        return this.mFragment;
    }

    public boolean classify(StereoMolecule stereoMolecule, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        this.mFragment.clear();
        this.mID = null;
        stereoMolecule.ensureHelperArrays(63);
        if (stereoMolecule.getBondOrder(n) != 1 || stereoMolecule.isAromaticBond(n)) {
            return false;
        }
        if (stereoMolecule.getAtomicNo(stereoMolecule.getBondAtom(0, n)) == 1 || stereoMolecule.getAtomicNo(stereoMolecule.getBondAtom(1, n)) == 1) {
            return false;
        }
        boolean bl = stereoMolecule.isSmallRingBond(n);
        if (bl && stereoMolecule.getBondRingSize(n) < 6) {
            return false;
        }
        boolean[] blArray = new boolean[stereoMolecule.getAtoms()];
        this.mAlkyneAtomCount = 0;
        for (n11 = 0; n11 < 2; ++n11) {
            this.mCentralAtom[n11] = stereoMolecule.getBondAtom(n11, n);
            this.mRearAtom[n11] = stereoMolecule.getBondAtom(1 - n11, n);
            block1: while (stereoMolecule.getAtomPi(this.mCentralAtom[n11]) == 2 && stereoMolecule.getNonHydrogenNeighbourCount(this.mCentralAtom[n11]) == 2 && stereoMolecule.getAtomicNo(this.mCentralAtom[n11]) < 10) {
                for (n10 = 0; n10 < stereoMolecule.getConnAtoms(this.mCentralAtom[n11]); ++n10) {
                    n9 = stereoMolecule.getConnAtom(this.mCentralAtom[n11], n10);
                    if (n9 == this.mRearAtom[n11] || stereoMolecule.getAtomicNo(n9) == 1) continue;
                    if (stereoMolecule.getConnAtoms(n9) == 1 || this.mAlkyneAtomCount == 16) {
                        return false;
                    }
                    blArray[this.mCentralAtom[n11]] = true;
                    this.mRearAtom[n11] = this.mCentralAtom[n11];
                    this.mCentralAtom[n11] = n9;
                    ++this.mAlkyneAtomCount;
                    continue block1;
                }
            }
            n10 = stereoMolecule.getNonHydrogenNeighbourCount(this.mCentralAtom[n11]);
            if (n10 > 4 || n10 == 1) {
                return false;
            }
            blArray[this.mCentralAtom[n11]] = true;
        }
        for (n11 = 0; n11 < 2; ++n11) {
            for (n10 = 0; n10 < stereoMolecule.getConnAtoms(this.mCentralAtom[n11]); ++n10) {
                n9 = stereoMolecule.getConnAtom(this.mCentralAtom[n11], n10);
                if (stereoMolecule.getAtomicNo(n9) == 1) continue;
                blArray[n9] = true;
            }
        }
        this.mToFragmentAtom = new int[stereoMolecule.getAtoms()];
        stereoMolecule.copyMoleculeByAtoms(this.mFragment, blArray, true, this.mToFragmentAtom);
        for (n11 = 0; n11 < this.mToFragmentAtom.length; ++n11) {
            if (this.mToFragmentAtom[n11] == -1) continue;
            this.mToMoleculeAtom[this.mToFragmentAtom[n11]] = n11;
        }
        this.mFragment.setFragment(true);
        if (bl && (n11 = this.mFragment.getBond(this.mToFragmentAtom[this.mCentralAtom[0]], this.mToFragmentAtom[this.mCentralAtom[1]])) != -1) {
            this.mFragment.setBondQueryFeature(n11, 256, true);
            RingCollection ringCollection = stereoMolecule.getRingSet();
            for (n9 = 0; n9 < ringCollection.getSize(); ++n9) {
                if (!ringCollection.isBondMember(n9, n)) continue;
                block7: for (n8 = 0; n8 < 2; ++n8) {
                    for (n7 = 0; n7 < stereoMolecule.getConnAtoms(this.mCentralAtom[n8]); ++n7) {
                        n6 = stereoMolecule.getConnAtom(this.mCentralAtom[n8], n7);
                        if (n6 == this.mRearAtom[n8] || !ringCollection.isAtomMember(n9, n6) || stereoMolecule.getAtomicNo(n6) == 1) continue;
                        this.mFragment.setBondQueryFeature(this.mFragment.getBond(this.mToFragmentAtom[this.mCentralAtom[n8]], this.mToFragmentAtom[n6]), 256, true);
                        continue block7;
                    }
                }
            }
        }
        for (n11 = 0; n11 < 2; ++n11) {
            if (stereoMolecule.isFlatNitrogen(this.mCentralAtom[n11])) {
                this.mFragment.setAtomQueryFeature(this.mToFragmentAtom[this.mCentralAtom[n11]], 0x10000000L, true);
            }
            boolean bl2 = false;
            for (n9 = 0; n9 < stereoMolecule.getConnAtoms(this.mCentralAtom[n11]); ++n9) {
                n8 = stereoMolecule.getConnAtom(this.mCentralAtom[n11], n9);
                if (n8 == this.mRearAtom[n11] || stereoMolecule.getAtomicNo(n8) == 1) continue;
                n7 = this.mFragment.getBond(this.mToFragmentAtom[this.mCentralAtom[n11]], this.mToFragmentAtom[n8]);
                if (this.mFragment.getBondType(n7) == 64) {
                    bl2 = true;
                } else if (stereoMolecule.getAtomicNo(n8) == 6 && !stereoMolecule.isAromaticAtom(this.mCentralAtom[n11])) {
                    long l = stereoMolecule.isAromaticAtom(n8) ? 2L : 4L;
                    this.mFragment.setAtomQueryFeature(this.mToFragmentAtom[n8], l, true);
                }
                n6 = stereoMolecule.getConnBond(this.mCentralAtom[n11], n9);
                n5 = stereoMolecule.getBondRingSize(n6);
                if (n5 == 3 || n5 == 4) {
                    this.mFragment.setBondQueryFeature(n7, n5 << 17, true);
                }
                if (stereoMolecule.isAromaticBond(n6) || stereoMolecule.getConnBondOrder(this.mCentralAtom[n11], n9) == 2) {
                    long l;
                    n4 = stereoMolecule.getNonHydrogenNeighbourCount(n8);
                    int n12 = n3 = n4 == 3 ? 1 : 0;
                    if (n3 == 0 && n4 == 2 && !stereoMolecule.isRingAtom(n8)) {
                        int n13 = n3 = stereoMolecule.getZNeighbour(this.mCentralAtom[1 - n11], n6) != -1 ? 1 : 0;
                    }
                    if (n3 != 0) {
                        l = 0x2E0000L;
                        this.mFragment.setAtomQueryFeature(this.mToFragmentAtom[n8], l, true);
                    } else if (stereoMolecule.isAromaticBond(n6)) {
                        l = 0x360000L;
                        this.mFragment.setAtomQueryFeature(this.mToFragmentAtom[n8], l, true);
                    }
                }
                if (stereoMolecule.getConnBondOrder(this.mCentralAtom[n11], n9) != 1) continue;
                if (stereoMolecule.getNonHydrogenNeighbourCount(n8) == 4) {
                    long l = 0x1E0000L;
                    this.mFragment.setAtomQueryFeature(this.mToFragmentAtom[n8], l, true);
                    continue;
                }
                if (stereoMolecule.getAtomicNo(n8) != 6) continue;
                this.mFragment.setAtomQueryFeature(this.mToFragmentAtom[n8], 0x200000L, true);
            }
            if (bl2) continue;
            if (stereoMolecule.isAromaticAtom(this.mCentralAtom[n11])) {
                this.mFragment.setAtomQueryFeature(this.mToFragmentAtom[this.mCentralAtom[n11]], 2L, true);
                continue;
            }
            this.mFragment.setAtomQueryFeature(this.mToFragmentAtom[this.mCentralAtom[n11]], 4L, true);
        }
        this.mFragment.ensureHelperArrays(191);
        for (n11 = 0; n11 < 2; ++n11) {
            int n14 = this.mToFragmentAtom[this.mCentralAtom[n11]];
            if (this.mFragment.getAtomParity(n14) != 3) continue;
            if (stereoMolecule.getAtomParity(this.mCentralAtom[n11]) == 3) {
                return false;
            }
            n9 = this.mFragment.getAtomPreferredStereoBond(n14);
            this.mFragment.setBondType(n9, 257);
            if (this.mFragment.getBondAtom(0, n9) != n14) {
                this.mFragment.setBondAtom(1, n9, this.mFragment.getBondAtom(0, n9));
                this.mFragment.setBondAtom(0, n9, n14);
            }
            this.mFragment.ensureHelperArrays(191);
        }
        n11 = this.mToFragmentAtom[this.mCentralAtom[0]];
        int n15 = this.mToFragmentAtom[this.mCentralAtom[1]];
        n9 = this.mToFragmentAtom[this.mRearAtom[0]];
        n8 = this.mToFragmentAtom[this.mRearAtom[1]];
        n7 = this.mFragment.getAtomESRType(n11);
        n6 = this.mFragment.getAtomESRType(n15);
        if (this.mFragment.isAtomStereoCenter(n11) && this.mFragment.isAtomStereoCenter(n15) && (n7 != 0 || n6 != 0) && (n7 != n6 || this.mFragment.getAtomESRGroup(n11) != this.mFragment.getAtomESRGroup(n15))) {
            return false;
        }
        n5 = 0;
        if (this.mFragment.isAtomStereoCenter(n11) && n7 != 0) {
            this.mFragment.setAtomESR(n11, 0, -1);
            n5 = 1;
        }
        if (this.mFragment.isAtomStereoCenter(n15) && n6 != 0) {
            this.mFragment.setAtomESR(n15, 0, -1);
            n5 = 1;
        }
        if (n5 != 0) {
            this.mFragment.ensureHelperArrays(191);
        }
        if ((n4 = this.mFragment.getSymmetryRank(n11)) < (n3 = this.mFragment.getSymmetryRank(n15))) {
            int n16 = this.mCentralAtom[0];
            this.mCentralAtom[0] = this.mCentralAtom[1];
            this.mCentralAtom[1] = n16;
            n16 = this.mRearAtom[0];
            this.mRearAtom[0] = this.mRearAtom[1];
            this.mRearAtom[1] = n16;
            n16 = n11;
            n11 = n15;
            n15 = n16;
            n16 = n9;
            n9 = n8;
            n8 = n16;
        }
        boolean bl3 = false;
        if (this.mFragment.isAtomStereoCenter(n11) || this.mFragment.isAtomStereoCenter(n15)) {
            if (this.mFragment.isAtomStereoCenter(n11)) {
                bl3 = this.mFragment.getAbsoluteAtomParity(n11) == 1;
            } else if (this.mFragment.isAtomStereoCenter(n15)) {
                boolean bl4 = bl3 = this.mFragment.getAbsoluteAtomParity(n15) == 1;
            }
            if (bl3) {
                for (n2 = 0; n2 < this.mFragment.getAllAtoms(); ++n2) {
                    this.mFragment.setAtomX(n2, -this.mFragment.getAtomX(n2));
                }
                this.mFragment.ensureHelperArrays(191);
            }
        }
        n2 = this.getReferenceNeighbor(n11, n9);
        int n17 = this.getReferenceNeighbor(n15, n8);
        this.mRefAtom[0] = n2 == -1 ? -1 : this.mToMoleculeAtom[n2];
        this.mRefAtom[1] = n17 == -1 ? -1 : this.mToMoleculeAtom[n17];
        String string = this.mFragment.getIDCode();
        if (string == null) {
            return false;
        }
        int n18 = this.getHalfSymmetry(n11, n9);
        int n19 = this.getHalfSymmetry(n15, n8);
        int n20 = n18 == 0 && n19 == 0 && (this.mFragment.getChirality() & 0xFFFF0000) == 131072 ? 2 : SYMMETRY[n18][n19];
        String string2 = n20 == 0 ? (bl3 ? "<" : ">") : (n20 == 1 ? (bl3 ? "-" : "+") : (n20 == 3 ? "=" : ""));
        this.mID = string + string2;
        return true;
    }

    private int getReferenceNeighbor(int n, int n2) {
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        boolean[] blArray = new boolean[this.mFragment.getConnAtoms(n)];
        for (int i = 0; i < this.mFragment.getConnAtoms(n); ++i) {
            int n6;
            int n7;
            if (blArray[i] || (n7 = this.mFragment.getConnAtom(n, i)) == n2 || n4 >= (n6 = this.mFragment.getSymmetryRank(n7))) continue;
            boolean bl = false;
            for (int j = i + 1; j < this.mFragment.getConnAtoms(n); ++j) {
                int n8 = this.mFragment.getConnAtom(n, j);
                if (n8 == n2 || this.mFragment.getSymmetryRank(n8) != n6) continue;
                blArray[j] = true;
                if (bl) {
                    return n7;
                }
                bl = true;
            }
            if (!bl) {
                n4 = n6;
                n3 = n7;
                continue;
            }
            n5 = n7;
        }
        if (n3 == -1 && this.isFlatAtom(n)) {
            return n5;
        }
        return n3;
    }

    private boolean isFlatAtom(int n) {
        return this.mFragment.getAtomPi(n) == 1 && this.mFragment.getAtomicNo(n) < 10 || this.mFragment.isAromaticAtom(n) || this.mFragment.isFlatNitrogen(n);
    }

    private int getHalfSymmetry(int n, int n2) {
        if (this.mFragment.getConnAtoms(n) == 2) {
            return 1;
        }
        int[] nArray = this.getTerminalAtoms(n, n2);
        if (this.mFragment.getConnAtoms(n) == 3) {
            if (this.mFragment.getSymmetryRank(nArray[0]) == this.mFragment.getSymmetryRank(nArray[1])) {
                return this.isFlatAtom(n) ? 2 : 1;
            }
            return this.isFlatAtom(n) ? 1 : 0;
        }
        if (this.mFragment.getConnAtoms(n) == 4) {
            for (int i = 0; i < nArray.length; ++i) {
                int n3 = this.mFragment.getSymmetryRank(nArray[i]);
                for (int j = i + 1; j < nArray.length; ++j) {
                    if (n3 != this.mFragment.getSymmetryRank(nArray[j])) continue;
                    return 1;
                }
            }
        }
        return 0;
    }

    private int[] getTerminalAtoms(int n, int n2) {
        int n3 = 0;
        int[] nArray = new int[this.mFragment.getConnAtoms(n) - 1];
        for (int i = 0; i < this.mFragment.getConnAtoms(n); ++i) {
            if (this.mFragment.getConnAtom(n, i) == n2) continue;
            nArray[n3++] = this.mFragment.getConnAtom(n, i);
        }
        return nArray;
    }
}

