/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.conf;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.conf.TorsionDB;
import com.actelion.research.chem.conf.TorsionDetail;
import com.actelion.research.chem.phesa.PheSAAlignment;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.stream.IntStream;

public class BondRotationHelper {
    private StereoMolecule mMol;
    private int[] mRotatableBonds;
    private boolean[] mIsRotatableBond;
    private int[][] mSmallerSideAtomLists;
    private int[][] mBiggerSideAtomLists;
    private int[][] mTorsionAtoms;
    private int[][] mRearAtoms;
    private int[] mRotationCenters;
    private int[] mRotationCentersBig;
    private String[] mTorsionIDs;
    private boolean includeTerminalPolarH;
    private int[] terminalPolarHBond;

    public BondRotationHelper(StereoMolecule stereoMolecule) {
        this(stereoMolecule, false);
    }

    public BondRotationHelper(StereoMolecule stereoMolecule, boolean bl) {
        this.mMol = stereoMolecule;
        this.includeTerminalPolarH = bl;
        this.initialize();
    }

    public void initialize() {
        int[] nArray = new int[this.mMol.getAllAtoms()];
        int n2 = this.mMol.getFragmentNumbers(nArray, false, true);
        int[] nArray2 = new int[n2];
        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
            int n3 = nArray[i];
            nArray2[n3] = nArray2[n3] + 1;
        }
        this.mIsRotatableBond = new boolean[this.mMol.getBonds()];
        TorsionDB.findRotatableBonds(this.mMol, true, this.mIsRotatableBond);
        if (this.includeTerminalPolarH) {
            this.terminalPolarHBond = this.findTerminalBondsPolarHs(this.mIsRotatableBond);
        }
        ArrayList arrayList = new ArrayList();
        IntStream.range(0, this.mIsRotatableBond.length).forEach(n -> {
            if (this.mIsRotatableBond[n]) {
                arrayList.add(n);
            }
        });
        this.mRotatableBonds = arrayList.stream().mapToInt(n -> n).toArray();
        this.mTorsionAtoms = new int[this.mRotatableBonds.length][];
        this.mRearAtoms = new int[this.mRotatableBonds.length][];
        this.mSmallerSideAtomLists = new int[this.mRotatableBonds.length][];
        this.mBiggerSideAtomLists = new int[this.mRotatableBonds.length][];
        this.mRotationCenters = new int[this.mRotatableBonds.length];
        this.mRotationCentersBig = new int[this.mRotatableBonds.length];
        this.mTorsionIDs = new String[this.mRotatableBonds.length];
        for (int i = 0; i < this.mRotatableBonds.length; ++i) {
            String string;
            int n4 = this.mRotatableBonds[i];
            boolean bl = false;
            if (this.terminalPolarHBond != null) {
                for (int n5 : this.terminalPolarHBond) {
                    if (n5 != n4) continue;
                    bl = true;
                }
            }
            int[] nArray3 = new int[4];
            int[] nArray4 = new int[2];
            TorsionDetail torsionDetail = new TorsionDetail();
            this.mTorsionIDs[i] = string = TorsionDB.getTorsionID(this.mMol, n4, nArray3, torsionDetail);
            if (bl) {
                int n6 = this.mMol.getBondAtom(0, n4);
                int n7 = this.mMol.getBondAtom(1, n4);
                int n8 = this.mMol.getConnAtom(n6, 0) == n7 ? this.mMol.getConnAtom(n6, 1) : this.mMol.getConnAtom(n6, 0);
                int n9 = this.mMol.getConnAtom(n7, 0) == n6 ? this.mMol.getConnAtom(n7, 1) : this.mMol.getConnAtom(n7, 0);
                nArray4[0] = n7;
                nArray4[1] = n6;
                nArray3[0] = n8;
                nArray3[1] = n6;
                nArray3[2] = n7;
                nArray3[3] = n9;
            } else if (string != null) {
                nArray4[0] = torsionDetail.getRearAtom(0);
                nArray4[1] = torsionDetail.getRearAtom(1);
            } else {
                BondRotationHelper.predictAtomSequence(this.mMol, n4, nArray3, nArray4);
            }
            this.mTorsionAtoms[i] = nArray3;
            this.mRearAtoms[i] = nArray4;
            this.findSmallerSideAtomList(nArray2[nArray[this.mMol.getBondAtom(0, n4)]], nArray, i);
        }
    }

    private int[] findTerminalBondsPolarHs(boolean[] blArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.mMol.getBonds(); ++i) {
            int n = this.mMol.getBondAtom(0, i);
            int n2 = this.mMol.getBondAtom(1, i);
            if ((this.mMol.getAtomicNo(n) == 7 || this.mMol.getAtomicNo(n) == 8) && this.mMol.getNonHydrogenNeighbourCount(n) == 1 && this.mMol.getAllHydrogens(n) > 0) {
                blArray[i] = true;
                arrayList.add(i);
                continue;
            }
            if (this.mMol.getAtomicNo(n2) != 7 && this.mMol.getAtomicNo(n2) != 8 || this.mMol.getNonHydrogenNeighbourCount(n2) != 1 || this.mMol.getAllHydrogens(n2) <= 0) continue;
            blArray[i] = true;
            arrayList.add(i);
        }
        return arrayList.stream().mapToInt(Integer::intValue).toArray();
    }

    private void findSmallerSideAtomList(int n, int[] nArray, int n2) {
        int n3;
        int n4;
        int n5;
        boolean[] blArray = new boolean[this.mMol.getAllAtoms()];
        int n6 = this.mMol.getSubstituent(this.mRearAtoms[n2][0], this.mTorsionAtoms[n2][1], blArray, null, null);
        int n7 = 0;
        if (this.mRearAtoms[n2][0] != this.mTorsionAtoms[n2][2]) {
            n7 = this.mMol.getPathLength(this.mRearAtoms[n2][0], this.mTorsionAtoms[n2][2]);
        }
        boolean bl = false;
        if (n6 > n - n7 - n6) {
            n6 = n - n7 - n6;
            bl = true;
        }
        if (bl && n7 != 0) {
            n5 = this.mRearAtoms[n2][0];
            n4 = this.mTorsionAtoms[n2][1];
            block0: while (this.mMol.getAtomPi(n5) == 2 && this.mMol.getConnAtoms(n5) == 2 && this.mMol.getAtomicNo(n5) < 10) {
                blArray[n5] = true;
                for (int i = 0; i < 2; ++i) {
                    n3 = this.mMol.getConnAtom(n5, i);
                    if (n3 == n4) continue;
                    n4 = n5;
                    n5 = n3;
                    continue block0;
                }
            }
        }
        n5 = 0;
        n4 = nArray[this.mTorsionAtoms[n2][1]];
        int[] nArray2 = new int[n6];
        for (n3 = 0; n3 < this.mMol.getAllAtoms(); ++n3) {
            if (nArray[n3] != n4 || !(blArray[n3] ^ bl)) continue;
            nArray2[n5++] = n3;
        }
        this.mRotationCenters[n2] = n3 = this.mTorsionAtoms[n2][bl ? 2 : 1];
        this.mRotationCentersBig[n2] = this.mTorsionAtoms[n2][bl ? 1 : 2];
        this.mSmallerSideAtomLists[n2] = nArray2;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        for (int n8 : nArray2) {
            hashSet2.add(n8);
        }
        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
            if (hashSet2.contains(i)) continue;
            hashSet.add(i);
        }
        this.mBiggerSideAtomLists[n2] = hashSet.stream().mapToInt(Integer::intValue).toArray();
    }

    public static void predictAtomSequence(StereoMolecule stereoMolecule, int n, int[] nArray, int[] nArray2) {
        int n2;
        int n3;
        for (n3 = 0; n3 < 2; ++n3) {
            n2 = stereoMolecule.getBondAtom(n3, n);
            int n4 = stereoMolecule.getBondAtom(1 - n3, n);
            block1: while (stereoMolecule.getAtomPi(n2) == 2 && stereoMolecule.getConnAtoms(n2) == 2 && stereoMolecule.getAtomicNo(n2) < 10) {
                for (int i = 0; i < 2; ++i) {
                    int n5 = stereoMolecule.getConnAtom(n2, i);
                    if (n5 == n4) continue;
                    n4 = n2;
                    n2 = n5;
                    continue block1;
                }
            }
            nArray[n3 + 1] = n2;
            nArray2[n3] = n4;
        }
        if (stereoMolecule.getAtomPi(nArray[1]) == 0 && stereoMolecule.getConnAtoms(nArray[1]) == 3) {
            nArray[0] = -1;
        } else {
            for (n3 = 0; n3 < stereoMolecule.getConnAtoms(nArray[1]); ++n3) {
                n2 = stereoMolecule.getConnAtom(nArray[1], n3);
                if (n2 == nArray[2]) continue;
                nArray[0] = n2;
                break;
            }
        }
        if (stereoMolecule.getAtomPi(nArray[2]) == 0 && stereoMolecule.getConnAtoms(nArray[2]) == 3) {
            nArray[3] = -1;
        } else {
            for (n3 = 0; n3 < stereoMolecule.getConnAtoms(nArray[2]); ++n3) {
                n2 = stereoMolecule.getConnAtom(nArray[2], n3);
                if (n2 == nArray[1]) continue;
                nArray[3] = n2;
                break;
            }
        }
    }

    public boolean isRotatableBond(int n) {
        return this.mIsRotatableBond[n];
    }

    public int[] getRotatableBonds() {
        return this.mRotatableBonds;
    }

    public void rotateSmallerSide(int n, double d) {
        if (!this.isRotatableBond(n)) {
            return;
        }
        int n2 = -1;
        for (int i = 0; i < this.mRotatableBonds.length; ++i) {
            if (this.mRotatableBonds[i] != n) continue;
            n2 = i;
        }
        if (n2 == -1) {
            return;
        }
        Coordinates coordinates = this.mMol.getCoordinates(this.mTorsionAtoms[n2][2]);
        Coordinates coordinates2 = coordinates.subC(this.mMol.getCoordinates(this.mTorsionAtoms[n2][1])).unit();
        double[][] dArray = new double[3][3];
        int n3 = this.mRotationCenters[n2];
        PheSAAlignment.getRotationMatrix(n3 == this.mTorsionAtoms[n2][1] ? d : -d, coordinates2, dArray);
        Coordinates coordinates3 = coordinates.scaleC(-1.0);
        for (int n4 : this.mSmallerSideAtomLists[n2]) {
            if (n4 == n3) continue;
            this.mMol.getCoordinates(n4).add(coordinates3);
            this.mMol.getCoordinates(n4).rotate(dArray);
            this.mMol.getCoordinates(n4).add(coordinates);
        }
    }

    public void rotateAroundBond(int n, double d, Conformer conformer, boolean bl) {
        Coordinates coordinates;
        int n2;
        double[][] dArray;
        Coordinates coordinates2;
        Coordinates coordinates3;
        int[] nArray;
        if (bl) {
            nArray = this.mBiggerSideAtomLists[n];
            coordinates3 = conformer.getCoordinates(this.mTorsionAtoms[n][1]);
            coordinates2 = coordinates3.subC(conformer.getCoordinates(this.mTorsionAtoms[n][2])).unit();
            dArray = new double[3][3];
            n2 = this.mRotationCentersBig[n];
            PheSAAlignment.getRotationMatrix(n2 == this.mTorsionAtoms[n][2] ? d : -d, coordinates2, dArray);
            coordinates = coordinates3.scaleC(-1.0);
        } else {
            coordinates3 = conformer.getCoordinates(this.mTorsionAtoms[n][2]);
            coordinates2 = coordinates3.subC(conformer.getCoordinates(this.mTorsionAtoms[n][1])).unit();
            dArray = new double[3][3];
            n2 = this.mRotationCenters[n];
            PheSAAlignment.getRotationMatrix(n2 == this.mTorsionAtoms[n][1] ? d : -d, coordinates2, dArray);
            coordinates = coordinates3.scaleC(-1.0);
            nArray = this.mSmallerSideAtomLists[n];
        }
        for (int n3 : nArray) {
            if (n3 == n2) continue;
            Coordinates coordinates4 = conformer.getCoordinates(n3);
            coordinates4.add(coordinates);
            coordinates4.rotate(dArray);
            coordinates4.add(coordinates3);
        }
    }

    public void setRotatableBonds(int[] nArray) {
        this.mRotatableBonds = nArray;
    }

    public int[][] getSmallerSideAtomLists() {
        return this.mSmallerSideAtomLists;
    }

    public void setSmallerSideAtomLists(int[][] nArray) {
        this.mSmallerSideAtomLists = nArray;
    }

    public int[][] getTorsionAtoms() {
        return this.mTorsionAtoms;
    }

    public void setTorsionAtoms(int[][] nArray) {
        this.mTorsionAtoms = nArray;
    }

    public int[][] getRearAtoms() {
        return this.mRearAtoms;
    }

    public void setRearAtoms(int[][] nArray) {
        this.mRearAtoms = nArray;
    }

    public int[] getRotationCenters() {
        return this.mRotationCenters;
    }

    public void setRotationCenters(int[] nArray) {
        this.mRotationCenters = nArray;
    }

    public String[] getTorsionIDs() {
        return this.mTorsionIDs;
    }

    public void setTorsionIDs(String[] stringArray) {
        this.mTorsionIDs = stringArray;
    }
}

