/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.alignment3d.transformation;

import com.actelion.research.chem.alignment3d.transformation.ExponentialMap;
import com.actelion.research.chem.alignment3d.transformation.Quaternion;

public class RotationDerivatives {
    private double[] v;
    private double theta;
    private double cosp;
    private double sinp;
    Quaternion q;

    public RotationDerivatives(double[] dArray) {
        this.sinp = Math.sin(0.5 * this.theta);
        this.v = dArray;
        this.theta = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        this.cosp = Math.cos(0.5 * this.theta);
        this.sinp = Math.sin(0.5 * this.theta);
        ExponentialMap exponentialMap = new ExponentialMap(dArray[0], dArray[1], dArray[2]);
        this.q = exponentialMap.toQuaternion();
    }

    void dRdvi(Quaternion quaternion, double[][] dArray) {
        double[] dArray2 = new double[]{-4.0 * this.q.getQ1() * quaternion.getQ1(), -4.0 * this.q.getQ2() * quaternion.getQ2(), -4.0 * this.q.getQ3() * quaternion.getQ3(), 2.0 * (this.q.getQ2() * quaternion.getQ1() + this.q.getQ1() * quaternion.getQ2()), 2.0 * (this.q.getQ0() * quaternion.getQ3() + this.q.getQ3() * quaternion.getQ0()), 2.0 * (this.q.getQ3() * quaternion.getQ1() + this.q.getQ1() * quaternion.getQ3()), 2.0 * (this.q.getQ0() * quaternion.getQ2() + this.q.getQ2() * quaternion.getQ0()), 2.0 * (this.q.getQ3() * quaternion.getQ2() + this.q.getQ2() * quaternion.getQ3()), 2.0 * (this.q.getQ0() * quaternion.getQ1() + this.q.getQ1() * quaternion.getQ0())};
        dArray[0][0] = dArray2[1] + dArray2[2];
        dArray[1][0] = dArray2[3] - dArray2[4];
        dArray[2][0] = dArray2[5] + dArray2[6];
        dArray[0][1] = dArray2[3] + dArray2[4];
        dArray[1][1] = dArray2[0] + dArray2[2];
        dArray[2][1] = dArray2[7] - dArray2[8];
        dArray[0][2] = dArray2[5] - dArray2[6];
        dArray[1][2] = dArray2[7] + dArray2[8];
        dArray[2][2] = dArray2[0] + dArray2[1];
    }

    public void dRdv(int n, double[][] dArray) {
        ExponentialMap exponentialMap = new ExponentialMap(this.v[0], this.v[1], this.v[2]);
        this.q = exponentialMap.toQuaternion();
        Quaternion quaternion = this.dqdvi(n);
        this.dRdvi(quaternion, dArray);
    }

    private Quaternion dqdvi(int n) {
        double d;
        double[] dArray = new double[3];
        assert (n >= 0 && n < 3);
        if (this.theta < 1.0E-6) {
            int n2 = (n + 1) % 3;
            int n3 = (n + 2) % 3;
            double d2 = 0.5 - this.theta * this.theta / 48.0;
            double d3 = this.v[n] * (this.theta * this.theta / 40.0 - 1.0) / 24.0;
            d = -0.5 * this.v[n] * d2;
            dArray[n] = this.v[n] * d3 + d2;
            dArray[n2] = this.v[n2] * d3;
            dArray[n3] = this.v[n3] * d3;
        } else {
            int n4 = (n + 1) % 3;
            int n5 = (n + 2) % 3;
            double d4 = 1.0 / this.theta;
            double d5 = d4 * d4 * this.v[n];
            double d6 = this.sinp * d4;
            double d7 = d5 * (0.5 * this.cosp - d6);
            dArray[n] = d7 * this.v[n] + d6;
            dArray[n4] = d7 * this.v[n4];
            dArray[n5] = d7 * this.v[n5];
            d = -0.5 * this.v[n] * d6;
        }
        return new Quaternion(d, dArray[0], dArray[1], dArray[2]);
    }
}

