/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

class SmilesRange {
    private byte[] smi;
    private int pos;
    public int min;
    public int max;
    public boolean isDefault;

    public SmilesRange(byte[] byArray) {
        this.smi = byArray;
    }

    public int parse(byte[] byArray, int n, int n2, int n3) {
        this.isDefault = false;
        this.pos = n;
        if (Character.isDigit(byArray[n])) {
            this.min = this.max = this.parseInt();
            return this.pos - n;
        }
        if (byArray[n] == 123 && Character.isDigit(byArray[n + 1])) {
            ++this.pos;
            this.min = this.parseInt();
            if (byArray[this.pos++] != 45) {
                return 0;
            }
            if (!Character.isDigit(byArray[this.pos])) {
                return 0;
            }
            this.max = this.parseInt();
            if (byArray[this.pos++] != 125) {
                return 0;
            }
            return this.pos - n;
        }
        this.min = n2;
        this.max = n3;
        this.isDefault = true;
        return 0;
    }

    public boolean isSingle() {
        return this.max == this.min;
    }

    public boolean isRange() {
        return this.max > this.min;
    }

    public String toString() {
        return "{" + this.min + "-" + this.max + "}";
    }

    private int parseInt() {
        int n = this.smi[this.pos++] - 48;
        if (Character.isDigit(this.smi[this.pos])) {
            n = 10 * n + (this.smi[this.pos++] - 48);
        }
        return n;
    }
}

