/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.ExtendedMolecule;

@Deprecated
public class SimpleCanonizer {
    private static final int cIDCodeVersion3 = 9;
    private ExtendedMolecule mMol;
    private int[] mCanRank;
    private long[] mCanBaseValue;
    private boolean mGraphGenerated;
    private int mGraphRings;
    private int[] mGraphAtom;
    private int[] mGraphBond;
    private int[] mGraphFrom;
    private int[] mGraphClosure;
    public static final int MAX_ATOM_BITS = 8;
    private String mIDCode;
    private String mCoordinates;
    private StringBuffer mEncodingBuffer;
    private int mEncodingBitsAvail;
    private int mEncodingTempData;
    private boolean mZCoordinatesAvailable;

    public SimpleCanonizer(ExtendedMolecule extendedMolecule) {
        int n;
        this.mMol = extendedMolecule;
        this.mMol.ensureHelperArrays(7);
        for (n = 0; n < this.mMol.getAtoms(); ++n) {
            if (this.mMol.getAtomZ(n) == 0.0) continue;
            this.mZCoordinatesAvailable = true;
            break;
        }
        this.mCanRank = new int[this.mMol.getAllAtoms()];
        this.mCanBaseValue = new long[this.mMol.getAtoms()];
        for (n = 0; n < this.mMol.getAtoms(); ++n) {
            this.mCanBaseValue[n] = (this.mMol.getAtomQueryFeatures(n) & 1L) != 0L ? 6L : (long)this.mMol.getAtomicNo(n);
            int n2 = n;
            this.mCanBaseValue[n2] = this.mCanBaseValue[n2] << 8;
            int n3 = n;
            this.mCanBaseValue[n3] = this.mCanBaseValue[n3] + (long)this.mMol.getAtomMass(n);
            int n4 = n;
            this.mCanBaseValue[n4] = this.mCanBaseValue[n4] << 2;
            int n5 = n;
            this.mCanBaseValue[n5] = this.mCanBaseValue[n5] + (long)this.mMol.getAtomPi(n);
            int n6 = n;
            this.mCanBaseValue[n6] = this.mCanBaseValue[n6] << 3;
            int n7 = n;
            this.mCanBaseValue[n7] = this.mCanBaseValue[n7] + (long)this.mMol.getConnAtoms(n);
            int n8 = n;
            this.mCanBaseValue[n8] = this.mCanBaseValue[n8] << 4;
            if ((this.mMol.getAtomQueryFeatures(n) & 1L) != 0L) {
                int n9 = n;
                this.mCanBaseValue[n9] = this.mCanBaseValue[n9] + 8L;
            } else {
                int n10 = n;
                this.mCanBaseValue[n10] = this.mCanBaseValue[n10] + (long)(8 + this.mMol.getAtomCharge(n));
            }
            int n11 = n;
            this.mCanBaseValue[n11] = this.mCanBaseValue[n11] << 5;
            int n12 = n;
            this.mCanBaseValue[n12] = this.mCanBaseValue[n12] + (long)this.mMol.getAtomRingSize(n);
            int n13 = n;
            this.mCanBaseValue[n13] = this.mCanBaseValue[n13] << 4;
            int n14 = n;
            this.mCanBaseValue[n14] = this.mCanBaseValue[n14] + (long)(this.mMol.getAtomAbnormalValence(n) + 1);
            int n15 = n;
            this.mCanBaseValue[n15] = this.mCanBaseValue[n15] << 46;
            int n16 = n;
            this.mCanBaseValue[n16] = this.mCanBaseValue[n16] + this.mMol.getAtomQueryFeatures(n);
            int n17 = n;
            this.mCanBaseValue[n17] = this.mCanBaseValue[n17] << 1;
            if (this.mMol.getAtomList(n) == null) continue;
            int n18 = n;
            this.mCanBaseValue[n18] = this.mCanBaseValue[n18] + 1L;
        }
        n = this.canPerformFullRanking();
        while (n < this.mMol.getAtoms()) {
            int n19;
            int n20;
            for (n20 = 0; n20 < this.mMol.getAtoms(); ++n20) {
                this.mCanBaseValue[n20] = 2 * this.mCanRank[n20];
            }
            for (n20 = 1; n20 <= n; ++n20) {
                n19 = 0;
                for (int i = 0; i < this.mMol.getAtoms(); ++i) {
                    if (this.mCanRank[i] != n20) continue;
                    ++n19;
                }
                if (n19 > 1) break;
            }
            for (n19 = 0; n19 < this.mMol.getAtoms(); ++n19) {
                if (this.mCanRank[n19] != n20) continue;
                int n21 = n19;
                this.mCanBaseValue[n21] = this.mCanBaseValue[n21] + 1L;
                break;
            }
            n = this.canPerformFullRanking();
        }
    }

    private int canPerformFullRanking() {
        int n;
        int n2 = this.canConsolidate();
        do {
            n = n2;
            this.canCalcNextBaseValues();
        } while (n != (n2 = this.canConsolidate()));
        return n2;
    }

    private void canCalcNextBaseValues() {
        int[] nArray = new int[16];
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            int n;
            for (n = 0; n < this.mMol.getConnAtoms(i); ++n) {
                int n2;
                int n3 = 2 * this.mCanRank[this.mMol.getConnAtom(i, n)];
                int n4 = this.mMol.getConnBond(i, n);
                if (this.mMol.getBondOrder(n4) == 2 && !this.mMol.isAromaticBond(n4)) {
                    ++n3;
                }
                for (n2 = 0; n2 < n && n3 >= nArray[n2]; ++n2) {
                }
                for (int j = n; j > n2; --j) {
                    nArray[j] = nArray[j - 1];
                }
                nArray[n2] = n3;
            }
            this.mCanBaseValue[i] = 0L;
            for (n = 0; n < Math.min(6, this.mMol.getConnAtoms(i)); ++n) {
                int n5 = i;
                this.mCanBaseValue[n5] = this.mCanBaseValue[n5] << 9;
                int n6 = i;
                this.mCanBaseValue[n6] = this.mCanBaseValue[n6] + (long)nArray[n];
            }
            int n7 = i;
            this.mCanBaseValue[n7] = this.mCanBaseValue[n7] + (long)(this.mCanRank[i] << 55);
        }
    }

    private int canConsolidate() {
        int n = 0;
        block0: while (true) {
            int n2;
            long l = Long.MAX_VALUE;
            for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
                if (l <= this.mCanBaseValue[n2]) continue;
                l = this.mCanBaseValue[n2];
            }
            if (l == Long.MAX_VALUE) break;
            ++n;
            n2 = 0;
            while (true) {
                if (n2 >= this.mMol.getAtoms()) continue block0;
                if (this.mCanBaseValue[n2] == l) {
                    this.mCanBaseValue[n2] = Long.MAX_VALUE;
                    this.mCanRank[n2] = n;
                }
                ++n2;
            }
            break;
        }
        return n;
    }

    private void generateGraph() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.mMol.getAtoms() == 0) {
            return;
        }
        if (this.mGraphGenerated) {
            return;
        }
        int n6 = 0;
        for (int i = 1; i < this.mMol.getAtoms(); ++i) {
            if (this.mCanRank[i] <= this.mCanRank[n6]) continue;
            n6 = i;
        }
        boolean[] blArray = new boolean[this.mMol.getAtoms()];
        boolean[] blArray2 = new boolean[this.mMol.getBonds()];
        int[] nArray = new int[this.mMol.getAtoms()];
        this.mGraphAtom = new int[this.mMol.getAtoms()];
        this.mGraphFrom = new int[this.mMol.getAtoms()];
        this.mGraphBond = new int[this.mMol.getBonds()];
        this.mGraphAtom[0] = n6;
        blArray[n6] = true;
        int n7 = 1;
        int n8 = 0;
        int n9 = 1;
        int n10 = 0;
        while (n8 < this.mMol.getAtoms()) {
            if (n8 < n9) {
                while (true) {
                    n5 = 0;
                    n4 = 0;
                    n3 = -1;
                    for (n2 = 0; n2 < this.mMol.getConnAtoms(this.mGraphAtom[n8]); ++n2) {
                        n = this.mMol.getConnAtom(this.mGraphAtom[n8], n2);
                        if (blArray[n] || this.mCanRank[n] <= n3) continue;
                        n5 = n;
                        n4 = this.mMol.getConnBond(this.mGraphAtom[n8], n2);
                        n3 = this.mCanRank[n];
                    }
                    if (n3 == -1) break;
                    nArray[n5] = n9;
                    this.mGraphFrom[n9] = n8;
                    this.mGraphAtom[n9++] = n5;
                    this.mGraphBond[n10++] = n4;
                    blArray[n5] = true;
                    blArray2[n4] = true;
                }
                ++n8;
                continue;
            }
            n5 = 0;
            n4 = -1;
            for (n3 = 0; n3 < this.mMol.getAtoms(); ++n3) {
                if (blArray[n3] || this.mCanRank[n3] <= n4) continue;
                n5 = n3;
                n4 = this.mCanRank[n3];
            }
            ++n7;
            nArray[n5] = n9;
            this.mGraphFrom[n9] = -1;
            this.mGraphAtom[n9++] = n5;
            blArray[n5] = true;
        }
        this.mGraphClosure = new int[2 * (this.mMol.getBonds() - n10)];
        this.mGraphRings = 0;
        while (true) {
            n5 = this.mMol.getMaxAtoms();
            n4 = this.mMol.getMaxAtoms();
            n3 = -1;
            for (n2 = 0; n2 < this.mMol.getBonds(); ++n2) {
                int n11;
                if (blArray2[n2]) continue;
                if (nArray[this.mMol.getBondAtom(0, n2)] < nArray[this.mMol.getBondAtom(1, n2)]) {
                    n = nArray[this.mMol.getBondAtom(0, n2)];
                    n11 = nArray[this.mMol.getBondAtom(1, n2)];
                } else {
                    n = nArray[this.mMol.getBondAtom(1, n2)];
                    n11 = nArray[this.mMol.getBondAtom(0, n2)];
                }
                if (n >= n5 && (n != n5 || n11 >= n4)) continue;
                n5 = n;
                n4 = n11;
                n3 = n2;
            }
            if (n3 == -1) break;
            blArray2[n3] = true;
            this.mGraphBond[n10++] = n3;
            this.mGraphClosure[2 * this.mGraphRings] = n5;
            this.mGraphClosure[2 * this.mGraphRings + 1] = n4;
            ++this.mGraphRings;
        }
        this.mGraphGenerated = true;
    }

    public String getIDCode() {
        this.generateGraph();
        this.idCodeCreate();
        return this.mIDCode.toString();
    }

    private void idCodeCreate() {
        int n;
        boolean[] blArray;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        this.encodeBitsStart();
        this.encodeBits(9L, 4);
        int n7 = Math.max(this.idGetNeededBits(this.mMol.getAtoms()), this.idGetNeededBits(this.mMol.getBonds()));
        this.encodeBits(n7, 4);
        if (n7 == 0) {
            this.encodeBits(this.mMol.isFragment() ? 1L : 0L, 1);
            this.encodeBits(0L, 1);
            this.mIDCode = this.encodeBitsEnd();
            return;
        }
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        for (n6 = 0; n6 < this.mMol.getAtoms(); ++n6) {
            if ((this.mMol.getAtomQueryFeatures(n6) & 1L) != 0L) continue;
            switch (this.mMol.getAtomicNo(n6)) {
                case 6: {
                    break;
                }
                case 7: {
                    ++n11;
                    break;
                }
                case 8: {
                    ++n10;
                    break;
                }
                default: {
                    ++n9;
                }
            }
            if (this.mMol.getAtomCharge(n6) == 0) continue;
            ++n8;
        }
        this.encodeBits(this.mMol.getAtoms(), n7);
        this.encodeBits(this.mMol.getBonds(), n7);
        this.encodeBits(n11, n7);
        this.encodeBits(n10, n7);
        this.encodeBits(n9, n7);
        this.encodeBits(n8, n7);
        for (n6 = 0; n6 < this.mMol.getAtoms(); ++n6) {
            if (this.mMol.getAtomicNo(this.mGraphAtom[n6]) != 7 || (this.mMol.getAtomQueryFeatures(this.mGraphAtom[n6]) & 1L) != 0L) continue;
            this.encodeBits(n6, n7);
        }
        for (n6 = 0; n6 < this.mMol.getAtoms(); ++n6) {
            if (this.mMol.getAtomicNo(this.mGraphAtom[n6]) != 8 || (this.mMol.getAtomQueryFeatures(this.mGraphAtom[n6]) & 1L) != 0L) continue;
            this.encodeBits(n6, n7);
        }
        for (n6 = 0; n6 < this.mMol.getAtoms(); ++n6) {
            if (this.mMol.getAtomicNo(this.mGraphAtom[n6]) == 6 || this.mMol.getAtomicNo(this.mGraphAtom[n6]) == 7 || this.mMol.getAtomicNo(this.mGraphAtom[n6]) == 8 || (this.mMol.getAtomQueryFeatures(this.mGraphAtom[n6]) & 1L) != 0L) continue;
            this.encodeBits(n6, n7);
            this.encodeBits(this.mMol.getAtomicNo(this.mGraphAtom[n6]), 8);
        }
        for (n6 = 0; n6 < this.mMol.getAtoms(); ++n6) {
            if (this.mMol.getAtomCharge(this.mGraphAtom[n6]) == 0 || (this.mMol.getAtomQueryFeatures(this.mGraphAtom[n6]) & 1L) != 0L) continue;
            this.encodeBits(n6, n7);
            this.encodeBits(8 + this.mMol.getAtomCharge(this.mGraphAtom[n6]), 4);
        }
        n6 = 0;
        int n12 = 0;
        for (n5 = 1; n5 < this.mMol.getAtoms(); ++n5) {
            if (this.mGraphFrom[n5] == -1) {
                n4 = 0;
            } else {
                n4 = 1 + this.mGraphFrom[n5] - n12;
                n12 = this.mGraphFrom[n5];
            }
            if (n6 >= n4) continue;
            n6 = n4;
        }
        n5 = this.idGetNeededBits(n6);
        this.encodeBits(n5, 4);
        n12 = 0;
        for (n4 = 1; n4 < this.mMol.getAtoms(); ++n4) {
            if (this.mGraphFrom[n4] == -1) {
                n3 = 0;
            } else {
                n3 = 1 + this.mGraphFrom[n4] - n12;
                n12 = this.mGraphFrom[n4];
            }
            this.encodeBits(n3, n5);
        }
        for (n4 = 0; n4 < 2 * this.mGraphRings; ++n4) {
            this.encodeBits(this.mGraphClosure[n4], n7);
        }
        for (n4 = 0; n4 < this.mMol.getBonds(); ++n4) {
            n3 = (this.mMol.getBondQueryFeatures(this.mGraphBond[n4]) & 0x1FE00) != 0 || this.mMol.getBondType(this.mGraphBond[n4]) == 32 ? 1 : (this.mMol.isDelocalizedBond(this.mGraphBond[n4]) ? 0 : this.mMol.getBondOrder(this.mGraphBond[n4]));
            this.encodeBits(n3, 2);
        }
        this.encodeBits(0L, n7);
        this.encodeBits(0L, 1);
        this.encodeBits(0L, n7);
        this.encodeBits(this.mMol.isFragment() ? 1L : 0L, 1);
        n4 = 0;
        for (n3 = 0; n3 < this.mMol.getAtoms(); n3 += 1) {
            if (this.mMol.getAtomMass(this.mGraphAtom[n3]) == 0) continue;
            ++n4;
        }
        if (n4 != 0) {
            this.encodeBits(1L, 1);
            this.encodeBits(1L, 4);
            this.encodeBits(n4, n7);
            for (n3 = 0; n3 < this.mMol.getAtoms(); n3 += 1) {
                if (this.mMol.getAtomMass(this.mGraphAtom[n3]) == 0) continue;
                this.encodeBits(n3, n7);
                this.encodeBits(this.mMol.getAtomMass(this.mGraphAtom[n3]), 8);
            }
        }
        n3 = 0;
        if (this.mMol.isFragment()) {
            this.addAtomQueryFeatures(0, false, n7, 2048L, 1, -1);
            this.addAtomQueryFeatures(3, false, n7, 4096L, 1, -1);
            this.addAtomQueryFeatures(4, false, n7, 120L, 4, 3);
            this.addAtomQueryFeatures(5, false, n7, 0x400000000006L, 2, 1);
            this.addAtomQueryFeatures(6, false, n7, 1L, 1, -1);
            this.addAtomQueryFeatures(7, false, n7, 1920L, 4, 7);
            n4 = 0;
            for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
                if (this.mMol.getAtomList(this.mGraphAtom[n2]) == null) continue;
                ++n4;
            }
            if (n4 > 0) {
                this.encodeBits(1L, 1);
                this.encodeBits(8L, 4);
                this.encodeBits(n4, n7);
                for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
                    int[] nArray = this.mMol.getAtomList(this.mGraphAtom[n2]);
                    if (nArray == null) continue;
                    this.encodeBits(n2, n7);
                    this.encodeBits(nArray.length, 4);
                    for (int i = 0; i < nArray.length; ++i) {
                        this.encodeBits(nArray[i], 8);
                    }
                }
            }
            this.addBondQueryFeatures(9, false, n7, 384, 2, 7);
            this.addBondQueryFeatures(10, false, n7, 31, 5, 0);
            this.addAtomQueryFeatures(11, false, n7, 8192L, 1, -1);
            this.addBondQueryFeatures(12, false, n7, 130560, 8, 9);
            this.addAtomQueryFeatures(13, false, n7, 114688L, 3, 14);
            this.addAtomQueryFeatures(14, false, n7, 0x3E0000L, 5, 17);
            n3 |= this.addAtomQueryFeatures(16, n3 != 0, n7, 0x1C00000L, 3, 22);
        }
        n4 = 0;
        for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
            if (this.mMol.getAtomAbnormalValence(this.mGraphAtom[n2]) == -1) continue;
            ++n4;
        }
        if (n4 != 0) {
            n3 = this.ensureSecondFeatureBlock(n3 != 0);
            this.encodeBits(1L, 1);
            this.encodeBits(1L, 4);
            this.encodeBits(n4, n7);
            for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
                if (this.mMol.getAtomAbnormalValence(this.mGraphAtom[n2]) == -1) continue;
                this.encodeBits(n2, n7);
                this.encodeBits(this.mMol.getAtomAbnormalValence(this.mGraphAtom[n2]), 4);
            }
        }
        if (this.mMol.isFragment()) {
            n3 |= this.addAtomQueryFeatures(19, n3 != 0, n7, 0xE000000L, 3, 25);
            n3 |= this.addBondQueryFeatures(20, n3 != 0, n7, 917504, 3, 17);
        }
        n4 = 0;
        for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
            if (this.mMol.getAtomRadical(this.mGraphAtom[n2]) == 0) continue;
            ++n4;
        }
        if (n4 != 0) {
            n3 = this.ensureSecondFeatureBlock(n3 != 0);
            this.encodeBits(1L, 1);
            this.encodeBits(5L, 4);
            this.encodeBits(n4, n7);
            for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
                if (this.mMol.getAtomRadical(this.mGraphAtom[n2]) == 0) continue;
                this.encodeBits(n2, n7);
                this.encodeBits(this.mMol.getAtomRadical(this.mGraphAtom[n2]) >> 4, 2);
            }
        }
        if (this.mMol.isFragment()) {
            n3 |= this.addAtomQueryFeatures(22, n3 != 0, n7, 0x10000000L, 1, -1);
            n3 |= this.addBondQueryFeatures(23, n3 != 0, n7, 0x100000, 1, -1);
            n3 |= this.addBondQueryFeatures(24, n3 != 0, n7, 0x600000, 2, 21);
        }
        if ((blArray = this.getAromaticSPBonds()) != null) {
            int n13;
            n4 = 0;
            for (n13 = 0; n13 < this.mMol.getBonds(); ++n13) {
                if (!blArray[this.mGraphBond[n13]]) continue;
                ++n4;
            }
            n3 = this.ensureSecondFeatureBlock(n3 != 0);
            this.encodeBits(1L, 1);
            this.encodeBits(10L, 4);
            this.encodeBits(n4, n7);
            for (n13 = 0; n13 < this.mMol.getBonds(); ++n13) {
                if (!blArray[this.mGraphBond[n13]]) continue;
                this.encodeBits(n13, n7);
            }
        }
        if (this.mMol.isFragment()) {
            n3 |= this.addAtomQueryFeatures(27, n3 != 0, n7, 0x20000000L, 1, -1);
        }
        n4 = 0;
        for (n = 0; n < this.mMol.getBonds(); ++n) {
            if (this.mMol.getBondType(this.mGraphBond[n]) != 32) continue;
            ++n4;
        }
        n3 = this.ensureSecondFeatureBlock(n3 != 0);
        this.encodeBits(1L, 1);
        this.encodeBits(12L, 4);
        this.encodeBits(n4, n7);
        for (n = 0; n < this.mMol.getBonds(); ++n) {
            if (this.mMol.getBondType(this.mGraphBond[n]) != 32) continue;
            this.encodeBits(n, n7);
        }
        this.encodeBits(0L, 1);
        this.mIDCode = this.encodeBitsEnd();
    }

    private boolean ensureSecondFeatureBlock(boolean bl) {
        if (!bl) {
            this.encodeBits(1L, 1);
            this.encodeBits(15L, 4);
        }
        return true;
    }

    private boolean addAtomQueryFeatures(int n, boolean bl, int n2, long l, int n3, int n4) {
        int n5;
        int n6 = 0;
        for (n5 = 0; n5 < this.mMol.getAtoms(); ++n5) {
            if ((this.mMol.getAtomQueryFeatures(this.mGraphAtom[n5]) & l) == 0L) continue;
            ++n6;
        }
        if (n6 == 0) {
            return false;
        }
        if (n > 15) {
            this.ensureSecondFeatureBlock(bl);
            n -= 16;
        }
        this.encodeBits(1L, 1);
        this.encodeBits(n, 4);
        this.encodeBits(n6, n2);
        for (n5 = 0; n5 < this.mMol.getAtoms(); ++n5) {
            long l2 = this.mMol.getAtomQueryFeatures(this.mGraphAtom[n5]) & l;
            if (l2 == 0L) continue;
            this.encodeBits(n5, n2);
            if (n3 == 1) continue;
            this.encodeBits(l2 >> n4, n3);
        }
        return true;
    }

    private boolean addBondQueryFeatures(int n, boolean bl, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = 0;
        for (n6 = 0; n6 < this.mMol.getBonds(); ++n6) {
            if ((this.mMol.getBondQueryFeatures(this.mGraphBond[n6]) & n3) == 0) continue;
            ++n7;
        }
        if (n7 == 0) {
            return false;
        }
        if (n > 15) {
            this.ensureSecondFeatureBlock(bl);
            n -= 16;
        }
        this.encodeBits(1L, 1);
        this.encodeBits(n, 4);
        this.encodeBits(n7, n2);
        for (n6 = 0; n6 < this.mMol.getBonds(); ++n6) {
            int n8 = this.mMol.getBondQueryFeatures(this.mGraphBond[n6]) & n3;
            if (n8 == 0) continue;
            this.encodeBits(n6, n2);
            if (n4 == 1) continue;
            this.encodeBits(n8 >> n5, n4);
        }
        return true;
    }

    private boolean[] getAromaticSPBonds() {
        boolean[] blArray = null;
        for (int i = 0; i < this.mMol.getBonds(); ++i) {
            if (this.mMol.getAtomPi(this.mMol.getBondAtom(0, i)) != 2 || this.mMol.getAtomPi(this.mMol.getBondAtom(1, i)) != 2) continue;
            if (blArray == null) {
                blArray = new boolean[this.mMol.getBonds()];
            }
            blArray[i] = true;
        }
        return blArray;
    }

    public String getEncodedCoordinates() {
        if (this.mCoordinates == null) {
            this.generateGraph();
            this.encodeCoordinates(this.mZCoordinatesAvailable);
        }
        return this.mCoordinates;
    }

    private void encodeCoordinates(boolean bl) {
        double d;
        int n;
        if (this.mMol.getAtoms() == 0) {
            this.mCoordinates = "";
            return;
        }
        int n2 = this.mZCoordinatesAvailable ? 16 : 8;
        this.encodeBitsStart();
        this.mEncodingBuffer.append('!');
        this.encodeBits(this.mZCoordinatesAvailable ? 1L : 0L, 1);
        this.encodeBits(bl ? 1L : 0L, 1);
        this.encodeBits(n2 / 2, 4);
        double d2 = 0.0;
        for (n = 1; n < this.mMol.getAtoms(); ++n) {
            double d3;
            double d4;
            int n3 = this.mGraphAtom[n];
            int n4 = this.mGraphFrom[n] == -1 ? -1 : this.mGraphAtom[this.mGraphFrom[n]];
            double d5 = d = n4 == -1 ? Math.abs(this.mMol.getAtomX(n3) - this.mMol.getAtomX(this.mGraphAtom[0])) / 8.0 : Math.abs(this.mMol.getAtomX(n3) - this.mMol.getAtomX(n4));
            if (d2 < d) {
                d2 = d;
            }
            double d6 = d4 = n4 == -1 ? Math.abs(this.mMol.getAtomY(n3) - this.mMol.getAtomY(this.mGraphAtom[0])) / 8.0 : Math.abs(this.mMol.getAtomY(n3) - this.mMol.getAtomY(n4));
            if (d2 < d4) {
                d2 = d4;
            }
            if (!this.mZCoordinatesAvailable) continue;
            double d7 = d3 = n4 == -1 ? Math.abs(this.mMol.getAtomZ(n3) - this.mMol.getAtomZ(this.mGraphAtom[0])) / 8.0 : Math.abs(this.mMol.getAtomZ(n3) - this.mMol.getAtomZ(n4));
            if (!(d2 < d3)) continue;
            d2 = d3;
        }
        if (d2 == 0.0) {
            this.mCoordinates = "";
            return;
        }
        n = 1 << n2;
        double d8 = d2 / ((double)n / 2.0 - 1.0);
        d = d8 / 2.0;
        for (int i = 1; i < this.mMol.getAtoms(); ++i) {
            int n5 = this.mGraphAtom[i];
            int n6 = this.mGraphFrom[i] == -1 ? -1 : this.mGraphAtom[this.mGraphFrom[i]];
            double d9 = n6 == -1 ? (this.mMol.getAtomX(n5) - this.mMol.getAtomX(this.mGraphAtom[0])) / 8.0 : this.mMol.getAtomX(n5) - this.mMol.getAtomX(n6);
            double d10 = n6 == -1 ? (this.mMol.getAtomY(n5) - this.mMol.getAtomY(this.mGraphAtom[0])) / 8.0 : this.mMol.getAtomY(n5) - this.mMol.getAtomY(n6);
            this.encodeBits((int)((d2 + d9 + d) / d8), n2);
            this.encodeBits((int)((d2 + d10 + d) / d8), n2);
            if (!this.mZCoordinatesAvailable) continue;
            double d11 = n6 == -1 ? (this.mMol.getAtomZ(n5) - this.mMol.getAtomZ(this.mGraphAtom[0])) / 8.0 : this.mMol.getAtomZ(n5) - this.mMol.getAtomZ(n6);
            this.encodeBits((int)((d2 + d11 + d) / d8), n2);
        }
        if (bl) {
            this.encodeBits(this.encodeABVL(this.mMol.getAverageBondLength(true), n), n2);
            this.encodeBits(this.encodeShift(this.mMol.getAtomX(this.mGraphAtom[0]), n), n2);
            this.encodeBits(this.encodeShift(this.mMol.getAtomY(this.mGraphAtom[0]), n), n2);
            if (this.mZCoordinatesAvailable) {
                this.encodeBits(this.encodeShift(this.mMol.getAtomZ(this.mGraphAtom[0]), n), n2);
            }
        }
        this.mCoordinates = this.encodeBitsEnd();
    }

    private int encodeABVL(double d, int n) {
        return Math.min(n - 1, Math.max(0, (int)(0.5 + Math.log10(d / 0.1) / Math.log10(2000.0) * (double)(n - 1))));
    }

    private int encodeShift(double d, int n) {
        int n2 = n / 2;
        boolean bl = d < 0.0;
        d = Math.abs(d);
        float f = (float)n / 100.0f;
        int n3 = (int)(0.5 + d * (double)(n2 - 1) / (d + (double)f));
        return bl ? n2 + n3 : n3;
    }

    private void encodeBitsStart() {
        this.mEncodingBuffer = new StringBuffer();
        this.mEncodingBitsAvail = 6;
        this.mEncodingTempData = 0;
    }

    private void encodeBits(long l, int n) {
        while (n != 0) {
            if (this.mEncodingBitsAvail == 0) {
                this.mEncodingBuffer.append((char)(this.mEncodingTempData + 64));
                this.mEncodingBitsAvail = 6;
                this.mEncodingTempData = 0;
            }
            this.mEncodingTempData <<= 1;
            this.mEncodingTempData = (int)((long)this.mEncodingTempData | l & 1L);
            l >>= 1;
            --n;
            --this.mEncodingBitsAvail;
        }
    }

    private String encodeBitsEnd() {
        this.mEncodingTempData <<= this.mEncodingBitsAvail;
        this.mEncodingBuffer.append((char)(this.mEncodingTempData + 64));
        return this.mEncodingBuffer.toString();
    }

    private int idGetNeededBits(int n) {
        int n2 = 0;
        while (n > 0) {
            n >>= 1;
            ++n2;
        }
        return n2;
    }
}

