/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.AbstractDepictor;
import com.actelion.research.chem.DepictorTransformation;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.generic.GenericPolygon;
import com.actelion.research.gui.generic.GenericRectangle;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class SVGDepictor
extends AbstractDepictor<Void> {
    public static final int DEFAULT_ELEM_WIDTH = 8;
    private static final String FONTNAME = "Helvetica";
    private static int instanceCnt = 0;
    private double lineWidth = 1.0;
    private int textSize = 10;
    private int width = 400;
    private int height = 400;
    private boolean legacyMode = true;
    private String currentColor = "black";
    private final List<String> bonds = new ArrayList<String>();
    private final List<String> atoms = new ArrayList<String>();
    private String id;
    private StringBuilder buffer = new StringBuilder();
    private Font currentFont = new Font("Helvetica", 0, 12);
    private Graphics2D graphics;

    public SVGDepictor(StereoMolecule stereoMolecule, String string) {
        this(stereoMolecule, 0, string);
    }

    public SVGDepictor(StereoMolecule stereoMolecule, int n, String string) {
        super(stereoMolecule, n);
        this.id = string;
        ++instanceCnt;
    }

    public void setLegacyMode(boolean bl) {
        this.legacyMode = bl;
    }

    public static final String makeColor(int n, int n2, int n3) {
        return "rgb(" + n + "," + n2 + "," + n3 + ")";
    }

    public String getId() {
        return this.id != null ? this.id : "mol" + instanceCnt;
    }

    private void write(String string) {
        this.buffer.append("\t");
        this.buffer.append(string);
        this.buffer.append("\n");
    }

    @Override
    protected void drawBlackLine(AbstractDepictor.DepictorLine depictorLine) {
        int n = (int)depictorLine.x1;
        int n2 = (int)depictorLine.x2;
        int n3 = (int)depictorLine.y1;
        int n4 = (int)depictorLine.y2;
        String string = "<line x1=\"" + n + "\" y1=\"" + n3 + "\" x2=\"" + n2 + "\" y2=\"" + n4 + "\" style=\"stroke:" + this.currentColor + "; stroke-width:" + this.lineWidth + "\"/>";
        this.write(string);
    }

    @Override
    protected void drawDottedLine(AbstractDepictor.DepictorLine depictorLine) {
        int n = (int)depictorLine.x1;
        int n2 = (int)depictorLine.x2;
        int n3 = (int)depictorLine.y1;
        int n4 = (int)depictorLine.y2;
        int n5 = (int)(3.0 * this.lineWidth);
        String string = "<line stroke-dasharray=\"" + n5 + "," + n5 + "\" x1=\"" + n + "\" y1=\"" + n3 + "\" x2=\"" + n2 + "\" y2=\"" + n4 + "\" style=\"stroke:" + this.currentColor + "; stroke-width:" + this.lineWidth + "\"/>";
        this.write(string);
    }

    @Override
    protected void drawPolygon(GenericPolygon genericPolygon) {
        StringBuilder stringBuilder = new StringBuilder("<polygon points=\"");
        for (int i = 0; i < genericPolygon.getSize(); ++i) {
            stringBuilder.append(Math.round(genericPolygon.getX(i)));
            stringBuilder.append(",");
            stringBuilder.append(Math.round(genericPolygon.getY(i)));
            stringBuilder.append(" ");
        }
        stringBuilder.append("\" style=\"fill:" + this.currentColor + "; stroke:" + this.currentColor + "; stroke-width:" + this.lineWidth + "\"/>");
        this.write(stringBuilder.toString());
    }

    @Override
    protected void drawString(String string, double d, double d2) {
        double d3 = this.getStringWidth(string);
        String string2 = "<text x=\"" + (int)(d - d3 / 2.0) + "\" y=\"" + (int)(d2 + (double)(this.textSize / 3)) + "\" stroke=\"none\" font-size=\"" + this.currentFont.getSize() + "\" fill=\"" + this.currentColor + "\">" + string + "</text>";
        this.write(string2);
    }

    @Override
    protected void fillCircle(double d, double d2, double d3) {
        String string = "<circle cx=\"" + (int)(d + d3 / 2.0) + "\" cy=\"" + (int)(d2 + d3 / 2.0) + "\" r=\"" + (int)(d3 / 2.0) + "\" fill=\"" + this.currentColor + "\" />";
        this.write(string);
    }

    @Override
    protected double getLineWidth() {
        return this.lineWidth;
    }

    @Override
    protected double getStringWidth(String string) {
        float f = (float)this.currentFont.getStringBounds(string, this.graphics.getFontRenderContext()).getWidth();
        return f;
    }

    @Override
    protected int getTextSize() {
        return this.textSize;
    }

    @Override
    protected void setTextSize(int n) {
        if (this.textSize != n) {
            this.textSize = n;
            this.currentFont = new Font(FONTNAME, 0, n);
        }
    }

    @Override
    protected void setLineWidth(double d) {
        this.lineWidth = Math.round(100.0 * Math.max(d, 1.0)) / 100L;
    }

    @Override
    protected void setRGB(int n) {
        this.currentColor = SVGDepictor.makeColor((n & 0xFF0000) >> 16, (n & 0xFF00) >> 8, n & 0xFF);
    }

    @Override
    protected void onDrawBond(int n, double d, double d2, double d3, double d4) {
        String string = "<line id=\"" + this.getId() + ":Bond:" + n + "\" class=\"event\" x1=\"" + (int)d + "\" y1=\"" + (int)d2 + "\" x2=\"" + (int)d3 + "\" y2=\"" + (int)d4 + "\" stroke-width=\"" + 8 + "\" stroke-opacity=\"0\"/>";
        this.bonds.add(string);
    }

    @Override
    protected void onDrawAtom(int n, String string, double d, double d2) {
        int n2 = 8;
        String string2 = "<circle id=\"" + this.getId() + ":Atom:" + n + "\" class=\"event\" cx=\"" + (int)d + "\" cy=\"" + (int)d2 + "\" r=\"" + n2 + "\" fill-opacity=\"0\"/>";
        this.atoms.add(string2);
    }

    public String toString() {
        String string = "<svg id=\"" + this.getId() + "\" xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" width=\"" + this.width + "px\" height=\"" + this.height + "px\" viewBox=\"0 0 " + this.width + " " + this.height + "\">\n";
        String string2 = "</svg>";
        String string3 = this.legacyMode ? "<style> #" + this.getId() + " {pointer-events:none; }  #" + this.getId() + " .event  { pointer-events:all;}  </style>\n" : "<g style=\"font-size:" + this.getTextSize() + "px; fill-opacity:1; stroke-opacity:1; fill:black; stroke:black; font-weight:normal; text-rendering:optimizeLegibility; font-family:sans-serif; stroke-linejoin:round; stroke-linecap:round; stroke-dashoffset:0;\">";
        string = string + "\t";
        string = string + string3;
        if (this.legacyMode) {
            for (String string4 : this.bonds) {
                this.write(string4);
            }
            for (String string4 : this.atoms) {
                this.write(string4);
            }
        }
        if (!this.legacyMode) {
            this.write("</g>");
        }
        return string + this.buffer.toString() + string2;
    }

    @Override
    public DepictorTransformation simpleValidateView(GenericRectangle genericRectangle, int n) {
        this.width = (int)genericRectangle.getWidth();
        this.height = (int)genericRectangle.getHeight();
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 2);
        this.graphics = bufferedImage.createGraphics();
        return super.simpleValidateView(genericRectangle, n);
    }
}

