/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.util.DoubleFormat;

public class Mutation {
    public static final int MUTATION_ADD_ATOM = 1;
    public static final int MUTATION_INSERT_ATOM = 2;
    public static final int MUTATION_CHANGE_ATOM = 4;
    public static final int MUTATION_CUTOUT_ATOM = 8;
    public static final int MUTATION_DELETE_ATOM = 16;
    public static final int MUTATION_CLOSE_RING = 32;
    public static final int MUTATION_CHANGE_BOND = 64;
    public static final int MUTATION_DELETE_BOND = 128;
    public static final int MUTATION_CHANGE_RING = 256;
    public static final int MUTATION_CLOSE_RING_AND_AROMATIZE = 512;
    public static final int MUTATION_TOGGLE_AMID_SULFONAMID = 1024;
    public static final int MUTATION_MIGRATE = 2048;
    public static final int MUTATION_SWAP_SUBSTITUENT = 4096;
    public static final int MUTATION_DELETE_SUBSTITUENT = 8192;
    public static final int MUTATION_CUTOUT_SFRAGMENT = 16384;
    public static final int MUTATION_INVERT_PARITY = 32768;
    public static final int[][] cAllowedAtomicNo = new int[][]{{5, 6, 7, 8, 9, 15, 16, 17, 35, 53}, {6, 7, 8, 15, 16}, {6, 7}};
    public int mMutationType;
    public int mWhere1;
    public int mWhere2;
    public int mSpecifier1;
    public int mSpecifier2;
    public int[] mAtomList;
    public double mProbability;

    public Mutation() {
    }

    public Mutation(int n, int n2, int n3, int n4, int n5, double d) {
        this.mMutationType = n;
        this.mWhere1 = n2;
        this.mWhere2 = n3;
        this.mSpecifier1 = n4;
        this.mSpecifier2 = n5;
        this.mProbability = d;
    }

    public Mutation(int n, int n2, int n3, int n4, int[] nArray, double d) {
        this.mMutationType = n;
        this.mWhere1 = n2;
        this.mWhere2 = n3;
        this.mSpecifier1 = n4;
        this.mAtomList = nArray;
        this.mProbability = d;
    }

    public String toString() {
        switch (this.mMutationType) {
            case 1: {
                return "Atom Addition; AtAtom:" + this.mWhere1 + " AtomicNo:" + this.mSpecifier1 + " BondType:" + this.mSpecifier2 + " Probability:" + DoubleFormat.toString(this.mProbability);
            }
            case 2: {
                return "Atom Insertion; AtBond:" + this.mWhere1 + " AtomicNo:" + this.mSpecifier1 + " Probability:" + DoubleFormat.toString(this.mProbability);
            }
            case 4: {
                return "Atom Change; Atom:" + this.mWhere1 + " AtomicNo:" + this.mSpecifier1 + " Probability:" + DoubleFormat.toString(this.mProbability);
            }
            case 16: {
                return "Atom Deletion; Atom:" + this.mWhere1 + " Probability:" + DoubleFormat.toString(this.mProbability);
            }
            case 8: {
                return "Atom CutOut; Atom:" + this.mWhere1 + " Probability:" + DoubleFormat.toString(this.mProbability);
            }
            case 32: {
                return "Bond Addition; FromAtom:" + this.mWhere1 + " ToAtom:" + this.mWhere2 + " BondType:" + this.mSpecifier1 + " Probability:" + DoubleFormat.toString(this.mProbability);
            }
            case 64: {
                return "Bond Change; Bond:" + this.mWhere1 + " BondType:" + this.mSpecifier1 + " Probability:" + DoubleFormat.toString(this.mProbability);
            }
            case 128: {
                return "Bond Deletion; Bond:" + this.mWhere1 + " Probability:" + DoubleFormat.toString(this.mProbability);
            }
            case 256: {
                return "Ring Change; Ring:" + this.mWhere1 + " Probability:" + DoubleFormat.toString(this.mProbability);
            }
            case 512: {
                return "Close Ring And Aromatize; FromAtom:" + this.mWhere1 + " ToAtom:" + this.mWhere2 + " Probability:" + DoubleFormat.toString(this.mProbability);
            }
            case 1024: {
                return "Toggle Amid-Sulfonamid; Atom:" + this.mWhere1 + " Oxygen:" + this.mWhere1 + " Probability:" + DoubleFormat.toString(this.mProbability);
            }
            case 2048: {
                return "Group Migration; Bond:" + this.mWhere1 + " originalAtom:" + this.mSpecifier1 + " newAtom:" + this.mSpecifier2 + " Probability:" + DoubleFormat.toString(this.mProbability);
            }
            case 4096: {
                return "Swap Substituent; coreAtom1:" + this.mWhere1 + " firstAtom1:" + this.mSpecifier1 + " coreAtom2:" + this.mWhere2 + " firstAtom2:" + this.mSpecifier2 + " Probability:" + DoubleFormat.toString(this.mProbability);
            }
            case 8192: {
                return "Delete Substituent; coreAtom:" + this.mWhere1 + " firstAtom:" + this.mSpecifier1 + " Probability:" + DoubleFormat.toString(this.mProbability);
            }
            case 16384: {
                return "CutOut Fragment; rootAtom:" + this.mWhere1 + " new bond from atom1:" + this.mSpecifier1 + " to atom2:" + this.mSpecifier2 + " Probability:" + DoubleFormat.toString(this.mProbability);
            }
            case 32768: {
                return "Invert Parity; " + (this.mWhere1 != -1 ? "atom:" + this.mWhere1 : "bond:" + this.mWhere2) + " Probability:" + DoubleFormat.toString(this.mProbability);
            }
        }
        return "Unknown Mutation";
    }
}

