/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import java.io.IOException;
import java.io.Writer;

public class MolfileV3Creator {
    private StringBuilder mMolfile;
    private static final double TARGET_AVBL = 1.5;
    private static final double PRECISION_FACTOR = 10000.0;
    private double mScalingFactor = 1.0;

    public MolfileV3Creator(StereoMolecule stereoMolecule) {
        this(stereoMolecule, true);
    }

    public MolfileV3Creator(StereoMolecule stereoMolecule, boolean bl) {
        this(stereoMolecule, bl, 0.0, new StringBuilder(32768));
    }

    public MolfileV3Creator(StereoMolecule stereoMolecule, boolean bl, StringBuilder stringBuilder) {
        this(stereoMolecule, bl, 0.0, stringBuilder);
    }

    public MolfileV3Creator(StereoMolecule stereoMolecule, boolean bl, double d, StringBuilder stringBuilder) {
        stereoMolecule.ensureHelperArrays(15);
        String string = System.lineSeparator();
        this.mMolfile = stringBuilder == null ? new StringBuilder() : stringBuilder;
        String string2 = stereoMolecule.getName() != null ? stereoMolecule.getName() : "";
        this.mMolfile.append(string2 + string);
        this.mMolfile.append("Actelion Java MolfileCreator 2.0" + string + string);
        this.mMolfile.append("  0  0  0  0  0  0              0 V3000" + string);
        this.mScalingFactor = 1.0;
        boolean bl2 = MolfileV3Creator.hasCoordinates(stereoMolecule);
        if (bl2) {
            if (d != 0.0) {
                this.mScalingFactor = d;
            } else if (bl) {
                this.mScalingFactor = MolfileV3Creator.calculateScalingFactor(stereoMolecule);
            }
        }
        this.writeBody(stereoMolecule, bl2);
        this.mMolfile.append("M  END" + string);
    }

    private static boolean hasCoordinates(StereoMolecule stereoMolecule) {
        if (stereoMolecule.getAllAtoms() == 1) {
            return true;
        }
        for (int i = 1; i < stereoMolecule.getAllAtoms(); ++i) {
            if (stereoMolecule.getAtomX(i) == stereoMolecule.getAtomX(0) && stereoMolecule.getAtomY(i) == stereoMolecule.getAtomY(0) && stereoMolecule.getAtomZ(i) == stereoMolecule.getAtomZ(0)) continue;
            return true;
        }
        return false;
    }

    private static double calculateScalingFactor(StereoMolecule stereoMolecule) {
        double d = 1.0;
        double d2 = stereoMolecule.getAverageBondLength();
        if (d2 != 0.0) {
            if (d2 < 1.0 || d2 > 3.0) {
                d = 1.5 / d2;
            }
        } else {
            double d3 = 3.4028234663852886E38;
            for (int i = 1; i < stereoMolecule.getAllAtoms(); ++i) {
                for (int j = 0; j < i; ++j) {
                    double d4;
                    double d5;
                    double d6 = stereoMolecule.getAtomX(j) - stereoMolecule.getAtomX(i);
                    double d7 = d6 * d6 + (d5 = stereoMolecule.getAtomY(j) - stereoMolecule.getAtomY(i)) * d5 + (d4 = stereoMolecule.getAtomZ(j) - stereoMolecule.getAtomZ(i)) * d4;
                    if (!(d3 > d7)) continue;
                    d3 = d7;
                }
            }
            d = 3.0 / Math.max(0.75, d3);
        }
        return d;
    }

    public static String writeCTAB(StereoMolecule stereoMolecule, double d) {
        MolfileV3Creator molfileV3Creator = new MolfileV3Creator();
        molfileV3Creator.mScalingFactor = d;
        stereoMolecule.ensureHelperArrays(15);
        molfileV3Creator.writeBody(stereoMolecule, true);
        return molfileV3Creator.getMolfile();
    }

    private static String writeCTAB(StereoMolecule stereoMolecule, boolean bl) {
        MolfileV3Creator molfileV3Creator = new MolfileV3Creator();
        stereoMolecule.ensureHelperArrays(15);
        molfileV3Creator.writeBody(stereoMolecule, bl);
        return molfileV3Creator.getMolfile();
    }

    private MolfileV3Creator() {
        this.mMolfile = new StringBuilder(32768);
    }

    private void writeBody(StereoMolecule stereoMolecule, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        String string = System.lineSeparator();
        this.mMolfile.append("M  V30 BEGIN CTAB" + string);
        this.mMolfile.append("M  V30 COUNTS " + stereoMolecule.getAllAtoms() + " " + stereoMolecule.getAllBonds() + " 0 0 0" + string);
        this.mMolfile.append("M  V30 BEGIN ATOM" + string);
        for (n6 = 0; n6 < stereoMolecule.getAllAtoms(); ++n6) {
            long l;
            long l2;
            this.mMolfile.append("M  V30 " + (n6 + 1));
            if (stereoMolecule.getAtomList(n6) != null) {
                int[] nArray = stereoMolecule.getAtomList(n6);
                n5 = (stereoMolecule.getAtomQueryFeatures(n6) & 1L) != 0L ? 1 : 0;
                this.mMolfile.append(n5 != 0 ? " NOT[" : " [");
                block21: for (int i = 0; i < nArray.length; ++i) {
                    if (i > 0) {
                        this.mMolfile.append(",");
                    }
                    String string2 = Molecule.cAtomLabel[nArray[i]];
                    switch (string2.length()) {
                        case 1: {
                            this.mMolfile.append(string2);
                            continue block21;
                        }
                        case 2: {
                            this.mMolfile.append(string2);
                            continue block21;
                        }
                        case 3: {
                            this.mMolfile.append(string2);
                            continue block21;
                        }
                        default: {
                            this.mMolfile.append("?");
                        }
                    }
                }
                this.mMolfile.append("]");
            } else if ((stereoMolecule.getAtomQueryFeatures(n6) & 1L) != 0L) {
                this.mMolfile.append(" A");
            } else if (stereoMolecule.getAtomicNo(n6) >= 129 && stereoMolecule.getAtomicNo(n6) <= 144 || stereoMolecule.getAtomicNo(n6) == 154) {
                this.mMolfile.append(" R#");
            } else {
                this.mMolfile.append(" " + stereoMolecule.getAtomLabel(n6));
            }
            if (bl) {
                this.mMolfile.append(" " + (double)((int)(10000.0 * this.mScalingFactor * stereoMolecule.getAtomX(n6))) / 10000.0);
                this.mMolfile.append(" " + (double)((int)(10000.0 * this.mScalingFactor * -stereoMolecule.getAtomY(n6))) / 10000.0);
                this.mMolfile.append(" " + (double)((int)(10000.0 * this.mScalingFactor * -stereoMolecule.getAtomZ(n6))) / 10000.0);
            } else {
                this.mMolfile.append(" 0 0 0");
            }
            this.mMolfile.append(" " + stereoMolecule.getAtomMapNo(n6));
            if (stereoMolecule.getAtomCharge(n6) != 0) {
                this.mMolfile.append(" CHG=" + stereoMolecule.getAtomCharge(n6));
            }
            if (stereoMolecule.getAtomRadical(n6) != 0) {
                this.mMolfile.append(" RAD=");
                switch (stereoMolecule.getAtomRadical(n6)) {
                    case 16: {
                        this.mMolfile.append("1");
                        break;
                    }
                    case 32: {
                        this.mMolfile.append("2");
                        break;
                    }
                    case 48: {
                        this.mMolfile.append("3");
                    }
                }
            }
            if (stereoMolecule.getAtomParity(n6) == 1 || stereoMolecule.getAtomParity(n6) == 2) {
                this.mMolfile.append(" CFG=");
                if (stereoMolecule.getAtomParity(n6) == 1) {
                    this.mMolfile.append("1");
                } else {
                    this.mMolfile.append("2");
                }
            }
            if (stereoMolecule.getAtomMass(n6) != 0) {
                this.mMolfile.append(" MASS=" + stereoMolecule.getAtomMass(n6));
            }
            if ((n4 = stereoMolecule.getAtomAbnormalValence(n6)) != -1) {
                this.mMolfile.append(" VAL=" + (n4 == 0 ? "-1" : Integer.valueOf(n4)));
            }
            if ((n5 = stereoMolecule.getAtomicNo(n6)) >= 129 && n5 <= 144 || n5 == 154) {
                this.mMolfile.append(" RGROUPS=(1 " + (n5 == 154 ? 0 : (n5 >= 142 ? n5 - 141 : n5 - 125)) + ")");
            }
            if ((l2 = 0x780L & stereoMolecule.getAtomQueryFeatures(n6)) == 384L) {
                this.mMolfile.append(" HCOUNT=2");
            } else if (l2 == 128L) {
                this.mMolfile.append(" HCOUNT=1");
            } else if (l2 == 1792L) {
                this.mMolfile.append(" HCOUNT=-1");
            } else if (l2 == 1664L) {
                this.mMolfile.append(" HCOUNT=1");
            }
            long l3 = stereoMolecule.getAtomQueryFeatures(n6) & 0x1800L;
            if (l3 != 0L) {
                if ((l3 & 0x1000L) != 0L) {
                    this.mMolfile.append(" SUBST=" + (stereoMolecule.getAllConnAtoms(n6) + 1));
                } else {
                    this.mMolfile.append(" SUBST=-1");
                }
            }
            if ((l = stereoMolecule.getAtomQueryFeatures(n6) & 0x78L) != 0L) {
                if (l == 112L) {
                    this.mMolfile.append(" RBCNT=-1");
                } else if (l == 8L) {
                    this.mMolfile.append(" RBCNT=2");
                } else if (l == 104L) {
                    this.mMolfile.append(" RBCNT=2");
                } else if (l == 88L) {
                    this.mMolfile.append(" RBCNT=3");
                } else if (l == 56L) {
                    this.mMolfile.append(" RBCNT=4");
                }
            }
            this.mMolfile.append(string);
        }
        this.mMolfile.append("M  V30 END ATOM" + string);
        this.mMolfile.append("M  V30 BEGIN BOND" + string);
        for (n6 = 0; n6 < stereoMolecule.getAllBonds(); ++n6) {
            int n7;
            int n8;
            this.mMolfile.append("M  V30 " + (n6 + 1));
            switch (stereoMolecule.getBondType(n6)) {
                case 1: {
                    n4 = 1;
                    n5 = 0;
                    break;
                }
                case 2: {
                    n4 = 2;
                    n5 = 0;
                    break;
                }
                case 4: {
                    n4 = 3;
                    n5 = 0;
                    break;
                }
                case 129: {
                    n4 = 1;
                    n5 = 3;
                    break;
                }
                case 257: {
                    n4 = 1;
                    n5 = 1;
                    break;
                }
                case 386: {
                    n4 = 2;
                    n5 = 2;
                    break;
                }
                case 64: {
                    n4 = 4;
                    n5 = 0;
                    break;
                }
                case 32: {
                    n4 = 9;
                    n5 = 0;
                    break;
                }
                default: {
                    n4 = 1;
                    n5 = 0;
                }
            }
            int n9 = stereoMolecule.getBondQueryFeatures(n6) & 0x1F;
            if (n9 != 0) {
                n4 = n9 == 8 ? 4 : (n9 == 3 ? 5 : (n9 == 9 ? 6 : (n9 == 10 ? 7 : 8)));
            }
            this.mMolfile.append(" " + n4 + " " + (stereoMolecule.getBondAtom(0, n6) + 1) + " " + (stereoMolecule.getBondAtom(1, n6) + 1));
            if (n5 != 0) {
                this.mMolfile.append(" CFG=" + n5);
            }
            int n10 = (n8 = stereoMolecule.getBondQueryFeatures(n6) & 0x180) == 0 ? 0 : (n7 = n8 == 256 ? 1 : 2);
            if (n7 != 0) {
                this.mMolfile.append(" TOPO=" + n7);
            }
            this.mMolfile.append(string);
        }
        this.mMolfile.append("M  V30 END BOND" + string);
        n6 = 0;
        n4 = 0;
        int[] nArray = new int[32];
        int[] nArray2 = new int[32];
        for (n3 = 0; n3 < stereoMolecule.getAtoms(); ++n3) {
            if (stereoMolecule.getAtomParity(n3) != 1 && stereoMolecule.getAtomParity(n3) != 2) continue;
            n6 = 1;
            int n11 = stereoMolecule.getAtomESRType(n3);
            if (n11 == 1) {
                int n12 = stereoMolecule.getAtomESRGroup(n3);
                nArray2[n12] = nArray2[n12] + 1;
                continue;
            }
            if (n11 == 2) {
                int n13 = stereoMolecule.getAtomESRGroup(n3);
                nArray[n13] = nArray[n13] + 1;
                continue;
            }
            ++n4;
        }
        n3 = 0;
        int[] nArray3 = new int[32];
        int[] nArray4 = new int[32];
        for (n2 = 0; n2 < stereoMolecule.getBonds(); ++n2) {
            if (stereoMolecule.getBondOrder(n2) == 2 || stereoMolecule.getBondParity(n2) != 1 && stereoMolecule.getBondParity(n2) != 2) continue;
            n6 = 1;
            n = stereoMolecule.getBondESRType(n2);
            if (n == 1) {
                int n14 = stereoMolecule.getBondESRGroup(n2);
                nArray4[n14] = nArray4[n14] + 1;
                continue;
            }
            if (n == 2) {
                int n15 = stereoMolecule.getBondESRGroup(n2);
                nArray3[n15] = nArray3[n15] + 1;
                continue;
            }
            ++n3;
        }
        if (n6 != 0) {
            this.mMolfile.append("M  V30 BEGIN COLLECTION" + string);
            if (n4 != 0) {
                this.mMolfile.append("M  V30 MDLV30/STEABS ATOMS=(" + n4);
                for (n2 = 0; n2 < stereoMolecule.getAtoms(); ++n2) {
                    if (stereoMolecule.getAtomParity(n2) != 1 && stereoMolecule.getAtomParity(n2) != 2 || stereoMolecule.getAtomESRType(n2) != 0) continue;
                    this.mMolfile.append(" " + (n2 + 1));
                }
                this.mMolfile.append(")" + string);
            }
            if (n3 != 0) {
                this.mMolfile.append("M  V30 MDLV30/STEABS BONDS=(" + n3);
                for (n2 = 0; n2 < stereoMolecule.getBonds(); ++n2) {
                    if (stereoMolecule.getBondOrder(n2) == 2 || stereoMolecule.getBondParity(n2) != 1 && stereoMolecule.getBondParity(n2) != 2 || stereoMolecule.getBondESRType(n2) != 0) continue;
                    this.mMolfile.append(" " + (n2 + 1));
                }
                this.mMolfile.append(")" + string);
            }
            for (n2 = 0; n2 < 32; ++n2) {
                if (nArray[n2] != 0) {
                    this.mMolfile.append("M  V30 MDLV30/STEREL" + (n2 + 1) + " ATOMS=(" + nArray[n2]);
                    for (n = 0; n < stereoMolecule.getAtoms(); ++n) {
                        if (stereoMolecule.getAtomParity(n) != 1 && stereoMolecule.getAtomParity(n) != 2 || stereoMolecule.getAtomESRType(n) != 2 || stereoMolecule.getAtomESRGroup(n) != n2) continue;
                        this.mMolfile.append(" " + (n + 1));
                    }
                    this.mMolfile.append(")" + string);
                }
                if (nArray2[n2] != 0) {
                    this.mMolfile.append("M  V30 MDLV30/STERAC" + (n2 + 1) + " ATOMS=(" + nArray2[n2]);
                    for (n = 0; n < stereoMolecule.getAtoms(); ++n) {
                        if (stereoMolecule.getAtomParity(n) != 1 && stereoMolecule.getAtomParity(n) != 2 || stereoMolecule.getAtomESRType(n) != 1 || stereoMolecule.getAtomESRGroup(n) != n2) continue;
                        this.mMolfile.append(" " + (n + 1));
                    }
                    this.mMolfile.append(")" + string);
                }
                if (nArray3[n2] != 0) {
                    this.mMolfile.append("M  V30 MDLV30/STEREL" + (n2 + 1) + " BONDS=(" + nArray3[n2]);
                    for (n = 0; n < stereoMolecule.getBonds(); ++n) {
                        if (stereoMolecule.getBondOrder(n) == 2 || stereoMolecule.getBondParity(n) != 1 && stereoMolecule.getBondParity(n) != 2 || stereoMolecule.getBondESRType(n) != 2 || stereoMolecule.getBondESRGroup(n) != n2) continue;
                        this.mMolfile.append(" " + (n + 1));
                    }
                    this.mMolfile.append(")" + string);
                }
                if (nArray4[n2] == 0) continue;
                this.mMolfile.append("M  V30 MDLV30/STERAC" + (n2 + 1) + " BONDS=(" + nArray4[n2]);
                for (n = 0; n < stereoMolecule.getBonds(); ++n) {
                    if (stereoMolecule.getBondOrder(n) == 2 || stereoMolecule.getBondParity(n) != 1 && stereoMolecule.getBondParity(n) != 2 || stereoMolecule.getBondESRType(n) != 1 || stereoMolecule.getBondESRGroup(n) != n2) continue;
                    this.mMolfile.append(" " + (n + 1));
                }
                this.mMolfile.append(")" + string);
            }
            this.mMolfile.append("M  V30 END COLLECTION" + string);
        }
        this.mMolfile.append("M  V30 END CTAB" + string);
    }

    public String getMolfile() {
        return this.mMolfile.toString();
    }

    public double getScalingFactor() {
        return this.mScalingFactor;
    }

    public void writeMolfile(Writer writer) throws IOException {
        writer.write(this.mMolfile.toString());
    }
}

