/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.AromaticityResolver;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.io.BOMSkipper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.TreeMap;

public class MolfileParser {
    public static final int MODE_KEEP_HYDROGEN_MAP = 1;
    public static final int ALLOWED_ATOM_LABELS = 67;
    public static final int ALLOWED_ATOM_LABELS_IN_LIST = 1;
    public static boolean debug = false;
    private StereoMolecule mMol;
    private TreeMap<Integer, Integer> mAtomIndexMap;
    private TreeMap<Integer, Integer> mBondIndexMap;
    private boolean mTreatAnyAsMetalBond;
    private boolean mDeduceMissingCharges;
    private boolean mChiralFlag;
    private boolean mIsV3000;
    private boolean mAssumeChiralTrue;
    private int mMode;
    private int[] mHydrogenMap;

    public MolfileParser() {
        this.mMode = 0;
    }

    public MolfileParser(int n) {
        this.mMode = n;
    }

    public int[] getHandleHydrogenMap() {
        return this.mHydrogenMap == null ? this.mMol.getHandleHydrogenMap() : this.mHydrogenMap;
    }

    private boolean readMoleculeFromBuffer(BufferedReader bufferedReader) {
        int[] nArray = null;
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            String string;
            String string2;
            this.mHydrogenMap = null;
            if (this.mMol != null) {
                this.mMol.clear();
                this.mMol.setFragment(false);
            }
            if (null == (string2 = (string = bufferedReader.readLine()))) {
                this.TRACE("readMoleculeFromBuffer: No Header Line\n");
                return false;
            }
            string = bufferedReader.readLine();
            if (null == string) {
                this.TRACE("Error [readMoleculeFromBuffer]: No Program Line\n");
                return false;
            }
            string = bufferedReader.readLine();
            if (null == string) {
                this.TRACE("Error [readMoleculeFromBuffer]: No Comment Line\n");
                return false;
            }
            this.mTreatAnyAsMetalBond = string.contains("From CSD data. Using bond type 'Any'");
            this.mDeduceMissingCharges = string.contains("From CSD data.");
            string = bufferedReader.readLine();
            if (null == string) {
                this.TRACE("Error [readMoleculeFromBuffer]: No Counts Line\n");
                return false;
            }
            this.mIsV3000 = false;
            this.mChiralFlag = this.mAssumeChiralTrue;
            try {
                n6 = Integer.parseInt(string.substring(0, 3).trim());
                n5 = Integer.parseInt(string.substring(3, 6).trim());
                n4 = this.parseIntOrSpaces(string.substring(6, 9).trim());
                this.mChiralFlag |= 1 == this.parseIntOrSpaces(string.substring(12, 15).trim());
                this.mIsV3000 = string.length() >= 39 && string.startsWith("V3000", 34);
            }
            catch (Exception exception) {
                this.TRACE("Warning [readMoleculeFromBuffer]: Unable to interpret counts line\n");
                return false;
            }
            if (this.mIsV3000) {
                boolean bl = this.readMoleculeV3FromBuffer(bufferedReader);
                this.mMol.setName(string2);
                return bl;
            }
            if (this.mMol == null) {
                this.mMol = new StereoMolecule(n6, n5);
            }
            this.mMol.setName(string2);
            if (!this.mChiralFlag) {
                this.mMol.setToRacemate();
            }
            if (0 == n6) {
                while (!(string == null || string.equals("M  END") || string.equals("$$$$") || string.substring(1).equals("$"))) {
                    string = bufferedReader.readLine();
                }
                return true;
            }
            for (n3 = 0; n3 < n6; ++n3) {
                int n7;
                int n8;
                string = bufferedReader.readLine();
                if (null == string) {
                    this.TRACE("Error [readMoleculeFromBuffer]: No Atom Line\n");
                    return false;
                }
                float f = Float.parseFloat(string.substring(0, 10).trim());
                float f2 = Float.parseFloat(string.substring(10, 20).trim());
                float f3 = Float.parseFloat(string.substring(20, 30).trim());
                n2 = this.mMol.addAtom(f, -f2, -f3);
                String string3 = string.substring(31, 34).trim();
                if (string3.equals("A") || string3.equals("*")) {
                    this.mMol.setAtomQueryFeature(n2, 1L, true);
                } else if (string3.equals("Q")) {
                    int[] nArray2 = new int[]{6};
                    this.mMol.setAtomList(n2, nArray2, true);
                } else {
                    n8 = Molecule.getAtomicNoFromLabel(string3, 67);
                    this.mMol.setAtomicNo(n2, n8);
                }
                n8 = this.parseIntOrSpaces(string.substring(34, 36).trim());
                if (n8 != 0) {
                    this.mMol.setAtomMass(n2, Molecule.cRoundedMass[this.mMol.getAtomicNo(n2)] + n8);
                }
                if ((n = this.parseIntOrSpaces(string.substring(36, 39).trim())) != 0) {
                    if (n == 4) {
                        this.mMol.setAtomRadical(n2, 32);
                    } else {
                        this.mMol.setAtomCharge(n2, 4 - n);
                    }
                }
                int n9 = string.length() < 63 ? 0 : this.parseIntOrSpaces(string.substring(60, 63).trim());
                this.mMol.setAtomMapNo(n2, n9, false);
                int n10 = string.length() < 45 ? 0 : this.parseIntOrSpaces(string.substring(42, 45).trim());
                switch (n10) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.mMol.setAtomQueryFeature(n2, 768L, true);
                        break;
                    }
                    case 2: {
                        this.mMol.setAtomQueryFeature(n2, 128L, true);
                        break;
                    }
                    case 3: {
                        this.mMol.setAtomQueryFeature(n2, 384L, true);
                        break;
                    }
                    default: {
                        this.mMol.setAtomQueryFeature(n2, 896L, true);
                    }
                }
                if (string.length() >= 48 && string.charAt(47) == '1') {
                    this.mMol.setAtomQueryFeature(n2, 8192L, true);
                }
                int n11 = n7 = string.length() < 51 ? 0 : this.parseIntOrSpaces(string.substring(48, 51).trim());
                if (n7 == 0) continue;
                if (nArray == null) {
                    nArray = new int[n6];
                }
                nArray[n2] = n7;
            }
            for (n3 = 0; n3 < n5; ++n3) {
                int n12;
                string = bufferedReader.readLine();
                if (null == string) {
                    this.TRACE("Error [readMoleculeFromBuffer]:No Bond Line\n");
                    return false;
                }
                int n13 = Integer.parseInt(string.substring(0, 3).trim()) - 1;
                int n14 = Integer.parseInt(string.substring(3, 6).trim()) - 1;
                int n15 = Integer.parseInt(string.substring(6, 9).trim());
                n2 = string.length() < 12 ? 0 : this.parseIntOrSpaces(string.substring(9, 12).trim());
                int n16 = n12 = string.length() < 18 ? 0 : this.parseIntOrSpaces(string.substring(15, 18).trim());
                if (n15 == 8 && (this.mTreatAnyAsMetalBond || this.mMol.isMetalAtom(n13) || this.mMol.isMetalAtom(n14))) {
                    n15 = 9;
                }
                this.buildBond(n13, n14, n15, n2, n12);
            }
            for (n3 = 0; n3 < n4; ++n3) {
                string = bufferedReader.readLine();
                if (null != string) continue;
                this.TRACE("Error [readMoleculeFromBuffer]: No List Line\n");
                return false;
            }
            string = bufferedReader.readLine();
            if (null == string) {
                this.TRACE("Error ReadMoleculeFromBuffer Missing M END or $$$$\n");
                if ((this.mMode & 1) != 0) {
                    this.mHydrogenMap = this.mMol.getHandleHydrogenMap();
                }
                this.handleValences(nArray);
                if (!this.mChiralFlag) {
                    this.mMol.ensureHelperArrays(15);
                }
                return true;
            }
            while (string != null && !string.equals("M  END") && !string.equals("$$$$")) {
                int n17;
                int n18;
                int n19;
                if (string.startsWith("M  CHG") && (n19 = Integer.parseInt(string.substring(6, 9).trim())) > 0) {
                    n3 = 10;
                    n18 = 14;
                    int n20 = 1;
                    while (n20 <= n19) {
                        n2 = Integer.parseInt(string.substring(n3, n3 + 3).trim()) - 1;
                        int n21 = Integer.parseInt(string.substring(n18, n18 + 3).trim());
                        this.mMol.setAtomCharge(n2, n21);
                        ++n20;
                        n3 += 8;
                        n18 += 8;
                    }
                }
                if (string.startsWith("M  ISO") && (n19 = Integer.parseInt(string.substring(6, 9).trim())) > 0) {
                    n3 = 10;
                    n18 = 14;
                    int n22 = 1;
                    while (n22 <= n19) {
                        n2 = Integer.parseInt(string.substring(n3, n3 + 3).trim()) - 1;
                        int n23 = Integer.parseInt(string.substring(n18, n18 + 3).trim());
                        this.mMol.setAtomMass(n2, n23);
                        ++n22;
                        n3 += 8;
                        n18 += 8;
                    }
                }
                if (string.startsWith("M  RAD") && (n19 = Integer.parseInt(string.substring(6, 9).trim())) > 0) {
                    n3 = 10;
                    n18 = 14;
                    int n24 = 1;
                    while (n24 <= n19) {
                        n2 = Integer.parseInt(string.substring(n3, n3 + 3).trim()) - 1;
                        int n25 = Integer.parseInt(string.substring(n18, n18 + 3).trim());
                        switch (n25) {
                            case 1: {
                                this.mMol.setAtomRadical(n2, 16);
                                break;
                            }
                            case 2: {
                                this.mMol.setAtomRadical(n2, 32);
                                break;
                            }
                            case 3: {
                                this.mMol.setAtomRadical(n2, 48);
                            }
                        }
                        ++n24;
                        n3 += 8;
                        n18 += 8;
                    }
                }
                if ((string.startsWith("M  RBC") || string.startsWith("M  RBD")) && (n3 = Integer.parseInt(string.substring(6, 9).trim())) > 0) {
                    n18 = 10;
                    n19 = 14;
                    int n26 = 1;
                    while (n26 <= n3) {
                        n2 = Integer.parseInt(string.substring(n18, n18 + 3).trim()) - 1;
                        n17 = Integer.parseInt(string.substring(n19, n19 + 3).trim());
                        switch (n17) {
                            case -1: {
                                this.mMol.setAtomQueryFeature(n2, 112L, true);
                                break;
                            }
                            case 1: {
                                this.mMol.setAtomQueryFeature(n2, 8L, true);
                                break;
                            }
                            case 2: {
                                this.mMol.setAtomQueryFeature(n2, 104L, true);
                                break;
                            }
                            case 3: {
                                this.mMol.setAtomQueryFeature(n2, 112L, true);
                                break;
                            }
                            case 4: {
                                this.mMol.setAtomQueryFeature(n2, 56L, true);
                            }
                        }
                        ++n26;
                        n18 += 8;
                        n19 += 8;
                    }
                }
                if (string.startsWith("M  ALS") && (n3 = Integer.parseInt(string.substring(7, 10).trim()) - 1) >= 0) {
                    n18 = Integer.parseInt(string.substring(10, 13).trim());
                    n19 = string.charAt(14) == 'T' ? 1 : 0;
                    int[] nArray3 = new int[n18];
                    n2 = 16;
                    n17 = 0;
                    while (n17 < n18) {
                        String string4 = string.substring(n2, n2 + 4).trim();
                        nArray3[n17] = Molecule.getAtomicNoFromLabel(string4, 1);
                        ++n17;
                        n2 += 4;
                    }
                    this.mMol.setAtomicNo(n3, 6);
                    this.mMol.setAtomList(n3, nArray3, n19 != 0);
                }
                if (string.startsWith("M  SUB") && (n19 = Integer.parseInt(string.substring(6, 9).trim())) > 0) {
                    n3 = 10;
                    n18 = 14;
                    int n27 = 1;
                    while (n27 <= n19) {
                        n2 = Integer.parseInt(string.substring(n3, n3 + 3).trim()) - 1;
                        n17 = Integer.parseInt(string.substring(n18, n18 + 3).trim());
                        if (n17 == -2) {
                            this.mMol.setAtomQueryFeature(n2, 2048L, true);
                        } else if (n17 > 0) {
                            int n28 = 0;
                            for (n = 0; n < this.mMol.getAllBonds(); ++n) {
                                if (this.mMol.getBondAtom(0, n) != n2 && this.mMol.getBondAtom(1, n) != n2) continue;
                                ++n28;
                            }
                            if (n17 > n28) {
                                this.mMol.setAtomQueryFeature(n2, 4096L, true);
                            }
                        }
                        ++n27;
                        n3 += 8;
                        n18 += 8;
                    }
                }
                if (string.startsWith("M  RGP") && (n19 = Integer.parseInt(string.substring(6, 9).trim())) > 0) {
                    n3 = 10;
                    n18 = 14;
                    int n29 = 1;
                    while (n29 <= n19) {
                        n2 = Integer.parseInt(string.substring(n3, n3 + 3).trim()) - 1;
                        n17 = Integer.parseInt(string.substring(n18, n18 + 3).trim());
                        if (n17 >= 1 && n17 <= 20) {
                            this.mMol.setAtomicNo(n2, Molecule.getAtomicNoFromLabel("R" + n17, 2));
                        }
                        ++n29;
                        n3 += 8;
                        n18 += 8;
                    }
                }
                string = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("error reading molfile " + exception);
            return false;
        }
        if (this.mDeduceMissingCharges) {
            this.introduceObviousMetalBonds();
            this.deduceMissingCharges();
        }
        if ((this.mMode & 1) != 0) {
            this.mHydrogenMap = this.mMol.getHandleHydrogenMap();
        }
        this.handleValences(nArray);
        this.mMol.ensureHelperArrays(15);
        return true;
    }

    public void setAssumeChiralTrue(boolean bl) {
        this.mAssumeChiralTrue = bl;
    }

    public boolean isChiralFlagSet() {
        return this.mChiralFlag;
    }

    public boolean isV3000() {
        return this.mIsV3000;
    }

    private void handleValences(int[] nArray) {
        if (nArray != null) {
            this.mMol.ensureHelperArrays(1);
            for (int i = 0; i < this.mMol.getAtoms(); ++i) {
                if (nArray[i] == 0) continue;
                int n = this.mMol.getElectronValenceCorrection(i, this.mMol.getOccupiedValence(i));
                if (nArray[i] == 15) {
                    if (n < 0) continue;
                    this.mMol.setAtomAbnormalValence(i, 0);
                    continue;
                }
                if (nArray[i] == this.mMol.getMaxValence(i)) continue;
                this.mMol.setAtomAbnormalValence(i, nArray[i] - n);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean readMoleculeV3FromBuffer(BufferedReader bufferedReader) throws IOException {
        if (this.mAtomIndexMap != null) {
            this.mAtomIndexMap.clear();
        }
        if (this.mBondIndexMap != null) {
            this.mBondIndexMap.clear();
        }
        int n = 0;
        String string = bufferedReader.readLine();
        while (true) {
            block22: {
                block23: {
                    String string2;
                    block24: {
                        if (string != null && string.startsWith("M  V30 ")) {
                            string = string.substring(7).trim();
                        } else {
                            while (string != null && !string.startsWith("M  END") && !string.equals("$$$$")) {
                                string = bufferedReader.readLine();
                            }
                            return true;
                        }
                        while (string.endsWith("-")) {
                            string2 = bufferedReader.readLine();
                            if (!string2.startsWith("M  V30 ")) {
                                return false;
                            }
                            string = string.substring(0, string.length() - 1).concat(string2.substring(7)).trim();
                        }
                        if (!string.startsWith("BEGIN")) break block23;
                        string2 = string.substring(6).trim();
                        if (!string2.startsWith("CTAB")) break block24;
                        n = 1;
                        break block22;
                    }
                    if (string2.startsWith("ATOM")) {
                        n = 2;
                        break block22;
                    } else if (string2.startsWith("BOND")) {
                        n = 3;
                        break block22;
                    } else {
                        if (!string2.startsWith("COLLECTION")) {
                            this.TRACE("Error MolfileParser: Unsupported version 3 block\n");
                            return false;
                        }
                        n = 4;
                    }
                    break block22;
                }
                if (string.startsWith("END")) {
                    n = 0;
                } else if (n == 1) {
                    this.interpretV3CountLine(string);
                } else if (n == 2) {
                    this.interpretV3AtomLine(string);
                } else if (n == 3) {
                    this.interpretV3BondLine(string);
                } else {
                    if (n != 4) {
                        this.TRACE("Error MolfileParser: Unexpected version 3 line\n");
                        return false;
                    }
                    this.interpretV3CollectionLine(string);
                }
            }
            string = bufferedReader.readLine();
        }
    }

    private void interpretV3CountLine(String string) {
        if (this.mMol == null && string.startsWith("COUNTS")) {
            int n = 7;
            int n2 = this.indexOfNextItem(string, this.indexOfWhiteSpace(string, 7));
            int n3 = Integer.parseInt(string.substring(n, this.indexOfWhiteSpace(string, n)));
            int n4 = Integer.parseInt(string.substring(n2, this.indexOfWhiteSpace(string, n2)));
            this.mMol = new StereoMolecule(n3, n4);
        }
    }

    private void interpretV3AtomLine(String string) throws IOException {
        Object object;
        int n = 0;
        int n2 = this.endOfItem(string, n);
        int n3 = Integer.parseInt(string.substring(n, n2));
        n = this.indexOfNextItem(string, n2);
        n2 = this.endOfItem(string, n);
        String string2 = string.substring(n, n2);
        int[] nArray = null;
        boolean bl = false;
        int n4 = this.isV3AtomList(string);
        if (n4 != 0) {
            nArray = this.interpretV3AtomList(string);
            if (n4 < 0) {
                bl = true;
            }
            n2 = Math.abs(n4);
        }
        n = this.indexOfNextItem(string, n2);
        n2 = this.endOfItem(string, n);
        float f = Float.parseFloat(string.substring(n, n2));
        n = this.indexOfNextItem(string, n2);
        n2 = this.endOfItem(string, n);
        float f2 = Float.parseFloat(string.substring(n, n2));
        n = this.indexOfNextItem(string, n2);
        n2 = this.endOfItem(string, n);
        float f3 = Float.parseFloat(string.substring(n, n2));
        n = this.indexOfNextItem(string, n2);
        n2 = this.endOfItem(string, n);
        int n5 = Integer.parseInt(string.substring(n, n2));
        int n6 = this.mMol.addAtom(f, -f2, -f3);
        if (n6 + 1 != n3) {
            this.mapAtomIndex(n3, n6);
        }
        if (nArray != null) {
            this.mMol.setAtomicNo(n6, 6);
            this.mMol.setAtomList(n6, nArray, bl);
        }
        if (n5 != 0) {
            this.mMol.setAtomMapNo(n6, n5, false);
        }
        if (string2.equals("A") || string2.equals("*")) {
            this.mMol.setAtomQueryFeature(n6, 1L, true);
        } else if (string2.equals("Q")) {
            object = new int[]{6};
            this.mMol.setAtomList(n6, (int[])object, true);
        } else {
            this.mMol.setAtomicNo(n6, Molecule.getAtomicNoFromLabel(string2, 67));
        }
        block18: while ((n = this.indexOfNextItem(string, n2)) != -1) {
            n2 = this.endOfItem(string, n);
            object = string.substring(n, n2);
            int n7 = object.indexOf(61);
            String string3 = object.substring(0, n7);
            int n8 = Integer.parseInt(object.substring(n7 + 1));
            if (string3.equals("CHG")) {
                this.mMol.setAtomCharge(n6, n8);
                continue;
            }
            if (string3.equals("RAD")) {
                switch (n8) {
                    case 1: {
                        this.mMol.setAtomRadical(n6, 16);
                        break;
                    }
                    case 2: {
                        this.mMol.setAtomRadical(n6, 32);
                        break;
                    }
                    case 3: {
                        this.mMol.setAtomRadical(n6, 48);
                    }
                }
                continue;
            }
            if (string3.equals("CFG")) continue;
            if (string3.equals("MASS")) {
                this.mMol.setAtomMass(n6, n8);
                continue;
            }
            if (string3.equals("VAL")) {
                this.mMol.setAtomAbnormalValence(n6, n8 == -1 ? 0 : (n8 == 0 ? -1 : n8));
                continue;
            }
            if (string3.equals("HCOUNT")) {
                switch (n8) {
                    case 0: {
                        continue block18;
                    }
                    case -1: {
                        this.mMol.setAtomQueryFeature(n6, 1792L, true);
                        continue block18;
                    }
                    case 1: {
                        this.mMol.setAtomQueryFeature(n6, 128L, true);
                        continue block18;
                    }
                    case 2: {
                        this.mMol.setAtomQueryFeature(n6, 384L, true);
                        continue block18;
                    }
                }
                this.mMol.setAtomQueryFeature(n6, 896L, true);
                continue;
            }
            if (string3.equals("SUBST")) {
                if (n8 == -1) {
                    this.mMol.setAtomQueryFeature(n6, 2048L, true);
                    continue;
                }
                if (n8 <= 0) continue;
                int n9 = 0;
                for (int i = 0; i < this.mMol.getAllBonds(); ++i) {
                    if (this.mMol.getBondAtom(0, i) != n6 && this.mMol.getBondAtom(1, i) != n6) continue;
                    ++n9;
                }
                if (n8 <= n9) continue;
                this.mMol.setAtomQueryFeature(n6, 4096L, true);
                continue;
            }
            if (string3.equals("RBCNT")) {
                switch (n8) {
                    case -1: {
                        this.mMol.setAtomQueryFeature(n6, 112L, true);
                        break;
                    }
                    case 1: {
                        this.mMol.setAtomQueryFeature(n6, 8L, true);
                        break;
                    }
                    case 2: {
                        this.mMol.setAtomQueryFeature(n6, 104L, true);
                        break;
                    }
                    case 3: {
                        this.mMol.setAtomQueryFeature(n6, 112L, true);
                        break;
                    }
                    case 4: {
                        this.mMol.setAtomQueryFeature(n6, 56L, true);
                    }
                }
                continue;
            }
            this.TRACE("Warning MolfileParser: Unused version 3 atom specifier:" + string3 + "\n");
        }
    }

    private void interpretV3BondLine(String string) throws IOException {
        int n = 0;
        int n2 = this.endOfItem(string, n);
        int n3 = Integer.parseInt(string.substring(n, n2));
        n = this.indexOfNextItem(string, n2);
        n2 = this.endOfItem(string, n);
        int n4 = Integer.parseInt(string.substring(n, n2));
        n = this.indexOfNextItem(string, n2);
        n2 = this.endOfItem(string, n);
        int n5 = this.getUsedAtomIndex(Integer.parseInt(string.substring(n, n2)));
        n = this.indexOfNextItem(string, n2);
        n2 = this.endOfItem(string, n);
        int n6 = this.getUsedAtomIndex(Integer.parseInt(string.substring(n, n2)));
        int n7 = 0;
        int n8 = 0;
        while ((n = this.indexOfNextItem(string, n2)) != -1) {
            n2 = this.endOfItem(string, n);
            String string2 = string.substring(n, n2);
            int n9 = string2.indexOf(61);
            String string3 = string2.substring(0, n9);
            int n10 = Integer.parseInt(string2.substring(n9 + 1));
            if (string3.equals("CFG")) {
                switch (n10) {
                    case 1: {
                        n7 = 1;
                        break;
                    }
                    case 2: {
                        n7 = n4 == 2 ? 3 : 4;
                        break;
                    }
                    case 3: {
                        n7 = 6;
                    }
                }
                continue;
            }
            if (string3.equals("TOPO")) {
                n8 = n10;
                continue;
            }
            this.TRACE("Warning MolfileParser: Unused version 3 bond specifier:" + string3 + "\n");
        }
        int n11 = this.buildBond(n5, n6, n4, n7, n8);
        if (n11 + 1 != n3) {
            this.mapBondIndex(n3, n11);
        }
    }

    private void interpretV3CollectionLine(String string) {
        String string2 = this.interpretObjectType(string);
        if (string2 != null) {
            int[] nArray = this.interpretV3List(string, string2);
            if (string.startsWith("MDLV30/STEABS")) {
                if (string2.equals("ATOMS")) {
                    for (int i = 0; i < nArray.length; ++i) {
                        this.mMol.setAtomESR(this.getUsedAtomIndex(nArray[i]), 0, -1);
                    }
                } else {
                    for (int i = 0; i < nArray.length; ++i) {
                        this.mMol.setBondESR(this.getUsedBondIndex(nArray[i]), 0, -1);
                    }
                }
            } else if (string.startsWith("MDLV30/STERAC")) {
                int n = Integer.parseInt(string.substring(13, this.indexOfWhiteSpace(string, 13)));
                if (string2.equals("ATOMS")) {
                    for (int i = 0; i < nArray.length; ++i) {
                        this.mMol.setAtomESR(this.getUsedAtomIndex(nArray[i]), 1, n - 1);
                    }
                } else {
                    for (int i = 0; i < nArray.length; ++i) {
                        this.mMol.setBondESR(this.getUsedBondIndex(nArray[i]), 1, n - 1);
                    }
                }
            } else if (string.startsWith("MDLV30/STEREL")) {
                int n = Integer.parseInt(string.substring(13, this.indexOfWhiteSpace(string, 13)));
                if (string2.equals("ATOMS")) {
                    for (int i = 0; i < nArray.length; ++i) {
                        this.mMol.setAtomESR(this.getUsedAtomIndex(nArray[i]), 2, n - 1);
                    }
                } else {
                    for (int i = 0; i < nArray.length; ++i) {
                        this.mMol.setBondESR(this.getUsedBondIndex(nArray[i]), 2, n - 1);
                    }
                }
            } else if (string.startsWith("MDLV30/HILITE")) {
                if (string2.equals("ATOMS")) {
                    for (int i = 0; i < nArray.length; ++i) {
                        this.mMol.setAtomColor(this.getUsedAtomIndex(nArray[i]), 448);
                    }
                } else {
                    for (int i = 0; i < nArray.length; ++i) {
                        int n = this.getUsedBondIndex(nArray[i]);
                        this.mMol.setAtomColor(this.mMol.getBondAtom(0, n), 448);
                        this.mMol.setAtomColor(this.mMol.getBondAtom(1, n), 448);
                    }
                }
            } else {
                this.TRACE("Error [readMoleculeFromBuffer]: Unknown version 3 collection type\n");
            }
        }
    }

    private String interpretObjectType(String string) {
        if (string.contains("ATOMS=(")) {
            return "ATOMS";
        }
        if (string.contains("BONDS=(")) {
            return "BONDS";
        }
        this.TRACE("Error [readMoleculeFromBuffer]: Unknown or missing collection object type\n");
        return null;
    }

    private int[] interpretV3AtomList(String string) {
        int[] nArray = null;
        int n = string.indexOf("[");
        int n2 = string.indexOf("]", n);
        if (n >= 0 && n2 > 0) {
            int[] nArray2 = new int[16];
            String string2 = string.substring(n + 1, n2);
            int n3 = 0;
            boolean bl = true;
            while (bl && n3 < 16) {
                n = string2.indexOf(",");
                String string3 = null;
                if (n == -1) {
                    string3 = string2;
                    bl = false;
                } else {
                    string3 = string2.substring(0, n);
                    string2 = string2.substring(n + 1);
                }
                nArray2[n3++] = Molecule.getAtomicNoFromLabel(string3, 1);
            }
            nArray = new int[n3];
            System.arraycopy(nArray2, 0, nArray, 0, n3);
        }
        return nArray;
    }

    private int isV3AtomList(String string) {
        if (string.indexOf("[") >= 0) {
            int n = string.indexOf(" NOT[");
            int n2 = string.indexOf("]", n);
            if (n >= 0 && n2 > 0) {
                return -(n2 + 1);
            }
            n = string.indexOf(" [");
            n2 = string.indexOf("]", n);
            if (n >= 0 && n2 > 0) {
                return n2 + 1;
            }
            n = string.indexOf(" 'NOT[");
            n2 = string.indexOf("]'", n);
            if (n >= 0 && n2 > 0) {
                return -(n2 + 2);
            }
            n = string.indexOf(" '[");
            n2 = string.indexOf("]'", n);
            if (n >= 0 && n2 > 0) {
                return n2 + 2;
            }
            System.err.println("Warning invalid atom list in line: " + string);
        }
        return 0;
    }

    private int[] interpretV3List(String string, String string2) {
        int n = string.indexOf(string2 + "=(") + string2.length() + 2;
        int n2 = string.indexOf(41, n);
        int n3 = this.indexOfWhiteSpace(string, n);
        int n4 = Integer.parseInt(string.substring(n, n3));
        int[] nArray = new int[n4];
        for (int i = 0; i < n4; ++i) {
            n = this.indexOfNextItem(string, n3);
            if ((n3 = this.indexOfWhiteSpace(string, n)) == -1 || n3 > n2) {
                n3 = n2;
            }
            nArray[i] = Integer.parseInt(string.substring(n, n3));
        }
        return nArray;
    }

    public boolean parse(StereoMolecule stereoMolecule, File file) {
        this.mMol = stereoMolecule;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            BOMSkipper.skip(bufferedReader);
            return this.readMoleculeFromBuffer(bufferedReader);
        }
        catch (IOException iOException) {
            System.err.println("Error reading file " + iOException);
            return false;
        }
    }

    public boolean parse(StereoMolecule stereoMolecule, String string) {
        return this.parse(stereoMolecule, new BufferedReader(new StringReader(string)));
    }

    public boolean parse(StereoMolecule stereoMolecule, StringBuffer stringBuffer) {
        return this.parse(stereoMolecule, stringBuffer.toString());
    }

    public boolean parse(StereoMolecule stereoMolecule, BufferedReader bufferedReader) {
        this.mMol = stereoMolecule;
        return this.readMoleculeFromBuffer(bufferedReader);
    }

    public StereoMolecule getCompactMolecule(String string) {
        this.mMol = null;
        return this.readMoleculeFromBuffer(new BufferedReader(new StringReader(string))) ? this.mMol : null;
    }

    public StereoMolecule getCompactMolecule(BufferedReader bufferedReader) {
        this.mMol = null;
        return this.readMoleculeFromBuffer(bufferedReader) ? this.mMol : null;
    }

    public StereoMolecule getCompactMolecule(File file) {
        this.mMol = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            boolean bl = this.readMoleculeFromBuffer(bufferedReader);
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return bl ? this.mMol : null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    private int buildBond(int n, int n2, int n3, int n4, int n5) {
        int n6 = 1;
        boolean bl = false;
        block0 : switch (n4) {
            case 1: {
                n6 = 257;
                break;
            }
            case 3: {
                n6 = 386;
                break;
            }
            case 4: {
                n6 = 257;
                bl = true;
                break;
            }
            case 6: {
                n6 = 129;
                break;
            }
            default: {
                switch (n3) {
                    case 1: {
                        n6 = 1;
                        break block0;
                    }
                    case 2: {
                        n6 = 2;
                        break block0;
                    }
                    case 3: {
                        n6 = 4;
                        break block0;
                    }
                    case 4: {
                        n6 = 64;
                        break block0;
                    }
                    case 9: {
                        n6 = 32;
                    }
                }
            }
        }
        int n7 = this.mMol.addBond(n, n2, n6);
        int n8 = 0;
        if (bl) {
            this.mMol.setAtomESR(n, 1, -1);
        }
        if (n3 > 4) {
            switch (n3) {
                case 5: {
                    n8 |= 3;
                    break;
                }
                case 6: {
                    n8 |= 9;
                    break;
                }
                case 7: {
                    n8 |= 0xA;
                    break;
                }
                case 8: {
                    if (n6 == 32) break;
                    n8 |= 0x1F;
                }
            }
        }
        if (n5 == 1) {
            n8 |= 0x100;
        }
        if (n5 == 2) {
            n8 |= 0x80;
        }
        if (n8 != 0) {
            this.mMol.setBondQueryFeature(n7, n8, true);
        }
        return n7;
    }

    private void mapAtomIndex(int n, int n2) {
        if (this.mAtomIndexMap == null) {
            this.mAtomIndexMap = new TreeMap();
        }
        this.mAtomIndexMap.put(new Integer(n), new Integer(n2));
    }

    private void mapBondIndex(int n, int n2) {
        if (this.mBondIndexMap == null) {
            this.mBondIndexMap = new TreeMap();
        }
        this.mBondIndexMap.put(new Integer(n), new Integer(n2));
    }

    private int getUsedAtomIndex(int n) {
        Integer n2 = this.mAtomIndexMap == null ? null : this.mAtomIndexMap.get(new Integer(n));
        return n2 == null ? n - 1 : n2;
    }

    private int getUsedBondIndex(int n) {
        Integer n2 = this.mBondIndexMap == null ? null : this.mBondIndexMap.get(new Integer(n));
        return n2 == null ? n - 1 : n2;
    }

    private int parseIntOrSpaces(String string) throws NumberFormatException {
        return string.length() == 0 ? 0 : Integer.parseInt(string);
    }

    private int endOfItem(String string, int n) {
        int n2 = this.indexOfWhiteSpace(string, n + 1);
        return n2 == -1 ? string.length() : n2;
    }

    private int indexOfWhiteSpace(String string, int n) {
        for (int i = n; i < string.length(); ++i) {
            if (string.charAt(i) != ' ' && string.charAt(i) != '\t') continue;
            return i;
        }
        return -1;
    }

    private int indexOfNextItem(String string, int n) {
        if (n == -1) {
            return -1;
        }
        for (int i = n + 1; i < string.length(); ++i) {
            if (string.charAt(i) == ' ' || string.charAt(i) == '\t') continue;
            return i;
        }
        return -1;
    }

    void TRACE(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    private void introduceObviousMetalBonds() {
        int n;
        int n2;
        int n3;
        int[] nArray = new int[this.mMol.getAllAtoms()];
        for (n3 = 0; n3 < this.mMol.getAllBonds(); ++n3) {
            if (this.mMol.getBondType(n3) != 64) continue;
            for (n2 = 0; n2 < 2; ++n2) {
                nArray[this.mMol.getBondAtom((int)n2, (int)n3)] = 1;
            }
        }
        for (n3 = 0; n3 < this.mMol.getAllBonds(); ++n3) {
            n2 = this.mMol.getBondOrder(n3);
            for (n = 0; n < 2; ++n) {
                int n4 = this.mMol.getBondAtom(n, n3);
                nArray[n4] = nArray[n4] + n2;
            }
        }
        for (n3 = 0; n3 < this.mMol.getAllBonds(); ++n3) {
            if (this.mMol.getBondOrder(n3) != 1) continue;
            for (n2 = 0; n2 < 2; ++n2) {
                int n5;
                n = this.mMol.getBondAtom(1 - n2, n3);
                if (!this.mMol.isMetalAtom(n) || !this.mMol.isElectronegative(n5 = this.mMol.getBondAtom(n2, n3)) || nArray[n5] <= this.mMol.getMaxValence(n5)) continue;
                this.mMol.setBondType(n3, 32);
            }
        }
    }

    private void deduceMissingCharges() {
        int n;
        int[] nArray = new int[this.mMol.getAllAtoms()];
        for (n = 0; n < this.mMol.getAllAtoms(); ++n) {
            nArray[n] = -this.mMol.getAtomCharge(n);
        }
        new AromaticityResolver(this.mMol).locateDelocalizedDoubleBonds(null, true, false);
        for (n = 0; n < this.mMol.getAllAtoms(); ++n) {
            int n2 = n;
            nArray[n2] = nArray[n2] + this.mMol.getAtomCharge(n);
        }
        for (n = 0; n < this.mMol.getAllAtoms(); ++n) {
            if (nArray[n] == 0) continue;
            int n3 = -nArray[n];
            for (int i = 0; i < this.mMol.getAllBonds(); ++i) {
                for (int j = 0; j < 2; ++j) {
                    int n4;
                    if (n3 <= 0 || this.mMol.getBondType(i) != 32 || this.mMol.getBondAtom(1 - j, i) != n || !this.mMol.isMetalAtom(n4 = this.mMol.getBondAtom(j, i))) continue;
                    int n5 = this.getMaxOxidationState(n4);
                    int n6 = this.mMol.getAtomCharge(n4);
                    if (n6 >= n5) continue;
                    int n7 = Math.min(n3, n5 - n6);
                    this.mMol.setAtomCharge(n4, n6 + n7);
                    n3 -= n7;
                }
            }
        }
    }

    private int getMaxOxidationState(int n) {
        int n2 = this.mMol.getAtomicNo(n);
        byte[] byArray = n2 < Molecule.cCommonOxidationState.length ? Molecule.cCommonOxidationState[n2] : null;
        return byArray == null ? 0 : byArray[byArray.length - 1];
    }
}

