/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.gui.generic.GenericRectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class Molecule
implements Serializable {
    static final long serialVersionUID = 539103536L;
    public static final int cMaxAtomicNo = 190;
    protected static final int cAtomFlagsParity = 3;
    public static final int cAtomParityNone = 0;
    public static final int cAtomParity1 = 1;
    public static final int cAtomParity2 = 2;
    public static final int cAtomParityUnknown = 3;
    public static final int cAtomParityIsPseudo = 4;
    protected static final int cAtomFlagSmallRing = 8;
    public static final int cAtomRadicalState = 48;
    public static final int cAtomRadicalStateShift = 4;
    public static final int cAtomRadicalStateNone = 0;
    public static final int cAtomRadicalStateS = 16;
    public static final int cAtomRadicalStateD = 32;
    public static final int cAtomRadicalStateT = 48;
    private static final int cAtomFlagsColor = 448;
    public static final int cAtomColorNone = 0;
    public static final int cAtomColorBlue = 64;
    public static final int cAtomColorRed = 128;
    public static final int cAtomColorGreen = 192;
    public static final int cAtomColorMagenta = 256;
    public static final int cAtomColorOrange = 320;
    public static final int cAtomColorDarkGreen = 384;
    public static final int cAtomColorDarkRed = 448;
    private static final int cAtomFlagSelected = 512;
    protected static final int cAtomFlagsHelper2 = 15368;
    protected static final int cAtomFlagsHelper3 = 67223559;
    protected static final int cAtomFlagsHelper = 67238927;
    protected static final int cAtomFlagsRingBonds = 3072;
    protected static final int cAtomFlags2RingBonds = 1024;
    protected static final int cAtomFlags3RingBonds = 2048;
    protected static final int cAtomFlags4RingBonds = 3072;
    protected static final int cAtomFlagAllylic = 4096;
    protected static final int cAtomFlagStabilized = 8192;
    private static final int cAtomFlagsCIPParity = 49152;
    private static final int cAtomFlagsCIPParityShift = 14;
    public static final int cAtomCIPParityNone = 0;
    public static final int cAtomCIPParityRorM = 1;
    public static final int cAtomCIPParitySorP = 2;
    public static final int cAtomCIPParityProblem = 3;
    protected static final int cAtomFlagStereoProblem = 65536;
    protected static final int cAtomFlagMarked = 131072;
    public static final int cESRTypeAbs = 0;
    public static final int cESRTypeAnd = 1;
    public static final int cESRTypeOr = 2;
    public static final int cESRMaxGroups = 32;
    public static final int cESRGroupBits = 5;
    protected static final int cAtomFlagsESR = 33292288;
    private static final int cAtomFlagsESRType = 786432;
    private static final int cAtomFlagsESRTypeShift = 18;
    private static final int cAtomFlagsESRGroup = 0x1F00000;
    private static final int cAtomFlagsESRGroupShift = 20;
    protected static final int cAtomFlagConfigurationUnknown = 0x2000000;
    private static final int cAtomFlagIsStereoCenter = 0x4000000;
    protected static final int cAtomFlagsValence = 0x78000000;
    private static final int cAtomFlagsValenceShift = 27;
    public static final int cAtomQFNoOfBits = 46;
    public static final int cAtomQFAromStateBits = 2;
    public static final int cAtomQFAromStateShift = 1;
    public static final int cAtomQFRingStateBits = 4;
    public static final int cAtomQFRingStateShift = 3;
    public static final int cAtomQFHydrogenBits = 4;
    public static final int cAtomQFHydrogenShift = 7;
    public static final int cAtomQFPiElectronBits = 3;
    public static final int cAtomQFPiElectronShift = 14;
    public static final int cAtomQFNeighbourBits = 5;
    public static final int cAtomQFNeighbourShift = 17;
    public static final int cAtomQFSmallRingSizeBits = 3;
    public static final int cAtomQFSmallRingSizeShift = 22;
    public static final int cAtomQFChargeBits = 3;
    public static final int cAtomQFChargeShift = 25;
    public static final int cAtomQFRxnParityBits = 2;
    public static final int cAtomQFRxnParityShift = 30;
    public static final int cAtomQFNewRingSizeBits = 7;
    public static final int cAtomQFNewRingSizeShift = 32;
    public static final int cAtomQFENeighbourBits = 5;
    public static final int cAtomQFENeighbourShift = 39;
    public static final int cAtomQFStereoStateBits = 2;
    public static final int cAtomQFStereoStateShift = 44;
    public static final long cAtomQFSimpleFeatures = 140187971602430L;
    public static final long cAtomQFNarrowing = 140733461823486L;
    public static final long cAtomQFAny = 1L;
    public static final long cAtomQFAromState = 0x400000000006L;
    public static final long cAtomQFAromatic = 2L;
    public static final long cAtomQFNotAromatic = 4L;
    public static final long cAtomQFRingState = 120L;
    public static final long cAtomQFNotChain = 8L;
    public static final long cAtomQFNot2RingBonds = 16L;
    public static final long cAtomQFNot3RingBonds = 32L;
    public static final long cAtomQFNot4RingBonds = 64L;
    public static final long cAtomQFHydrogen = 1920L;
    public static final long cAtomQFNot0Hydrogen = 128L;
    public static final long cAtomQFNot1Hydrogen = 256L;
    public static final long cAtomQFNot2Hydrogen = 512L;
    public static final long cAtomQFNot3Hydrogen = 1024L;
    public static final long cAtomQFNoMoreNeighbours = 2048L;
    public static final long cAtomQFMoreNeighbours = 4096L;
    public static final long cAtomQFMatchStereo = 8192L;
    public static final long cAtomQFPiElectrons = 114688L;
    public static final long cAtomQFNot0PiElectrons = 16384L;
    public static final long cAtomQFNot1PiElectron = 32768L;
    public static final long cAtomQFNot2PiElectrons = 65536L;
    public static final long cAtomQFNeighbours = 0x3E0000L;
    public static final long cAtomQFNot0Neighbours = 131072L;
    public static final long cAtomQFNot1Neighbour = 262144L;
    public static final long cAtomQFNot2Neighbours = 524288L;
    public static final long cAtomQFNot3Neighbours = 0x100000L;
    public static final long cAtomQFNot4Neighbours = 0x200000L;
    public static final long cAtomQFSmallRingSize = 0x1C00000L;
    public static final long cAtomQFCharge = 0xE000000L;
    public static final long cAtomQFNotChargeNeg = 0x2000000L;
    public static final long cAtomQFNotCharge0 = 0x4000000L;
    public static final long cAtomQFNotChargePos = 0x8000000L;
    public static final long cAtomQFFlatNitrogen = 0x10000000L;
    public static final long cAtomQFExcludeGroup = 0x20000000L;
    public static final long cAtomQFRxnParityHint = 0xC0000000L;
    public static final long cAtomQFRxnParityRetain = 0x40000000L;
    public static final long cAtomQFRxnParityInvert = 0x80000000L;
    public static final long cAtomQFRxnParityRacemize = 0xC0000000L;
    public static final long cAtomQFNewRingSize = 0x7F00000000L;
    public static final long cAtomQFRingSize0 = 0x100000000L;
    public static final long cAtomQFRingSize3 = 0x200000000L;
    public static final long cAtomQFRingSize4 = 0x400000000L;
    public static final long cAtomQFRingSize5 = 0x800000000L;
    public static final long cAtomQFRingSize6 = 0x1000000000L;
    public static final long cAtomQFRingSize7 = 0x2000000000L;
    public static final long cAtomQFRingSizeLarge = 0x4000000000L;
    public static final long cAtomQFENeighbours = 0xF8000000000L;
    public static final long cAtomQFNot0ENeighbours = 0x8000000000L;
    public static final long cAtomQFNot1ENeighbour = 0x10000000000L;
    public static final long cAtomQFNot2ENeighbours = 0x20000000000L;
    public static final long cAtomQFNot3ENeighbours = 0x40000000000L;
    public static final long cAtomQFNot4ENeighbours = 0x80000000000L;
    public static final long cAtomQFStereoState = 0x300000000000L;
    public static final long cAtomQFIsStereo = 0x100000000000L;
    public static final long cAtomQFIsNotStereo = 0x200000000000L;
    public static final long cAtomQFHeteroAromatic = 0x400000000000L;
    public static final int cBondTypeSingle = 1;
    public static final int cBondTypeDouble = 2;
    public static final int cBondTypeTriple = 4;
    public static final int cBondTypeQuadruple = 8;
    public static final int cBondTypeQuintuple = 16;
    public static final int cBondTypeMetalLigand = 32;
    public static final int cBondTypeDelocalized = 64;
    public static final int cBondTypeDown = 129;
    public static final int cBondTypeUp = 257;
    public static final int cBondTypeCross = 386;
    public static final int cBondTypeDeleted = 512;
    public static final int cBondTypeIncreaseOrder = 511;
    public static final int cBondTypeMaskSimple = 127;
    public static final int cBondTypeMaskStereo = 384;
    protected static final int cBondFlagsHelper2 = 704;
    protected static final int cBondFlagsHelper3 = 63;
    protected static final int cBondFlagsParity = 3;
    public static final int cBondParityNone = 0;
    public static final int cBondParityEor1 = 1;
    public static final int cBondParityZor2 = 2;
    public static final int cBondParityUnknown = 3;
    private static final int cBondParityIsPseudo = 4;
    private static final int cBondFlagsCIPParity = 48;
    protected static final int cBondFlagsCIPParityShift = 4;
    public static final int cBondCIPParityNone = 0;
    public static final int cBondCIPParityEorP = 1;
    public static final int cBondCIPParityZorM = 2;
    public static final int cBondCIPParityProblem = 3;
    protected static final int cBondFlagRing = 64;
    protected static final int cBondFlagSmallRing = 128;
    protected static final int cBondFlagsESR = 32512;
    private static final int cBondFlagsESRType = 768;
    private static final int cBondFlagsESRTypeShift = 8;
    private static final int cBondFlagsESRGroup = 31744;
    private static final int cBondFlagsESRGroupShift = 10;
    private static final int cBondFlagBGHilited = 32768;
    private static final int cBondFlagFGHilited = 65536;
    private static final int cBondParityUnknownOrNone = 131072;
    public static final int cBondQFNoOfBits = 23;
    public static final int cBondQFBondTypesBits = 5;
    public static final int cBondQFBondTypesShift = 0;
    public static final int cBondQFRareBondTypesBits = 2;
    public static final int cBondQFRareBondTypesShift = 5;
    public static final int cBondQFRingStateBits = 2;
    public static final int cBondQFRingStateShift = 7;
    public static final int cBondQFBridgeBits = 8;
    public static final int cBondQFBridgeShift = 9;
    public static final int cBondQFBridgeMinBits = 4;
    public static final int cBondQFBridgeMinShift = 9;
    public static final int cBondQFBridgeSpanBits = 4;
    public static final int cBondQFBridgeSpanShift = 13;
    public static final int cBondQFRingSizeBits = 3;
    public static final int cBondQFRingSizeShift = 17;
    public static final int cBondQFAromStateBits = 2;
    public static final int cBondQFAromStateShift = 21;
    public static final int cBondQFAllFeatures = 0xFFFFFF;
    public static final int cBondQFSimpleFeatures = 6291967;
    public static final int cBondQFNarrowing = 6291840;
    public static final int cBondQFBondTypes = 31;
    public static final int cBondQFRareBondTypes = 96;
    public static final int cBondQFSingle = 1;
    public static final int cBondQFDouble = 2;
    public static final int cBondQFTriple = 4;
    public static final int cBondQFDelocalized = 8;
    public static final int cBondQFMetalLigand = 16;
    public static final int cBondQFQuadruple = 32;
    public static final int cBondQFQuintuple = 64;
    public static final int cBondQFRingState = 384;
    public static final int cBondQFNotRing = 128;
    public static final int cBondQFRing = 256;
    public static final int cBondQFBridge = 130560;
    public static final int cBondQFBridgeMin = 7680;
    public static final int cBondQFBridgeSpan = 122880;
    public static final int cBondQFRingSize = 917504;
    public static final int cBondQFMatchStereo = 0x100000;
    public static final int cBondQFAromState = 0x600000;
    public static final int cBondQFAromatic = 0x200000;
    public static final int cBondQFNotAromatic = 0x400000;
    public static final int cBondQFMatchFormalOrder = 0x800000;
    public static final int cHelperNone = 0;
    public static final int cHelperBitNeighbours = 1;
    public static final int cHelperBitRingsSimple = 2;
    public static final int cHelperBitRings = 4;
    public static final int cHelperBitParities = 8;
    public static final int cHelperBitCIP = 16;
    public static final int cHelperBitSymmetrySimple = 32;
    public static final int cHelperBitSymmetryStereoHeterotopicity = 64;
    public static final int cHelperBitIncludeNitrogenParities = 128;
    public static final int cHelperBitsStereo = 248;
    public static final int cHelperNeighbours = 1;
    public static final int cHelperRingsSimple = 3;
    public static final int cHelperRings = 7;
    public static final int cHelperParities = 15;
    public static final int cHelperCIP = 31;
    public static final int cHelperSymmetrySimple = 63;
    public static final int cHelperSymmetryStereoHeterotopicity = 95;
    public static final int cChiralityIsomerCountMask = 65535;
    public static final int cChiralityUnknown = 0;
    public static final int cChiralityNotChiral = 65536;
    public static final int cChiralityMeso = 131072;
    public static final int cChiralityRacemic = 196608;
    public static final int cChiralityKnownEnantiomer = 262144;
    public static final int cChiralityUnknownEnantiomer = 327680;
    public static final int cChiralityEpimers = 393216;
    public static final int cChiralityDiastereomers = 458752;
    public static final double cDefaultAVBL = 24.0;
    private static double sDefaultAVBL = 24.0;
    public static final int cMoleculeColorDefault = 0;
    public static final int cMoleculeColorNeutral = 1;
    public static final int cPseudoAtomsHydrogenIsotops = 1;
    public static final int cPseudoAtomsRGroups = 2;
    public static final int cPseudoAtomsAGroups = 4;
    public static final int cPseudoAtomR = 8;
    public static final int cPseudoAtomA = 16;
    public static final int cPseudoAtomX = 32;
    public static final int cPseudoAtomsAminoAcids = 64;
    public static final int cPseudoAtomPolymer = 128;
    public static final int cPseudoAtomAttachmentPoint = 256;
    public static final int cPseudoAtomsAll = 511;
    public static final int cDefaultAllowedPseudoAtoms = 321;
    public static final String[] cAtomLabel = new String[]{"?", "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", "Nh", "Fl", "Mc", "Lv", "Ts", "Og", "??", "??", "??", "??", "??", "??", "??", "??", "??", "??", "R4", "R5", "R6", "R7", "R8", "R9", "R10", "R11", "R12", "R13", "R14", "R15", "R16", "R1", "R2", "R3", "A", "A1", "A2", "A3", "??", "??", "D", "T", "X", "R", "H2", "H+", "Nnn", "HYD", "Pol", "??", "??", "??", "??", "??", "??", "??", "??", "??", "??", "??", "Ala", "Arg", "Asn", "Asp", "Cys", "Gln", "Glu", "Gly", "His", "Ile", "Leu", "Lys", "Met", "Phe", "Pro", "Ser", "Thr", "Trp", "Tyr", "Val"};
    public static final short[] cRoundedMass = new short[]{0, 1, 4, 7, 9, 11, 12, 14, 16, 19, 20, 23, 24, 27, 28, 31, 32, 35, 40, 39, 40, 45, 48, 51, 52, 55, 56, 59, 58, 63, 64, 69, 74, 75, 80, 79, 84, 85, 88, 89, 90, 93, 98, 0, 102, 103, 106, 107, 114, 115, 120, 121, 130, 127, 132, 133, 138, 139, 140, 141, 142, 0, 152, 153, 158, 159, 164, 165, 166, 169, 174, 175, 180, 181, 184, 187, 192, 193, 195, 197, 202, 205, 208, 209, 209, 210, 222, 223, 226, 227, 232, 231, 238, 237, 244, 243, 247, 247, 251, 252, 257, 258, 259, 262, 267, 268, 271, 270, 277, 276, 281, 281, 283, 285, 289, 289, 293, 294, 294, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 71, 156, 114, 115, 103, 128, 129, 57, 137, 113, 113, 128, 131, 147, 97, 87, 101, 186, 163, 99};
    public static final int cDefaultAtomValence = 6;
    private static final byte[] cDefaultAtomValences = new byte[]{6};
    private static final byte[] cAminoAcidValences = new byte[]{2};
    public static final byte[][] cAtomValence = new byte[][]{null, {1}, {0}, {1}, {2}, {3}, {4}, {3}, {2}, {1}, {0}, {1}, {2}, {3}, {4}, {3, 5}, {2, 4, 6}, {1, 3, 5, 7}, {0}, {1}, {2}, null, null, null, null, null, null, null, null, null, null, {2, 3}, {2, 4}, {3, 5}, {2, 4, 6}, {1, 3, 5, 7}, {0, 2}, {1}, {2}, null, null, null, null, null, null, null, null, null, null, {1, 2, 3}, {2, 4}, {3, 5}, {2, 4, 6}, {1, 3, 5, 7}, {0, 2, 4, 6}, {1}, {2}, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, {2}, {2}, {2}, {2}, {3}, {2}, {2}, {2}, {2}, {2}, {2}, {2}, {2}, {2}, {2}, {2}, {2}, {2}, {2}, {2}};
    public static final byte[][] cCommonOxidationState = new byte[][]{null, {1}, null, {1}, {2}, null, null, {-3}, {-2}, {-1}, null, {1}, {2}, {3}, null, {-3}, {-2}, {-1}, null, {1}, {2}, {3}, {2, 3, 4}, {2, 3, 4, 5}, {2, 3, 6}, {2, 3, 4, 7}, {2, 3}, {2, 3}, {2, 3}, {1, 2}, {2}, {3}, {2, 4}, {-3, 3, 5}, {-2}, {-1}, null, {1}, {2}, {3}, {4}, {3, 5}, {6}, {4, 6, 7}, {3}, {3}, {2, 4}, {1}, {2}, {3}, {2, 4}, {-3, 3, 5}, {-2, 4, 6}, {-1}, null, {1}, {2}, {3}, {3, 4}, {3}, {3}, {3}, {2, 3}, {2, 3}, {3}, {3}, {3}, {3}, {3}, {3}, {2, 3}, {3}, {4}, {5}, {6}, {4, 6, 7}, {3, 4}, {3, 4}, {2, 4}, {1, 3}, {1, 2}, {1, 3}, {2, 4}, {3, 5}, {-2, 2, 4}, {-1, 1}, null, {1}, {2}, {3}, {4}, {4, 5}, {3, 4, 5, 6}, {3, 4, 5, 6}, {3, 4, 5, 6}, {3, 4, 5, 6}, {3}, {3, 4}, {3}, {3}, {3}, {2, 3}, {2, 3}, {3}};
    protected transient int mMaxAtoms;
    protected transient int mMaxBonds;
    protected transient int mValidHelperArrays;
    protected transient int mAllAtoms;
    protected transient int mAllBonds;
    protected transient int[] mAtomicNo;
    protected transient int[] mAtomCharge;
    protected transient int[] mAtomMapNo;
    protected transient int[] mAtomMass;
    protected transient int[] mAtomFlags;
    protected transient long[] mAtomQueryFeatures;
    protected transient int[][] mBondAtom;
    protected transient int[] mBondType;
    protected transient int[] mBondFlags;
    protected transient int[] mBondQueryFeatures;
    protected transient Coordinates[] mCoordinates;
    protected transient boolean mIsFragment;
    protected transient boolean mIsRacemate;
    protected transient boolean mProtectHydrogen;
    protected transient int mChirality;
    protected transient int[][] mAtomList;
    protected transient byte[][] mAtomCustomLabel;
    private transient int mMoleculeColor;
    private transient double mZoomRotationX;
    private transient double mZoomRotationY;
    private transient double[] mOriginalAngle;
    private transient double[] mOriginalDistance;
    private transient String mName;
    private transient Object mUserData;

    public static int getAtomicNoFromLabel(String string) {
        return Molecule.getAtomicNoFromLabel(string, 321);
    }

    public static int getAtomicNoFromLabel(String string, int n) {
        int n2;
        if ((n & 0x100) != 0 && string.equals("?")) {
            return 0;
        }
        for (n2 = 1; n2 <= 128; ++n2) {
            if (string.equals("??") || !string.equalsIgnoreCase(cAtomLabel[n2])) continue;
            return n2;
        }
        if ((n & 2) != 0) {
            for (n2 = 129; n2 <= 144; ++n2) {
                if (!string.equalsIgnoreCase(cAtomLabel[n2])) continue;
                return n2;
            }
        }
        if ((n & 4) != 0) {
            for (n2 = 146; n2 <= 148; ++n2) {
                if (!string.equalsIgnoreCase(cAtomLabel[n2])) continue;
                return n2;
            }
        }
        if ((n & 1) != 0) {
            for (n2 = 151; n2 <= 152; ++n2) {
                if (!string.equalsIgnoreCase(cAtomLabel[n2])) continue;
                return n2;
            }
        }
        if ((n & 0x20) != 0 && string.equalsIgnoreCase(cAtomLabel[153])) {
            return 153;
        }
        if ((n & 8) != 0 && string.equalsIgnoreCase(cAtomLabel[154])) {
            return 154;
        }
        if ((n & 0x10) != 0 && string.equalsIgnoreCase(cAtomLabel[145])) {
            return 145;
        }
        if ((n & 0x80) != 0 && string.equalsIgnoreCase(cAtomLabel[159])) {
            return 159;
        }
        if ((n & 0x40) != 0) {
            for (n2 = 171; n2 <= 190; ++n2) {
                if (!string.equalsIgnoreCase(cAtomLabel[n2])) continue;
                return n2;
            }
        }
        return 0;
    }

    public static byte[] getAllowedValences(int n) {
        return n >= 0 && n < cAtomValence.length && cAtomValence[n] != null ? cAtomValence[n] : (n >= 171 && n <= 190 ? cAminoAcidValences : cDefaultAtomValences);
    }

    public static double getAngle(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = d3 - d;
        double d7 = d4 - d2;
        if (d7 != 0.0) {
            d5 = Math.atan(d6 / d7);
            if (d7 < 0.0) {
                d5 = d6 < 0.0 ? (d5 -= Math.PI) : (d5 += Math.PI);
            }
        } else {
            d5 = d6 > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        return d5;
    }

    public static double getAngleDif(double d, double d2) {
        double d3;
        for (d3 = d - d2; d3 < -Math.PI; d3 += Math.PI * 2) {
        }
        while (d3 > Math.PI) {
            d3 -= Math.PI * 2;
        }
        return d3;
    }

    public static int bondTypeToOrder(int n) {
        int n2 = n & 0x7F;
        return n2 == 1 || n2 == 64 ? 1 : (n2 == 2 ? 2 : (n2 == 4 ? 3 : (n2 == 8 ? 4 : (n2 == 16 ? 5 : 0))));
    }

    public static int bondOrderToType(int n, boolean bl) {
        return n == 0 ? 32 : (n == 1 ? 1 : (n == 2 ? (bl ? 386 : 2) : (n == 3 ? 4 : (n == 4 ? 8 : 16))));
    }

    public Molecule() {
        this.mMaxBonds = 256;
        this.mMaxAtoms = 256;
        this.init();
    }

    public Molecule(int n, int n2) {
        this.mMaxAtoms = Math.max(1, n);
        this.mMaxBonds = Math.max(1, n2);
        this.init();
    }

    private void init() {
        this.mValidHelperArrays = 0;
        this.mAtomicNo = new int[this.mMaxAtoms];
        this.mAtomCharge = new int[this.mMaxAtoms];
        this.mAtomMapNo = new int[this.mMaxAtoms];
        this.mCoordinates = new Coordinates[this.mMaxAtoms];
        for (int i = 0; i < this.mMaxAtoms; ++i) {
            this.mCoordinates[i] = new Coordinates();
        }
        this.mAtomMass = new int[this.mMaxAtoms];
        this.mAtomFlags = new int[this.mMaxAtoms];
        this.mAtomQueryFeatures = new long[this.mMaxAtoms];
        this.mAtomList = null;
        this.mAtomCustomLabel = null;
        this.mBondAtom = new int[2][this.mMaxBonds];
        this.mBondType = new int[this.mMaxBonds];
        this.mBondFlags = new int[this.mMaxBonds];
        this.mBondQueryFeatures = new int[this.mMaxBonds];
    }

    public int addAtom(double d, double d2) {
        return this.addAtom(d, d2, 0.0);
    }

    public int addAtom(double d, double d2, double d3) {
        int n = this.addAtom(6);
        this.mCoordinates[n].set(d, d2, d3);
        return n;
    }

    public int addAtom(String string) {
        int n = Molecule.getAtomicNoFromLabel(string);
        return n == 0 ? -1 : this.addAtom(n);
    }

    public int addAtom(int n) {
        if (this.mAllAtoms >= this.mMaxAtoms) {
            this.setMaxAtoms(this.mMaxAtoms * 2);
        }
        this.mAtomicNo[this.mAllAtoms] = 0;
        this.setAtomicNo(this.mAllAtoms, n);
        this.mAtomCharge[this.mAllAtoms] = 0;
        this.mAtomFlags[this.mAllAtoms] = 0;
        this.mAtomQueryFeatures[this.mAllAtoms] = 0L;
        this.mAtomMapNo[this.mAllAtoms] = 0;
        this.mCoordinates[this.mAllAtoms].set(0.0, 0.0, 0.0);
        if (this.mAtomList != null) {
            this.mAtomList[this.mAllAtoms] = null;
        }
        if (this.mAtomCustomLabel != null) {
            this.mAtomCustomLabel[this.mAllAtoms] = null;
        }
        this.mValidHelperArrays = 0;
        return this.mAllAtoms++;
    }

    public int suggestBondType(int n, int n2) {
        return this.isMetalAtom(n) || this.isMetalAtom(n2) ? 32 : 1;
    }

    public int addBond(int n, int n2) {
        return this.addBond(n, n2, this.suggestBondType(n, n2));
    }

    public int addBond(int n, int n2, int n3) {
        if (n == n2) {
            return -1;
        }
        for (int i = 0; i < this.mAllBonds; ++i) {
            if ((this.mBondAtom[0][i] != n || this.mBondAtom[1][i] != n2) && (this.mBondAtom[0][i] != n2 || this.mBondAtom[1][i] != n)) continue;
            if (this.mBondType[i] < n3) {
                this.mBondType[i] = n3;
            }
            return i;
        }
        if (this.mAllBonds >= this.mMaxBonds) {
            this.setMaxBonds(this.mMaxBonds * 2);
        }
        this.mBondAtom[0][this.mAllBonds] = n;
        this.mBondAtom[1][this.mAllBonds] = n2;
        this.mBondType[this.mAllBonds] = n3;
        this.mBondFlags[this.mAllBonds] = 0;
        this.mBondQueryFeatures[this.mAllBonds] = 0;
        this.mValidHelperArrays = 0;
        return this.mAllBonds++;
    }

    public boolean addOrChangeAtom(double d, double d2, int n, int n2, int n3, int n4, String string) {
        int n5 = this.findAtom(d, d2);
        if (n5 == -1) {
            if (this.mAllAtoms >= this.mMaxAtoms) {
                this.setMaxAtoms(this.mMaxAtoms * 2);
            }
            n5 = this.addAtom(n);
            this.mCoordinates[n5].set(d, d2, 0.0);
            this.mAtomMass[n5] = n2;
            this.setAtomAbnormalValence(n5, n3);
            this.setAtomRadical(n5, n4);
            this.setAtomCustomLabel(n5, string);
            return true;
        }
        boolean bl = this.changeAtom(n5, n, n2, n3, n4);
        this.setAtomCustomLabel(n5, string);
        return bl;
    }

    public int addOrChangeBond(int n, int n2, int n3) {
        for (int i = 0; i < this.mAllBonds; ++i) {
            if ((this.mBondAtom[0][i] != n || this.mBondAtom[1][i] != n2) && (this.mBondAtom[0][i] != n2 || this.mBondAtom[1][i] != n)) continue;
            this.changeBond(i, n3);
            this.mValidHelperArrays = 0;
            return i;
        }
        if (this.mAllBonds >= this.mMaxBonds) {
            this.setMaxBonds(this.mMaxBonds * 2);
        }
        this.mBondAtom[0][this.mAllBonds] = n;
        this.mBondAtom[1][this.mAllBonds] = n2;
        this.mBondType[this.mAllBonds] = n3;
        this.mBondFlags[this.mAllBonds] = 0;
        this.mBondQueryFeatures[this.mAllBonds] = 0;
        this.mValidHelperArrays = 0;
        return this.mAllBonds++;
    }

    public boolean addRing(double d, double d2, int n, boolean bl, double d3) {
        while (this.mAllAtoms + n > this.mMaxAtoms) {
            this.setMaxAtoms(this.mMaxAtoms * 2);
        }
        while (this.mAllBonds + n > this.mMaxBonds) {
            this.setMaxBonds(this.mMaxBonds * 2);
        }
        int n2 = this.findAtom(d, d2);
        if (n2 != -1) {
            return this.addRingToAtom(n2, n, bl, d3);
        }
        int n3 = this.findBond(d, d2);
        if (n3 != -1) {
            return this.addRingToBond(n3, n, bl, d3);
        }
        n2 = this.addAtom(d, d2);
        double d4 = Math.PI * (double)(n - 2) / (double)n;
        this.polygon(n2, n, n2, bl, 0.0, Math.PI - d4, d3);
        this.mValidHelperArrays = 0;
        return true;
    }

    public boolean addRingToAtom(int n, int n2, boolean bl, double d) {
        if (bl && this.getOccupiedValence(n) > 1 || !bl && this.getOccupiedValence(n) > 2) {
            return false;
        }
        int n3 = 0;
        double[] dArray = new double[4];
        for (int i = 0; i < this.mAllBonds; ++i) {
            for (int j = 0; j < 2; ++j) {
                if (this.mBondAtom[j][i] != n) continue;
                if (n3 == 2) {
                    n3 = 3;
                    break;
                }
                dArray[n3++] = this.getBondAngle(n, this.mBondAtom[1 - j][i]);
            }
            if (n3 == 3) break;
        }
        if (n3 == 3) {
            return false;
        }
        double d2 = n3 == 1 ? dArray[0] + Math.PI : (Math.abs(dArray[0] - dArray[1]) > Math.PI ? (dArray[0] + dArray[1]) / 2.0 : (dArray[0] + dArray[1]) / 2.0 + Math.PI);
        double d3 = Math.PI * (double)(n2 - 2) / (double)n2;
        this.polygon(n, n2, n, bl, d2 - d3 / 2.0, Math.PI - d3, d);
        this.mValidHelperArrays = 0;
        return true;
    }

    public boolean addRingToBond(int n, int n2, boolean bl, double d) {
        int n3;
        int n4;
        int n5;
        int[] nArray = new int[2];
        double[] dArray = new double[2];
        nArray[0] = this.mBondAtom[0][n];
        nArray[1] = this.mBondAtom[1][n];
        if (this.getOccupiedValence(nArray[0]) > 3) {
            return false;
        }
        if (this.getOccupiedValence(nArray[1]) > 3) {
            return false;
        }
        int n6 = 0;
        double[] dArray2 = new double[4];
        for (n5 = 0; n5 < this.mAllBonds; ++n5) {
            if (n5 == n) continue;
            for (n4 = 0; n4 < 2; ++n4) {
                for (n3 = 0; n3 < 2; ++n3) {
                    if (this.mBondAtom[n4][n5] != nArray[n3]) continue;
                    if (n6 == 4) {
                        n6 = 5;
                        break;
                    }
                    dArray2[n6++] = this.getBondAngle(nArray[n3], this.mBondAtom[1 - n4][n5]);
                }
                if (n6 == 5) break;
            }
            if (n6 == 5) break;
        }
        if (n6 == 5) {
            return false;
        }
        dArray[0] = this.getBondAngle(nArray[0], nArray[1]);
        if (dArray[0] < 0.0) {
            dArray[1] = dArray[0] + Math.PI;
            n5 = 0;
        } else {
            dArray[1] = dArray[0];
            dArray[0] = dArray[1] - Math.PI;
            n5 = 1;
        }
        n4 = 0;
        for (n3 = 0; n3 < n6; ++n3) {
            if (dArray2[n3] > dArray[0] && dArray2[n3] < dArray[1]) {
                --n4;
                continue;
            }
            ++n4;
        }
        n5 = n4 > 0 ? 1 - n5 : n5;
        double d2 = Math.PI * (double)(n2 - 2) / (double)n2;
        this.polygon(nArray[n5], n2 - 1, nArray[1 - n5], bl, dArray[n4 > 0 ? 0 : 1] + Math.PI - d2, Math.PI - d2, d);
        this.mValidHelperArrays = 0;
        return true;
    }

    public boolean changeAtom(int n, int n2, int n3, int n4, int n5) {
        if ((n2 == 1 || n2 == 151 || n2 == 152) && this.getOccupiedValence(n) > 1) {
            return false;
        }
        int n6 = n;
        this.mAtomQueryFeatures[n6] = this.mAtomQueryFeatures[n6] & 0xFFFFFFFFFFFFFFFEL;
        if (this.mAtomList != null) {
            this.mAtomList[n] = null;
        }
        if (this.mAtomCustomLabel != null) {
            this.mAtomCustomLabel[n] = null;
        }
        if (n2 == this.mAtomicNo[n] && n3 == this.mAtomMass[n] && n4 == this.getAtomAbnormalValence(n) && n5 == this.getAtomRadical(n)) {
            return false;
        }
        if (n2 == 151 || n2 == 152) {
            n3 = n2 - 149;
            n2 = 1;
        }
        int n7 = n;
        this.mAtomFlags[n7] = this.mAtomFlags[n7] & 0x3C0;
        this.mAtomicNo[n] = n2;
        this.mAtomMass[n] = n3;
        this.mAtomCharge[n] = 0;
        this.mAtomQueryFeatures[n] = 0L;
        this.setAtomAbnormalValence(n, n4);
        this.setAtomRadical(n, n5);
        this.removeMappingNo(this.mAtomMapNo[n]);
        this.mValidHelperArrays = 0;
        return true;
    }

    public boolean changeAtomCharge(double d, double d2, boolean bl) {
        int n = this.findAtom(d, d2);
        return n != -1 && this.changeAtomCharge(n, bl);
    }

    public boolean changeAtomCharge(int n, boolean bl) {
        if (bl) {
            if (this.mAtomCharge[n] > 8) {
                return false;
            }
            int n2 = n;
            this.mAtomCharge[n2] = this.mAtomCharge[n2] + 1;
        } else {
            if (this.mAtomCharge[n] < -8) {
                return false;
            }
            int n3 = n;
            this.mAtomCharge[n3] = this.mAtomCharge[n3] - 1;
        }
        this.mValidHelperArrays = 0;
        return true;
    }

    public boolean changeBond(int n, int n2) {
        boolean bl = false;
        int n3 = this.mBondType[n];
        if (n2 == 511) {
            bl = this.incrementBondOrder(n);
        } else if (this.validateBondType(n, n2)) {
            if (n2 == 257 || n2 == 129) {
                boolean bl2 = this.qualifiesAsStereoBond(n, this.mBondAtom[0][n]);
                boolean bl3 = this.qualifiesAsStereoBond(n, this.mBondAtom[1][n]);
                if (n2 == n3) {
                    if (bl2 == bl3 || bl3) {
                        int n4 = this.mBondAtom[0][n];
                        this.mBondAtom[0][n] = this.mBondAtom[1][n];
                        this.mBondAtom[1][n] = n4;
                        bl = true;
                    }
                } else {
                    if (!bl2 && bl3) {
                        int n5 = this.mBondAtom[0][n];
                        this.mBondAtom[0][n] = this.mBondAtom[1][n];
                        this.mBondAtom[1][n] = n5;
                    }
                    this.mBondType[n] = n2;
                    bl = true;
                }
            } else {
                this.mBondType[n] = n2;
                bl = true;
            }
        }
        if (bl) {
            this.mValidHelperArrays = (n3 & 0x7F) == (n2 & 0x7F) ? this.mValidHelperArrays & 7 : 0;
            this.mBondQueryFeatures[n] = 0;
        }
        return bl;
    }

    private boolean qualifiesAsStereoBond(int n, int n2) {
        int n3;
        if (this.getBondOrder(n) != 1) {
            return false;
        }
        if ((this.mAtomFlags[n2] & 3) != 0) {
            return true;
        }
        for (n3 = 0; n3 < this.mAllBonds; ++n3) {
            if (n3 == n || this.mBondType[n3] != 2 || (this.mBondAtom[0][n3] != n2 || (this.mAtomFlags[this.mBondAtom[1][n3]] & 3) == 0) && (this.mBondAtom[1][n3] != n2 || (this.mAtomFlags[this.mBondAtom[0][n3]] & 3) == 0)) continue;
            return true;
        }
        for (n3 = 0; n3 < this.mAllBonds; ++n3) {
            if (n3 == n || this.mBondType[n3] != 1 || this.mBondAtom[0][n3] != n2 && this.mBondAtom[1][n3] != n2 || (this.mBondFlags[n3] & 3) == 0) continue;
            return true;
        }
        return false;
    }

    public int[] addMolecule(Molecule molecule) {
        return this.addMolecule(molecule, molecule.mAllAtoms, molecule.mAllBonds);
    }

    public int[] addMolecule(Molecule molecule, int n, int n2) {
        int n3;
        this.mIsFragment |= molecule.mIsFragment;
        int[] nArray = new int[molecule.mAllAtoms];
        int n4 = this.renumberESRGroups(1);
        int n5 = this.renumberESRGroups(2);
        for (n3 = 0; n3 < n; ++n3) {
            nArray[n3] = molecule.copyAtom(this, n3, n4, n5);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            molecule.copyBond(this, n3, n4, n5, nArray, false);
        }
        this.mIsRacemate = this.mIsRacemate && molecule.mIsRacemate;
        this.mChirality = 0;
        this.mValidHelperArrays = 0;
        return nArray;
    }

    public int[] addSubstituent(Molecule molecule, int n) {
        return this.addSubstituent(molecule, n, false);
    }

    public int[] addSubstituent(Molecule molecule, int n, boolean bl) {
        int n2;
        int[] nArray = new int[molecule.mAllAtoms];
        int n3 = this.renumberESRGroups(1);
        int n4 = this.renumberESRGroups(2);
        for (n2 = 0; n2 < molecule.mAllAtoms; ++n2) {
            nArray[n2] = molecule.getAtomicNo(n2) != 0 ? molecule.copyAtom(this, n2, n3, n4) : (bl && molecule.getAtomMapNo(n2) != 0 ? molecule.getAtomMapNo(n2) - 1 : n);
        }
        for (n2 = 0; n2 < molecule.mAllBonds; ++n2) {
            molecule.copyBond(this, n2, n3, n4, nArray, false);
        }
        this.mIsRacemate = this.mIsRacemate && molecule.mIsRacemate;
        this.mChirality = 0;
        this.mValidHelperArrays = 0;
        return nArray;
    }

    public void copyMolecule(Molecule molecule) {
        int n;
        molecule.mAtomList = null;
        molecule.mAtomCustomLabel = null;
        molecule.mIsFragment = this.mIsFragment;
        molecule.mAllAtoms = 0;
        for (n = 0; n < this.mAllAtoms; ++n) {
            this.copyAtom(molecule, n, 0, 0);
        }
        molecule.mAllBonds = 0;
        for (n = 0; n < this.mAllBonds; ++n) {
            this.copyBond(molecule, n, 0, 0, null, false);
        }
        this.copyMoleculeProperties(molecule);
    }

    public int copyAtom(Molecule molecule, int n, int n2, int n3) {
        int n4 = molecule.mAllAtoms;
        if (n4 >= molecule.mMaxAtoms) {
            molecule.setMaxAtoms(molecule.mMaxAtoms * 2);
        }
        int n5 = this.getAtomESRType(n);
        int n6 = -1;
        if (n5 == 1) {
            n6 = n2 == -1 ? molecule.renumberESRGroups(n5) : Math.min(31, n2 + this.getAtomESRGroup(n));
        } else if (n5 == 2) {
            n6 = n3 == -1 ? molecule.renumberESRGroups(n5) : Math.min(31, n3 + this.getAtomESRGroup(n));
        }
        molecule.mAtomicNo[n4] = this.mAtomicNo[n];
        molecule.mAtomCharge[n4] = this.mAtomCharge[n];
        molecule.mAtomMass[n4] = this.mAtomMass[n];
        molecule.mAtomFlags[n4] = this.mAtomFlags[n];
        molecule.mAtomQueryFeatures[n4] = molecule.mIsFragment ? this.mAtomQueryFeatures[n] : 0L;
        molecule.mCoordinates[n4].set(this.mCoordinates[n]);
        molecule.mAtomMapNo[n4] = this.mAtomMapNo[n];
        if (molecule.mAtomList != null) {
            molecule.mAtomList[n4] = null;
        }
        if (this.mAtomList != null && this.mAtomList[n] != null && molecule.mIsFragment) {
            if (molecule.mAtomList == null) {
                molecule.mAtomList = new int[molecule.mAtomicNo.length][];
            }
            molecule.mAtomList[n4] = Arrays.copyOf(this.mAtomList[n], this.mAtomList[n].length);
        }
        if (molecule.mAtomCustomLabel != null) {
            molecule.mAtomCustomLabel[n4] = null;
        }
        if (this.mAtomCustomLabel != null && this.mAtomCustomLabel[n] != null) {
            if (molecule.mAtomCustomLabel == null) {
                molecule.mAtomCustomLabel = new byte[molecule.mAtomicNo.length][];
            }
            molecule.mAtomCustomLabel[n4] = Arrays.copyOf(this.mAtomCustomLabel[n], this.mAtomCustomLabel[n].length);
        }
        if (n6 != -1) {
            int n7 = n4;
            molecule.mAtomFlags[n7] = molecule.mAtomFlags[n7] & 0xFE0FFFFF;
            int n8 = n4;
            molecule.mAtomFlags[n8] = molecule.mAtomFlags[n8] | n6 << 20;
        }
        ++molecule.mAllAtoms;
        molecule.mValidHelperArrays = 0;
        return n4;
    }

    public int copyBond(Molecule molecule, int n, int n2, int n3, int[] nArray, boolean bl) {
        return this.copyBond(molecule, n, n2, n3, nArray == null ? this.mBondAtom[0][n] : nArray[this.mBondAtom[0][n]], nArray == null ? this.mBondAtom[1][n] : nArray[this.mBondAtom[1][n]], bl);
    }

    public int copyBond(Molecule molecule, int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6;
        int n7 = molecule.mAllBonds;
        if (n7 >= molecule.mMaxBonds) {
            molecule.setMaxBonds(molecule.mMaxBonds * 2);
        }
        int n8 = this.getBondESRType(n);
        int n9 = -1;
        if (n8 == 1) {
            n9 = n2 == -1 ? molecule.renumberESRGroups(n8) : Math.min(32, n2 + this.getBondESRGroup(n));
        }
        if (n8 == 2) {
            n9 = n3 == -1 ? molecule.renumberESRGroups(n8) : Math.min(32, n3 + this.getBondESRGroup(n));
        }
        molecule.mBondAtom[0][n7] = n4;
        molecule.mBondAtom[1][n7] = n5;
        molecule.mBondType[n7] = n6 = bl && this.isDelocalizedBond(n) ? 64 : this.mBondType[n];
        molecule.mBondFlags[n7] = this.mBondFlags[n];
        int n10 = molecule.mBondQueryFeatures[n7] = molecule.mIsFragment ? this.mBondQueryFeatures[n] : 0;
        if (n9 != -1) {
            int n11 = n7;
            molecule.mBondFlags[n11] = molecule.mBondFlags[n11] & 0xFFFF83FF;
            int n12 = n7;
            molecule.mBondFlags[n12] = molecule.mBondFlags[n12] | n9 << 10;
        }
        ++molecule.mAllBonds;
        molecule.mValidHelperArrays = 0;
        return n7;
    }

    public void copyMoleculeProperties(Molecule molecule) {
        molecule.mIsFragment = this.mIsFragment;
        molecule.mIsRacemate = this.mIsRacemate;
        molecule.mProtectHydrogen = this.mProtectHydrogen;
        molecule.mChirality = this.mChirality;
        molecule.mName = this.mName;
        molecule.mValidHelperArrays = this.mValidHelperArrays & 0x18;
    }

    public void invalidateHelperArrays(int n) {
        this.mValidHelperArrays &= ~n;
    }

    public int renumberESRGroups(int n) {
        int n2;
        if (n == 0) {
            return 0;
        }
        boolean[] blArray = null;
        for (n2 = 0; n2 < this.mAllAtoms; ++n2) {
            if (this.getAtomESRType(n2) != n) continue;
            if (blArray == null) {
                blArray = new boolean[32];
            }
            blArray[this.getAtomESRGroup((int)n2)] = true;
        }
        for (n2 = 0; n2 < this.mAllBonds; ++n2) {
            if (this.getBondESRType(n2) != n) continue;
            if (blArray == null) {
                blArray = new boolean[32];
            }
            blArray[this.getBondESRGroup((int)n2)] = true;
        }
        n2 = 0;
        if (blArray != null) {
            int n3;
            int n4;
            int[] nArray = new int[32];
            for (n4 = 0; n4 < 32; ++n4) {
                if (!blArray[n4]) continue;
                nArray[n4] = n2++;
            }
            for (n4 = 0; n4 < this.mAllAtoms; ++n4) {
                if (this.getAtomESRType(n4) != n) continue;
                n3 = nArray[this.getAtomESRGroup(n4)];
                int n5 = n4;
                this.mAtomFlags[n5] = this.mAtomFlags[n5] & 0xFE0FFFFF;
                int n6 = n4;
                this.mAtomFlags[n6] = this.mAtomFlags[n6] | n3 << 20;
            }
            for (n4 = 0; n4 < this.mAllBonds; ++n4) {
                if (this.getBondESRType(n4) != n) continue;
                n3 = nArray[this.getBondESRGroup(n4)];
                int n7 = n4;
                this.mBondFlags[n7] = this.mBondFlags[n7] & 0xFFFF83FF;
                int n8 = n4;
                this.mBondFlags[n8] = this.mBondFlags[n8] | n3 << 10;
            }
        }
        return n2;
    }

    public void swapAtoms(int n, int n2) {
        Object[] objectArray;
        int n3 = this.mAtomicNo[n];
        this.mAtomicNo[n] = this.mAtomicNo[n2];
        this.mAtomicNo[n2] = n3;
        n3 = this.mAtomCharge[n];
        this.mAtomCharge[n] = this.mAtomCharge[n2];
        this.mAtomCharge[n2] = n3;
        n3 = this.mAtomMass[n];
        this.mAtomMass[n] = this.mAtomMass[n2];
        this.mAtomMass[n2] = n3;
        n3 = this.mAtomFlags[n];
        this.mAtomFlags[n] = this.mAtomFlags[n2];
        this.mAtomFlags[n2] = n3;
        long l = this.mAtomQueryFeatures[n];
        this.mAtomQueryFeatures[n] = this.mAtomQueryFeatures[n2];
        this.mAtomQueryFeatures[n2] = l;
        n3 = this.mAtomMapNo[n];
        this.mAtomMapNo[n] = this.mAtomMapNo[n2];
        this.mAtomMapNo[n2] = n3;
        Coordinates coordinates = this.mCoordinates[n];
        this.mCoordinates[n] = this.mCoordinates[n2];
        this.mCoordinates[n2] = coordinates;
        if (this.mAtomList != null) {
            objectArray = this.mAtomList[n];
            this.mAtomList[n] = this.mAtomList[n2];
            this.mAtomList[n2] = objectArray;
        }
        if (this.mAtomCustomLabel != null) {
            objectArray = this.mAtomCustomLabel[n];
            this.mAtomCustomLabel[n] = this.mAtomCustomLabel[n2];
            this.mAtomCustomLabel[n2] = (byte[])objectArray;
        }
        for (int i = 0; i < this.mAllBonds; ++i) {
            for (int j = 0; j < 2; ++j) {
                if (this.mBondAtom[j][i] == n) {
                    this.mBondAtom[j][i] = n2;
                    continue;
                }
                if (this.mBondAtom[j][i] != n2) continue;
                this.mBondAtom[j][i] = n;
            }
        }
        this.mValidHelperArrays = 0;
    }

    public void swapBonds(int n, int n2) {
        int n3 = this.mBondAtom[0][n];
        this.mBondAtom[0][n] = this.mBondAtom[0][n2];
        this.mBondAtom[0][n2] = n3;
        n3 = this.mBondAtom[1][n];
        this.mBondAtom[1][n] = this.mBondAtom[1][n2];
        this.mBondAtom[1][n2] = n3;
        n3 = this.mBondType[n];
        this.mBondType[n] = this.mBondType[n2];
        this.mBondType[n2] = n3;
        n3 = this.mBondFlags[n];
        this.mBondFlags[n] = this.mBondFlags[n2];
        this.mBondFlags[n2] = n3;
        n3 = this.mBondQueryFeatures[n];
        this.mBondQueryFeatures[n] = this.mBondQueryFeatures[n2];
        this.mBondQueryFeatures[n2] = n3;
        this.mValidHelperArrays = 0;
    }

    public void deleteAtom(int n) {
        for (int i = 0; i < this.mAllBonds; ++i) {
            for (int j = 0; j < 2; ++j) {
                if (this.mBondAtom[j][i] != n) continue;
                this.mBondType[i] = 512;
                int n2 = 0;
                for (int k = 0; k < this.mAllBonds; ++k) {
                    if (k == i || this.mBondAtom[0][k] != this.mBondAtom[1 - j][i] && this.mBondAtom[1][k] != this.mBondAtom[1 - j][i]) continue;
                    ++n2;
                }
                if (n2 != 0) continue;
                this.removeMappingNo(this.mAtomMapNo[this.mBondAtom[1 - j][i]]);
                this.mAtomicNo[this.mBondAtom[1 - j][i]] = -1;
            }
        }
        this.removeMappingNo(this.mAtomMapNo[n]);
        this.mAtomicNo[n] = -1;
        if (this.mAtomList != null) {
            this.mAtomList[n] = null;
        }
        if (this.mAtomCustomLabel != null) {
            this.mAtomCustomLabel[n] = null;
        }
        this.compressMolTable();
        this.mValidHelperArrays = 0;
    }

    public boolean deleteAtomOrBond(double d, double d2) {
        int n = this.findAtom(d, d2);
        if (n != -1) {
            if ((this.mAtomFlags[n] & 0x200) != 0) {
                this.deleteSelectedAtoms();
            } else {
                this.deleteAtom(n);
            }
            this.mValidHelperArrays = 0;
            return true;
        }
        int n2 = this.findBond(d, d2);
        if (n2 != -1) {
            if ((this.mAtomFlags[this.mBondAtom[0][n2]] & this.mAtomFlags[this.mBondAtom[1][n2]] & 0x200) != 0) {
                this.deleteSelectedAtoms();
            } else {
                this.deleteBondAndSurrounding(n2);
            }
            this.mValidHelperArrays = 0;
            return true;
        }
        return false;
    }

    public void deleteBond(int n) {
        this.mBondType[n] = 512;
        this.compressMolTable();
        this.mValidHelperArrays = 0;
    }

    public void deleteBondAndSurrounding(int n) {
        for (int i = 0; i < 2; ++i) {
            int n2 = 0;
            for (int j = 0; j < this.mAllBonds; ++j) {
                if (j == n || this.mBondAtom[0][j] != this.mBondAtom[i][n] && this.mBondAtom[1][j] != this.mBondAtom[i][n]) continue;
                ++n2;
            }
            if (n2 != 0) continue;
            this.removeMappingNo(this.mAtomMapNo[this.mBondAtom[i][n]]);
            this.mAtomicNo[this.mBondAtom[i][n]] = -1;
        }
        this.mBondType[n] = 512;
        this.compressMolTable();
        this.mValidHelperArrays = 0;
    }

    public int[] deleteAtoms(boolean[] blArray) {
        boolean bl = false;
        for (int i = 0; i < this.mAllAtoms; ++i) {
            if (!blArray[i]) continue;
            this.markAtomForDeletion(i);
            bl = true;
        }
        if (!bl) {
            return null;
        }
        return this.deleteMarkedAtomsAndBonds();
    }

    public int[] deleteAtoms(int[] nArray) {
        if (nArray.length == 0) {
            return null;
        }
        for (int n : nArray) {
            this.markAtomForDeletion(n);
        }
        return this.deleteMarkedAtomsAndBonds();
    }

    public int[] getDeleteAtomsBondMap(boolean[] blArray) {
        int n;
        boolean[] blArray2 = new boolean[this.mAllBonds];
        for (n = 0; n < this.mAllBonds; ++n) {
            if (!blArray[this.mBondAtom[0][n]] && !blArray[this.mBondAtom[1][n]]) continue;
            blArray2[n] = true;
        }
        n = 0;
        int[] nArray = new int[this.mAllBonds];
        for (int i = 0; i < this.mAllBonds; ++i) {
            nArray[i] = blArray2[i] ? -1 : n++;
        }
        return nArray;
    }

    public int[] getDeleteAtomsBondMap(int[] nArray) {
        boolean[] blArray = new boolean[this.mAllAtoms];
        for (int n : nArray) {
            blArray[n] = true;
        }
        return this.getDeleteAtomsBondMap(blArray);
    }

    public boolean deleteSelectedAtoms() {
        boolean bl = false;
        for (int i = 0; i < this.mAllAtoms; ++i) {
            if ((this.mAtomFlags[i] & 0x200) == 0) continue;
            this.markAtomForDeletion(i);
            bl = true;
        }
        return bl && this.deleteMarkedAtomsAndBonds() != null;
    }

    public void markAtomForDeletion(int n) {
        this.mAtomicNo[n] = -1;
    }

    public void markBondForDeletion(int n) {
        this.mBondType[n] = 512;
    }

    public boolean isAtomMarkedForDeletion(int n) {
        return this.mAtomicNo[n] == -1;
    }

    public boolean isBondMarkedForDeletion(int n) {
        return this.mBondType[n] == 512;
    }

    public int[] deleteMarkedAtomsAndBonds() {
        int n;
        boolean bl = false;
        for (n = 0; n < this.mAllAtoms; ++n) {
            if (this.mAtomicNo[n] != -1) continue;
            bl = true;
            this.removeMappingNo(this.mAtomMapNo[n]);
        }
        for (n = 0; n < this.mAllBonds; ++n) {
            if (this.mBondType[n] == 512) {
                bl = true;
                continue;
            }
            if (this.mAtomicNo[this.mBondAtom[0][n]] != -1 && this.mAtomicNo[this.mBondAtom[1][n]] != -1) continue;
            this.mBondType[n] = 512;
            bl = true;
        }
        if (bl) {
            this.mValidHelperArrays = 0;
            return this.compressMolTable();
        }
        return null;
    }

    @Deprecated
    public void deleteMolecule() {
        this.clear();
    }

    public void clear() {
        this.mAllAtoms = 0;
        this.mAllBonds = 0;
        this.mIsFragment = false;
        this.mIsRacemate = false;
        this.mChirality = 0;
        this.mAtomList = null;
        this.mAtomCustomLabel = null;
        this.mName = null;
        this.mValidHelperArrays = 0;
    }

    public void removeAtomSelection() {
        int n = 0;
        while (n < this.mAllAtoms) {
            int n2 = n++;
            this.mAtomFlags[n2] = this.mAtomFlags[n2] & 0xFFFFFDFF;
        }
    }

    public void removeAtomColors() {
        int n = 0;
        while (n < this.mAllAtoms) {
            int n2 = n++;
            this.mAtomFlags[n2] = this.mAtomFlags[n2] & 0xFFFFFE3F;
        }
    }

    public void removeAtomCustomLabels() {
        this.mAtomCustomLabel = null;
    }

    public void removeAtomMarkers() {
        int n = 0;
        while (n < this.mAllAtoms) {
            int n2 = n++;
            this.mAtomFlags[n2] = this.mAtomFlags[n2] & 0xFFFDFFFF;
        }
    }

    public void removeBondHiliting() {
        int n = 0;
        while (n < this.mAllBonds) {
            int n2 = n++;
            this.mBondFlags[n2] = this.mBondFlags[n2] & 0xFFFE7FFF;
        }
    }

    public int findAtom(double d, double d2) {
        int n = -1;
        double d3 = this.getAverageBondLength();
        double d4 = Double.MAX_VALUE;
        double d5 = d3 * d3 / 12.0;
        for (int i = 0; i < this.mAllAtoms; ++i) {
            double d6 = this.mCoordinates[i].x;
            double d7 = this.mCoordinates[i].y;
            double d8 = (d - d6) * (d - d6) + (d2 - d7) * (d2 - d7);
            if (!(d8 < d5) || !(d8 < d4)) continue;
            d4 = d8;
            n = i;
        }
        return n;
    }

    public int findBond(double d, double d2) {
        int n = -1;
        double d3 = this.getAverageBondLength();
        double d4 = Double.MAX_VALUE;
        for (int i = 0; i < this.mAllBonds; ++i) {
            double d5;
            double d6 = this.mCoordinates[this.mBondAtom[0][i]].x;
            double d7 = this.mCoordinates[this.mBondAtom[0][i]].y;
            double d8 = this.mCoordinates[this.mBondAtom[1][i]].x;
            double d9 = this.mCoordinates[this.mBondAtom[1][i]].y;
            double d10 = d8 - d6;
            double d11 = d9 - d7;
            double d12 = Math.sqrt(d10 * d10 + d11 * d11);
            double d13 = (d6 + d8) / 2.0;
            d10 = d - d13;
            double d14 = (d7 + d9) / 2.0;
            d11 = d2 - d14;
            if (Math.sqrt(d10 * d10 + d11 * d11) > d12 / 2.0) continue;
            if (d8 == d6) {
                d5 = Math.abs(d6 - d);
            } else {
                double d15 = (d9 - d7) / (d6 - d8);
                double d16 = -d15 * d6 - d7;
                d5 = Math.abs((d15 * d + d2 + d16) / Math.sqrt(d15 * d15 + 1.0));
            }
            if (!(d5 < d3) || !(d5 < d4)) continue;
            d4 = d5;
            n = i;
        }
        return n;
    }

    public int getAllAtoms() {
        return this.mAllAtoms;
    }

    public int getAllBonds() {
        return this.mAllBonds;
    }

    public int getAtomAbnormalValence(int n) {
        return ((this.mAtomFlags[n] & 0x78000000) >>> 27) - 1;
    }

    public int getAtomCharge(int n) {
        return this.mAtomCharge[n];
    }

    public int getAtomCIPParity(int n) {
        return (this.mAtomFlags[n] & 0xC000) >> 14;
    }

    public int getAtomColor(int n) {
        return this.mAtomFlags[n] & 0x1C0;
    }

    public Coordinates[] getAtomCoordinates() {
        return this.mCoordinates;
    }

    public int getAtomESRGroup(int n) {
        if (this.getAtomESRType(n) != 1 && this.getAtomESRType(n) != 2) {
            return -1;
        }
        return (this.mAtomFlags[n] & 0x1F00000) >> 20;
    }

    public int getAtomESRType(int n) {
        return (this.mAtomFlags[n] & 0xC0000) >> 18;
    }

    public int getAtomicNo(int n) {
        return this.mAtomicNo[n];
    }

    public String getAtomCustomLabel(int n) {
        return this.mAtomCustomLabel == null ? null : (this.mAtomCustomLabel[n] == null ? null : new String(this.mAtomCustomLabel[n]));
    }

    public byte[] getAtomCustomLabelBytes(int n) {
        return this.mAtomCustomLabel == null ? null : this.mAtomCustomLabel[n];
    }

    public String getAtomLabel(int n) {
        return cAtomLabel[this.mAtomicNo[n]];
    }

    public int[] getAtomList(int n) {
        return this.mAtomList == null ? null : this.mAtomList[n];
    }

    public String getAtomListString(int n) {
        if (this.mAtomList == null || this.mAtomList[n] == null) {
            return (this.mAtomQueryFeatures[n] & 1L) != 0L ? "" : cAtomLabel[this.mAtomicNo[n]];
        }
        String string = "";
        for (int i = 0; i < this.mAtomList[n].length; ++i) {
            if (i > 0) {
                string = string.concat(",");
            }
            int n2 = this.mAtomList[n][i];
            string = string.concat(cAtomLabel[n2]);
        }
        return string;
    }

    public int getAtomMapNo(int n) {
        return Math.abs(this.mAtomMapNo[n]);
    }

    public int getAtomMass(int n) {
        return this.mAtomMass[n];
    }

    public int getAtomParity(int n) {
        return this.mAtomFlags[n] & 3;
    }

    public long getAtomQueryFeatures(int n) {
        return this.mAtomQueryFeatures[n];
    }

    public int getAtomRadical(int n) {
        return this.mAtomFlags[n] & 0x30;
    }

    public Coordinates getCoordinates(int n) {
        return this.mCoordinates[n];
    }

    public double getAtomX(int n) {
        return this.mCoordinates[n].x;
    }

    public double getAtomY(int n) {
        return this.mCoordinates[n].y;
    }

    public double getAtomZ(int n) {
        return this.mCoordinates[n].z;
    }

    public GenericRectangle getBounds(GenericRectangle genericRectangle) {
        if (this.mAllAtoms == 0) {
            return null;
        }
        double d = this.mCoordinates[0].x;
        double d2 = this.mCoordinates[0].y;
        double d3 = this.mCoordinates[0].x;
        double d4 = this.mCoordinates[0].y;
        for (int i = 1; i < this.mAllAtoms; ++i) {
            if (d > this.mCoordinates[i].x) {
                d = this.mCoordinates[i].x;
            } else if (d3 < this.mCoordinates[i].x) {
                d3 = this.mCoordinates[i].x;
            }
            if (d2 > this.mCoordinates[i].y) {
                d2 = this.mCoordinates[i].y;
                continue;
            }
            if (!(d4 < this.mCoordinates[i].y)) continue;
            d4 = this.mCoordinates[i].y;
        }
        if (genericRectangle == null) {
            genericRectangle = new GenericRectangle(d, d2, d3 - d, d4 - d2);
        } else {
            genericRectangle.x = d;
            genericRectangle.y = d2;
            genericRectangle.width = d3 - d;
            genericRectangle.height = d4 - d2;
        }
        return genericRectangle;
    }

    public static double getDefaultAverageBondLength() {
        return sDefaultAVBL;
    }

    public static void setDefaultAverageBondLength(double d) {
        sDefaultAVBL = d;
    }

    public double getAverageBondLength() {
        return this.getAverageBondLength(this.mAllAtoms, this.mAllBonds, sDefaultAVBL);
    }

    public double getAverageBondLength(double d) {
        return this.getAverageBondLength(this.mAllAtoms, this.mAllBonds, d);
    }

    public double getAverageBondLength(int n, int n2) {
        return this.getAverageBondLength(n, n2, sDefaultAVBL);
    }

    public double getAverageBondLength(int n, int n2, double d) {
        return this.getAverageBondLength(n, n2, d, this.mCoordinates);
    }

    public double getAverageBondLength(int n, int n2, double d, Coordinates[] coordinatesArray) {
        int n3;
        boolean bl = false;
        int n4 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            if (this.mBondType[n3] == 32 || (this.mBondQueryFeatures[n3] & 0x1FE00) != 0) continue;
            ++n4;
        }
        if (n4 == 0) {
            for (n3 = 0; n3 < n2; ++n3) {
                if ((this.mBondQueryFeatures[n3] & 0x1FE00) != 0) continue;
                ++n4;
            }
            bl = true;
        }
        if (n4 == 0) {
            if (n < 2) {
                return d;
            }
            double d2 = Double.MAX_VALUE;
            for (int i = 1; i < n; ++i) {
                for (int j = 0; j < i; ++j) {
                    double d3 = coordinatesArray[i].distance(coordinatesArray[j]);
                    if (!(d3 > 0.0) || !(d3 < d2)) continue;
                    d2 = d3;
                }
            }
            return d2 != Double.MAX_VALUE ? 0.6 * d2 : d;
        }
        double d4 = 0.0;
        for (int i = 0; i < n2; ++i) {
            if (!bl && this.mBondType[i] == 32 || (this.mBondQueryFeatures[i] & 0x1FE00) != 0) continue;
            d4 += coordinatesArray[this.mBondAtom[1][i]].distance(coordinatesArray[this.mBondAtom[0][i]]);
        }
        return d4 / (double)n4;
    }

    public double getBondAngle(int n, int n2) {
        return Molecule.getAngle(this.mCoordinates[n].x, this.mCoordinates[n].y, this.mCoordinates[n2].x, this.mCoordinates[n2].y);
    }

    public double calculateTorsion(int[] nArray) {
        Coordinates coordinates = this.mCoordinates[nArray[0]];
        Coordinates coordinates2 = this.mCoordinates[nArray[1]];
        Coordinates coordinates3 = this.mCoordinates[nArray[2]];
        Coordinates coordinates4 = this.mCoordinates[nArray[3]];
        Coordinates coordinates5 = coordinates2.subC(coordinates);
        Coordinates coordinates6 = coordinates3.subC(coordinates2);
        Coordinates coordinates7 = coordinates4.subC(coordinates3);
        Coordinates coordinates8 = coordinates5.cross(coordinates6);
        Coordinates coordinates9 = coordinates6.cross(coordinates7);
        return -Math.atan2(coordinates6.getLength() * coordinates5.dot(coordinates9), coordinates8.dot(coordinates9));
    }

    public void center() {
        int n;
        Coordinates coordinates = new Coordinates();
        for (n = 0; n < this.mAllAtoms; ++n) {
            coordinates.add(this.mCoordinates[n]);
        }
        coordinates.scale(1.0 / (double)this.mAllAtoms);
        for (n = 0; n < this.mAllAtoms; ++n) {
            this.mCoordinates[n].sub(coordinates);
        }
    }

    public void translate(double d, double d2, double d3) {
        for (int i = 0; i < this.mAllAtoms; ++i) {
            this.mCoordinates[i].add(d, d2, d3);
        }
    }

    public int getBondAtom(int n, int n2) {
        return this.mBondAtom[n][n2];
    }

    public int getBondCIPParity(int n) {
        return (this.mBondFlags[n] & 0x30) >> 4;
    }

    public int getBondESRGroup(int n) {
        if (this.getBondESRType(n) != 1 && this.getBondESRType(n) != 2) {
            return -1;
        }
        return (this.mBondFlags[n] & 0x7C00) >> 10;
    }

    public int getBondESRType(int n) {
        return (this.mBondFlags[n] & 0x300) >> 8;
    }

    public double getBondLength(int n) {
        int n2 = this.mBondAtom[0][n];
        int n3 = this.mBondAtom[1][n];
        double d = this.mCoordinates[n3].x - this.mCoordinates[n2].x;
        double d2 = this.mCoordinates[n3].y - this.mCoordinates[n2].y;
        return Math.sqrt(d * d + d2 * d2);
    }

    public int getBondOrder(int n) {
        switch (this.mBondType[n] & 0x7F) {
            case 1: 
            case 64: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 8: {
                return 4;
            }
            case 16: {
                return 5;
            }
        }
        return 0;
    }

    public int getBondParity(int n) {
        return this.mBondFlags[n] & 3;
    }

    public int getBondQueryFeatures(int n) {
        return this.mBondQueryFeatures[n];
    }

    public boolean isBondBridge(int n) {
        return (this.mBondQueryFeatures[n] & 0x1FE00) != 0;
    }

    public int getBondBridgeMinSize(int n) {
        return (this.mBondQueryFeatures[n] & 0x1E00) >> 9;
    }

    public int getBondBridgeMaxSize(int n) {
        return ((this.mBondQueryFeatures[n] & 0x1E00) >> 9) + ((this.mBondQueryFeatures[n] & 0x1E000) >> 13);
    }

    public int getBondType(int n) {
        return this.mBondType[n];
    }

    public int getBondTypeSimple(int n) {
        return this.mBondType[n] & 0x7F;
    }

    public int getChirality() {
        return this.mChirality;
    }

    public int getMaxAtoms() {
        return this.mMaxAtoms;
    }

    private static Coordinates[] copyOf(Coordinates[] coordinatesArray, int n) {
        Coordinates[] coordinatesArray2 = new Coordinates[n];
        for (int i = 0; i < coordinatesArray.length; ++i) {
            if (coordinatesArray[i] == null) continue;
            coordinatesArray2[i] = new Coordinates(coordinatesArray[i]);
        }
        return coordinatesArray2;
    }

    private static int[] copyOf(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, Math.min(nArray.length, n));
        return nArray2;
    }

    private static long[] copyOf(long[] lArray, int n) {
        long[] lArray2 = new long[n];
        System.arraycopy(lArray, 0, lArray2, 0, Math.min(lArray.length, n));
        return lArray2;
    }

    private static int[][] copyOf(int[][] nArray, int n) {
        int[][] nArrayArray = new int[n][];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == null) continue;
            nArrayArray[i] = new int[nArray[i].length];
            System.arraycopy(nArray[i], 0, nArrayArray[i], 0, nArray[i].length);
        }
        return nArrayArray;
    }

    private static byte[][] copyOf(byte[][] byArray, int n) {
        byte[][] byArrayArray = new byte[n][];
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == null) continue;
            byArrayArray[i] = new byte[byArray[i].length];
            System.arraycopy(byArray[i], 0, byArrayArray[i], 0, byArray[i].length);
        }
        return byArrayArray;
    }

    public void setMaxAtoms(int n) {
        this.mAtomicNo = Molecule.copyOf(this.mAtomicNo, n);
        this.mAtomCharge = Molecule.copyOf(this.mAtomCharge, n);
        this.mAtomMapNo = Molecule.copyOf(this.mAtomMapNo, n);
        int n2 = this.mCoordinates.length;
        this.mCoordinates = Molecule.copyOf(this.mCoordinates, n);
        for (int i = n2; i < n; ++i) {
            this.mCoordinates[i] = new Coordinates();
        }
        this.mAtomMass = Molecule.copyOf(this.mAtomMass, n);
        this.mAtomFlags = Molecule.copyOf(this.mAtomFlags, n);
        this.mAtomQueryFeatures = Molecule.copyOf(this.mAtomQueryFeatures, n);
        if (this.mAtomList != null) {
            this.mAtomList = Molecule.copyOf(this.mAtomList, n);
        }
        if (this.mAtomCustomLabel != null) {
            this.mAtomCustomLabel = Molecule.copyOf(this.mAtomCustomLabel, n);
        }
        this.mMaxAtoms = n;
    }

    public int getMaxBonds() {
        return this.mMaxBonds;
    }

    public void setMaxBonds(int n) {
        this.mBondAtom[0] = Molecule.copyOf(this.mBondAtom[0], n);
        this.mBondAtom[1] = Molecule.copyOf(this.mBondAtom[1], n);
        this.mBondType = Molecule.copyOf(this.mBondType, n);
        this.mBondFlags = Molecule.copyOf(this.mBondFlags, n);
        this.mBondQueryFeatures = Molecule.copyOf(this.mBondQueryFeatures, n);
        this.mMaxBonds = n;
    }

    public int getMoleculeColor() {
        return this.mMoleculeColor;
    }

    public void setMoleculeColor(int n) {
        this.mMoleculeColor = n;
    }

    public String getName() {
        return this.mName;
    }

    public boolean getStereoProblem(int n) {
        return (this.mAtomFlags[n] & 0x10000) != 0;
    }

    public boolean isAtomConfigurationUnknown(int n) {
        return (this.mAtomFlags[n] & 0x2000000) != 0;
    }

    public boolean isAtomParityPseudo(int n) {
        return (this.mAtomFlags[n] & 4) != 0;
    }

    public boolean isAtomStereoCenter(int n) {
        return (this.mAtomFlags[n] & 0x4000000) != 0;
    }

    public boolean isBondParityPseudo(int n) {
        return (this.mBondFlags[n] & 4) != 0;
    }

    public boolean isBondParityUnknownOrNone(int n) {
        return (this.mBondFlags[n] & 0x20000) != 0;
    }

    public boolean isFragment() {
        return this.mIsFragment;
    }

    public boolean isDelocalizedBond(int n) {
        return this.mBondType[n] == 64;
    }

    public boolean is3D() {
        for (int i = 0; i < this.mAllAtoms; ++i) {
            if (this.mCoordinates[i].z == 0.0) continue;
            return true;
        }
        return false;
    }

    public boolean isNaturalAbundance(int n) {
        return this.mAtomMass[n] == 0;
    }

    public boolean isPurelyOrganic() {
        block3: for (int i = 0; i < this.mAllAtoms; ++i) {
            switch (this.mAtomicNo[i]) {
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 33: 
                case 34: 
                case 35: 
                case 52: 
                case 53: {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isSelectedAtom(int n) {
        return (this.mAtomFlags[n] & 0x200) != 0;
    }

    public boolean isMarkedAtom(int n) {
        return (this.mAtomFlags[n] & 0x20000) != 0;
    }

    public boolean isBondBackgroundHilited(int n) {
        return (this.mBondFlags[n] & 0x8000) != 0;
    }

    public boolean isBondForegroundHilited(int n) {
        return (this.mBondFlags[n] & 0x10000) != 0;
    }

    public boolean isSelectedBond(int n) {
        return (this.mAtomFlags[this.mBondAtom[0][n]] & this.mAtomFlags[this.mBondAtom[1][n]] & 0x200) != 0;
    }

    public boolean isAutoMappedAtom(int n) {
        return this.mAtomMapNo[n] < 0;
    }

    public boolean isStereoBond(int n) {
        return this.mBondType[n] == 257 || this.mBondType[n] == 129;
    }

    public boolean isStereoBond(int n, int n2) {
        return (this.mBondType[n] == 257 || this.mBondType[n] == 129) && this.mBondAtom[0][n] == n2;
    }

    public void setAllAtoms(int n) {
        this.mAllAtoms = n;
        this.mValidHelperArrays = 0;
    }

    public void setAllBonds(int n) {
        this.mAllBonds = n;
        this.mValidHelperArrays = 0;
    }

    public void setAtomAbnormalValence(int n, int n2) {
        if (n2 >= -1 && n2 <= 14) {
            int n3 = n;
            this.mAtomFlags[n3] = this.mAtomFlags[n3] & 0x87FFFFFF;
            int n4 = n;
            this.mAtomFlags[n4] = this.mAtomFlags[n4] | 1 + n2 << 27;
            if (this.mAtomicNo[n] == 6 && (n2 == -1 || n2 == 0 || n2 == 2 || n2 == 4)) {
                int n5 = n;
                this.mAtomFlags[n5] = this.mAtomFlags[n5] & 0xFFFFFFCF;
                if (n2 == 2) {
                    int n6 = n;
                    this.mAtomFlags[n6] = this.mAtomFlags[n6] | 0x10;
                }
            }
        }
    }

    public void setAtomCharge(int n, int n2) {
        this.mAtomCharge[n] = n2;
        this.mValidHelperArrays = 0;
    }

    public void setAtomColor(int n, int n2) {
        int n3 = n;
        this.mAtomFlags[n3] = this.mAtomFlags[n3] & 0xFFFFFE3F;
        int n4 = n;
        this.mAtomFlags[n4] = this.mAtomFlags[n4] | n2;
    }

    public void setAtomConfigurationUnknown(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.mAtomFlags[n2] = this.mAtomFlags[n2] | 0x2000000;
        } else {
            int n3 = n;
            this.mAtomFlags[n3] = this.mAtomFlags[n3] & 0xFDFFFFFF;
        }
        this.mValidHelperArrays &= 7;
    }

    public void setAtomSelection(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.mAtomFlags[n2] = this.mAtomFlags[n2] | 0x200;
        } else {
            int n3 = n;
            this.mAtomFlags[n3] = this.mAtomFlags[n3] & 0xFFFFFDFF;
        }
    }

    public void setAtomMarker(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.mAtomFlags[n2] = this.mAtomFlags[n2] | 0x20000;
        } else {
            int n3 = n;
            this.mAtomFlags[n3] = this.mAtomFlags[n3] & 0xFFFDFFFF;
        }
    }

    public void setAtomicNo(int n, int n2) {
        if (n2 >= 0 && n2 <= 190) {
            if (n2 == 151 || n2 == 152) {
                this.mAtomicNo[n] = 1;
                this.mAtomMass[n] = n2 - 149;
            } else {
                this.mAtomicNo[n] = n2;
                this.mAtomMass[n] = 0;
            }
            int n3 = n;
            this.mAtomFlags[n3] = this.mAtomFlags[n3] & 0x87FFFFFF;
            this.mValidHelperArrays = 0;
        }
    }

    public void setAtomList(int n, int[] nArray) {
        if (this.mAtomList == null) {
            this.mAtomList = new int[this.mMaxAtoms][];
        }
        if (nArray != null) {
            Arrays.sort(nArray);
        }
        this.mAtomList[n] = nArray;
        this.mValidHelperArrays = 0;
        this.mIsFragment = true;
    }

    public void setAtomList(int n, int[] nArray, boolean bl) {
        if (nArray == null) {
            if (this.mAtomList != null) {
                this.mAtomList[n] = null;
            }
            return;
        }
        if (nArray.length == 1 && !bl) {
            int n2 = nArray[0];
            if (this.mAtomicNo[n] != n2) {
                this.changeAtom(n, n2, 0, -1, 0);
            }
            if (this.mAtomList != null) {
                this.mAtomList[n] = null;
            }
            return;
        }
        if (this.mAtomList == null) {
            this.mAtomList = new int[this.mMaxAtoms][];
        }
        this.mAtomList[n] = nArray;
        if (bl) {
            int n3 = n;
            this.mAtomQueryFeatures[n3] = this.mAtomQueryFeatures[n3] | 1L;
        }
        this.mValidHelperArrays = 0;
        this.mIsFragment = true;
    }

    public void setAtomMapNo(int n, int n2, boolean bl) {
        this.mAtomMapNo[n] = bl ? -n2 : n2;
    }

    public void setAtomMass(int n, int n2) {
        this.mAtomMass[n] = n2;
        this.mValidHelperArrays &= 7;
    }

    public void setAtomParity(int n, int n2, boolean bl) {
        int n3 = n;
        this.mAtomFlags[n3] = this.mAtomFlags[n3] & 0xFDFFFFF8;
        int n4 = n;
        this.mAtomFlags[n4] = this.mAtomFlags[n4] | n2;
        if (bl) {
            int n5 = n;
            this.mAtomFlags[n5] = this.mAtomFlags[n5] | 4;
        }
    }

    protected void setAtomStereoCenter(int n, boolean bl) {
        int n2 = n;
        this.mAtomFlags[n2] = this.mAtomFlags[n2] & 0xFBFFFFFF;
        if (bl) {
            int n3 = n;
            this.mAtomFlags[n3] = this.mAtomFlags[n3] | 0x4000000;
        }
    }

    public void setAtomQueryFeature(int n, long l, boolean bl) {
        if (bl) {
            int n2 = n;
            this.mAtomQueryFeatures[n2] = this.mAtomQueryFeatures[n2] | l;
        } else {
            int n3 = n;
            this.mAtomQueryFeatures[n3] = this.mAtomQueryFeatures[n3] & (l ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.mValidHelperArrays = 0;
        this.mIsFragment = true;
    }

    public void setAtomRadical(int n, int n2) {
        int n3 = n;
        this.mAtomFlags[n3] = this.mAtomFlags[n3] & 0xFFFFFFCF;
        int n4 = n;
        this.mAtomFlags[n4] = this.mAtomFlags[n4] | n2;
        this.mValidHelperArrays &= 7;
    }

    public void setAtomCIPParity(int n, int n2) {
        int n3 = n;
        this.mAtomFlags[n3] = this.mAtomFlags[n3] & 0xFFFF3FFF;
        int n4 = n;
        this.mAtomFlags[n4] = this.mAtomFlags[n4] | n2 << 14;
    }

    public void setAtomX(int n, double d) {
        this.mCoordinates[n].x = d;
        this.mValidHelperArrays &= 7;
    }

    public void setAtomY(int n, double d) {
        this.mCoordinates[n].y = d;
        this.mValidHelperArrays &= 7;
    }

    public void setAtomZ(int n, double d) {
        this.mCoordinates[n].z = d;
        this.mValidHelperArrays &= 7;
    }

    public void setBondAtom(int n, int n2, int n3) {
        this.mBondAtom[n][n2] = n3;
        this.mValidHelperArrays = 0;
    }

    public void setBondCIPParity(int n, int n2) {
        int n3 = n;
        this.mBondFlags[n3] = this.mBondFlags[n3] & 0xFFFFFFCF;
        int n4 = n;
        this.mBondFlags[n4] = this.mBondFlags[n4] | n2 << 4;
    }

    public void setBondBackgroundHiliting(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.mBondFlags[n2] = this.mBondFlags[n2] | 0x8000;
        } else {
            int n3 = n;
            this.mBondFlags[n3] = this.mBondFlags[n3] & 0xFFFF7FFF;
        }
    }

    public void setBondForegroundHiliting(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.mBondFlags[n2] = this.mBondFlags[n2] | 0x10000;
        } else {
            int n3 = n;
            this.mBondFlags[n3] = this.mBondFlags[n3] & 0xFFFEFFFF;
        }
    }

    public void setBondParity(int n, int n2, boolean bl) {
        int n3 = n;
        this.mBondFlags[n3] = this.mBondFlags[n3] & 0xFFFDFFF8;
        int n4 = n;
        this.mBondFlags[n4] = this.mBondFlags[n4] | n2;
        if (bl) {
            int n5 = n;
            this.mBondFlags[n5] = this.mBondFlags[n5] | 4;
        }
    }

    public void setBondParityUnknownOrNone(int n) {
        int n2 = n;
        this.mBondFlags[n2] = this.mBondFlags[n2] | 0x20000;
    }

    public void setBondQueryFeature(int n, int n2, boolean bl) {
        if (bl) {
            int n3 = n;
            this.mBondQueryFeatures[n3] = this.mBondQueryFeatures[n3] | n2;
        } else {
            int n4 = n;
            this.mBondQueryFeatures[n4] = this.mBondQueryFeatures[n4] & ~n2;
        }
        this.mValidHelperArrays = 0;
        this.mIsFragment = true;
    }

    public void setBondOrder(int n, int n2) {
        this.mBondType[n] = n2 == 1 ? 1 : (n2 == 2 ? 2 : (n2 == 3 ? 4 : 32));
        this.mValidHelperArrays = 0;
    }

    public void setBondType(int n, int n2) {
        this.mBondType[n] = n2;
        this.mValidHelperArrays = 0;
    }

    public void setChirality(int n) {
        this.mChirality = n;
    }

    public void setHydrogenProtection(boolean bl) {
        this.mProtectHydrogen = bl;
    }

    public void setHelperValidity(int n) {
        this.mValidHelperArrays = n;
    }

    public void setToRacemate() {
        this.mIsRacemate = true;
    }

    public void setAtomCustomLabel(int n, byte[] byArray) {
        if (byArray != null && byArray.length == 0) {
            byArray = null;
        }
        if (byArray == null) {
            if (this.mAtomCustomLabel != null) {
                this.mAtomCustomLabel[n] = null;
            }
        } else {
            if (this.mAtomCustomLabel == null) {
                this.mAtomCustomLabel = new byte[this.mMaxAtoms][];
            }
            this.mAtomCustomLabel[n] = byArray;
        }
    }

    public void setAtomCustomLabel(int n, String string) {
        if (string != null) {
            if (string.length() == 0) {
                string = null;
            } else {
                int n2 = Molecule.getAtomicNoFromLabel(string);
                if (n2 != 0 && string.equals(cAtomLabel[n2]) || string.equals("?")) {
                    this.setAtomicNo(n, n2);
                    string = null;
                }
            }
        }
        if (string == null) {
            if (this.mAtomCustomLabel != null) {
                this.mAtomCustomLabel[n] = null;
            }
        } else {
            if (this.mAtomCustomLabel == null) {
                this.mAtomCustomLabel = new byte[this.mMaxAtoms][];
            }
            this.mAtomCustomLabel[n] = string.getBytes();
        }
    }

    public void setAtomESR(int n, int n2, int n3) {
        if (n2 == 0) {
            int n4 = n;
            this.mAtomFlags[n4] = this.mAtomFlags[n4] & 0xFE03FFFF;
            int n5 = n;
            this.mAtomFlags[n5] = this.mAtomFlags[n5] | n2 << 18;
        } else {
            if (n3 >= 32) {
                return;
            }
            if (n3 == -1) {
                int n6;
                int n7 = -1;
                for (n6 = 0; n6 < this.mAllAtoms; ++n6) {
                    if (n6 == n || n2 != this.getAtomESRType(n6) || n7 >= this.getAtomESRGroup(n6)) continue;
                    n7 = this.getAtomESRGroup(n6);
                }
                for (n6 = 0; n6 < this.mAllBonds; ++n6) {
                    if (n2 != this.getBondESRType(n6) || n7 >= this.getBondESRGroup(n6)) continue;
                    n7 = this.getBondESRGroup(n6);
                }
                n3 = n7 + 1;
                if (n3 >= 32) {
                    return;
                }
            }
            int n8 = n;
            this.mAtomFlags[n8] = this.mAtomFlags[n8] & 0xFE03FFFF;
            int n9 = n;
            this.mAtomFlags[n9] = this.mAtomFlags[n9] | (n2 << 18 | n3 << 20);
        }
        this.mValidHelperArrays &= 7;
    }

    public void setBondESR(int n, int n2, int n3) {
        if (n2 == 0) {
            int n4 = n;
            this.mBondFlags[n4] = this.mBondFlags[n4] & 0xFFFF80FF;
            int n5 = n;
            this.mBondFlags[n5] = this.mBondFlags[n5] | n2 << 8;
        } else {
            if (n3 >= 32) {
                return;
            }
            if (n3 == -1) {
                int n6;
                int n7 = -1;
                for (n6 = 0; n6 < this.mAllAtoms; ++n6) {
                    if (n2 != this.getAtomESRType(n6) || n7 >= this.getAtomESRGroup(n6)) continue;
                    n7 = this.getAtomESRGroup(n6);
                }
                for (n6 = 0; n6 < this.mAllBonds; ++n6) {
                    if (n6 == n || n2 != this.getBondESRType(n6) || n7 >= this.getBondESRGroup(n6)) continue;
                    n7 = this.getBondESRGroup(n6);
                }
                n3 = n7 + 1;
                if (n3 >= 32) {
                    return;
                }
            }
            int n8 = n;
            this.mBondFlags[n8] = this.mBondFlags[n8] & 0xFFFF80FF;
            int n9 = n;
            this.mBondFlags[n9] = this.mBondFlags[n9] | (n2 << 8 | n3 << 10);
        }
        this.mValidHelperArrays &= 7;
    }

    public void setFragment(boolean bl) {
        if (this.mIsFragment != bl) {
            this.mIsFragment = bl;
            if (!bl) {
                this.removeQueryFeatures();
            }
            this.mValidHelperArrays = 0;
        }
    }

    public void setName(String string) {
        this.mName = string;
    }

    public Object getUserData() {
        return this.mUserData;
    }

    public void setUserData(Object object) {
        this.mUserData = object;
    }

    public boolean removeQueryFeatures() {
        int n;
        boolean bl = false;
        for (n = 0; n < this.mAllAtoms; ++n) {
            if ((this.mAtomQueryFeatures[n] & 0x20000000L) == 0L) continue;
            this.markAtomForDeletion(n);
            bl = true;
        }
        if (bl) {
            this.deleteMarkedAtomsAndBonds();
        }
        if (this.mAtomList != null) {
            this.mAtomList = null;
            bl = true;
        }
        for (n = 0; n < this.mAllAtoms; ++n) {
            if (this.mAtomQueryFeatures[n] == 0L) continue;
            this.mAtomQueryFeatures[n] = 0L;
            bl = true;
        }
        for (n = 0; n < this.mAllBonds; ++n) {
            if (this.mBondQueryFeatures[n] != 0) {
                this.mBondQueryFeatures[n] = 0;
                bl = true;
            }
            if (this.mBondType[n] != 64) continue;
            this.mBondType[n] = 1;
            bl = true;
        }
        if (bl) {
            this.mValidHelperArrays = 0;
        }
        return bl;
    }

    protected void setStereoProblem(int n) {
        int n2 = n;
        this.mAtomFlags[n2] = this.mAtomFlags[n2] | 0x10000;
    }

    public boolean stripIsotopInfo() {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < this.mAllAtoms; ++i) {
            if (this.mAtomMass[i] == 0) continue;
            this.mAtomMass[i] = 0;
            bl = true;
            if (this.mAtomicNo[i] != 1) continue;
            bl2 = true;
        }
        if (bl2) {
            this.mValidHelperArrays = 0;
        }
        return bl;
    }

    public void translateCoords(double d, double d2) {
        for (int i = 0; i < this.mAllAtoms; ++i) {
            this.mCoordinates[i].x += d;
            this.mCoordinates[i].y += d2;
        }
        this.mZoomRotationX += d;
        this.mZoomRotationY += d2;
    }

    public void scaleCoords(double d) {
        for (int i = 0; i < this.mAllAtoms; ++i) {
            this.mCoordinates[i].x *= d;
            this.mCoordinates[i].y *= d;
        }
    }

    public void zoomAndRotateInit(double d, double d2) {
        this.mZoomRotationX = d;
        this.mZoomRotationY = d2;
        this.mOriginalAngle = new double[this.mAllAtoms];
        this.mOriginalDistance = new double[this.mAllAtoms];
        for (int i = 0; i < this.mAllAtoms; ++i) {
            double d3 = d - this.mCoordinates[i].x;
            double d4 = d2 - this.mCoordinates[i].y;
            this.mOriginalDistance[i] = Math.sqrt(d3 * d3 + d4 * d4);
            this.mOriginalAngle[i] = Molecule.getAngle(d, d2, this.mCoordinates[i].x, this.mCoordinates[i].y);
        }
    }

    public void zoomAndRotate(double d, double d2, boolean bl) {
        for (int i = 0; i < this.mAllAtoms; ++i) {
            if (bl && !this.isSelectedAtom(i)) continue;
            double d3 = this.mOriginalDistance[i] * d;
            double d4 = this.mOriginalAngle[i] - d2;
            this.mCoordinates[i].x = this.mZoomRotationX + d3 * Math.sin(d4);
            this.mCoordinates[i].y = this.mZoomRotationY + d3 * Math.cos(d4);
        }
        if (bl) {
            this.mValidHelperArrays &= 7;
        }
    }

    private int getMaximumBondOrder(int n) {
        int n2 = this.isTransitionMetalAtom(this.mBondAtom[0][n]) || this.isTransitionMetalAtom(this.mBondAtom[1][n]) ? 5 : 3;
        for (int i = 0; i < 2; ++i) {
            int n3 = this.mBondAtom[i][n];
            int n4 = this.getBondOrder(n) + this.getMaxValence(n3) - this.getOccupiedValence(n3);
            if (n2 <= n4) continue;
            n2 = n4;
        }
        return n2;
    }

    private boolean incrementBondOrder(int n) {
        int n2;
        int n3 = this.getMaximumBondOrder(n);
        boolean bl = this.isMetalAtom(this.mBondAtom[0][n]) || this.isMetalAtom(this.mBondAtom[1][n]);
        int n4 = n2 = bl ? 32 : 1;
        if (this.mBondType[n] == 16) {
            this.mBondType[n] = n2;
            this.mValidHelperArrays = 0;
            return true;
        }
        if (this.mBondType[n] == 8) {
            this.mBondType[n] = n3 > 4 ? 16 : n2;
            this.mValidHelperArrays = 0;
            return true;
        }
        if (this.mBondType[n] == 4) {
            this.mBondType[n] = n3 > 3 ? 8 : n2;
            this.mValidHelperArrays = 0;
            return true;
        }
        if (this.mBondType[n] == 2) {
            this.mBondType[n] = 386;
            this.mValidHelperArrays &= 7;
            if ((this.mBondFlags[n] & 0x80) == 0) {
                return true;
            }
        }
        if (this.mBondType[n] == 386) {
            this.mBondType[n] = n3 > 2 ? 4 : n2;
            this.mValidHelperArrays = 0;
            return true;
        }
        if ((0x180 & this.mBondType[n]) != 0) {
            this.mBondType[n] = 1;
            this.mValidHelperArrays &= 7;
            return true;
        }
        if (!bl && n3 < 2) {
            return false;
        }
        if (this.mBondType[n] == 1) {
            this.mBondType[n] = 2;
            this.mValidHelperArrays = 0;
            return true;
        }
        if (n3 < 1) {
            return false;
        }
        if (this.mBondType[n] == 32) {
            this.mBondType[n] = 1;
            this.mValidHelperArrays = 0;
            return true;
        }
        return false;
    }

    protected boolean validateBondType(int n, int n2) {
        int n3 = n2 & 0x7F;
        int n4 = this.getMaximumBondOrder(n);
        switch (n3) {
            case 1: 
            case 64: {
                return n4 >= 1;
            }
            case 2: {
                return n4 >= 2;
            }
            case 4: {
                return n4 >= 3;
            }
            case 8: {
                return n4 >= 4;
            }
            case 16: {
                return n4 >= 5;
            }
            case 32: {
                return true;
            }
        }
        return false;
    }

    protected int getOccupiedValence(int n) {
        return this.simpleGetValence(n);
    }

    private int simpleGetValence(int n) {
        int n2 = 0;
        for (int i = 0; i < this.mAllBonds; ++i) {
            if (this.mBondAtom[0][i] != n && this.mBondAtom[1][i] != n) continue;
            n2 += this.getBondOrder(i);
        }
        return n2;
    }

    public int getMaxValenceUncharged(int n) {
        int n2 = this.getAtomAbnormalValence(n);
        if (n2 == -1) {
            n2 = this.getDefaultMaxValenceUncharged(n);
        }
        return n2;
    }

    public int getDefaultMaxValenceUncharged(int n) {
        byte[] byArray = this.mAtomicNo[n] < cAtomValence.length ? cAtomValence[this.mAtomicNo[n]] : null;
        return byArray == null ? 6 : byArray[byArray.length - 1];
    }

    public int getMaxValence(int n) {
        int n2 = this.getMaxValenceUncharged(n);
        return n2 + this.getElectronValenceCorrection(n, n2);
    }

    public int getElectronValenceCorrection(int n, int n2) {
        int n3;
        if (this.mAtomicNo[n] >= 171 && this.mAtomicNo[n] <= 190) {
            return 0;
        }
        int n4 = 0;
        if ((this.mAtomFlags[n] & 0x30) == 32) {
            --n4;
        }
        if ((this.mAtomFlags[n] & 0x30) == 16 || (this.mAtomFlags[n] & 0x30) == 48) {
            n4 -= 2;
        }
        if ((n3 = this.mAtomCharge[n]) == 0 && this.mIsFragment) {
            if ((this.mAtomQueryFeatures[n] & 0xE000000L) == 0xC000000L) {
                n3 = -1;
            }
            if ((this.mAtomQueryFeatures[n] & 0xE000000L) == 0x6000000L) {
                n3 = 1;
            }
        }
        n4 = this.mAtomicNo[n] == 7 || this.mAtomicNo[n] == 8 || this.mAtomicNo[n] == 9 ? (n4 += n3) : (this.mAtomicNo[n] == 6 || this.mAtomicNo[n] == 14 || this.mAtomicNo[n] == 32 ? (n4 -= Math.abs(n3)) : (this.mAtomicNo[n] == 15 || this.mAtomicNo[n] == 33 ? (n2 - n4 - n3 <= 3 ? (n4 += n3) : (n4 -= n3)) : (this.mAtomicNo[n] == 16 || this.mAtomicNo[n] == 34 || this.mAtomicNo[n] == 52 ? (n2 - n4 - n3 <= 4 ? (n4 += n3) : (n4 -= Math.abs(n3))) : (this.mAtomicNo[n] == 17 || this.mAtomicNo[n] == 35 || this.mAtomicNo[n] == 53 ? (n2 - n4 - n3 <= 5 ? (n4 += n3) : (n4 -= Math.abs(n3))) : (n4 -= n3)))));
        return n4;
    }

    public static boolean isAtomicNoElectronegative(int n) {
        switch (n) {
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 33: 
            case 34: 
            case 35: 
            case 52: 
            case 53: {
                return true;
            }
        }
        return false;
    }

    public boolean isElectronegative(int n) {
        if (this.mIsFragment) {
            if ((this.mAtomQueryFeatures[n] & 1L) != 0L) {
                return false;
            }
            if (this.mAtomList != null && this.mAtomList[n] != null) {
                for (int n2 : this.mAtomList[n]) {
                    if (Molecule.isAtomicNoElectronegative(n2)) continue;
                    return false;
                }
            }
        }
        return Molecule.isAtomicNoElectronegative(this.mAtomicNo[n]);
    }

    public static boolean isAtomicNoElectropositive(int n) {
        if (n == 1 || n == 6) {
            return false;
        }
        if (Molecule.isAtomicNoElectronegative(n)) {
            return false;
        }
        if (n == 2 || n == 10 || n == 18 || n == 36 || n == 54) {
            return false;
        }
        return n <= 103;
    }

    public boolean isElectropositive(int n) {
        if (this.mIsFragment) {
            if ((this.mAtomQueryFeatures[n] & 1L) != 0L) {
                return false;
            }
            if (this.mAtomList != null && this.mAtomList[n] != null) {
                for (int n2 : this.mAtomList[n]) {
                    if (Molecule.isAtomicNoElectropositive(n2)) continue;
                    return false;
                }
            }
        }
        return Molecule.isAtomicNoElectropositive(this.mAtomicNo[n]);
    }

    public boolean isMetalAtom(int n) {
        if (this.mIsFragment) {
            if ((this.mAtomQueryFeatures[n] & 1L) != 0L) {
                return false;
            }
            if (this.mAtomList != null && this.mAtomList[n] != null) {
                for (int n2 : this.mAtomList[n]) {
                    if (Molecule.isAtomicNoMetal(n2)) continue;
                    return false;
                }
            }
        }
        return Molecule.isAtomicNoMetal(this.mAtomicNo[n]);
    }

    public boolean isTransitionMetalAtom(int n) {
        if (this.mIsFragment) {
            if ((this.mAtomQueryFeatures[n] & 1L) != 0L) {
                return false;
            }
            if (this.mAtomList != null && this.mAtomList[n] != null) {
                for (int n2 : this.mAtomList[n]) {
                    if (Molecule.isAtomicNoMetal(n2)) continue;
                    return false;
                }
            }
        }
        return Molecule.isAtomicNoTransitionMetal(this.mAtomicNo[n]);
    }

    public static boolean isAtomicNoMetal(int n) {
        return n >= 3 && n <= 4 || n >= 11 && n <= 13 || n >= 19 && n <= 31 || n >= 37 && n <= 51 || n >= 55 && n <= 84 || n >= 87 && n <= 103;
    }

    public static boolean isAtomicNoTransitionMetal(int n) {
        return n >= 21 && n <= 30 || n >= 39 && n <= 48 || n == 57 || n >= 72 && n <= 80 || n == 89 || n >= 104 && n <= 112;
    }

    public boolean isOrganicAtom(int n) {
        if (this.mIsFragment) {
            if ((this.mAtomQueryFeatures[n] & 1L) != 0L) {
                return false;
            }
            if (this.mAtomList != null && this.mAtomList[n] != null) {
                for (int n2 : this.mAtomList[n]) {
                    if (Molecule.isAtomicNoOrganic(n2)) continue;
                    return false;
                }
            }
        }
        return Molecule.isAtomicNoOrganic(this.mAtomicNo[n]);
    }

    public static boolean isAtomicNoOrganic(int n) {
        return n == 1 || n >= 5 && n <= 9 || n >= 14 && n <= 17 || n >= 32 && n <= 35 || n >= 52 && n <= 53;
    }

    public void removeAtomMapping(boolean bl) {
        for (int i = 0; i < this.mAllAtoms; ++i) {
            if (bl && this.mAtomMapNo[i] >= 0) continue;
            this.mAtomMapNo[i] = 0;
        }
    }

    protected void removeMappingNo(int n) {
        for (int i = 0; i < this.mAllAtoms; ++i) {
            if (Math.abs(this.mAtomMapNo[i]) != Math.abs(n)) continue;
            this.mAtomMapNo[i] = 0;
        }
    }

    protected int[] compressMolTable() {
        int n;
        int n2;
        for (int i = 0; i < this.mAllBonds; ++i) {
            if (this.mBondType[i] != 512 || !(this.mAtomicNo[n2 = this.mBondAtom[0][i]] == -1 ^ this.mAtomicNo[n = this.mBondAtom[1][i]] == -1) || this.mAtomCharge[n2] == 0 || this.mAtomCharge[n] == 0 || !(this.mAtomCharge[n2] < 0 ^ this.mAtomCharge[n] < 0)) continue;
            if (this.mAtomCharge[n2] < 0) {
                int n3 = n2;
                this.mAtomCharge[n3] = this.mAtomCharge[n3] + 1;
                int n4 = n;
                this.mAtomCharge[n4] = this.mAtomCharge[n4] - 1;
                continue;
            }
            int n5 = n2;
            this.mAtomCharge[n5] = this.mAtomCharge[n5] - 1;
            int n6 = n;
            this.mAtomCharge[n6] = this.mAtomCharge[n6] + 1;
        }
        int[] nArray = new int[this.mAllAtoms];
        n2 = 0;
        for (n = 0; n < this.mAllAtoms; ++n) {
            if (this.mAtomicNo[n] == -1) {
                nArray[n] = -1;
                continue;
            }
            if (n2 < n) {
                this.mAtomicNo[n2] = this.mAtomicNo[n];
                this.mAtomCharge[n2] = this.mAtomCharge[n];
                this.mAtomMass[n2] = this.mAtomMass[n];
                this.mAtomFlags[n2] = this.mAtomFlags[n];
                this.mAtomQueryFeatures[n2] = this.mAtomQueryFeatures[n];
                this.mAtomMapNo[n2] = this.mAtomMapNo[n];
                this.mCoordinates[n2].set(this.mCoordinates[n]);
                if (this.mAtomList != null) {
                    this.mAtomList[n2] = this.mAtomList[n];
                }
                if (this.mAtomCustomLabel != null) {
                    this.mAtomCustomLabel[n2] = this.mAtomCustomLabel[n];
                }
            }
            nArray[n] = n2++;
        }
        this.mAllAtoms = n2;
        n = 0;
        for (int i = 0; i < this.mAllBonds; ++i) {
            if (this.mBondType[i] == 512) continue;
            this.mBondType[n] = this.mBondType[i];
            this.mBondFlags[n] = this.mBondFlags[i];
            this.mBondQueryFeatures[n] = this.mBondQueryFeatures[i];
            this.mBondAtom[0][n] = nArray[this.mBondAtom[0][i]];
            this.mBondAtom[1][n] = nArray[this.mBondAtom[1][i]];
            ++n;
        }
        this.mAllBonds = n;
        return nArray;
    }

    private void polygon(int n, int n2, int n3, boolean bl, double d, double d2, double d3) {
        int n4;
        if (n != n3) {
            double d4 = this.mCoordinates[n].x - this.mCoordinates[n3].x;
            double d5 = this.mCoordinates[n].y - this.mCoordinates[n3].y;
            d3 = Math.sqrt(d4 * d4 + d5 * d5);
        }
        int n5 = n;
        boolean bl2 = this.simpleGetValence(n) != 3;
        for (int i = 1; i < n2; ++i) {
            double d6 = this.mCoordinates[n5].x + d3 * Math.sin(d);
            double d7 = this.mCoordinates[n5].y + d3 * Math.cos(d);
            int n6 = -1;
            for (int j = 0; j < this.mAllAtoms; ++j) {
                if (!(Math.abs(d6 - this.mCoordinates[j].x) < 4.0) || !(Math.abs(d7 - this.mCoordinates[j].y) < 4.0)) continue;
                n6 = j;
                break;
            }
            if (n6 == -1) {
                n6 = this.addAtom(d6, d7);
                this.mCoordinates[n6].x = d6;
                this.mCoordinates[n6].y = d7;
                this.mCoordinates[n6].z = 0.0;
            }
            if ((n4 = this.getBondNo(n5, n6)) == -1) {
                n4 = this.addBond(n5, n6, this.suggestBondType(n5, n6));
                if (bl) {
                    if (bl2 && this.simpleGetValence(this.mBondAtom[0][n4]) < 4 && this.simpleGetValence(this.mBondAtom[1][n4]) < 3) {
                        this.mBondType[n4] = 2;
                    }
                    bl2 = !bl2;
                }
            }
            n5 = n6;
            d += d2;
        }
        n4 = this.getBondNo(n5, n3);
        if (n4 == -1) {
            n4 = this.addBond(n5, n3, this.suggestBondType(n5, n3));
        }
        if (bl && bl2 && this.simpleGetValence(this.mBondAtom[0][n4]) < 4 && this.simpleGetValence(this.mBondAtom[1][n4]) < 4) {
            this.mBondType[n4] = 2;
        }
    }

    private int getBondNo(int n, int n2) {
        for (int i = 0; i < this.mAllBonds; ++i) {
            if ((this.mBondAtom[0][i] != n || this.mBondAtom[1][i] != n2) && (this.mBondAtom[0][i] != n2 || this.mBondAtom[1][i] != n) || this.mBondType[i] == 512) continue;
            return i;
        }
        return -1;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        objectOutputStream.writeInt(this.mAllAtoms);
        objectOutputStream.writeInt(this.mAllBonds);
        objectOutputStream.writeBoolean(this.mIsFragment);
        for (n = 0; n < this.mAllAtoms; ++n) {
            int n2;
            objectOutputStream.writeInt(this.mAtomicNo[n]);
            objectOutputStream.writeInt(this.mAtomCharge[n]);
            objectOutputStream.writeInt(this.mAtomMass[n]);
            objectOutputStream.writeInt(this.mAtomFlags[n] & 0xFBFE03F0);
            objectOutputStream.writeLong(this.mAtomQueryFeatures[n]);
            objectOutputStream.writeDouble(this.mCoordinates[n].x);
            objectOutputStream.writeDouble(this.mCoordinates[n].y);
            objectOutputStream.writeDouble(this.mCoordinates[n].z);
            objectOutputStream.writeInt(this.mAtomMapNo[n]);
            if (this.mAtomList != null && this.mAtomList[n] != null) {
                objectOutputStream.writeInt(this.mAtomList[n].length);
                for (n2 = 0; n2 < this.mAtomList[n].length; ++n2) {
                    objectOutputStream.writeInt(this.mAtomList[n][n2]);
                }
            } else {
                objectOutputStream.writeInt(0);
            }
            if (this.mAtomCustomLabel != null && this.mAtomCustomLabel[n] != null) {
                objectOutputStream.writeInt(this.mAtomCustomLabel[n].length);
                for (n2 = 0; n2 < this.mAtomCustomLabel[n].length; ++n2) {
                    objectOutputStream.writeByte(this.mAtomCustomLabel[n][n2]);
                }
                continue;
            }
            objectOutputStream.writeInt(0);
        }
        for (n = 0; n < this.mAllBonds; ++n) {
            objectOutputStream.writeInt(this.mBondAtom[0][n]);
            objectOutputStream.writeInt(this.mBondAtom[1][n]);
            objectOutputStream.writeInt(this.mBondType[n]);
            objectOutputStream.writeInt(this.mBondFlags[n]);
            objectOutputStream.writeInt(this.mBondQueryFeatures[n]);
        }
        objectOutputStream.writeObject(this.mName);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        int n;
        this.mAllAtoms = objectInputStream.readInt();
        this.mAllBonds = objectInputStream.readInt();
        this.mMaxAtoms = this.mAllAtoms;
        this.mMaxBonds = this.mAllBonds;
        this.init();
        this.mIsFragment = objectInputStream.readBoolean();
        for (n = 0; n < this.mAllAtoms; ++n) {
            int n2;
            this.mAtomicNo[n] = objectInputStream.readInt();
            this.mAtomCharge[n] = objectInputStream.readInt();
            this.mAtomMass[n] = objectInputStream.readInt();
            this.mAtomFlags[n] = objectInputStream.readInt();
            this.mAtomQueryFeatures[n] = objectInputStream.readLong();
            this.mCoordinates[n].set(objectInputStream.readDouble(), objectInputStream.readDouble(), objectInputStream.readDouble());
            this.mAtomMapNo[n] = objectInputStream.readInt();
            int n3 = objectInputStream.readInt();
            if (n3 != 0) {
                if (this.mAtomList == null) {
                    this.mAtomList = new int[this.mMaxAtoms][];
                }
                this.mAtomList[n] = new int[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.mAtomList[n][n2] = objectInputStream.readInt();
                }
            }
            if ((n3 = objectInputStream.readInt()) == 0) continue;
            if (this.mAtomCustomLabel == null) {
                this.mAtomCustomLabel = new byte[this.mMaxAtoms][];
            }
            this.mAtomCustomLabel[n] = new byte[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.mAtomCustomLabel[n][n2] = objectInputStream.readByte();
            }
        }
        for (n = 0; n < this.mAllBonds; ++n) {
            this.mBondAtom[0][n] = objectInputStream.readInt();
            this.mBondAtom[1][n] = objectInputStream.readInt();
            this.mBondType[n] = objectInputStream.readInt();
            this.mBondFlags[n] = objectInputStream.readInt();
            this.mBondQueryFeatures[n] = objectInputStream.readInt();
        }
        try {
            this.mName = (String)objectInputStream.readObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mValidHelperArrays = 0;
    }
}

