/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.ExtendedMolecule;

class EZHalfParity {
    ExtendedMolecule mMol;
    int mCentralAxialAtom;
    int mRemoteAxialAtom;
    int mHighConn;
    int mLowConn;
    int mValue;
    boolean mStereoBondFound;
    boolean mRanksEqual;
    boolean mInSameFragment;

    protected EZHalfParity(ExtendedMolecule extendedMolecule, int[] nArray, int n, int n2) {
        this.mMol = extendedMolecule;
        this.mRemoteAxialAtom = n;
        this.mCentralAxialAtom = n2;
        int n3 = -1;
        for (int i = 0; i < this.mMol.getAllConnAtoms(this.mCentralAxialAtom); ++i) {
            int n4 = this.mMol.getConnAtom(this.mCentralAxialAtom, i);
            int n5 = this.mMol.getConnBond(this.mCentralAxialAtom, i);
            if (n4 == this.mRemoteAxialAtom) {
                if (this.mMol.getBondType(n5) != 386) continue;
                this.mValue = -1;
                continue;
            }
            if (this.mMol.isStereoBond(n5, this.mCentralAxialAtom)) {
                if (this.mStereoBondFound) {
                    extendedMolecule.setStereoProblem(n2);
                }
                this.mStereoBondFound = true;
            }
            if (n3 == nArray[n4]) {
                this.mLowConn = n4;
                this.mRanksEqual = true;
                this.mInSameFragment = this.mMol.isRingBond(n5);
                continue;
            }
            if (n3 < nArray[n4]) {
                n3 = nArray[n4];
                this.mLowConn = this.mHighConn;
                this.mHighConn = n4;
                continue;
            }
            this.mLowConn = n4;
        }
    }

    protected int getValue() {
        if (this.mValue != 0) {
            return this.mValue;
        }
        if (this.mStereoBondFound && this.mMol.getAtomicNo(this.mCentralAxialAtom) != 15 && this.mMol.getAtomicNo(this.mCentralAxialAtom) != 16) {
            for (int i = 0; i < this.mMol.getAllConnAtoms(this.mCentralAxialAtom); ++i) {
                int n = this.mMol.getConnBond(this.mCentralAxialAtom, i);
                if (!this.mMol.isStereoBond(n, this.mCentralAxialAtom)) continue;
                this.mValue = this.mMol.getConnAtom(this.mCentralAxialAtom, i) == this.mHighConn ? (this.mMol.getBondType(n) == 257 ? 3 : 1) : (this.mMol.getBondType(n) == 257 ? 1 : 3);
                return this.mValue;
            }
        }
        double d = this.mMol.getBondAngle(this.mCentralAxialAtom, this.mRemoteAxialAtom);
        double d2 = this.mMol.getBondAngle(this.mCentralAxialAtom, this.mHighConn);
        if (d2 < d) {
            d2 += Math.PI * 2;
        }
        if (this.mMol.getAllConnAtoms(this.mCentralAxialAtom) == 2) {
            double d3 = d2 - d;
            if (d3 > 3.0915926535897933 && d3 < 3.191592653589793) {
                this.mValue = -1;
                return this.mValue;
            }
            this.mValue = d3 < Math.PI ? 4 : 2;
            return this.mValue;
        }
        double d4 = this.mMol.getBondAngle(this.mCentralAxialAtom, this.mLowConn);
        if (d4 < d) {
            d4 += Math.PI * 2;
        }
        this.mValue = d4 < d2 ? 2 : 4;
        return this.mValue;
    }
}

