/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.calc.DataProcessor;
import java.util.Arrays;
import java.util.Comparator;

public class DiversitySelector
extends DataProcessor {
    private int mNoOfFeatures;
    private int mExistingSetCount;
    private long[][] mFeatureList;
    private boolean mAddingToExistingSet;
    private double[] mCentroidVector;

    public void initializeExistingSet(int n) {
        this.mFeatureList = new long[1][];
        this.mCentroidVector = new double[n];
        this.mExistingSetCount = 0;
    }

    public void addToExistingSet(long[] lArray) {
        this.mFeatureList[0] = lArray;
        DiversitySelectorRecord diversitySelectorRecord = new DiversitySelectorRecord(0);
        diversitySelectorRecord.addToCentroidVector();
        this.mAddingToExistingSet = true;
        ++this.mExistingSetCount;
    }

    public void setExistingSet(long[][] lArray) {
        this.mCentroidVector = new double[64 * lArray[0].length];
        this.mFeatureList = lArray;
        for (int i = 0; i < lArray.length; ++i) {
            DiversitySelectorRecord diversitySelectorRecord = new DiversitySelectorRecord(i);
            diversitySelectorRecord.addToCentroidVector();
        }
        this.mAddingToExistingSet = true;
        this.mExistingSetCount = lArray.length;
    }

    public int[] select(long[][] lArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5 = lArray.length;
        this.mNoOfFeatures = 64 * lArray[0].length;
        this.mFeatureList = lArray;
        if (n > n5) {
            n = n5;
        }
        this.startProgress("Creating Key Lists...", 0, n5);
        DiversitySelectorRecord[] diversitySelectorRecordArray = new DiversitySelectorRecord[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            diversitySelectorRecordArray[n4] = new DiversitySelectorRecord(n4);
            if ((n4 & 0xFF) != 255) continue;
            if (this.threadMustDie()) {
                this.stopProgress("Selection cancelled");
                return null;
            }
            this.updateProgress(n4);
        }
        this.startProgress("Locating Starting Compound...", 0, n5);
        if (!this.mAddingToExistingSet) {
            this.mCentroidVector = new double[this.mNoOfFeatures];
            for (n4 = 0; n4 < n5; ++n4) {
                diversitySelectorRecordArray[n4].addToCentroidVector();
                if ((n4 & 0xFF) != 255) continue;
                if (this.threadMustDie()) {
                    this.stopProgress("Selection cancelled");
                    return null;
                }
                this.updateProgress(n4 / 2);
            }
            double d = 0.0;
            n3 = 0;
            for (int i = 0; i < n5; ++i) {
                double d2 = 0.0;
                for (int j = 0; j < diversitySelectorRecordArray[i].mKeyList.length; ++j) {
                    int n6 = diversitySelectorRecordArray[i].mKeyList[j];
                    d2 += (this.mCentroidVector[n6] - diversitySelectorRecordArray[i].mWeight) * diversitySelectorRecordArray[i].mWeight;
                }
                if (d < d2) {
                    d = d2;
                    n3 = i;
                }
                if ((i & 0xFF) != 255) continue;
                if (this.threadMustDie()) {
                    this.stopProgress("Selection cancelled");
                    return null;
                }
                this.updateProgress((n5 + i) / 2);
            }
            DiversitySelectorRecord diversitySelectorRecord = diversitySelectorRecordArray[n3];
            diversitySelectorRecordArray[n3] = diversitySelectorRecordArray[0];
            diversitySelectorRecordArray[0] = diversitySelectorRecord;
            this.mCentroidVector = new double[this.mNoOfFeatures];
            diversitySelectorRecord.addToCentroidVector();
        }
        this.startProgress("Selecting Compounds...", 0, n);
        n4 = 0;
        int n7 = n2 = this.mAddingToExistingSet ? 0 : 1;
        while (n2 < n) {
            int n8 = 3;
            for (n3 = (int)(10.0 * (double)(this.mExistingSetCount + n5) / (double)(this.mExistingSetCount + n2)); n3 < n5 - n2 && (n4 & n8) == 0; n3 *= 4) {
                n8 = n8 << 2 | 3;
            }
            int n9 = n2 + n3;
            if (n9 > n5) {
                n9 = n5;
            }
            for (int i = n2; i < n9; ++i) {
                diversitySelectorRecordArray[i].calculateDotProduct();
            }
            Arrays.sort(diversitySelectorRecordArray, n2, n9, new DiversitySelectorComparator());
            diversitySelectorRecordArray[n2].addToCentroidVector();
            ++n4;
            if (this.threadMustDie()) {
                this.stopProgress("Selection cancelled");
                return null;
            }
            this.updateProgress(n2);
            ++n2;
        }
        int[] nArray = new int[n];
        for (n3 = 0; n3 < n; ++n3) {
            nArray[n3] = diversitySelectorRecordArray[n3].mCompoundIndex;
        }
        this.stopProgress("Compound Selection Done");
        return nArray;
    }

    class DiversitySelectorComparator<T>
    implements Comparator<T> {
        DiversitySelectorComparator() {
        }

        @Override
        public int compare(T t, T t2) {
            double d = ((DiversitySelectorRecord)t).mDotProduct;
            double d2 = ((DiversitySelectorRecord)t2).mDotProduct;
            return d < d2 ? -1 : (d == d2 ? 0 : 1);
        }
    }

    protected class DiversitySelectorRecord {
        private int mCompoundIndex;
        private int[] mKeyList;
        private double mWeight;
        public double mDotProduct;

        private DiversitySelectorRecord(int n) {
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < DiversitySelector.this.mNoOfFeatures; ++n2) {
                if ((DiversitySelector.this.mFeatureList[n][n2 / 64] & (long)(1 << 63 - n2 % 64)) == 0L) continue;
                ++n3;
            }
            this.mKeyList = new int[n3];
            n3 = 0;
            for (n2 = 0; n2 < DiversitySelector.this.mNoOfFeatures; ++n2) {
                if ((DiversitySelector.this.mFeatureList[n][n2 / 64] & (long)(1 << 63 - n2 % 64)) == 0L) continue;
                this.mKeyList[n3++] = n2;
            }
            this.mWeight = 1.0 / Math.sqrt(n3);
            this.mCompoundIndex = n;
        }

        private void addToCentroidVector() {
            for (int i = 0; i < this.mKeyList.length; ++i) {
                double[] dArray = DiversitySelector.this.mCentroidVector;
                int n = this.mKeyList[i];
                dArray[n] = dArray[n] + this.mWeight;
            }
        }

        private void calculateDotProduct() {
            this.mDotProduct = 0.0;
            for (int i = 0; i < this.mKeyList.length; ++i) {
                this.mDotProduct += this.mWeight * DiversitySelector.this.mCentroidVector[this.mKeyList[i]];
            }
        }
    }
}

