/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.AbstractDrawingObject;
import com.actelion.research.chem.Molecule;
import com.actelion.research.gui.generic.GenericPoint;
import com.actelion.research.gui.generic.GenericRectangle;

public class DepictorTransformation {
    private double mOffsetX;
    private double mOffsetY;
    private double mScaling;

    public DepictorTransformation() {
        this.clear();
    }

    public DepictorTransformation(DepictorTransformation depictorTransformation) {
        this.mScaling = depictorTransformation.mScaling;
        this.mOffsetX = depictorTransformation.mOffsetX;
        this.mOffsetY = depictorTransformation.mOffsetY;
    }

    public DepictorTransformation(double d, double d2, double d3) {
        this.mScaling = d;
        this.mOffsetX = d2;
        this.mOffsetY = d3;
    }

    public DepictorTransformation(GenericRectangle genericRectangle, GenericRectangle genericRectangle2, double d, int n) {
        this.clear();
        if (genericRectangle2 != null) {
            if ((n & 0x30000) == 0) {
                if (!genericRectangle2.contains(genericRectangle)) {
                    if (genericRectangle.width > genericRectangle2.width || genericRectangle.height > genericRectangle2.height) {
                        double d2 = genericRectangle2.width / genericRectangle.width;
                        double d3 = genericRectangle2.height / genericRectangle.height;
                        this.mScaling = Math.min(d2, d3);
                    }
                    if (genericRectangle.x * this.mScaling < genericRectangle2.x) {
                        this.mOffsetX = genericRectangle2.x - genericRectangle.x * this.mScaling;
                    } else if ((genericRectangle.x + genericRectangle.width) * this.mScaling > genericRectangle2.x + genericRectangle2.width) {
                        this.mOffsetX = genericRectangle2.x + genericRectangle2.width - (genericRectangle.x + genericRectangle.width) * this.mScaling;
                    }
                    if (genericRectangle.y * this.mScaling < genericRectangle2.y) {
                        this.mOffsetY = genericRectangle2.y - genericRectangle.y * this.mScaling;
                    } else if ((genericRectangle.y + genericRectangle.height) * this.mScaling > genericRectangle2.y + genericRectangle2.height) {
                        this.mOffsetY = genericRectangle2.y + genericRectangle2.height - (genericRectangle.y + genericRectangle.height) * this.mScaling;
                    }
                }
            } else {
                double d4 = genericRectangle2.width / genericRectangle.width;
                double d5 = genericRectangle2.height / genericRectangle.height;
                double d6 = n & 0xFFFF;
                if (d6 == 0.0) {
                    d6 = 24.0;
                } else if ((n & 0x20000) != 0) {
                    d6 /= 256.0;
                }
                double d7 = d6 / d;
                this.mScaling = Math.min(d7, Math.min(d4, d5));
                this.mOffsetX = genericRectangle2.x + genericRectangle2.width / 2.0 - this.mScaling * (genericRectangle.x + genericRectangle.width / 2.0);
                this.mOffsetY = genericRectangle2.y + genericRectangle2.height / 2.0 - this.mScaling * (genericRectangle.y + genericRectangle.height / 2.0);
            }
        } else if ((n & 0x10000) != 0) {
            double d8 = (n & 0xFFFF) != 0 ? (double)(n & 0xFFFF) : 24.0;
            this.mScaling = d8 / d;
        }
    }

    public void clear() {
        this.mOffsetX = 0.0;
        this.mOffsetY = 0.0;
        this.mScaling = 1.0;
    }

    public double transformX(double d) {
        return d * this.mScaling + this.mOffsetX;
    }

    public double transformY(double d) {
        return d * this.mScaling + this.mOffsetY;
    }

    public double getScaling() {
        return this.mScaling;
    }

    public double getOffsetX() {
        return this.mOffsetX;
    }

    public double getOffsetY() {
        return this.mOffsetY;
    }

    public void move(double d, double d2) {
        this.mOffsetX += d;
        this.mOffsetY += d2;
    }

    public void setScaling(double d) {
        this.mScaling = d;
    }

    public boolean isVoidTransformation() {
        return this.mScaling == 1.0 && this.mOffsetX == 0.0 && this.mOffsetY == 0.0;
    }

    public void applyTo(DepictorTransformation depictorTransformation) {
        depictorTransformation.mScaling *= this.mScaling;
        depictorTransformation.mOffsetX = depictorTransformation.mOffsetX * this.mScaling + this.mOffsetX;
        depictorTransformation.mOffsetY = depictorTransformation.mOffsetY * this.mScaling + this.mOffsetY;
    }

    public void applyTo(GenericPoint genericPoint) {
        genericPoint.x = genericPoint.x * this.mScaling + this.mOffsetX;
        genericPoint.y = genericPoint.y * this.mScaling + this.mOffsetY;
    }

    public void applyTo(GenericRectangle genericRectangle) {
        genericRectangle.x = genericRectangle.x * this.mScaling + this.mOffsetX;
        genericRectangle.y = genericRectangle.y * this.mScaling + this.mOffsetY;
        genericRectangle.width *= this.mScaling;
        genericRectangle.height *= this.mScaling;
    }

    public void applyTo(Molecule molecule) {
        molecule.scaleCoords(this.mScaling);
        molecule.translateCoords(this.mOffsetX, this.mOffsetY);
    }

    public void applyTo(AbstractDrawingObject abstractDrawingObject) {
        abstractDrawingObject.scale(this.mScaling);
        abstractDrawingObject.move(this.mOffsetX, this.mOffsetY);
    }

    public DepictorTransformation getInverseTransformation() {
        DepictorTransformation depictorTransformation = new DepictorTransformation();
        depictorTransformation.mScaling = 1.0 / this.mScaling;
        depictorTransformation.mOffsetX = -this.mOffsetX / this.mScaling;
        depictorTransformation.mOffsetY = -this.mOffsetY / this.mScaling;
        return depictorTransformation;
    }

    public String toString() {
        return "DepictorTransformation Offset: " + this.mOffsetX + "," + this.mOffsetY + " Scaling: " + this.mScaling;
    }
}

