/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.gui.generic.GenericRectangle;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;

public class ChemistryHelper {
    public static final int REACTION_TYPE_NOMOLS = 0;
    public static final int REACTION_TYPE_NOPRODUCTS = 1;
    public static final int REACTION_TYPE_REACTANTS = 2;
    public static final int REACTION_TYPE_NORMAL = 3;

    private ChemistryHelper() {
    }

    public static int getReactionType(Reaction reaction) {
        int n = reaction.getMolecules();
        int n2 = reaction.getReactants();
        int n3 = reaction.getProducts();
        if (n == 0) {
            return 0;
        }
        if (n2 == 0) {
            return 2;
        }
        if (n3 == 0) {
            return 1;
        }
        return 3;
    }

    public static GenericRectangle getBoundingRect(Reaction reaction, boolean bl) {
        GenericRectangle genericRectangle = null;
        if (reaction == null) {
            return null;
        }
        int n = reaction.getReactants();
        int n2 = reaction.getProducts();
        int n3 = reaction.getMolecules();
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n3; ++i) {
            StereoMolecule stereoMolecule = reaction.getMolecule(i);
            int n4 = stereoMolecule.getAllBonds();
            GenericRectangle genericRectangle2 = ChemistryHelper.getBoundingRect(stereoMolecule);
            if (genericRectangle == null) {
                if (genericRectangle2 == null || n4 <= 0) continue;
                genericRectangle = genericRectangle2;
                d += genericRectangle2.getWidth();
                continue;
            }
            if (genericRectangle2 == null || n4 <= 0) continue;
            genericRectangle = genericRectangle.union(genericRectangle2);
            d += genericRectangle2.getWidth();
        }
        if (bl && n == 0 && n3 > 0) {
            d2 = d / (double)n3;
            genericRectangle = new GenericRectangle(genericRectangle.getX() - d2, genericRectangle.getY(), genericRectangle.getWidth() + d2, genericRectangle.getHeight());
        } else if (bl && n2 == 0 && n3 > 0) {
            d2 = d / (double)n3;
            genericRectangle = new GenericRectangle(genericRectangle.getX(), genericRectangle.getY(), genericRectangle.getWidth() + d2, genericRectangle.getHeight());
        }
        return genericRectangle;
    }

    public static GenericRectangle getBoundingRect(ExtendedMolecule extendedMolecule) {
        double d = Double.MIN_VALUE;
        double d2 = Double.MIN_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MAX_VALUE;
        if (extendedMolecule == null) {
            return null;
        }
        int n = extendedMolecule.getAllAtoms();
        double d5 = 0.0;
        d5 = extendedMolecule.getAverageBondLength();
        for (int i = 0; i < n; ++i) {
            d = Math.max(d, extendedMolecule.getAtomX(i));
            d3 = Math.min(d3, extendedMolecule.getAtomX(i));
            d2 = Math.max(d2, extendedMolecule.getAtomY(i));
            d4 = Math.min(d4, extendedMolecule.getAtomY(i));
        }
        return n > 0 ? new GenericRectangle(d3, d4, Math.max(d - d3, d5), Math.max(d2 - d4, d5)) : null;
    }

    public static double getAverageBondLength(Reaction reaction) {
        int n = reaction.getMolecules();
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            StereoMolecule stereoMolecule = reaction.getMolecule(i);
            if (stereoMolecule.getAllAtoms() <= 1) continue;
            d2 += stereoMolecule.getAverageBondLength();
        }
        if (n > 0) {
            return d2 / (double)n;
        }
        return 0.0;
    }

    public static void setAverageBondLength(Reaction reaction, double d) {
        double d2 = 0.0;
        int n = reaction.getMolecules();
        for (int i = 0; i < n; ++i) {
            StereoMolecule stereoMolecule = reaction.getMolecule(i);
            d2 = stereoMolecule.getAverageBondLength();
            double d3 = d / d2;
            ChemistryHelper.transformMolecule(stereoMolecule, 0.0, 0.0, d3);
        }
    }

    public static GenericRectangle getReactantsBoundingRect(Reaction reaction) {
        if (reaction == null) {
            throw new NullPointerException("Cannot pass null reaction");
        }
        int n = reaction.getReactants();
        GenericRectangle genericRectangle = null;
        for (int i = 0; i < n; ++i) {
            GenericRectangle genericRectangle2 = ChemistryHelper.getBoundingRect(reaction.getReactant(i));
            if (genericRectangle != null && genericRectangle2 != null) {
                GenericRectangle genericRectangle3 = genericRectangle.union(genericRectangle2);
                genericRectangle = new GenericRectangle(genericRectangle3.getX(), genericRectangle3.getY(), genericRectangle3.getWidth(), genericRectangle3.getHeight());
                continue;
            }
            genericRectangle = genericRectangle2;
        }
        return genericRectangle;
    }

    public static GenericRectangle getArrowBoundingRect(Reaction reaction) {
        GenericRectangle genericRectangle = ChemistryHelper.getReactantsBoundingRect(reaction);
        GenericRectangle genericRectangle2 = ChemistryHelper.getProductsBoundingRect(reaction);
        if (genericRectangle != null && genericRectangle2 != null) {
            GenericRectangle genericRectangle3 = genericRectangle.union(genericRectangle2);
            double d = genericRectangle3.getHeight() / 2.0 + genericRectangle3.getY();
            double d2 = genericRectangle.x + genericRectangle.width;
            double d3 = genericRectangle2.x;
            return new GenericRectangle(d2 < d3 ? d2 : d3, d, Math.abs(d3 - d2), 0.0);
        }
        if (genericRectangle != null) {
            double d = genericRectangle.getHeight() / 2.0 + genericRectangle.getY();
            double d4 = genericRectangle.x + genericRectangle.width;
            double d5 = genericRectangle.getWidth();
            return new GenericRectangle(d4, d, d5, 0.0);
        }
        if (genericRectangle2 != null) {
            double d = genericRectangle2.getHeight() / 2.0 + genericRectangle2.getY();
            double d6 = 0.0;
            double d7 = genericRectangle2.x;
            return new GenericRectangle(d7, d, d6, 0.0);
        }
        return new GenericRectangle(0.0, 0.0, 0.0, 0.0);
    }

    public static GenericRectangle getDiffRect(GenericRectangle genericRectangle, GenericRectangle genericRectangle2) {
        if (genericRectangle != null && genericRectangle2 != null) {
            GenericRectangle genericRectangle3 = genericRectangle.union(genericRectangle2);
            double d = genericRectangle3.y;
            double d2 = genericRectangle.x + genericRectangle.width;
            double d3 = genericRectangle2.x;
            double d4 = genericRectangle3.y;
            double d5 = genericRectangle3.y + genericRectangle3.height;
            GenericRectangle genericRectangle4 = new GenericRectangle(d2 < d3 ? d2 : d3, d4 < d5 ? d4 : d5, Math.abs(d3 - d2), Math.abs(d5 - d4));
            return genericRectangle4;
        }
        return null;
    }

    private static GenericRectangle scaleTo(GenericRectangle genericRectangle, double d, double d2) {
        double d3 = (genericRectangle.getWidth() - d) / 2.0 + genericRectangle.getX();
        double d4 = (genericRectangle.getHeight() - d2) / 2.0 + genericRectangle.getY();
        return new GenericRectangle(d3, d4, d, d2);
    }

    public static GenericRectangle getProductsBoundingRect(Reaction reaction) {
        if (reaction == null) {
            throw new NullPointerException("Cannot pass null reaction");
        }
        int n = reaction.getProducts();
        GenericRectangle genericRectangle = null;
        for (int i = 0; i < n; ++i) {
            GenericRectangle genericRectangle2 = ChemistryHelper.getBoundingRect(reaction.getProduct(i));
            genericRectangle = genericRectangle != null && genericRectangle2 != null ? genericRectangle.union(genericRectangle2) : genericRectangle2;
        }
        return genericRectangle;
    }

    public static void transformReaction(Reaction reaction, double d, double d2, double d3) {
        int n = reaction.getMolecules();
        for (int i = 0; i < n; ++i) {
            ChemistryHelper.transformMolecule(reaction.getMolecule(i), d, d2, d3);
        }
    }

    public static void transformMolecules(Molecule[] moleculeArray, double d, double d2, double d3) {
        if (moleculeArray != null) {
            for (Molecule molecule : moleculeArray) {
                ChemistryHelper.transformMolecule(molecule, d, d2, d3);
            }
        }
    }

    public static void transformMolecule(Molecule molecule, double d, double d2, double d3) {
        int n = molecule.getAllAtoms();
        for (int i = 0; i < n; ++i) {
            molecule.setAtomX(i, (molecule.getAtomX(i) + d) * d3);
            molecule.setAtomY(i, (molecule.getAtomY(i) + d2) * d3);
        }
    }

    public static void scaleIntoF(Reaction reaction, double d, double d2, double d3, double d4, double d5) {
        GenericRectangle genericRectangle = ChemistryHelper.getBoundingRect(reaction, true);
        if (genericRectangle != null) {
            double d6 = -genericRectangle.x;
            double d7 = -genericRectangle.y;
            ChemistryHelper.transformReaction(reaction, d6, d7, 1.0);
            genericRectangle = ChemistryHelper.getBoundingRect(reaction, true);
            double d8 = genericRectangle.getWidth();
            double d9 = genericRectangle.getHeight();
            double d10 = d3 / d8;
            double d11 = d4 / d9;
            double d12 = d10;
            if (d10 > d11) {
                d12 = d11;
            }
            ChemistryHelper.transformReaction(reaction, 0.0, 0.0, d10);
        }
    }

    public static void scaleInto(Reaction reaction, double d, double d2, double d3, double d4, double d5) {
        if (d3 > d5 * 2.0) {
            Molecule[] moleculeArray = ChemistryHelper.getReactants(reaction);
            Molecule[] moleculeArray2 = ChemistryHelper.getProducts(reaction);
            double d6 = 0.0;
            double d7 = 0.0;
            int n = reaction.getMolecules();
            for (int i = 0; i < n; ++i) {
                GenericRectangle genericRectangle;
                StereoMolecule stereoMolecule = reaction.getMolecule(i);
                if (stereoMolecule.getAllAtoms() <= 1 || (genericRectangle = ChemistryHelper.getBoundingRect(stereoMolecule)) == null) continue;
                d7 += genericRectangle.getHeight();
                d6 += genericRectangle.getWidth();
            }
            if (d7 == 0.0 || d6 == 0.0) {
                return;
            }
            double d8 = d3 / d6;
            double d9 = d4 / d7;
            double d10 = d8;
            if (d8 > d9) {
                d10 = d9;
            }
            double d11 = ChemistryHelper.getAverageBondLength(reaction);
            double d12 = (d3 - d5) / 2.0;
            double d13 = d4;
            d10 = Math.min(24.0 / d11, d10);
            GenericRectangle genericRectangle = ChemistryHelper.getBoundingRect((ExtendedMolecule[])moleculeArray);
            ChemistryHelper.transformMolecules(moleculeArray, 0.0, 0.0, d10);
            genericRectangle = ChemistryHelper.getBoundingRect((ExtendedMolecule[])moleculeArray);
            double d14 = d - genericRectangle.x + (d12 - genericRectangle.getWidth()) / 2.0;
            double d15 = d2 - genericRectangle.y + (d13 - genericRectangle.getHeight()) / 2.0;
            ChemistryHelper.transformMolecules(moleculeArray, d14, d15, 1.0);
            genericRectangle = ChemistryHelper.getBoundingRect((ExtendedMolecule[])moleculeArray2);
            ChemistryHelper.transformMolecules(moleculeArray2, 0.0, 0.0, d10);
            genericRectangle = ChemistryHelper.getBoundingRect((ExtendedMolecule[])moleculeArray2);
            d14 = d + d12 + d5 - genericRectangle.x + (d12 - genericRectangle.getWidth()) / 2.0;
            d15 = d2 - genericRectangle.y + (d13 - genericRectangle.getHeight()) / 2.0;
            ChemistryHelper.transformMolecules(moleculeArray2, d14, d15, 1.0);
        }
    }

    public static void scaleIntoOld(Reaction reaction, double d, double d2, double d3, double d4, double d5) {
        if (d3 > d5 * 2.0) {
            Molecule[] moleculeArray = ChemistryHelper.getReactants(reaction);
            Molecule[] moleculeArray2 = ChemistryHelper.getProducts(reaction);
            GenericRectangle genericRectangle = ChemistryHelper.getBoundingRect((ExtendedMolecule[])moleculeArray);
            GenericRectangle genericRectangle2 = ChemistryHelper.getBoundingRect((ExtendedMolecule[])moleculeArray2);
            System.out.printf("Reactants bounds %s %s %s\n", d3, genericRectangle.getWidth(), moleculeArray.length);
            System.out.printf("Product bounds %s %s\n", d4, genericRectangle2.getHeight());
            double d6 = (d3 - d5) / 2.0;
            double d7 = d4;
            double d8 = d6 / Math.max(genericRectangle.getWidth(), genericRectangle2.getWidth());
            double d9 = d7 / Math.max(genericRectangle.getHeight(), genericRectangle2.getHeight());
            System.out.printf("Scaling %f vs %f\n", d8, d9);
            double d10 = d8 < d9 ? d6 / (double)Math.max((float)genericRectangle.getWidth(), (float)genericRectangle2.getWidth()) : d7 / (double)Math.max((float)genericRectangle.getHeight(), (float)genericRectangle2.getHeight());
            double d11 = ChemistryHelper.getAverageBondLength(reaction);
            d10 = Math.min(24.0 / d11, d10);
            ChemistryHelper.transformMolecules(moleculeArray, 0.0, 0.0, d10);
            genericRectangle = ChemistryHelper.getBoundingRect((ExtendedMolecule[])moleculeArray);
            double d12 = d - genericRectangle.x + (d6 - genericRectangle.getWidth()) / 2.0;
            double d13 = d2 - genericRectangle.y + (d7 - genericRectangle.getHeight()) / 2.0;
            ChemistryHelper.transformMolecules(moleculeArray, d12, d13, 1.0);
            ChemistryHelper.transformMolecules(moleculeArray2, 0.0, 0.0, d10);
            genericRectangle2 = ChemistryHelper.getBoundingRect((ExtendedMolecule[])moleculeArray2);
            d12 = d + d6 + d5 - genericRectangle2.x + (d6 - genericRectangle2.getWidth()) / 2.0;
            d13 = d2 - genericRectangle2.y + (d7 - genericRectangle2.getHeight()) / 2.0;
            ChemistryHelper.transformMolecules(moleculeArray2, d12, d13, 1.0);
        }
    }

    public static ExtendedMolecule[] getReactants(Reaction reaction) {
        ExtendedMolecule[] extendedMoleculeArray = new ExtendedMolecule[reaction.getReactants()];
        for (int i = 0; i < extendedMoleculeArray.length; ++i) {
            extendedMoleculeArray[i] = reaction.getReactant(i);
        }
        return extendedMoleculeArray;
    }

    public static ExtendedMolecule[] getProducts(Reaction reaction) {
        ExtendedMolecule[] extendedMoleculeArray = new ExtendedMolecule[reaction.getProducts()];
        for (int i = 0; i < extendedMoleculeArray.length; ++i) {
            extendedMoleculeArray[i] = reaction.getProduct(i);
        }
        return extendedMoleculeArray;
    }

    public static GenericRectangle getBoundingRect(ExtendedMolecule[] extendedMoleculeArray) {
        if (extendedMoleculeArray == null || extendedMoleculeArray.length == 0) {
            return new GenericRectangle(0.0, 0.0, 0.0, 0.0);
        }
        GenericRectangle genericRectangle = ChemistryHelper.getBoundingRect(extendedMoleculeArray[0]);
        for (int i = 1; i < extendedMoleculeArray.length; ++i) {
            GenericRectangle genericRectangle2 = ChemistryHelper.getBoundingRect(extendedMoleculeArray[i]);
            if (genericRectangle2 == null) continue;
            genericRectangle = genericRectangle == null ? genericRectangle2 : genericRectangle.union(ChemistryHelper.getBoundingRect(extendedMoleculeArray[i]));
        }
        if (genericRectangle == null) {
            genericRectangle = new GenericRectangle(0.0, 0.0, 0.0, 0.0);
        }
        return genericRectangle;
    }

    public static void arrangeReaction(Reaction reaction, Dimension dimension) {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        if (reaction != null && (n = reaction.getMolecules()) > 0) {
            double d3 = ChemistryHelper.getAverageBondLength(reaction);
            ChemistryHelper.setAverageBondLength(reaction, d3);
            for (int i = 0; i < n; ++i) {
                StereoMolecule stereoMolecule = reaction.getMolecule(i);
                GenericRectangle genericRectangle = ChemistryHelper.getBoundingRect(stereoMolecule);
                if (genericRectangle == null) continue;
                d += genericRectangle.width;
                d2 += genericRectangle.height;
            }
            GenericRectangle genericRectangle = ChemistryHelper.getArrowBoundingRect(reaction);
            int n2 = Math.max(0, n - 2);
            double d4 = dimension.width / (n + n2 + 1) / 2;
            double d5 = d / (double)n;
            d = d + (double)n2 * d5 / 2.0 + genericRectangle.getWidth();
            d += d / (double)n;
            double d6 = d2 / (double)n;
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, dimension.width, dimension.height);
            double d7 = double_.width / d;
            double d8 = double_.height / d6;
            double d9 = Math.min(d7, d8);
            double d10 = 0.0;
            for (int i = 0; i < n; ++i) {
                StereoMolecule stereoMolecule = reaction.getMolecule(i);
                ChemistryHelper.transformMolecule(stereoMolecule, 0.0, 0.0, d9);
                GenericRectangle genericRectangle2 = ChemistryHelper.getBoundingRect(stereoMolecule);
                if (genericRectangle2 == null || double_ == null) continue;
                double d11 = (double_.height - genericRectangle2.height) / 2.0;
                double d12 = -genericRectangle2.x + d10;
                double d13 = -genericRectangle2.y + d11;
                ChemistryHelper.transformMolecule(stereoMolecule, d12, d13, 1.0);
                GenericRectangle genericRectangle3 = ChemistryHelper.getBoundingRect(stereoMolecule);
                if (i == reaction.getReactants() - 1) {
                    d10 += genericRectangle3.width + d4 * 2.0;
                    continue;
                }
                d10 += genericRectangle3.width + d4;
            }
        }
    }
}

