/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.MoleculeNeutralizer;
import com.actelion.research.chem.SimpleCanonizer;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.TautomerHelper;

public class CanonizerUtil {
    public static String getIDCode(StereoMolecule stereoMolecule, IDCODE_TYPE iDCODE_TYPE, boolean bl) {
        switch (iDCODE_TYPE) {
            case NORMAL: {
                return CanonizerUtil.getIDCode(stereoMolecule, bl);
            }
            case NOSTEREO: {
                return CanonizerUtil.getIDCodeNoStereo(stereoMolecule, bl);
            }
            case BACKBONE: {
                return CanonizerUtil.getIDCodeBackBone(stereoMolecule, bl);
            }
            case TAUTOMER: {
                return CanonizerUtil.getIDCodeTautomer(stereoMolecule, bl);
            }
            case NOSTEREO_TAUTOMER: {
                return CanonizerUtil.getIDCodeNoStereoTautomer(stereoMolecule, bl);
            }
        }
        return null;
    }

    public static long getHash(StereoMolecule stereoMolecule, IDCODE_TYPE iDCODE_TYPE, boolean bl) {
        String string = CanonizerUtil.getIDCode(stereoMolecule, iDCODE_TYPE, bl);
        return string != null ? StrongHasher.hash(string) : 0L;
    }

    public static long getNoStereoHash(StereoMolecule stereoMolecule, boolean bl) {
        String string = CanonizerUtil.getIDCodeNoStereo(stereoMolecule, bl);
        return string != null ? StrongHasher.hash(string) : 0L;
    }

    public static long getTautomerHash(StereoMolecule stereoMolecule, boolean bl) {
        String string = CanonizerUtil.getIDCodeTautomer(stereoMolecule, bl);
        return string != null ? StrongHasher.hash(string) : 0L;
    }

    public static long getNoStereoTautomerHash(StereoMolecule stereoMolecule, boolean bl) {
        String string = CanonizerUtil.getIDCodeNoStereoTautomer(stereoMolecule, bl);
        return string != null ? StrongHasher.hash(string) : 0L;
    }

    public static long getBackboneHash(StereoMolecule stereoMolecule, boolean bl) {
        String string = CanonizerUtil.getIDCodeBackBone(stereoMolecule, bl);
        return string != null ? StrongHasher.hash(string) : 0L;
    }

    private static String getIDCode(StereoMolecule stereoMolecule, boolean bl) {
        try {
            if (!bl) {
                return new Canonizer(stereoMolecule).getIDCode();
            }
            stereoMolecule = stereoMolecule.getCompactCopy();
            stereoMolecule.stripSmallFragments(true);
            MoleculeNeutralizer.neutralizeChargedMolecule(stereoMolecule);
            return new Canonizer(stereoMolecule).getIDCode();
        }
        catch (Throwable throwable) {
            System.err.println("WARN: getIDCode() " + throwable);
            return null;
        }
    }

    private static String getIDCodeNoStereo(StereoMolecule stereoMolecule, boolean bl) {
        try {
            stereoMolecule = stereoMolecule.getCompactCopy();
            if (bl) {
                stereoMolecule.stripSmallFragments(true);
                MoleculeNeutralizer.neutralizeChargedMolecule(stereoMolecule);
            }
            stereoMolecule.stripStereoInformation();
            return new SimpleCanonizer(stereoMolecule).getIDCode();
        }
        catch (Throwable throwable) {
            System.err.println("WARN: getIDCodeNoStereo() " + throwable);
            return null;
        }
    }

    private static String getIDCodeTautomer(StereoMolecule stereoMolecule, boolean bl) {
        try {
            if (bl) {
                stereoMolecule = stereoMolecule.getCompactCopy();
                stereoMolecule.stripSmallFragments(true);
                MoleculeNeutralizer.neutralizeChargedMolecule(stereoMolecule);
            }
            StereoMolecule stereoMolecule2 = new TautomerHelper(stereoMolecule).createGenericTautomer();
            return new Canonizer(stereoMolecule2, 8).getIDCode();
        }
        catch (Throwable throwable) {
            System.err.println("WARN: getIDCodeTautomer() " + throwable);
            return null;
        }
    }

    private static String getIDCodeNoStereoTautomer(StereoMolecule stereoMolecule, boolean bl) {
        try {
            stereoMolecule = stereoMolecule.getCompactCopy();
            if (bl) {
                stereoMolecule.stripSmallFragments(true);
                MoleculeNeutralizer.neutralizeChargedMolecule(stereoMolecule);
            }
            stereoMolecule.stripStereoInformation();
            StereoMolecule stereoMolecule2 = new TautomerHelper(stereoMolecule).createGenericTautomer();
            return new Canonizer(stereoMolecule2, 8).getIDCode();
        }
        catch (Throwable throwable) {
            System.err.println("WARN: getIDCodeNoStereoTautomer() " + throwable);
            return null;
        }
    }

    private static String getIDCodeBackBone(StereoMolecule stereoMolecule, boolean bl) {
        try {
            stereoMolecule = stereoMolecule.getCompactCopy();
            if (bl) {
                stereoMolecule.stripSmallFragments(true);
                MoleculeNeutralizer.neutralizeChargedMolecule(stereoMolecule);
            }
            stereoMolecule.stripStereoInformation();
            int n = stereoMolecule.getAllBonds();
            for (int i = 0; i < n; ++i) {
                stereoMolecule.setBondType(i, 1);
            }
            return new SimpleCanonizer(stereoMolecule).getIDCode();
        }
        catch (Throwable throwable) {
            System.err.println("WARN: getIDCodeBackBone() " + throwable);
            return null;
        }
    }

    public static class StrongHasher {
        private static final long[] byteTable = new long[256];
        private static final long HSTART = -4953706369002393500L;
        private static final long HMULT = 7664345821815920749L;

        public static long hash(String string) {
            if (string == null) {
                return 1L;
            }
            long l = -4953706369002393500L;
            long[] lArray = byteTable;
            for (int i = string.length() - 1; i >= 0; --i) {
                char c = string.charAt(i);
                l = l * 7664345821815920749L ^ lArray[c & 0xFF];
                l = l * 7664345821815920749L ^ lArray[c >>> 8 & 0xFF];
            }
            return l;
        }

        static {
            long l = 6074001001750140548L;
            for (int i = 0; i < 256; ++i) {
                for (int j = 0; j < 31; ++j) {
                    l = l >>> 7 ^ l;
                    l = l << 11 ^ l;
                    l = l >>> 10 ^ l;
                }
                StrongHasher.byteTable[i] = l;
            }
        }
    }

    public static enum IDCODE_TYPE {
        NORMAL,
        NOSTEREO,
        BACKBONE,
        TAUTOMER,
        NOSTEREO_TAUTOMER;

    }
}

