/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import java.util.Arrays;

public class CanonizerBaseValue
implements Comparable<CanonizerBaseValue> {
    public long[] mValue;
    private int mAtom;
    private int mIndex;
    private int mAvailableBits;

    public CanonizerBaseValue(int n) {
        this.mValue = new long[n];
    }

    public void init(int n) {
        this.mAtom = n;
        this.mIndex = 0;
        this.mAvailableBits = 63;
        Arrays.fill(this.mValue, 0L);
    }

    public void add(long l) {
        int n = this.mIndex;
        this.mValue[n] = this.mValue[n] + l;
    }

    public void add(int n, long l) {
        if (this.mAvailableBits == 0) {
            ++this.mIndex;
            this.mAvailableBits = 63;
        }
        if (this.mAvailableBits == 63) {
            int n2 = this.mIndex;
            this.mValue[n2] = this.mValue[n2] | l;
            this.mAvailableBits -= n;
        } else if (this.mAvailableBits >= n) {
            int n3 = this.mIndex;
            this.mValue[n3] = this.mValue[n3] << n;
            int n4 = this.mIndex;
            this.mValue[n4] = this.mValue[n4] | l;
            this.mAvailableBits -= n;
        } else {
            int n5 = this.mIndex;
            this.mValue[n5] = this.mValue[n5] << this.mAvailableBits;
            int n6 = this.mIndex++;
            this.mValue[n6] = this.mValue[n6] | l >> n - this.mAvailableBits;
            this.mAvailableBits = 63 - (n -= this.mAvailableBits);
            int n7 = this.mIndex;
            this.mValue[n7] = this.mValue[n7] | l & (long)((1 << n) - 1);
        }
    }

    public int getAtom() {
        return this.mAtom;
    }

    @Override
    public int compareTo(CanonizerBaseValue canonizerBaseValue) {
        assert (this.mIndex == canonizerBaseValue.mIndex);
        for (int i = 0; i < this.mIndex; ++i) {
            if (this.mValue[i] == canonizerBaseValue.mValue[i]) continue;
            return this.mValue[i] < canonizerBaseValue.mValue[i] ? -1 : 1;
        }
        return this.mValue[this.mIndex] == canonizerBaseValue.mValue[this.mIndex] ? 0 : (this.mValue[this.mIndex] < canonizerBaseValue.mValue[this.mIndex] ? -1 : 1);
    }
}

