/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.RingCollection;

public class AromaticityResolver {
    ExtendedMolecule mMol;
    private boolean mAllHydrogensAreExplicit;
    private boolean[] mIsDelocalizedAtom;
    private boolean[] mIsDelocalizedBond;
    private int mAromaticAtoms;
    private int mAromaticBonds;
    private int mPiElectronsAdded;

    public AromaticityResolver(ExtendedMolecule extendedMolecule) {
        this.mMol = extendedMolecule;
    }

    public boolean locateDelocalizedDoubleBonds(boolean[] blArray) {
        return this.locateDelocalizedDoubleBonds(blArray, false, false);
    }

    public boolean locateDelocalizedDoubleBonds(boolean[] blArray, boolean bl, boolean bl2) {
        int n;
        int n2;
        this.mMol.ensureHelperArrays(1);
        if (blArray != null) {
            this.mIsDelocalizedBond = blArray;
        } else {
            this.mIsDelocalizedBond = new boolean[this.mMol.getBonds()];
            for (n2 = 0; n2 < this.mMol.getBonds(); ++n2) {
                if (this.mMol.getBondType(n2) != 64) continue;
                this.mIsDelocalizedBond[n2] = true;
                this.mMol.setBondType(n2, 1);
            }
        }
        this.mPiElectronsAdded = 0;
        this.mIsDelocalizedAtom = new boolean[this.mMol.getAtoms()];
        for (n2 = 0; n2 < this.mMol.getBonds(); ++n2) {
            if (!this.mIsDelocalizedBond[n2]) continue;
            ++this.mAromaticBonds;
            for (n = 0; n < 2; ++n) {
                if (this.mIsDelocalizedAtom[this.mMol.getBondAtom(n, n2)]) continue;
                this.mIsDelocalizedAtom[this.mMol.getBondAtom((int)n, (int)n2)] = true;
                ++this.mAromaticAtoms;
            }
        }
        if (this.mAromaticBonds == 0) {
            return true;
        }
        this.mAllHydrogensAreExplicit = bl2;
        this.protectFullValenceAtoms(bl);
        if (this.mMol.isFragment()) {
            this.promoteDelocalizedChains();
        }
        RingCollection ringCollection = new RingCollection(this.mMol, 1);
        if (bl) {
            this.addObviousAtomCharges(ringCollection);
        }
        this.protectObviousDelocalizationLeaks(ringCollection);
        this.protectAmideBonds(ringCollection);
        this.protectDoubleBondAtoms();
        this.promoteObviousBonds();
        while (this.promoteOuterShellDelocalizedRingSystems(ringCollection)) {
            this.promoteObviousBonds();
        }
        block4: while (this.mAromaticBonds != 0) {
            int n3;
            n = 0;
            if (n == 0) {
                for (n3 = 0; n3 < ringCollection.getSize(); ++n3) {
                    int n4;
                    if (ringCollection.getRingSize(n3) != 6) continue;
                    boolean bl3 = true;
                    int[] nArray = ringCollection.getRingBonds(n3);
                    for (n4 = 0; n4 < 6; ++n4) {
                        if (this.mIsDelocalizedBond[nArray[n4]]) continue;
                        bl3 = false;
                        break;
                    }
                    if (!bl3) continue;
                    for (n4 = 0; n4 < 6; n4 += 2) {
                        this.promoteBond(nArray[n4]);
                    }
                    n = 1;
                    break;
                }
            }
            if (n != 0) continue;
            for (n3 = 0; n3 < this.mMol.getBonds(); ++n3) {
                if (!this.mIsDelocalizedBond[n3]) continue;
                this.promoteBond(n3);
                this.promoteObviousBonds();
                n = 1;
                continue block4;
            }
        }
        return this.mAromaticAtoms == this.mPiElectronsAdded;
    }

    private void protectObviousDelocalizationLeaks(RingCollection ringCollection) {
        int n;
        int n2;
        for (n2 = 0; n2 < ringCollection.getSize(); ++n2) {
            int n3 = ringCollection.getRingSize(n2);
            if (n3 != 3 && n3 != 5 && n3 != 7) continue;
            int[] nArray = ringCollection.getRingAtoms(n2);
            for (int i = 0; i < n3; ++i) {
                n = nArray[i];
                if (!this.isAromaticAtom(n)) continue;
                if (n3 == 5) {
                    if (!(this.mMol.getAtomicNo(n) == 6 && this.mMol.getAtomCharge(n) == -1 && this.mMol.getAllConnAtoms(n) == 3 || this.mMol.getAtomicNo(n) == 7 && this.mMol.getAtomCharge(n) == 0 && this.mMol.getAllConnAtoms(n) == 3 || this.mMol.getAtomicNo(n) == 8 && this.mMol.getAtomCharge(n) == 0 && this.mMol.getConnAtoms(n) == 2 || this.mMol.getAtomicNo(n) == 16 && this.mMol.getAtomCharge(n) == 0 && this.mMol.getConnAtoms(n) == 2) && (this.mMol.getAtomicNo(n) != 34 || this.mMol.getAtomCharge(n) != 0 || this.mMol.getConnAtoms(n) != 2)) continue;
                    this.protectAtom(n);
                    continue;
                }
                if ((this.mMol.getAtomicNo(n) != 5 || this.mMol.getAtomCharge(n) != 0 || this.mMol.getAllConnAtoms(n) != 3) && (this.mMol.getAtomicNo(n) != 6 || this.mMol.getAtomCharge(n) != 1)) continue;
                this.protectAtom(n);
            }
        }
        for (n2 = 0; n2 < ringCollection.getSize(); ++n2) {
            if (ringCollection.getRingSize(n2) != 5) continue;
            int[] nArray = ringCollection.getRingBonds(n2);
            boolean bl = true;
            for (int i = 0; i < nArray.length; ++i) {
                if (this.mIsDelocalizedBond[nArray[i]]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            int[] nArray2 = ringCollection.getRingAtoms(n2);
            n = 0;
            int n4 = -1;
            for (int i = 0; i < nArray.length; ++i) {
                int n5;
                if (this.mMol.getAtomCharge(nArray2[i]) != -1 || this.mMol.getAtomicNo(nArray2[i]) != 6) continue;
                int n6 = this.mMol.getAllConnAtoms(nArray2[i]) == 3 ? 3 : (n5 = this.mMol.getAllConnAtomsPlusMetalBonds(nArray2[i]) == 3 ? 2 : 1);
                if (n >= n5) continue;
                n = n5;
                n4 = nArray2[i];
            }
            if (n4 == -1) continue;
            this.protectAtom(n4);
        }
    }

    private boolean promoteOuterShellDelocalizedRingSystems(RingCollection ringCollection) {
        int n;
        int n2;
        int n3;
        int[] nArray = new int[this.mMol.getBonds()];
        for (n3 = 0; n3 < ringCollection.getSize(); ++n3) {
            int[] nArray2 = ringCollection.getRingBonds(n3);
            n2 = 1;
            for (n = 0; n < nArray2.length; ++n) {
                if (this.mIsDelocalizedBond[nArray2[n]]) continue;
                n2 = 0;
                break;
            }
            if (n2 == 0) continue;
            for (n = 0; n < nArray2.length; ++n) {
                int n4 = nArray2[n];
                nArray[n4] = nArray[n4] + 1;
            }
        }
        n3 = this.mAromaticBonds;
        for (int i = 0; i < this.mMol.getBonds(); ++i) {
            if (nArray[i] != 1) continue;
            block4: for (n2 = 0; n2 < 2 && this.mIsDelocalizedBond[i]; ++n2) {
                int n5;
                n = this.mMol.getBondAtom(n2, i);
                int n6 = this.mMol.getBondAtom(1 - n2, i);
                if (!this.hasSharedDelocalizedBond(n, nArray) || this.hasSharedDelocalizedBond(n6, nArray)) continue;
                while (-1 != (n5 = this.getNextOuterDelocalizedConnIndex(n6, n, nArray))) {
                    int n7 = this.mMol.getConnAtom(n6, n5);
                    int n8 = this.mMol.getConnBond(n6, n5);
                    if (!this.mIsDelocalizedBond[n8]) continue block4;
                    this.promoteBond(n8);
                    n5 = this.getNextOuterDelocalizedConnIndex(n7, n6, nArray);
                    if (n5 == -1) continue block4;
                    n = n7;
                    n6 = this.mMol.getConnAtom(n7, n5);
                }
            }
        }
        return n3 != this.mAromaticBonds;
    }

    private boolean hasSharedDelocalizedBond(int n, int[] nArray) {
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            if (nArray[this.mMol.getConnBond(n, i)] <= 1) continue;
            return true;
        }
        return false;
    }

    private int getNextOuterDelocalizedConnIndex(int n, int n2, int[] nArray) {
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            if (nArray[this.mMol.getConnBond(n, i)] != 1 || this.mMol.getConnAtom(n, i) == n2) continue;
            return i;
        }
        return -1;
    }

    private boolean isAromaticAtom(int n) {
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            if (!this.mIsDelocalizedBond[this.mMol.getConnBond(n, i)]) continue;
            return true;
        }
        return false;
    }

    private void protectFullValenceAtoms(boolean bl) {
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            if (!this.mIsDelocalizedAtom[i] || this.mMol.getLowestFreeValence(i) != 0 || bl && (this.mMol.getAtomicNo(i) != 5 || this.mMol.getAtomCharge(i) >= 0) && this.mMol.getAtomicNo(i) != 6 && this.mMol.getAtomicNo(i) != 14 && (!this.mMol.isElectronegative(i) || this.mMol.getAtomCharge(i) <= 0)) continue;
            this.protectAtom(i);
        }
    }

    private void protectAtom(int n) {
        if (this.mIsDelocalizedAtom[n]) {
            this.mIsDelocalizedAtom[n] = false;
            --this.mAromaticAtoms;
        }
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            int n2 = this.mMol.getConnBond(n, i);
            if (!this.mIsDelocalizedBond[n2]) continue;
            this.mIsDelocalizedBond[n2] = false;
            --this.mAromaticBonds;
        }
    }

    private void promoteBond(int n) {
        if (this.mMol.getBondType(n) == 1) {
            this.mMol.setBondType(n, 2);
            this.mPiElectronsAdded += 2;
        }
        for (int i = 0; i < 2; ++i) {
            int n2 = this.mMol.getBondAtom(i, n);
            this.mIsDelocalizedAtom[n2] = false;
            for (int j = 0; j < this.mMol.getConnAtoms(n2); ++j) {
                int n3 = this.mMol.getConnBond(n2, j);
                if (!this.mIsDelocalizedBond[n3]) continue;
                this.mIsDelocalizedBond[n3] = false;
                --this.mAromaticBonds;
            }
        }
    }

    private void promoteObviousBonds() {
        boolean bl;
        do {
            bl = false;
            for (int i = 0; i < this.mMol.getBonds(); ++i) {
                if (!this.mIsDelocalizedBond[i]) continue;
                boolean bl2 = false;
                for (int j = 0; j < 2; ++j) {
                    int n = this.mMol.getBondAtom(j, i);
                    boolean bl3 = false;
                    for (int k = 0; k < this.mMol.getConnAtoms(n); ++k) {
                        if (i == this.mMol.getConnBond(n, k) || !this.mIsDelocalizedBond[this.mMol.getConnBond(n, k)]) continue;
                        bl3 = true;
                        break;
                    }
                    if (bl3) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) continue;
                bl = true;
                this.promoteBond(i);
            }
        } while (bl);
    }

    private void promoteDelocalizedChains() {
        block0: for (int i = 0; i < this.mMol.getBonds(); ++i) {
            if (!this.mIsDelocalizedBond[i]) continue;
            for (int j = 0; j < 2; ++j) {
                int n;
                int n2 = this.mMol.getBondAtom(j, i);
                boolean bl = false;
                for (n = 0; n < this.mMol.getConnAtoms(n2); ++n) {
                    if (i == this.mMol.getConnBond(n2, n) || !this.mIsDelocalizedBond[this.mMol.getConnBond(n2, n)]) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                n = i;
                int n3 = this.mMol.getBondAtom(1 - j, i);
                block3: while (n != -1) {
                    this.mIsDelocalizedBond[n] = false;
                    --this.mAromaticBonds;
                    this.mMol.setBondType(n, 64);
                    n = -1;
                    n2 = n3;
                    for (int k = 0; k < this.mMol.getConnAtoms(n2); ++k) {
                        if (!this.mIsDelocalizedBond[this.mMol.getConnBond(n2, k)]) continue;
                        if (n == -1) {
                            n = this.mMol.getConnBond(n2, k);
                            n3 = this.mMol.getConnAtom(n2, k);
                            continue;
                        }
                        n2 = -1;
                        n = -1;
                        continue block3;
                    }
                }
                continue block0;
            }
        }
    }

    private void protectAmideBonds(RingCollection ringCollection) {
        for (int i = 0; i < this.mMol.getBonds(); ++i) {
            if (!this.mIsDelocalizedBond[i] || !ringCollection.qualifiesAsAmideTypeBond(i)) continue;
            this.protectAtom(this.mMol.getBondAtom(0, i));
            this.protectAtom(this.mMol.getBondAtom(1, i));
        }
    }

    private void protectDoubleBondAtoms() {
        for (int i = 0; i < this.mMol.getBonds(); ++i) {
            if (this.mMol.getBondOrder(i) != 2) continue;
            block1: for (int j = 0; j < 2; ++j) {
                int n = this.mMol.getBondAtom(j, i);
                if (this.mMol.getAtomicNo(n) > 8) continue;
                for (int k = 0; k < this.mMol.getConnAtoms(n); ++k) {
                    int n2 = this.mMol.getConnBond(n, k);
                    if (!this.mIsDelocalizedBond[n2]) continue;
                    this.protectAtom(n);
                    continue block1;
                }
            }
        }
    }

    private void addObviousAtomCharges(RingCollection ringCollection) {
        int n;
        int n2;
        int n3;
        int n42;
        int n5;
        int n6;
        int n7;
        int n8;
        boolean[] blArray = new boolean[ringCollection.getSize()];
        int[] nArray = new int[this.mMol.getAtoms()];
        for (int i = 0; i < ringCollection.getSize(); ++i) {
            blArray[i] = true;
            int[] nArray2 = ringCollection.getRingBonds(i);
            n8 = nArray2.length;
            for (n7 = 0; n7 < n8; ++n7) {
                n6 = nArray2[n7];
                if (this.mIsDelocalizedBond[n6]) continue;
                blArray[i] = false;
                break;
            }
            if (!blArray[i]) continue;
            nArray2 = ringCollection.getRingAtoms(i);
            n8 = nArray2.length;
            for (n7 = 0; n7 < n8; ++n7) {
                int n9 = n6 = nArray2[n7];
                nArray[n9] = nArray[n9] + 1;
            }
        }
        boolean[] blArray2 = new boolean[this.mMol.getAtoms()];
        for (int i = 0; i < ringCollection.getSize(); ++i) {
            n8 = ringCollection.getRingSize(i);
            if (n8 != 3 && n8 != 5 && n8 != 6 && n8 != 7 || !blArray[i]) continue;
            for (int n10 : ringCollection.getRingAtoms(i)) {
                blArray2[n10] = true;
            }
            n7 = 1;
            n6 = -1;
            n5 = 0;
            for (int n42 : ringCollection.getRingAtoms(i)) {
                if (n8 == 6 || nArray[n42] > 1) {
                    if (this.checkAtomTypePi1(n42, false)) continue;
                    n7 = 0;
                    break;
                }
                int n11 = n3 = n8 == 5 ? this.checkAtomTypeLeak5(n42, false) : this.checkAtomTypeLeak7(n42, false);
                if (!this.checkAtomTypePi1(n42, false)) {
                    if (n5 == 10) {
                        n7 = 0;
                        break;
                    }
                    n6 = n42;
                    n5 = 20;
                    continue;
                }
                if (n5 >= n3) continue;
                n5 = n3;
                n6 = n42;
            }
            if (n7 == 0) continue;
            for (int n42 : ringCollection.getRingAtoms(i)) {
                if (n42 == n6) {
                    if (n8 == 5) {
                        this.checkAtomTypeLeak5(n42, true);
                    } else {
                        this.checkAtomTypeLeak7(n42, true);
                    }
                    this.protectAtom(n42);
                    continue;
                }
                this.checkAtomTypePi1(n42, true);
            }
        }
        int[] nArray3 = new int[this.mMol.getAtoms()];
        boolean[] blArray3 = new boolean[this.mMol.getAtoms()];
        for (n7 = 0; n7 < this.mMol.getBonds(); ++n7) {
            n6 = this.mMol.getBondAtom(0, n7);
            n5 = this.mMol.getBondAtom(1, n7);
            if (blArray2[n6] || blArray2[n5]) continue;
            if (this.mIsDelocalizedBond[n7]) {
                int n12 = n6;
                nArray3[n12] = nArray3[n12] + 1;
                int n13 = n5;
                nArray3[n13] = nArray3[n13] + 1;
            }
            if (this.mMol.getBondType(n7) != 32) continue;
            blArray3[n6] = true;
            blArray3[n5] = true;
        }
        int[] nArray4 = new int[this.mMol.getAtoms()];
        int[] nArray5 = new int[this.mMol.getAtoms()];
        for (n5 = 0; n5 < this.mMol.getAtoms(); ++n5) {
            if (nArray3[n5] != 1) continue;
            nArray5[0] = n5;
            n2 = 0;
            block9: for (int i = 0; i <= n2; ++i) {
                for (n = 0; n < this.mMol.getConnAtoms(nArray5[i]); ++n) {
                    if (!this.mIsDelocalizedBond[this.mMol.getConnBond(nArray5[i], n)]) continue;
                    n42 = this.mMol.getConnAtom(nArray5[i], n);
                    if (i != 0 && n42 == nArray5[i - 1] || nArray3[n42] == 0) continue;
                    nArray5[++n2] = n42;
                    if ((nArray3[n42] & 1) == 0) continue block9;
                    for (n3 = 1; n3 < n2; n3 += 2) {
                        nArray4[nArray5[n3]] = -1;
                    }
                    n2 = 0;
                    continue block9;
                }
            }
        }
        boolean[] blArray4 = new boolean[this.mMol.getAtoms()];
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            if (blArray4[i] || nArray3[i] == 0) continue;
            nArray5[0] = i;
            blArray4[i] = true;
            n = 0;
            for (n2 = 0; n2 <= n; ++n2) {
                for (n42 = 0; n42 < this.mMol.getConnAtoms(nArray5[n2]); ++n42) {
                    if (!this.mIsDelocalizedBond[this.mMol.getConnBond(nArray5[n2], n42)] || blArray4[n3 = this.mMol.getConnAtom(nArray5[n2], n42)]) continue;
                    nArray5[++n] = n3;
                    blArray4[n3] = true;
                }
            }
            if ((n & 1) != 0) continue;
            for (n42 = 0; n42 <= n; ++n42) {
                if (nArray4[nArray5[n42]] != 0) continue;
                nArray4[nArray5[n42]] = this.checkAtomTypeLeakNonRing(nArray5[n42], false);
            }
            n42 = 1;
            for (n3 = 0; n3 <= n; ++n3) {
                if (nArray4[nArray5[n3]] > 0 || this.checkAtomTypePi1(nArray5[n3], false)) continue;
                n42 = 0;
                break;
            }
            if (n42 == 0) continue;
            n3 = 0;
            int n14 = -1;
            for (int j = 0; j <= n; ++j) {
                if (n3 >= nArray4[nArray5[j]]) continue;
                n3 = nArray4[nArray5[j]];
                n14 = nArray5[j];
            }
            if (n3 <= 0) continue;
            this.checkAtomTypeLeakNonRing(n14, true);
            this.protectAtom(n14);
        }
    }

    private boolean checkAtomTypePi1(int n, boolean bl) {
        int n2 = this.mMol.getAtomicNo(n);
        if (n2 >= 5 && n2 <= 8 || n2 == 15 || n2 == 16 || n2 == 33 || n2 == 34 || n2 == 52) {
            int n3 = this.mMol.getLowestFreeValence(n);
            if (n3 != 0) {
                return true;
            }
            int n4 = this.mMol.getAtomCharge(n);
            if (n2 == 5 && n4 >= 0) {
                if (bl) {
                    this.mMol.setAtomCharge(n, n4 - 1);
                }
                return true;
            }
            if (n2 != 5 && n4 <= 0) {
                if (bl) {
                    this.mMol.setAtomCharge(n, n4 + 1);
                }
                return true;
            }
        }
        return false;
    }

    private int checkAtomTypeLeak5(int n, boolean bl) {
        if (this.mMol.getAtomicNo(n) == 7) {
            if (this.mMol.getAllConnAtoms(n) == 3) {
                return 6;
            }
            if (this.mMol.getConnAtoms(n) == 2) {
                return 4;
            }
        } else {
            if (this.mMol.getAtomicNo(n) == 8) {
                return 10;
            }
            if (this.mMol.getAtomicNo(n) == 15 || this.mMol.getAtomicNo(n) == 33) {
                if (this.mMol.getConnAtoms(n) == 3) {
                    return 8;
                }
            } else if (this.mMol.getAtomicNo(n) == 16 || this.mMol.getAtomicNo(n) == 34 || this.mMol.getAtomicNo(n) == 52) {
                if (this.mMol.getConnAtoms(n) == 2) {
                    return 12;
                }
            } else if (this.mMol.getAtomicNo(n) == 6) {
                if (bl) {
                    this.mMol.setAtomCharge(n, -1);
                }
                return this.mMol.getAllConnAtoms(n) != this.mMol.getAllConnAtomsPlusMetalBonds(n) ? 2 : 3;
            }
        }
        return 0;
    }

    private int checkAtomTypeLeak7(int n, boolean bl) {
        if (this.mAllHydrogensAreExplicit ? this.mMol.getAllConnAtoms(n) != 3 : this.mMol.getAllConnAtoms(n) > 3) {
            return 0;
        }
        if (this.mMol.getAtomicNo(n) == 6) {
            if (bl) {
                this.mMol.setAtomCharge(n, 1);
            }
            return 2;
        }
        if (this.mMol.getAtomicNo(n) == 5) {
            return 4;
        }
        return 0;
    }

    private int checkAtomTypeLeakNonRing(int n, boolean bl) {
        if (this.mMol.getAtomCharge(n) != 0) {
            return 0;
        }
        if (this.mAllHydrogensAreExplicit) {
            if (this.mMol.getAtomicNo(n) == 5) {
                if (this.mMol.getOccupiedValence(n) != 2) {
                    return 0;
                }
                if (bl) {
                    this.mMol.setAtomCharge(n, 1);
                }
                return 1;
            }
            if (this.mMol.getAtomicNo(n) == 7) {
                if (this.mMol.getOccupiedValence(n) != 2) {
                    return 0;
                }
                if (bl) {
                    this.mMol.setAtomCharge(n, -1);
                }
                return this.hasMetalNeighbour(n) ? 6 : 3;
            }
            if (this.mMol.getAtomicNo(n) == 8) {
                if (this.mMol.getOccupiedValence(n) != 1) {
                    return 0;
                }
                if (bl) {
                    this.mMol.setAtomCharge(n, -1);
                }
                return this.hasMetalNeighbour(n) ? 7 : 4;
            }
            if (this.mMol.getAtomicNo(n) == 16) {
                if (this.mMol.getOccupiedValence(n) != 1) {
                    return 0;
                }
                if (bl) {
                    this.mMol.setAtomCharge(n, -1);
                }
                return this.hasMetalNeighbour(n) ? 5 : 2;
            }
            if (this.mMol.getAtomicNo(n) == 34) {
                if (this.mMol.getOccupiedValence(n) != 1) {
                    return 0;
                }
                if (bl) {
                    this.mMol.setAtomCharge(n, -1);
                }
                return this.hasMetalNeighbour(n) ? 4 : 1;
            }
        } else {
            if (this.mMol.getAtomicNo(n) == 5) {
                if (this.mMol.getOccupiedValence(n) > 2) {
                    return 0;
                }
                if (bl) {
                    this.mMol.setAtomCharge(n, 1);
                }
                return 1;
            }
            if (this.mMol.getAtomicNo(n) == 7) {
                if (this.mMol.getOccupiedValence(n) > 2) {
                    return 0;
                }
                if (bl) {
                    this.mMol.setAtomCharge(n, -1);
                }
                return this.hasMetalNeighbour(n) ? 5 : 3;
            }
            if (this.mMol.getAtomicNo(n) == 8) {
                if (this.mMol.getOccupiedValence(n) > 1) {
                    return 0;
                }
                if (bl) {
                    this.mMol.setAtomCharge(n, -1);
                }
                return this.hasMetalNeighbour(n) ? 7 : 4;
            }
            if (this.mMol.getAtomicNo(n) == 16) {
                if (this.mMol.getOccupiedValence(n) > 1) {
                    return 0;
                }
                if (bl) {
                    this.mMol.setAtomCharge(n, -1);
                }
                return this.hasMetalNeighbour(n) ? 5 : 2;
            }
        }
        return 0;
    }

    private boolean hasMetalNeighbour(int n) {
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            if (!this.mMol.isMetalAtom(this.mMol.getConnAtom(n, i))) continue;
            return true;
        }
        return false;
    }
}

