/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.regression.svm;

import com.actelion.research.calc.CorrelationCalculator;
import com.actelion.research.calc.Matrix;
import com.actelion.research.calc.ProgressController;
import com.actelion.research.calc.regression.ARegressionMethod;
import com.actelion.research.calc.regression.ParameterRegressionMethod;
import com.actelion.research.calc.regression.svm.AnalyticalParameterCalculatorSVM;
import com.actelion.research.calc.regression.svm.Matrix2SVMNodeConverter;
import com.actelion.research.calc.regression.svm.ParameterSVM;
import com.actelion.research.calc.regression.svm.SVMParameterHelper;
import com.actelion.research.calc.regression.svm.svm;
import com.actelion.research.util.Formatter;
import com.actelion.research.util.datamodel.DoubleArray;
import com.actelion.research.util.datamodel.ModelXYIndex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.machinelearning.svm.libsvm.svm_model;
import org.machinelearning.svm.libsvm.svm_problem;

public class SVMRegression
extends ARegressionMethod<ParameterSVM>
implements Comparable<SVMRegression> {
    public static final int LIMIT_ROWS_ANALYTICAL = 1000;
    public static boolean VERBOSE = false;
    public static final double NU = 0.1;
    private svm_model modelSVM;

    public SVMRegression() {
        this.setParameterRegressionMethod(new ParameterSVM(SVMParameterHelper.regressionEpsilonSVR()));
    }

    public SVMRegression(ParameterSVM parameterSVM) {
        this.setParameterRegressionMethod(parameterSVM);
    }

    @Override
    public Matrix createModel(ModelXYIndex modelXYIndex) {
        Serializable serializable;
        Object object;
        int n;
        if (((ParameterSVM)this.parameterRegressionMethod).getSvmParameter().degree == -1) {
            ModelXYIndex modelXYIndex2 = null;
            n = modelXYIndex.X.rows();
            if (n > 1000) {
                object = new ArrayList(n);
                for (int i = 0; i < n; ++i) {
                    object.add(i);
                }
                Collections.shuffle(object);
                serializable = new ArrayList(object.subList(0, 1000));
                modelXYIndex2 = modelXYIndex.sub((List<Integer>)((Object)serializable));
            } else {
                modelXYIndex2 = modelXYIndex;
            }
            object = AnalyticalParameterCalculatorSVM.calculate(modelXYIndex2);
            this.setParameterRegressionMethod(object);
        }
        int n2 = modelXYIndex.X.rows();
        n = modelXYIndex.Y.cols();
        if (n != 1) {
            throw new RuntimeException("Only one y column allowed!");
        }
        object = new Matrix(n2, n);
        serializable = new svm_problem();
        serializable.l = n2;
        serializable.x = Matrix2SVMNodeConverter.convert(modelXYIndex.X);
        if (((ParameterSVM)this.getParameter()).getGamma() <= 0.0) {
            ((ParameterSVM)this.getParameter()).setGamma(1.0 / (double)modelXYIndex.X.cols());
        }
        boolean bl = false;
        try {
            double[] dArray = modelXYIndex.Y.getColAsDouble(0);
            DoubleArray doubleArray = new DoubleArray(dArray);
            serializable.y = dArray;
            String string = svm.svm_check_parameter(serializable, ((ParameterSVM)this.getParameter()).getSvmParameter());
            if (string != null) {
                System.err.print("SVMRegressionMultiY svm_check_parameter error: " + string + "\n");
                bl = true;
            }
            ProgressController progressController = this.getProgressController();
            this.modelSVM = svm.svm_train(serializable, ((ParameterSVM)this.getParameter()).getSvmParameter(), progressController);
            if (progressController != null) {
                progressController.startProgress("Calculate train data fit", 0, n2);
            }
            DoubleArray doubleArray2 = new DoubleArray(n2);
            for (int i = 0; i < n2; ++i) {
                double d = svm.svm_predict(this.modelSVM, serializable.x[i]);
                doubleArray2.add(d);
                ((Matrix)object).set(i, 0, d);
                if (progressController == null) continue;
                progressController.updateProgress(i);
                if (!progressController.threadMustDie()) continue;
                bl = true;
                break;
            }
            if (VERBOSE) {
                double d = new CorrelationCalculator().calculateCorrelation(doubleArray, doubleArray2, 0);
                double d2 = d * d;
                System.out.println("SVMRegressionMultiY model r2 " + Formatter.format4(d2) + ".");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (VERBOSE) {
                System.err.println("SVMRegressionMultiY break.");
            }
            bl = true;
        }
        if (bl) {
            object = null;
        }
        return object;
    }

    @Override
    public Matrix calculateYHat(Matrix matrix) {
        int n = matrix.rows();
        Matrix matrix2 = new Matrix(n, 1);
        svm_problem svm_problem2 = new svm_problem();
        svm_problem2.l = n;
        svm_problem2.x = Matrix2SVMNodeConverter.convert(matrix);
        for (int i = 0; i < n; ++i) {
            double d = svm.svm_predict(this.modelSVM, svm_problem2.x[i]);
            matrix2.set(i, 0, d);
        }
        return matrix2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double calculateYHat(double[] dArray) {
        double d;
        SVMRegression sVMRegression = this;
        synchronized (sVMRegression) {
            svm_problem svm_problem2 = new svm_problem();
            svm_problem2.l = 1;
            svm_problem2.x = Matrix2SVMNodeConverter.convertSingleRow(dArray);
            d = svm.svm_predict(this.modelSVM, svm_problem2.x[0]);
        }
        return d;
    }

    public void setNu(double d) {
        ((ParameterSVM)this.getParameter()).setNu(d);
    }

    public void setGamma(double d) {
        ((ParameterSVM)this.getParameter()).setGamma(d);
    }

    @Override
    public int compareTo(SVMRegression sVMRegression) {
        return ((ParameterSVM)this.getParameter()).compareTo((ParameterRegressionMethod)sVMRegression.getParameter());
    }
}

