/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.regression.neuralnetwork;

import com.actelion.research.calc.ArrayUtilsCalc;
import com.actelion.research.calc.regression.ParameterRegressionMethod;
import com.actelion.research.calc.regression.neuralnetwork.NeuralNetworkParameterHelper;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import smile.regression.NeuralNetwork;

public class ParameterNeuralNetwork
extends ParameterRegressionMethod {
    public static final String TAG_ACTIVATION_FCT = "ActivationFunction";
    public static final String TAG_INNERLAYER_ARCITECTURE = "InnerLayerArchitecture";
    private int[] arrInnerLayerArchitecture;
    private NeuralNetwork.ActivationFunction activationFunction;

    public ParameterNeuralNetwork() {
        super("Neural network regression");
        this.setActivationFunction(NeuralNetwork.ActivationFunction.LOGISTIC_SIGMOID);
        this.setArrInnerLayerArchitecture(new int[0]);
    }

    @Override
    public int compareTo(ParameterRegressionMethod parameterRegressionMethod) {
        int n = 0;
        ParameterNeuralNetwork parameterNeuralNetwork = (ParameterNeuralNetwork)parameterRegressionMethod;
        return n;
    }

    public void setArrInnerLayerArchitecture(int[] nArray) {
        this.arrInnerLayerArchitecture = nArray;
        this.properties.put(TAG_INNERLAYER_ARCITECTURE, ArrayUtilsCalc.toString(nArray));
    }

    public void setActivationFunction(NeuralNetwork.ActivationFunction activationFunction) {
        this.properties.put(TAG_ACTIVATION_FCT, NeuralNetworkParameterHelper.getActivationFunctionName(activationFunction));
        this.activationFunction = activationFunction;
    }

    public NeuralNetwork.ActivationFunction getActivationFunction() {
        return this.activationFunction;
    }

    public int[] getArrInnerLayerArchitecture() {
        return this.arrInnerLayerArchitecture;
    }

    public static List<String> getHeader() {
        List<String> list = ParameterRegressionMethod.getHeader();
        list.add(TAG_ACTIVATION_FCT);
        list.add(TAG_INNERLAYER_ARCITECTURE);
        return list;
    }

    @Override
    public void decodeProperties2Parameter() {
        String string = this.properties.getProperty(TAG_ACTIVATION_FCT);
        this.activationFunction = NeuralNetworkParameterHelper.getActivationFunction(string);
        String string2 = this.properties.getProperty(TAG_INNERLAYER_ARCITECTURE);
        this.arrInnerLayerArchitecture = ArrayUtilsCalc.readIntArray(string2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ParameterNeuralNetwork{");
        stringBuilder.append("arrInnerLayerArchitecture=").append(Arrays.toString(this.arrInnerLayerArchitecture));
        stringBuilder.append(", activationFunction=").append(NeuralNetworkParameterHelper.getActivationFunctionName(this.activationFunction));
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) throws IOException {
        File file = new File("/home/korffmo1/tmp/tmp00");
        File file2 = new File(file, "neuralNetwork.properties");
        ParameterNeuralNetwork parameterNeuralNetwork = new ParameterNeuralNetwork();
        parameterNeuralNetwork.setActivationFunction(NeuralNetwork.ActivationFunction.LOGISTIC_SIGMOID);
        parameterNeuralNetwork.setArrInnerLayerArchitecture(new int[]{512, 64, 32, 8, 64});
        parameterNeuralNetwork.write(file2);
        ParameterNeuralNetwork parameterNeuralNetwork2 = new ParameterNeuralNetwork();
        parameterNeuralNetwork2.read(file2);
        System.out.println(parameterNeuralNetwork2.toString());
    }
}

