/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.regression.neuralnetwork;

import smile.regression.NeuralNetwork;

public class NeuralNetworkParameterHelper {
    public static final String ACTIVATION_FCT_LOG = "LogisticSigmoid";
    public static final String ACTIVATION_FCT_TAN = "Tangens";

    public static String getActivationFunctionName(NeuralNetwork.ActivationFunction activationFunction) {
        String string = "";
        switch (activationFunction) {
            case LOGISTIC_SIGMOID: {
                string = ACTIVATION_FCT_LOG;
                break;
            }
            case TANH: {
                string = ACTIVATION_FCT_TAN;
            }
        }
        return string;
    }

    public static NeuralNetwork.ActivationFunction getActivationFunction(String string) {
        NeuralNetwork.ActivationFunction activationFunction = null;
        if (ACTIVATION_FCT_LOG.equals(string)) {
            activationFunction = NeuralNetwork.ActivationFunction.LOGISTIC_SIGMOID;
        } else if (ACTIVATION_FCT_TAN.equals(string)) {
            activationFunction = NeuralNetwork.ActivationFunction.TANH;
        } else {
            throw new RuntimeException("Unknown activation function type " + string + ".");
        }
        return activationFunction;
    }
}

