/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.regression.linear.pls;

import com.actelion.research.calc.Matrix;
import com.actelion.research.calc.regression.ARegressionMethod;
import com.actelion.research.calc.regression.ModelError;
import com.actelion.research.calc.regression.linear.pls.ParameterPLS;
import com.actelion.research.calc.regression.linear.pls.SimPLS;
import com.actelion.research.util.datamodel.ModelXYIndex;

public class PLSRegressionModelCalculator
extends ARegressionMethod<ParameterPLS> {
    public static final int FACTORS = 15;
    private SimPLS simPLS;
    private Matrix B;
    private Matrix Xvar;
    private Matrix YHat;
    private Matrix X;
    private Matrix Y;
    private Matrix XtrainPreprocessed;
    private Matrix YtrainPreprocessed;

    public PLSRegressionModelCalculator() {
        this.setParameterRegressionMethod(new ParameterPLS(15));
    }

    public PLSRegressionModelCalculator(ParameterPLS parameterPLS) {
        this.setParameterRegressionMethod(parameterPLS);
    }

    public void setCenterData(boolean bl) {
        ((ParameterPLS)this.getParameter()).setCenterData(bl);
    }

    public void setFactors(int n) {
        ((ParameterPLS)this.getParameter()).setFactors(n);
    }

    @Override
    public Matrix createModel(ModelXYIndex modelXYIndex) {
        this.X = modelXYIndex.X;
        this.Y = modelXYIndex.Y;
        this.XtrainPreprocessed = modelXYIndex.X;
        this.YtrainPreprocessed = modelXYIndex.Y;
        if (((ParameterPLS)this.getParameter()).isCenterData()) {
            this.XtrainPreprocessed = modelXYIndex.X.getCenteredMatrix();
            this.YtrainPreprocessed = modelXYIndex.Y.getCenteredMatrix();
        }
        this.simPLS = new SimPLS();
        this.simPLS.simPlsSave(this.XtrainPreprocessed, this.YtrainPreprocessed, ((ParameterPLS)this.getParameter()).getFactors());
        Matrix matrix = this.simPLS.getR();
        if (matrix.cols() == 1 && matrix.rows() == 1 && matrix.get(0, 0) == 0.0) {
            System.out.println("RegressionModelCalculator R = 0.");
        }
        Matrix matrix2 = this.simPLS.getQ();
        this.B = matrix.multiply(false, true, matrix2);
        this.Xvar = this.XtrainPreprocessed.getVarianceCols();
        this.YHat = SimPLS.invLinReg_Yhat(this.B, this.X, modelXYIndex.X, this.Y);
        return this.YHat;
    }

    @Override
    public Matrix calculateYHat(Matrix matrix) {
        Matrix matrix2 = SimPLS.invLinReg_Yhat(this.B, this.X, matrix, this.Y);
        return matrix2;
    }

    @Override
    public double calculateYHat(double[] dArray) {
        Matrix matrix = SimPLS.invLinReg_Yhat(this.B, this.X, new Matrix(true, dArray), this.Y);
        return matrix.get(0, 0);
    }

    public double calculateYHat(byte[] byArray) {
        Matrix matrix = SimPLS.invLinReg_Yhat(this.B, this.X, new Matrix(true, byArray), this.Y);
        return matrix.get(0, 0);
    }

    public double calculateYHat(int[] nArray) {
        Matrix matrix = SimPLS.invLinReg_Yhat(this.B, this.X, new Matrix(true, nArray), this.Y);
        return matrix.get(0, 0);
    }

    public Matrix calculateYHatWithoutDeCentering(Matrix matrix) {
        Matrix matrix2 = SimPLS.invLinReg_Yhat(this.B, matrix);
        return matrix2;
    }

    public ModelError calculateModelErrorTest(Matrix matrix, Matrix matrix2) {
        Matrix matrix3 = SimPLS.invLinReg_Yhat(this.B, this.XtrainPreprocessed, matrix, this.YtrainPreprocessed);
        return ModelError.calculateError(matrix2, matrix3);
    }

    public Matrix getB() {
        return this.B;
    }

    public Matrix getXvar() {
        return this.Xvar;
    }

    public Matrix getYHat() {
        return this.YHat;
    }

    public Matrix getT(Matrix matrix) {
        return this.simPLS.getT(matrix);
    }
}

