/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.regression.knn;

import com.actelion.research.calc.regression.ParameterRegressionMethod;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class ParameterKNN
extends ParameterRegressionMethod {
    public static final String TAG_NEIGHBOURS = "Neighbours";
    private int neighbours;

    public ParameterKNN() {
        super("KNN regression");
        this.setNeighbours(3);
    }

    public ParameterKNN(int n) {
        super("KNN regression");
        this.setNeighbours(n);
    }

    public int getNeighbours() {
        return this.neighbours;
    }

    public void setNeighbours(int n) {
        this.neighbours = n;
        this.properties.setProperty(TAG_NEIGHBOURS, Integer.toString(n));
    }

    @Override
    public int compareTo(ParameterRegressionMethod parameterRegressionMethod) {
        int n = 0;
        ParameterKNN parameterKNN = (ParameterKNN)parameterRegressionMethod;
        if (this.neighbours > parameterKNN.neighbours) {
            n = 1;
        } else if (this.neighbours < parameterKNN.neighbours) {
            n = -1;
        }
        return n;
    }

    @Override
    protected void decodeProperties2Parameter() {
        this.neighbours = Integer.parseInt(this.properties.getProperty(TAG_NEIGHBOURS));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ParameterKNN{");
        stringBuilder.append("name=").append(this.getName());
        stringBuilder.append("neighbours=").append(this.neighbours);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static List<String> getHeader() {
        List<String> list = ParameterRegressionMethod.getHeader();
        list.add(TAG_NEIGHBOURS);
        return list;
    }

    public static void main(String[] stringArray) throws IOException {
        File file = new File("/home/korffmo1/tmp/tmp00");
        File file2 = new File(file, "knn.properties");
        ParameterKNN parameterKNN = new ParameterKNN();
        parameterKNN.setNeighbours(3);
        parameterKNN.write(file2);
        ParameterKNN parameterKNN2 = new ParameterKNN();
        parameterKNN2.read(file2);
        System.out.println(parameterKNN2.toString());
    }
}

