/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.graph;

import com.actelion.research.calc.Matrix;
import java.awt.Point;
import java.util.ArrayList;

public class MinimumSpanningTree {
    private Matrix maAdjacency;

    public MinimumSpanningTree(Matrix matrix) {
        this.maAdjacency = matrix;
    }

    public Matrix getMST() {
        Matrix matrix = new Matrix(this.maAdjacency.rows(), this.maAdjacency.cols());
        int[] nArray = new int[this.maAdjacency.rows()];
        Point point = this.getStartEdge();
        nArray[point.x] = 1;
        nArray[point.y] = 1;
        ArrayList<Point> arrayList = new ArrayList<Point>();
        arrayList.add(point);
        int n = this.maAdjacency.rows() - 1;
        for (int i = 0; i < n; ++i) {
            double d = Double.MAX_VALUE;
            int n2 = -1;
            int n3 = -1;
            for (int j = 0; j < this.maAdjacency.rows(); ++j) {
                if (nArray[j] != 1) continue;
                for (int k = 0; k < this.maAdjacency.cols(); ++k) {
                    if (j == k || nArray[k] == 1 || Double.isNaN(this.maAdjacency.get(j, k)) || !(this.maAdjacency.get(j, k) < d)) continue;
                    d = this.maAdjacency.get(j, k);
                    n2 = j;
                    n3 = k;
                }
            }
            if (n2 == -1) break;
            nArray[n2] = 1;
            nArray[n3] = 1;
            arrayList.add(new Point(n2, n3));
        }
        matrix.set(Double.NaN);
        for (Point point2 : arrayList) {
            matrix.set(point2.x, point2.y, this.maAdjacency.get(point2.x, point2.y));
            matrix.set(point2.y, point2.x, this.maAdjacency.get(point2.x, point2.y));
        }
        return matrix;
    }

    private Point getStartEdge() {
        double d = Double.MAX_VALUE;
        Point point = new Point();
        for (int i = 0; i < this.maAdjacency.rows(); ++i) {
            for (int j = i + 1; j < this.maAdjacency.cols(); ++j) {
                if (Double.isNaN(this.maAdjacency.get(i, j)) || !(this.maAdjacency.get(i, j) < d)) continue;
                d = this.maAdjacency.get(i, j);
                point.x = i;
                point.y = j;
            }
        }
        return point;
    }
}

