/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ScaleClasses {
    private List<Limit> liLimit = new ArrayList<Limit>();

    public void add(double d, double d2, double d3, double d4) {
        Limit limit = new Limit(d, d2, d3, d4);
        this.liLimit.add(limit);
    }

    public double scale(double d) {
        double d2 = 0.0;
        for (Limit limit : this.liLimit) {
            if (!limit.isInRange(d)) continue;
            d2 = limit.scale(d);
            break;
        }
        return d2;
    }

    public float scale(float f) {
        float f2 = 0.0f;
        for (Limit limit : this.liLimit) {
            if (!limit.isInRange(f)) continue;
            f2 = (float)limit.scale(f);
            break;
        }
        return f2;
    }

    public static void main(String[] stringArray) {
        int n = 20;
        DecimalFormat decimalFormat = new DecimalFormat("0.000");
        ScaleClasses scaleClasses = new ScaleClasses();
        scaleClasses.add(0.0, 0.25, 0.0, 0.45);
        scaleClasses.add(0.25, 0.75, 0.45, 0.55);
        scaleClasses.add(0.75, 1.0, 0.55, 1.0);
        Random random = new Random();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(0.0);
        arrayList.add(0.1);
        arrayList.add(0.25);
        arrayList.add(0.5);
        arrayList.add(0.6);
        arrayList.add(0.7);
        arrayList.add(0.8);
        arrayList.add(0.9);
        arrayList.add(0.91);
        arrayList.add(1.0);
        for (Double d : arrayList) {
            double d2 = scaleClasses.scale(d);
            System.out.println("val " + decimalFormat.format(d) + " scaled " + decimalFormat.format(d2));
        }
    }

    private static class Limit {
        private double mInHigh;
        private double mInLow;
        private double mScHigh;
        private double mScLow;
        private double mDeltaIn;
        private double mDeltaSc;
        private double mScale;

        public Limit(double d, double d2, double d3, double d4) {
            this.mInHigh = d2;
            this.mScHigh = d4;
            this.mInLow = d;
            this.mScLow = d3;
            this.init();
        }

        private void init() {
            this.mDeltaIn = this.mInHigh - this.mInLow;
            this.mDeltaSc = this.mScHigh - this.mScLow;
            this.mScale = this.mDeltaSc / this.mDeltaIn;
        }

        public double scale(double d) {
            double d2 = 0.0;
            double d3 = d - this.mInLow;
            d2 = d3 * this.mScale + this.mScLow;
            return d2;
        }

        public boolean isInRange(double d) {
            return d >= this.mInLow && d <= this.mInHigh;
        }
    }
}

