/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc;

import com.actelion.research.calc.Matrix;
import com.actelion.research.calc.MatrixFunctions;
import com.actelion.research.calc.regression.linear.pls.SimPLS;
import com.actelion.research.util.IO;
import com.actelion.research.util.datamodel.ModelXY;
import java.util.Date;
import java.util.Random;

public class MatrixTests {
    public static ModelXY getMultivariate(int n, int n2) {
        int n3;
        ModelXY modelXY = new ModelXY();
        Matrix matrix = new Matrix(n, n2);
        Matrix matrix2 = new Matrix(n, 1);
        double d = 10.0;
        Random random = new Random();
        for (n3 = 0; n3 < n2; ++n3) {
            for (int i = 0; i < n; ++i) {
                double d2 = random.nextDouble() * d;
                matrix.set(i, n3, d2);
            }
        }
        for (n3 = 0; n3 < n; ++n3) {
            double d3 = 0.0;
            for (int i = 0; i < n2; ++i) {
                double d4 = matrix.get(n3, i);
                d3 += d4 * (double)(i + 1);
            }
            matrix2.set(n3, 0, d3);
        }
        modelXY.X = matrix;
        modelXY.Y = matrix2;
        return modelXY;
    }

    public static Matrix test00() {
        double[][] dArrayArray = new double[][]{{1.001}, {1.002}, {1.003}, {1.004}};
        Matrix matrix = new Matrix(dArrayArray);
        return matrix;
    }

    public static Matrix test01() {
        double[][] dArrayArray = new double[][]{{1.004}, {1.003}, {1.002}, {1.001}};
        Matrix matrix = new Matrix(dArrayArray);
        return matrix;
    }

    public static Matrix test02() {
        double[][] dArrayArray = new double[][]{{1.0, 3.0, 4.0}, {2.0, 3.0, 4.0}, {3.0, 3.0, 2.0}, {4.0, 3.0, 1.0}};
        Matrix matrix = new Matrix(dArrayArray);
        return matrix;
    }

    public static Matrix test03() {
        double[][] dArrayArray = new double[][]{{1.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 1.0}};
        Matrix matrix = new Matrix(dArrayArray);
        return matrix;
    }

    public static Matrix test04() {
        double[][] dArrayArray = new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {2.0, 20.0, 2.0, 2.0}, {2.0, 20.0, 2.0, 2.0}, {3.0, 30.0, 3.0, 3.0}, {3.0, 30.0, 3.0, 3.0}, {4.0, 40.0, 40.0, 4.0}, {4.0, 40.0, 40.0, 4.0}};
        Matrix matrix = new Matrix(dArrayArray);
        return matrix;
    }

    public static Matrix test05() {
        double[][] dArrayArray = new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 2.0, 1.0, 1.0}, {1.0, 3.0, 1.0, 1.0}, {1.0, 4.0, 1.0, 1.0}, {0.0, 5.0, 1.0, 1.0}, {0.0, 6.0, 1.0, 1.0}, {0.0, 7.0, 1.0, 1.0}, {0.0, 8.0, 1.0, 1.0}};
        Matrix matrix = new Matrix(dArrayArray);
        return matrix;
    }

    public static Matrix test06() {
        double[][] dArrayArray = new double[][]{{1.0, 0.0}, {1.0, 0.0}, {1.0, 0.0}, {1.0, 0.0}, {0.0, 1.0}, {0.0, 1.0}, {0.0, 1.0}, {0.0, 1.0}};
        Matrix matrix = new Matrix(dArrayArray);
        return matrix;
    }

    public static Matrix test07() {
        double[][] dArrayArray = new double[][]{{1.0, 1.0, 0.0, 0.0}, {1.0, 1.0, 0.0, 0.0}, {1.0, 1.0, 0.0, 0.0}, {1.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 1.0}, {0.0, 0.0, 1.0, 1.0}, {0.0, 0.0, 1.0, 1.0}, {0.0, 0.0, 1.0, 1.0}};
        Matrix matrix = new Matrix(dArrayArray);
        return matrix;
    }

    public static Matrix test08() {
        double[][] dArrayArray = new double[][]{{1.0, 1.0, 1.0, 0.0}, {1.0, 0.0, 0.0, 0.0}, {1.0, 1.0, 0.0, 0.0}, {1.0, 1.0, 0.0, 0.0}, {0.0, 1.0, 1.0, 1.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 1.0, 1.0}, {0.0, 0.0, 1.0, 1.0}};
        Matrix matrix = new Matrix(dArrayArray);
        return matrix;
    }

    public static Matrix testMatrix02() {
        double[][] dArrayArray = new double[][]{{16.0, 2.0, 3.0, 13.0}, {5.0, 11.0, 10.0, 8.0}, {9.0, 7.0, 6.0, 12.0}, {4.0, 14.0, 15.0, 1.0}};
        Matrix matrix = new Matrix(dArrayArray);
        return matrix;
    }

    public static Matrix testMatrix_YWine() {
        double[][] dArrayArray = new double[][]{{14.0, 7.0, 8.0}, {10.0, 7.0, 6.0}, {8.0, 5.0, 5.0}, {2.0, 4.0, 7.0}, {6.0, 2.0, 4.0}};
        Matrix matrix = new Matrix(dArrayArray);
        return matrix;
    }

    public static Matrix testMatrix_XWine() {
        double[][] dArrayArray = new double[][]{{7.0, 7.0, 13.0, 7.0}, {4.0, 3.0, 14.0, 7.0}, {10.0, 5.0, 12.0, 5.0}, {16.0, 7.0, 11.0, 3.0}, {13.0, 3.0, 10.0, 3.0}};
        Matrix matrix = new Matrix(dArrayArray);
        return matrix;
    }

    public static Matrix testMatrixHenrion01() {
        double[][] dArrayArray = new double[][]{{4.0, 0.0}, {0.0, 8.0}, {4.0, 4.0}, {2.0, 0.0}, {0.0, 8.0}};
        Matrix matrix = new Matrix(dArrayArray);
        return matrix;
    }

    public static Matrix testLonglyY() {
        double[][] dArrayArray = new double[][]{{60323.0}, {61122.0}, {60171.0}, {61187.0}, {63221.0}, {63639.0}, {64989.0}, {63761.0}, {66019.0}, {67857.0}, {68169.0}, {66513.0}, {68655.0}, {69564.0}, {69331.0}, {70551.0}};
        Matrix matrix = new Matrix(dArrayArray);
        return matrix;
    }

    public static Matrix testLonglyX() {
        double[][] dArrayArray = new double[][]{{83.0, 234289.0, 2356.0, 1590.0, 107608.0, 1947.0}, {88.5, 259426.0, 2325.0, 1456.0, 108632.0, 1948.0}, {88.2, 258054.0, 3682.0, 1616.0, 109773.0, 1949.0}, {89.5, 284599.0, 3351.0, 1650.0, 110929.0, 1950.0}, {96.2, 328975.0, 2099.0, 3099.0, 112075.0, 1951.0}, {98.1, 346999.0, 1932.0, 3594.0, 113270.0, 1952.0}, {99.0, 365385.0, 1870.0, 3547.0, 115094.0, 1953.0}, {100.0, 363112.0, 3578.0, 3350.0, 116219.0, 1954.0}, {101.2, 397469.0, 2904.0, 3048.0, 117388.0, 1955.0}, {104.6, 419180.0, 2822.0, 2857.0, 118734.0, 1956.0}, {108.4, 442769.0, 2936.0, 2798.0, 120445.0, 1957.0}, {110.8, 444546.0, 4681.0, 2637.0, 121950.0, 1958.0}, {112.6, 482704.0, 3813.0, 2552.0, 123366.0, 1959.0}, {114.2, 502601.0, 3931.0, 2514.0, 125368.0, 1960.0}, {115.7, 518173.0, 4806.0, 2572.0, 127852.0, 1961.0}, {116.9, 554894.0, 4007.0, 2827.0, 130081.0, 1962.0}};
        Matrix matrix = new Matrix(dArrayArray);
        return matrix;
    }

    public static Matrix testDescriptor01X() {
        double[][] dArrayArray = new double[][]{{0.0, 0.0, 0.0, 1.0, 1.0, 1.0}, {0.0, 0.0, 0.0, 1.0, 1.0, 1.0}, {0.0, 0.0, 0.0, 1.0, 1.0, 1.0}, {0.0, 0.0, 0.0, 1.0, 1.0, 1.0}, {0.0, 0.0, 0.0, 1.0, 1.0, 1.0}, {0.0, 0.0, 0.0, 1.0, 1.0, 1.0}, {0.0, 0.0, 0.0, 1.0, 1.0, 1.0}, {0.0, 0.0, 0.0, 1.0, 1.0, 1.0}, {0.0, 0.0, 0.0, 1.0, 1.0, 1.0}, {0.0, 0.0, 0.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 0.0, 0.0, 0.0}, {1.0, 1.0, 1.0, 0.0, 0.0, 0.0}, {1.0, 1.0, 1.0, 0.0, 0.0, 0.0}, {1.0, 1.0, 1.0, 0.0, 0.0, 0.0}, {1.0, 1.0, 1.0, 0.0, 0.0, 0.0}, {1.0, 1.0, 1.0, 0.0, 0.0, 0.0}, {1.0, 1.0, 1.0, 0.0, 0.0, 0.0}, {1.0, 1.0, 1.0, 0.0, 0.0, 0.0}, {1.0, 1.0, 1.0, 0.0, 0.0, 0.0}, {1.0, 1.0, 1.0, 0.0, 0.0, 0.0}, {1.0, 1.0, 1.0, 0.0, 0.0, 0.0}};
        Matrix matrix = new Matrix(dArrayArray);
        return matrix;
    }

    public static Matrix testDescriptor01Y() {
        double[][] dArrayArray = new double[][]{{1.0, 0.0}, {1.0, 0.0}, {1.0, 0.0}, {1.0, 0.0}, {1.0, 0.0}, {1.0, 0.0}, {1.0, 0.0}, {1.0, 0.0}, {1.0, 0.0}, {1.0, 0.0}, {0.0, 1.0}, {0.0, 1.0}, {0.0, 1.0}, {0.0, 1.0}, {0.0, 1.0}, {0.0, 1.0}, {0.0, 1.0}, {0.0, 1.0}, {0.0, 1.0}, {0.0, 1.0}, {0.0, 1.0}};
        Matrix matrix = new Matrix(dArrayArray);
        return matrix;
    }

    public static Matrix testSimple1Y() {
        double[][] dArrayArray = new double[][]{{55.0}, {56.0}, {57.0}, {58.0}, {59.0}, {60.0}, {61.0}, {62.0}};
        Matrix matrix = new Matrix(dArrayArray);
        return matrix;
    }

    public static Matrix testSimple1X(int n) {
        double[][] dArrayArray = new double[][]{{55.0}, {56.0}, {57.0}, {58.0}, {59.0}, {60.0}, {61.0}, {62.0}};
        Matrix matrix = Matrix.getRND(dArrayArray.length, n);
        for (int i = 0; i < dArrayArray.length; ++i) {
            matrix.set(i, 0, dArrayArray[i][0]);
        }
        return matrix;
    }

    public static Matrix testSimple2X(int n) {
        double[][] dArrayArray = new double[][]{{55.0, 0.0}, {56.0, 0.0}, {57.0, 0.0}, {58.0, 0.0}, {0.0, 59.0}, {0.0, 60.0}, {0.0, 61.0}, {0.0, 62.0}};
        Matrix matrix = Matrix.getRND(dArrayArray.length, n);
        for (int i = 0; i < dArrayArray.length; ++i) {
            matrix.set(i, 0, dArrayArray[i][0]);
            matrix.set(i, 1, dArrayArray[i][1]);
        }
        return matrix;
    }

    public static boolean checkForEigenvaluesAndEigenvectors() {
        boolean bl = true;
        Matrix matrix = MatrixTests.testMatrix02();
        Matrix matrix2 = matrix.multiply(true, false, matrix);
        Matrix matrix3 = new Matrix(1, 1);
        Matrix matrix4 = new Matrix(1, 1);
        Matrix matrix5 = new Matrix(matrix2.getArray());
        Matrix.getEigenvector(matrix5, matrix5.getColDim(), matrix3, matrix4);
        Matrix matrix6 = matrix3.diagonalize();
        Matrix matrix7 = matrix5.multiply(false, false, matrix6);
        Matrix matrix8 = matrix2.multiply(false, false, matrix5);
        bl = matrix7.equal(matrix8, 1.0E-11);
        return bl;
    }

    protected static Matrix pls(Matrix matrix, Matrix matrix2, String string, int n, boolean bl, String string2) {
        Matrix matrix3 = null;
        if (bl) {
            matrix = matrix.log();
        }
        SimPLS simPLS = new SimPLS();
        Matrix matrix4 = matrix.getCenteredMatrix();
        Matrix matrix5 = matrix2.getCenteredMatrix();
        String string3 = "Xc(standardized):\r\n" + matrix4 + "\r\n\r\n";
        string3 = string3 + "Yc:\r\n" + matrix5 + "\r\n\r\n";
        IO.write(string2, string3, true);
        simPLS.simPlsSave(matrix4, matrix5, n);
        Matrix matrix6 = simPLS.getP();
        matrix3 = simPLS.getR();
        Matrix matrix7 = simPLS.getU();
        Matrix matrix8 = simPLS.getV();
        Matrix matrix9 = simPLS.getQ();
        Matrix matrix10 = simPLS.getT();
        string3 = "Matrices from the PLS decomposition of the Training data.\r\n\r\n";
        string3 = string3 + "P:\r\n" + matrix6 + "\r\n\r\n";
        string3 = string3 + "R:\r\n" + matrix3 + "\r\n\r\n";
        string3 = string3 + "U:\r\n" + matrix7 + "\r\n\r\n";
        string3 = string3 + "V:\r\n" + matrix8 + "\r\n\r\n";
        string3 = string3 + "Q:\r\n" + matrix9 + "\r\n\r\n";
        string3 = string3 + "T:\r\n" + matrix10 + "\r\n\r\n";
        IO.write(string2, string3, true);
        return matrix3;
    }

    public static void testMain01() {
        int n = 10;
        int n2 = 1000;
        int n3 = 1000;
        int n4 = 100;
        int n5 = 10;
        Matrix matrix = MatrixFunctions.getRandomMatrix(n2, n3);
        Matrix matrix2 = MatrixFunctions.getRandomMatrix(n3, n4);
        Matrix matrix3 = new Matrix(matrix);
        Matrix matrix4 = new Matrix();
        Matrix matrix5 = new Matrix();
        Date date = new Date();
        Matrix.getEigenvector(matrix3, n5, matrix5, matrix4);
        Date date2 = new Date();
        long l = date2.getTime() - date.getTime();
        System.out.println("Time: " + l);
    }

    public static void testMainHenrion() {
        Matrix matrix = MatrixTests.testMatrixHenrion01();
        Matrix matrix2 = matrix.getCenteredMatrix();
        System.out.println(matrix2);
        Matrix matrix3 = matrix.getStandardDeviationCols();
        System.out.println(matrix3);
        Matrix matrix4 = matrix.getStandardized();
        System.out.println(matrix4);
    }
}

