/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc;

import com.actelion.research.calc.Matrix;
import com.actelion.research.calc.statistics.median.ModelMedianDouble;
import com.actelion.research.calc.statistics.median.ModelMedianInteger;
import com.actelion.research.util.datamodel.PointDouble;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class ArrayUtilsCalc {
    public static final int[] cat(int[] nArray, int[] nArray2) {
        int n;
        int[] nArray3 = new int[nArray.length + nArray2.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray3[n] = nArray[n];
        }
        for (n = 0; n < nArray2.length; ++n) {
            nArray3[nArray.length + n] = nArray2[n];
        }
        return nArray3;
    }

    public static final boolean contains(int[] nArray, int n) {
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static final int[] copy(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = nArray[i];
        }
        return nArray2;
    }

    public static final byte[] copy(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = byArray[i];
        }
        return byArray2;
    }

    public static final List<int[]> copyIntArray(List<int[]> list) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>(list.size());
        for (int[] nArray : list) {
            int[] nArray2 = new int[nArray.length];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            arrayList.add(nArray2);
        }
        return arrayList;
    }

    public static final Object[] copy(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = objectArray[i];
        }
        return objectArray2;
    }

    public static boolean equals(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static final double[] extractCol(double[][] dArray, int n) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i][n];
        }
        return dArray2;
    }

    public static final double[] filter(int[] nArray, double[] dArray) {
        double[] dArray2 = new double[nArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            double d = 0.0;
            for (int j = 0; j < dArray.length; ++j) {
                int n = -dArray.length / 2 + j;
                int n2 = n + i;
                if (n2 < 0 || n2 >= dArray2.length) continue;
                d += (double)nArray[n2] * dArray[j];
            }
            dArray2[i] = d;
        }
        return dArray2;
    }

    public static final double[] filter(byte[] byArray, double[] dArray) {
        double[] dArray2 = new double[byArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            double d = 0.0;
            for (int j = 0; j < dArray.length; ++j) {
                int n = -dArray.length / 2 + j;
                int n2 = n + i;
                if (n2 < 0 || n2 >= dArray2.length) continue;
                d += (double)byArray[n2] * dArray[j];
            }
            dArray2[i] = d;
        }
        return dArray2;
    }

    public static final boolean findIdentical(int[] nArray, int[] nArray2) {
        boolean bl = false;
        block0: for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                if (nArray[i] != nArray2[j]) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    public static final double getCorrPearson(List<PointDouble> list) {
        double[] dArray = new double[list.size()];
        double[] dArray2 = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            dArray[i] = list.get((int)i).x;
            dArray2[i] = list.get((int)i).y;
        }
        return ArrayUtilsCalc.getCorrPearson(dArray, dArray2);
    }

    public static final double getCorrPearson(Matrix matrix, Matrix matrix2) {
        double[] dArray = matrix.toArray();
        double[] dArray2 = matrix2.toArray();
        return ArrayUtilsCalc.getCorrPearson(dArray, dArray2);
    }

    public static final double getCorrPearson(double[] dArray, double[] dArray2) {
        double[] dArray3 = ArrayUtilsCalc.getCentered(dArray);
        double[] dArray4 = ArrayUtilsCalc.getNormalized(dArray3);
        double[] dArray5 = ArrayUtilsCalc.getCentered(dArray2);
        double[] dArray6 = ArrayUtilsCalc.getNormalized(dArray5);
        double d = ArrayUtilsCalc.getCorrPearsonStandardized(dArray4, dArray6);
        return d;
    }

    public static final double getCorrPearsonStandardized(double[] dArray, double[] dArray2) {
        double d = ArrayUtilsCalc.getCovarianceCentered(dArray, dArray2);
        double d2 = ArrayUtilsCalc.getVariance(dArray);
        double d3 = ArrayUtilsCalc.getVariance(dArray2);
        double d4 = d / (d2 * d3);
        return d4;
    }

    public static double[] getCentered(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        double d = ArrayUtilsCalc.getMean(dArray);
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] - d;
        }
        return dArray2;
    }

    public static double getCovarianceCentered(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray2[i];
        }
        double d2 = d / (double)(dArray.length - 1);
        return d2;
    }

    public static double getGiniCoefficient(double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
            for (int j = 0; j < dArray.length; ++j) {
                d2 = Math.abs(dArray[i] - dArray[j]);
            }
        }
        double d3 = d2 / ((double)(2 * dArray.length) * d);
        return d3;
    }

    public static final double[] getNormalized(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        double d = ArrayUtilsCalc.getStandardDeviation(dArray);
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] / d;
        }
        return dArray2;
    }

    public static final double getMean(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d / (double)dArray.length;
    }

    public static final double getMean(int[] nArray) {
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d += (double)nArray[i];
        }
        return d / (double)nArray.length;
    }

    public static ModelMedianDouble getMedian(double[] dArray) {
        Arrays.sort(dArray);
        ModelMedianDouble modelMedianDouble = new ModelMedianDouble();
        modelMedianDouble.lowerQuartile = ArrayUtilsCalc.getPercentileFromSorted(dArray, 0.25);
        modelMedianDouble.median = ArrayUtilsCalc.getPercentileFromSorted(dArray, 0.5);
        modelMedianDouble.upperQuartile = ArrayUtilsCalc.getPercentileFromSorted(dArray, 0.75);
        modelMedianDouble.size = dArray.length;
        return modelMedianDouble;
    }

    public static ModelMedianInteger getMedian(int[] nArray) {
        Arrays.sort(nArray);
        ModelMedianInteger modelMedianInteger = new ModelMedianInteger();
        modelMedianInteger.lowerQuartile = ArrayUtilsCalc.getPercentileFromSorted(nArray, 0.25);
        modelMedianInteger.median = ArrayUtilsCalc.getPercentileFromSorted(nArray, 0.5);
        modelMedianInteger.upperQuartile = ArrayUtilsCalc.getPercentileFromSorted(nArray, 0.75);
        modelMedianInteger.size = nArray.length;
        return modelMedianInteger;
    }

    public static double getPercentileFromSorted(double[] dArray, double d) {
        if (dArray.length == 1) {
            return dArray[0];
        }
        double d2 = 0.0;
        int n = dArray.length;
        if ((double)((int)((double)n * d)) == (double)n * d) {
            int n2 = (int)((double)n * d) - 1;
            int n3 = n2 + 1;
            if (n2 < 0) {
                throw new RuntimeException("Fraction to small.");
            }
            d2 = (dArray[n2] + dArray[n3]) / 2.0;
        } else {
            int n4 = (int)((double)n * d);
            d2 = dArray[n4];
        }
        return d2;
    }

    public static int getPercentileFromSorted(int[] nArray, double d) {
        if (nArray.length == 1) {
            return nArray[0];
        }
        int n = 0;
        int n2 = nArray.length;
        if ((double)((int)((double)n2 * d)) == (double)n2 * d) {
            int n3 = (int)((double)n2 * d) - 1;
            int n4 = n3 + 1;
            if (n3 < 0) {
                throw new RuntimeException("Fraction to small.");
            }
            n = (int)((double)(nArray[n3] + nArray[n4]) / 2.0 + 0.5);
        } else {
            int n5 = (int)((double)n2 * d);
            n = nArray[n5];
        }
        return n;
    }

    public static final double getStandardDeviation(double[] dArray) {
        double d = 0.0;
        double d2 = ArrayUtilsCalc.getMean(dArray);
        for (int i = 0; i < dArray.length; ++i) {
            d += (dArray[i] - d2) * (dArray[i] - d2);
        }
        double d3 = Math.sqrt(d / (double)(dArray.length - 1));
        return d3;
    }

    public static final double getVariance(double[] dArray) {
        double d = 0.0;
        double d2 = ArrayUtilsCalc.getMean(dArray);
        for (int i = 0; i < dArray.length; ++i) {
            d += (dArray[i] - d2) * (dArray[i] - d2);
        }
        double d3 = d / (double)(dArray.length - 1);
        return d3;
    }

    public static final double getVariance(int[] nArray) {
        double d = 0.0;
        double d2 = ArrayUtilsCalc.getMean(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            d += ((double)nArray[i] - d2) * ((double)nArray[i] - d2);
        }
        double d3 = d / (double)(nArray.length - 1);
        return d3;
    }

    public static final int sum(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i];
        }
        return n;
    }

    public static final int sum(long[] lArray) {
        int n = 0;
        for (int i = 0; i < lArray.length; ++i) {
            n = (int)((long)n + lArray[i]);
        }
        return n;
    }

    public static final int sum(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n += byArray[i];
        }
        return n;
    }

    public static final double sum(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public static final String[] resize(String[] stringArray, int n) {
        String[] stringArray2 = new String[n];
        int n2 = Math.min(stringArray.length, n);
        System.arraycopy(stringArray, 0, stringArray2, 0, n2);
        return stringArray2;
    }

    public static final int[] resize(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        int n2 = Math.min(nArray.length, n);
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    public static final byte[] resize(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        int n2 = Math.min(byArray.length, n);
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public static final boolean[] resize(boolean[] blArray, int n) {
        boolean[] blArray2 = new boolean[n];
        int n2 = Math.min(blArray.length, n);
        System.arraycopy(blArray, 0, blArray2, 0, n2);
        return blArray2;
    }

    public static final double[] resize(double[] dArray, int n) {
        double[] dArray2 = new double[n];
        int n2 = Math.min(dArray.length, n);
        System.arraycopy(dArray, 0, dArray2, 0, n2);
        return dArray2;
    }

    public static final void removeDoubletsInt(List<int[]> list) {
        block0: for (int i = 0; i < list.size(); ++i) {
            for (int j = list.size() - 1; j > i; --j) {
                int[] nArray = list.get(i);
                int[] nArray2 = list.get(j);
                boolean bl = true;
                if (nArray2.length != nArray.length) {
                    bl = false;
                    continue block0;
                }
                for (int k = 0; k < nArray2.length; ++k) {
                    if (nArray[k] == nArray2[k]) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                list.remove(j);
            }
        }
    }

    public static final void removeDoubletsIntOrderIndepend(List<int[]> list) {
        for (int i = 0; i < list.size(); ++i) {
            for (int j = list.size() - 1; j > i; --j) {
                int[] nArray = list.get(i);
                int[] nArray2 = list.get(j);
                boolean bl = true;
                for (int k = 0; k < nArray.length; ++k) {
                    boolean bl2 = false;
                    for (int i2 = 0; i2 < nArray2.length; ++i2) {
                        if (nArray[k] != nArray2[i2]) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                list.remove(j);
            }
        }
    }

    public static final double[][] resize(double[][] dArray, int n, int n2) {
        double[][] dArray2 = new double[n][n2];
        int n3 = n;
        int n4 = n2;
        if (n > dArray.length) {
            n3 = dArray.length;
        }
        if (n2 > dArray[0].length) {
            n4 = dArray[0].length;
        }
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                dArray2[i][j] = dArray[i][j];
            }
        }
        return dArray2;
    }

    public static final boolean[][] resize(boolean[][] blArray, int n) {
        return ArrayUtilsCalc.resize(blArray, n, blArray[0].length);
    }

    public static final boolean[][] resize(boolean[][] blArray, int n, int n2) {
        boolean[][] blArray2 = new boolean[n][n2];
        int n3 = n;
        int n4 = n2;
        if (n > blArray.length) {
            n3 = blArray.length;
        }
        if (n2 > blArray[0].length) {
            n4 = blArray[0].length;
        }
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                blArray2[i][j] = blArray[i][j];
            }
        }
        return blArray2;
    }

    public static final int[] reverse(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[nArray2.length - i - 1] = nArray[i];
        }
        return nArray2;
    }

    public static final void reverse(Object[] objectArray) {
        for (int i = 0; i < objectArray.length / 2; ++i) {
            Object object = objectArray[objectArray.length - i - 1];
            objectArray[objectArray.length - i - 1] = objectArray[i];
            objectArray[i] = object;
        }
    }

    public static List<Integer> getOverlap(int[] nArray, int[] nArray2) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int i = 0; i < nArray.length; ++i) {
            treeSet.add(nArray[i]);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < nArray2.length; ++i) {
            if (treeSet.add(nArray2[i])) continue;
            arrayList.add(nArray2[i]);
        }
        return arrayList;
    }

    public static List<Integer> getUnique(int[] nArray, int[] nArray2) {
        int n;
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (n = 0; n < nArray.length; ++n) {
            treeSet.add(nArray[n]);
        }
        for (n = 0; n < nArray2.length; ++n) {
            treeSet.add(nArray2[n]);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(treeSet);
        return arrayList;
    }

    public static final int[] getUnique(int[] nArray) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int i = 0; i < nArray.length; ++i) {
            treeSet.add(nArray[i]);
        }
        int[] nArray2 = ArrayUtilsCalc.toIntArray(treeSet);
        return nArray2;
    }

    public static final int[] toIntArray(Collection<Integer> collection) {
        int[] nArray = new int[collection.size()];
        int n = 0;
        for (Integer n2 : collection) {
            nArray[n++] = n2;
        }
        return nArray;
    }

    public static final String[] toArray(List<String> list) {
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = list.get(i);
        }
        return stringArray;
    }

    public static final String[][] toArrayStrStr(List<List<String>> list) {
        String[][] stringArray = new String[list.size()][list.get(0).size()];
        for (int i = 0; i < list.size(); ++i) {
            for (int j = 0; j < list.get(i).size(); ++j) {
                stringArray[i][j] = list.get(i).get(j);
            }
        }
        return stringArray;
    }

    public static final double[] toDoubleArray(List<Double> list) {
        double[] dArray = new double[list.size()];
        int n = 0;
        for (double d : list) {
            dArray[n++] = d;
        }
        return dArray;
    }

    public static final double[] toDoubleArray(int[] nArray) {
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            dArray[i] = nArray[i];
        }
        return dArray;
    }

    public static final int[] toIntArray(double[] dArray) {
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            nArray[i] = (int)dArray[i];
        }
        return nArray;
    }

    public static final List<Integer> toList(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(nArray[i]);
        }
        return arrayList;
    }

    public static final List<String> toList(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public static final int indexOf(Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!objectArray[i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOf(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static final int lastIndexOf(int[] nArray, int n) {
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static final int lastIndexOfNot(byte[] byArray, int n) {
        for (int i = byArray.length - 1; i >= 0; --i) {
            if (byArray[i] == n) continue;
            return i;
        }
        return -1;
    }

    public static final double min(double[] dArray) {
        if (dArray.length == 0) {
            return 0.0;
        }
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            d = Math.min(d, dArray[i]);
        }
        return d;
    }

    public static final int min(int[] nArray) {
        if (nArray.length == 0) {
            return 0;
        }
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            n = Math.min(n, nArray[i]);
        }
        return n;
    }

    public static final double min(double[][] dArray, int n) {
        if (dArray.length == 0) {
            return 0.0;
        }
        double d = dArray[0][n];
        for (int i = 1; i < dArray.length; ++i) {
            d = Math.min(d, dArray[i][n]);
        }
        return d;
    }

    public static final double min(float[][] fArray, int n) {
        if (fArray.length == 0) {
            return 0.0;
        }
        float f = fArray[0][n];
        for (int i = 1; i < fArray.length; ++i) {
            f = Math.min(f, fArray[i][n]);
        }
        return f;
    }

    public static final byte max(byte[] byArray) {
        if (byArray.length == 0) {
            return 0;
        }
        byte by = byArray[0];
        for (int i = 1; i < byArray.length; ++i) {
            by = (byte)Math.max(by, byArray[i]);
        }
        return by;
    }

    public static final double max(double[] dArray) {
        if (dArray.length == 0) {
            return 0.0;
        }
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            d = Math.max(d, dArray[i]);
        }
        return d;
    }

    public static final double maxDouble(List<Double> list) {
        if (list.size() == 0) {
            return 0.0;
        }
        double d = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            d = Math.max(d, list.get(i));
        }
        return d;
    }

    public static final int maxInt(List<Integer> list) {
        if (list.size() == 0) {
            return 0;
        }
        int n = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            n = Math.max(n, list.get(i));
        }
        return n;
    }

    public static final double max(double[][] dArray, int n) {
        if (dArray.length == 0) {
            return 0.0;
        }
        double d = dArray[0][n];
        for (int i = 1; i < dArray.length; ++i) {
            d = Math.max(d, dArray[i][n]);
        }
        return d;
    }

    public static final double max(float[][] fArray, int n) {
        if (fArray.length == 0) {
            return 0.0;
        }
        float f = fArray[0][n];
        for (int i = 1; i < fArray.length; ++i) {
            f = Math.max(f, fArray[i][n]);
        }
        return f;
    }

    public static final int max(int[] nArray) {
        if (nArray.length == 0) {
            return 0;
        }
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            n = Math.max(n, nArray[i]);
        }
        return n;
    }

    public static int[] readIntArray(String string) {
        return ArrayUtilsCalc.readIntArray(string, ",");
    }

    public static int[] readIntArray(String string, String string2) {
        string = string.replace('[', ' ');
        string = string.replace(']', ' ');
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(Integer.parseInt(stringTokenizer.nextToken().trim()));
        }
        return ArrayUtilsCalc.toIntArray(arrayList);
    }

    public static double[] readDoubleArray(String string) {
        return ArrayUtilsCalc.readDoubleArray(string, ",");
    }

    public static double[] readDoubleArray(String string, String string2) {
        string = string.replace('[', ' ');
        string = string.replace(']', ' ');
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(Double.parseDouble(stringTokenizer.nextToken().trim()));
        }
        return ArrayUtilsCalc.toDoubleArray(arrayList);
    }

    public static final void set(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n;
        }
    }

    public static final void set(float[] fArray, float f) {
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = f;
        }
    }

    public static final void set(double[] dArray, double d) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = d;
        }
    }

    public static final void set(int[][] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[0].length; ++j) {
                nArray[i][j] = n;
            }
        }
    }

    public static final void set(short[][] sArray, short s) {
        for (int i = 0; i < sArray.length; ++i) {
            for (int j = 0; j < sArray[0].length; ++j) {
                sArray[i][j] = s;
            }
        }
    }

    public static final void set(double[][] dArray, double d) {
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                dArray[i][j] = d;
            }
        }
    }

    public static final void set(float[][] fArray, float f) {
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray[0].length; ++j) {
                fArray[i][j] = f;
            }
        }
    }

    public static final String toStringBinary(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < nArray.length; ++i) {
            stringBuilder.append(ArrayUtilsCalc.toStringBinary(nArray[i]));
            if (i >= nArray.length - 1) continue;
            stringBuilder.append(" ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String toStringBinary(int n) {
        String string = "";
        int n2 = 32;
        for (int i = 0; i < n2; ++i) {
            string = (n & 1) == 1 ? "1 " + string : "0 " + string;
            n >>= 1;
        }
        return string.trim();
    }

    public static final String toString(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < nArray.length; ++i) {
            stringBuilder.append((i > 0 ? "," : "") + nArray[i]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static final String toString(Collection<Integer> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        int n = 0;
        for (int n2 : collection) {
            stringBuilder.append((n > 0 ? "," : "") + n2);
            ++n;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static final String toStringNoBrackets(Collection<Integer> collection, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (int n2 : collection) {
            stringBuilder.append((n > 0 ? string : "") + n2);
            ++n;
        }
        return stringBuilder.toString();
    }

    public static final String toStringIntegerList(List<Integer> list, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); i += n) {
            if (i + n > list.size()) {
                n = list.size() - i;
            }
            for (int j = i; j < i + n; ++j) {
                stringBuilder.append(list.get(j));
                if (j >= i + n - 1) continue;
                stringBuilder.append(" ");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static final String toStringLongList(List<Long> list, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); i += n) {
            if (i + n > list.size()) {
                n = list.size() - i;
            }
            for (int j = i; j < i + n; ++j) {
                stringBuilder.append(list.get(j));
                if (j >= i + n - 1) continue;
                stringBuilder.append(" ");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static final String[] toStringArray(List<Integer> list) {
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = Integer.toString(list.get(i));
        }
        return stringArray;
    }

    public static final String toString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            stringBuilder.append((i > 0 ? ", " : "") + n);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static final String toStringPure(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuilder.append((i > 0 ? " " : "") + nArray[i]);
        }
        return stringBuilder.toString();
    }

    public static final String toStringIntArrays(List<int[]> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int[] nArray : list) {
            stringBuilder.append(ArrayUtilsCalc.toString(nArray) + "\n");
        }
        return stringBuilder.toString();
    }

    public static final String toString(int[][] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[0].length; ++j) {
                stringBuilder.append((j > 0 ? "," : "") + nArray[i][j]);
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static final String toStringFormatted(int[] nArray, int[] nArray2) {
        int[][] nArrayArray = new int[][]{nArray, nArray2};
        return ArrayUtilsCalc.toStringFormatted(nArrayArray);
    }

    public static final String toStringFormatted(int[][] nArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            for (int i = 0; i < nArray[0].length; ++i) {
                if (Math.abs(nArray[n][i]) <= n2) continue;
                n2 = Math.abs(nArray[n][i]);
            }
        }
        n = Integer.toString(n2).length() + 1;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[0].length; ++j) {
                StringBuilder stringBuilder2 = new StringBuilder(Integer.toString(nArray[i][j]));
                while (stringBuilder2.length() < n) {
                    stringBuilder2.insert(0, " ");
                }
                stringBuilder.append((CharSequence)stringBuilder2);
                if (j >= nArray[0].length - 1) continue;
                stringBuilder.append(" ");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static final String toString(double[] dArray) {
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int i = 0; i < dArray.length; ++i) {
            stringBuilder.append((i > 0 ? "," : "") + dArray[i]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static final String toStringPure(double[] dArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < dArray.length; ++i) {
            stringBuilder.append((i > 0 ? "\t" : "") + dArray[i]);
        }
        return stringBuilder.toString();
    }

    public static final String toString(double[] dArray, NumberFormat numberFormat) {
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int i = 0; i < dArray.length; ++i) {
            stringBuilder.append((i > 0 ? "," : "") + numberFormat.format(dArray[i]));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static final String toString(double[][] dArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                stringBuilder.append((j > 0 ? "," : "") + dArray[i][j]);
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static final String toString(double[] dArray, int n) {
        String string = "";
        string = string + "0";
        int n2 = 0;
        if (n > 0) {
            string = string + ".";
        }
        while (n2 < n) {
            string = string + "0";
            ++n2;
        }
        DecimalFormat decimalFormat = new DecimalFormat(string);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < dArray.length; ++i) {
            stringBuilder.append((i > 0 ? "," : "") + decimalFormat.format(dArray[i]));
        }
        return stringBuilder.toString();
    }

    public static final String toString(float[] fArray, int n) {
        String string = "";
        string = string + "0";
        int n2 = 0;
        if (n > 0) {
            string = string + ".";
        }
        while (n2 < n) {
            string = string + "0";
            ++n2;
        }
        DecimalFormat decimalFormat = new DecimalFormat(string);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < fArray.length; ++i) {
            stringBuilder.append((i > 0 ? "," : "") + decimalFormat.format(fArray[i]));
        }
        return stringBuilder.toString();
    }

    public static final String toString(double[][] dArray, int n) {
        String string = "";
        string = string + "0";
        int n2 = 0;
        if (n > 0) {
            string = string + ".";
        }
        while (n2 < n) {
            string = string + "0";
            ++n2;
        }
        DecimalFormat decimalFormat = new DecimalFormat(string);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                stringBuilder.append((j > 0 ? " " : "") + decimalFormat.format(dArray[i][j]));
            }
            stringBuilder.append(i < dArray.length - 1 ? "\n" : "");
        }
        return stringBuilder.toString();
    }

    public static final String toStringNoDigits(double[] dArray) {
        DecimalFormat decimalFormat = new DecimalFormat("0");
        String string = "";
        for (int i = 0; i < dArray.length; ++i) {
            string = string + (i > 0 ? "," : "") + decimalFormat.format(dArray[i]);
        }
        return string + "";
    }

    public static final String toString(Object[] objectArray) {
        String string = "[";
        for (int i = 0; i < objectArray.length; ++i) {
            string = string + (i > 0 ? "," : "") + objectArray[i];
        }
        return string + "]";
    }

    public static final void shift(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[(i + n + nArray.length) % nArray.length];
        }
        System.arraycopy(nArray2, 0, nArray, 0, nArray.length);
    }

    public static final List<Integer> parseInteger(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (stringTokenizer.hasMoreTokens()) {
            int n = Integer.parseInt(stringTokenizer.nextToken());
            arrayList.add(n);
        }
        return arrayList;
    }
}

