/*
 * Decompiled with CFR 0.152.
 */
package smile.sort;

import java.util.Comparator;
import smile.sort.SortUtils;

public class QuickSort {
    private static final int M = 7;
    private static final int NSTACK = 64;

    private QuickSort() {
    }

    public static int[] sort(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = i;
        }
        QuickSort.sort(nArray, nArray2);
        return nArray2;
    }

    public static void sort(int[] nArray, int[] nArray2) {
        QuickSort.sort(nArray, nArray2, nArray.length);
    }

    public static void sort(int[] nArray, int[] nArray2, int n) {
        int n2 = -1;
        int n3 = 0;
        int[] nArray3 = new int[64];
        int n4 = n - 1;
        while (true) {
            int n5;
            int n6;
            int n7;
            int n8;
            if (n4 - n3 < 7) {
                for (n8 = n3 + 1; n8 <= n4; ++n8) {
                    n7 = nArray[n8];
                    n6 = nArray2[n8];
                    for (n5 = n8 - 1; n5 >= n3 && nArray[n5] > n7; --n5) {
                        nArray[n5 + 1] = nArray[n5];
                        nArray2[n5 + 1] = nArray2[n5];
                    }
                    nArray[n5 + 1] = n7;
                    nArray2[n5 + 1] = n6;
                }
                if (n2 < 0) break;
                n4 = nArray3[n2--];
                n3 = nArray3[n2--];
                continue;
            }
            int n9 = n3 + n4 >> 1;
            SortUtils.swap(nArray, n9, n3 + 1);
            SortUtils.swap(nArray2, n9, n3 + 1);
            if (nArray[n3] > nArray[n4]) {
                SortUtils.swap(nArray, n3, n4);
                SortUtils.swap(nArray2, n3, n4);
            }
            if (nArray[n3 + 1] > nArray[n4]) {
                SortUtils.swap(nArray, n3 + 1, n4);
                SortUtils.swap(nArray2, n3 + 1, n4);
            }
            if (nArray[n3] > nArray[n3 + 1]) {
                SortUtils.swap(nArray, n3, n3 + 1);
                SortUtils.swap(nArray2, n3, n3 + 1);
            }
            n5 = n3 + 1;
            n8 = n4;
            n7 = nArray[n3 + 1];
            n6 = nArray2[n3 + 1];
            while (true) {
                if (nArray[++n5] < n7) {
                    continue;
                }
                while (nArray[--n8] > n7) {
                }
                if (n8 < n5) break;
                SortUtils.swap(nArray, n5, n8);
                SortUtils.swap(nArray2, n5, n8);
            }
            nArray[n3 + 1] = nArray[n8];
            nArray[n8] = n7;
            nArray2[n3 + 1] = nArray2[n8];
            nArray2[n8] = n6;
            if ((n2 += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (n4 - n5 + 1 >= n8 - n3) {
                nArray3[n2] = n4;
                nArray3[n2 - 1] = n5;
                n4 = n8 - 1;
                continue;
            }
            nArray3[n2] = n8 - 1;
            nArray3[n2 - 1] = n3;
            n3 = n5;
        }
    }

    public static void sort(int[] nArray, Object[] objectArray) {
        QuickSort.sort(nArray, objectArray, nArray.length);
    }

    public static void sort(int[] nArray, Object[] objectArray, int n) {
        int n2 = -1;
        int n3 = 0;
        int[] nArray2 = new int[64];
        int n4 = n - 1;
        while (true) {
            int n5;
            Object object;
            int n6;
            int n7;
            if (n4 - n3 < 7) {
                for (n7 = n3 + 1; n7 <= n4; ++n7) {
                    n6 = nArray[n7];
                    object = objectArray[n7];
                    for (n5 = n7 - 1; n5 >= n3 && nArray[n5] > n6; --n5) {
                        nArray[n5 + 1] = nArray[n5];
                        objectArray[n5 + 1] = objectArray[n5];
                    }
                    nArray[n5 + 1] = n6;
                    objectArray[n5 + 1] = object;
                }
                if (n2 < 0) break;
                n4 = nArray2[n2--];
                n3 = nArray2[n2--];
                continue;
            }
            int n8 = n3 + n4 >> 1;
            SortUtils.swap(nArray, n8, n3 + 1);
            SortUtils.swap(objectArray, n8, n3 + 1);
            if (nArray[n3] > nArray[n4]) {
                SortUtils.swap(nArray, n3, n4);
                SortUtils.swap(objectArray, n3, n4);
            }
            if (nArray[n3 + 1] > nArray[n4]) {
                SortUtils.swap(nArray, n3 + 1, n4);
                SortUtils.swap(objectArray, n3 + 1, n4);
            }
            if (nArray[n3] > nArray[n3 + 1]) {
                SortUtils.swap(nArray, n3, n3 + 1);
                SortUtils.swap(objectArray, n3, n3 + 1);
            }
            n5 = n3 + 1;
            n7 = n4;
            n6 = nArray[n3 + 1];
            object = objectArray[n3 + 1];
            while (true) {
                if (nArray[++n5] < n6) {
                    continue;
                }
                while (nArray[--n7] > n6) {
                }
                if (n7 < n5) break;
                SortUtils.swap(nArray, n5, n7);
                SortUtils.swap(objectArray, n5, n7);
            }
            nArray[n3 + 1] = nArray[n7];
            nArray[n7] = n6;
            objectArray[n3 + 1] = objectArray[n7];
            objectArray[n7] = object;
            if ((n2 += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (n4 - n5 + 1 >= n7 - n3) {
                nArray2[n2] = n4;
                nArray2[n2 - 1] = n5;
                n4 = n7 - 1;
                continue;
            }
            nArray2[n2] = n7 - 1;
            nArray2[n2 - 1] = n3;
            n3 = n5;
        }
    }

    public static int[] sort(float[] fArray) {
        int[] nArray = new int[fArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        QuickSort.sort(fArray, nArray);
        return nArray;
    }

    public static void sort(float[] fArray, int[] nArray) {
        QuickSort.sort(fArray, nArray, fArray.length);
    }

    public static void sort(float[] fArray, int[] nArray, int n) {
        int n2 = -1;
        int n3 = 0;
        int[] nArray2 = new int[64];
        int n4 = n - 1;
        while (true) {
            int n5;
            int n6;
            float f;
            int n7;
            if (n4 - n3 < 7) {
                for (n7 = n3 + 1; n7 <= n4; ++n7) {
                    f = fArray[n7];
                    n6 = nArray[n7];
                    for (n5 = n7 - 1; n5 >= n3 && !(fArray[n5] <= f); --n5) {
                        fArray[n5 + 1] = fArray[n5];
                        nArray[n5 + 1] = nArray[n5];
                    }
                    fArray[n5 + 1] = f;
                    nArray[n5 + 1] = n6;
                }
                if (n2 < 0) break;
                n4 = nArray2[n2--];
                n3 = nArray2[n2--];
                continue;
            }
            int n8 = n3 + n4 >> 1;
            SortUtils.swap(fArray, n8, n3 + 1);
            SortUtils.swap(nArray, n8, n3 + 1);
            if (fArray[n3] > fArray[n4]) {
                SortUtils.swap(fArray, n3, n4);
                SortUtils.swap(nArray, n3, n4);
            }
            if (fArray[n3 + 1] > fArray[n4]) {
                SortUtils.swap(fArray, n3 + 1, n4);
                SortUtils.swap(nArray, n3 + 1, n4);
            }
            if (fArray[n3] > fArray[n3 + 1]) {
                SortUtils.swap(fArray, n3, n3 + 1);
                SortUtils.swap(nArray, n3, n3 + 1);
            }
            n5 = n3 + 1;
            n7 = n4;
            f = fArray[n3 + 1];
            n6 = nArray[n3 + 1];
            while (true) {
                if (fArray[++n5] < f) {
                    continue;
                }
                while (fArray[--n7] > f) {
                }
                if (n7 < n5) break;
                SortUtils.swap(fArray, n5, n7);
                SortUtils.swap(nArray, n5, n7);
            }
            fArray[n3 + 1] = fArray[n7];
            fArray[n7] = f;
            nArray[n3 + 1] = nArray[n7];
            nArray[n7] = n6;
            if ((n2 += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (n4 - n5 + 1 >= n7 - n3) {
                nArray2[n2] = n4;
                nArray2[n2 - 1] = n5;
                n4 = n7 - 1;
                continue;
            }
            nArray2[n2] = n7 - 1;
            nArray2[n2 - 1] = n3;
            n3 = n5;
        }
    }

    public static void sort(float[] fArray, float[] fArray2) {
        QuickSort.sort(fArray, fArray2, fArray.length);
    }

    public static void sort(float[] fArray, float[] fArray2, int n) {
        int n2 = -1;
        int n3 = 0;
        int[] nArray = new int[64];
        int n4 = n - 1;
        while (true) {
            int n5;
            float f;
            float f2;
            int n6;
            if (n4 - n3 < 7) {
                for (n6 = n3 + 1; n6 <= n4; ++n6) {
                    f2 = fArray[n6];
                    f = fArray2[n6];
                    for (n5 = n6 - 1; n5 >= n3 && !(fArray[n5] <= f2); --n5) {
                        fArray[n5 + 1] = fArray[n5];
                        fArray2[n5 + 1] = fArray2[n5];
                    }
                    fArray[n5 + 1] = f2;
                    fArray2[n5 + 1] = f;
                }
                if (n2 < 0) break;
                n4 = nArray[n2--];
                n3 = nArray[n2--];
                continue;
            }
            int n7 = n3 + n4 >> 1;
            SortUtils.swap(fArray, n7, n3 + 1);
            SortUtils.swap(fArray2, n7, n3 + 1);
            if (fArray[n3] > fArray[n4]) {
                SortUtils.swap(fArray, n3, n4);
                SortUtils.swap(fArray2, n3, n4);
            }
            if (fArray[n3 + 1] > fArray[n4]) {
                SortUtils.swap(fArray, n3 + 1, n4);
                SortUtils.swap(fArray2, n3 + 1, n4);
            }
            if (fArray[n3] > fArray[n3 + 1]) {
                SortUtils.swap(fArray, n3, n3 + 1);
                SortUtils.swap(fArray2, n3, n3 + 1);
            }
            n5 = n3 + 1;
            n6 = n4;
            f2 = fArray[n3 + 1];
            f = fArray2[n3 + 1];
            while (true) {
                if (fArray[++n5] < f2) {
                    continue;
                }
                while (fArray[--n6] > f2) {
                }
                if (n6 < n5) break;
                SortUtils.swap(fArray, n5, n6);
                SortUtils.swap(fArray2, n5, n6);
            }
            fArray[n3 + 1] = fArray[n6];
            fArray[n6] = f2;
            fArray2[n3 + 1] = fArray2[n6];
            fArray2[n6] = f;
            if ((n2 += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (n4 - n5 + 1 >= n6 - n3) {
                nArray[n2] = n4;
                nArray[n2 - 1] = n5;
                n4 = n6 - 1;
                continue;
            }
            nArray[n2] = n6 - 1;
            nArray[n2 - 1] = n3;
            n3 = n5;
        }
    }

    public static void sort(float[] fArray, Object[] objectArray) {
        QuickSort.sort(fArray, objectArray, fArray.length);
    }

    public static void sort(float[] fArray, Object[] objectArray, int n) {
        int n2 = -1;
        int n3 = 0;
        int[] nArray = new int[64];
        int n4 = n - 1;
        while (true) {
            int n5;
            Object object;
            float f;
            int n6;
            if (n4 - n3 < 7) {
                for (n6 = n3 + 1; n6 <= n4; ++n6) {
                    f = fArray[n6];
                    object = objectArray[n6];
                    for (n5 = n6 - 1; n5 >= n3 && !(fArray[n5] <= f); --n5) {
                        fArray[n5 + 1] = fArray[n5];
                        objectArray[n5 + 1] = objectArray[n5];
                    }
                    fArray[n5 + 1] = f;
                    objectArray[n5 + 1] = object;
                }
                if (n2 < 0) break;
                n4 = nArray[n2--];
                n3 = nArray[n2--];
                continue;
            }
            int n7 = n3 + n4 >> 1;
            SortUtils.swap(fArray, n7, n3 + 1);
            SortUtils.swap(objectArray, n7, n3 + 1);
            if (fArray[n3] > fArray[n4]) {
                SortUtils.swap(fArray, n3, n4);
                SortUtils.swap(objectArray, n3, n4);
            }
            if (fArray[n3 + 1] > fArray[n4]) {
                SortUtils.swap(fArray, n3 + 1, n4);
                SortUtils.swap(objectArray, n3 + 1, n4);
            }
            if (fArray[n3] > fArray[n3 + 1]) {
                SortUtils.swap(fArray, n3, n3 + 1);
                SortUtils.swap(objectArray, n3, n3 + 1);
            }
            n5 = n3 + 1;
            n6 = n4;
            f = fArray[n3 + 1];
            object = objectArray[n3 + 1];
            while (true) {
                if (fArray[++n5] < f) {
                    continue;
                }
                while (fArray[--n6] > f) {
                }
                if (n6 < n5) break;
                SortUtils.swap(fArray, n5, n6);
                SortUtils.swap(objectArray, n5, n6);
            }
            fArray[n3 + 1] = fArray[n6];
            fArray[n6] = f;
            objectArray[n3 + 1] = objectArray[n6];
            objectArray[n6] = object;
            if ((n2 += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (n4 - n5 + 1 >= n6 - n3) {
                nArray[n2] = n4;
                nArray[n2 - 1] = n5;
                n4 = n6 - 1;
                continue;
            }
            nArray[n2] = n6 - 1;
            nArray[n2 - 1] = n3;
            n3 = n5;
        }
    }

    public static int[] sort(double[] dArray) {
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        QuickSort.sort(dArray, nArray);
        return nArray;
    }

    public static void sort(double[] dArray, int[] nArray) {
        QuickSort.sort(dArray, nArray, dArray.length);
    }

    public static void sort(double[] dArray, int[] nArray, int n) {
        int n2 = -1;
        int n3 = 0;
        int[] nArray2 = new int[64];
        int n4 = n - 1;
        while (true) {
            int n5;
            int n6;
            double d;
            int n7;
            if (n4 - n3 < 7) {
                for (n7 = n3 + 1; n7 <= n4; ++n7) {
                    d = dArray[n7];
                    n6 = nArray[n7];
                    for (n5 = n7 - 1; n5 >= n3 && !(dArray[n5] <= d); --n5) {
                        dArray[n5 + 1] = dArray[n5];
                        nArray[n5 + 1] = nArray[n5];
                    }
                    dArray[n5 + 1] = d;
                    nArray[n5 + 1] = n6;
                }
                if (n2 < 0) break;
                n4 = nArray2[n2--];
                n3 = nArray2[n2--];
                continue;
            }
            int n8 = n3 + n4 >> 1;
            SortUtils.swap(dArray, n8, n3 + 1);
            SortUtils.swap(nArray, n8, n3 + 1);
            if (dArray[n3] > dArray[n4]) {
                SortUtils.swap(dArray, n3, n4);
                SortUtils.swap(nArray, n3, n4);
            }
            if (dArray[n3 + 1] > dArray[n4]) {
                SortUtils.swap(dArray, n3 + 1, n4);
                SortUtils.swap(nArray, n3 + 1, n4);
            }
            if (dArray[n3] > dArray[n3 + 1]) {
                SortUtils.swap(dArray, n3, n3 + 1);
                SortUtils.swap(nArray, n3, n3 + 1);
            }
            n5 = n3 + 1;
            n7 = n4;
            d = dArray[n3 + 1];
            n6 = nArray[n3 + 1];
            while (true) {
                if (dArray[++n5] < d) {
                    continue;
                }
                while (dArray[--n7] > d) {
                }
                if (n7 < n5) break;
                SortUtils.swap(dArray, n5, n7);
                SortUtils.swap(nArray, n5, n7);
            }
            dArray[n3 + 1] = dArray[n7];
            dArray[n7] = d;
            nArray[n3 + 1] = nArray[n7];
            nArray[n7] = n6;
            if ((n2 += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (n4 - n5 + 1 >= n7 - n3) {
                nArray2[n2] = n4;
                nArray2[n2 - 1] = n5;
                n4 = n7 - 1;
                continue;
            }
            nArray2[n2] = n7 - 1;
            nArray2[n2 - 1] = n3;
            n3 = n5;
        }
    }

    public static void sort(double[] dArray, double[] dArray2) {
        QuickSort.sort(dArray, dArray2, dArray.length);
    }

    public static void sort(double[] dArray, double[] dArray2, int n) {
        int n2 = -1;
        int n3 = 0;
        int[] nArray = new int[64];
        int n4 = n - 1;
        while (true) {
            int n5;
            double d;
            double d2;
            int n6;
            if (n4 - n3 < 7) {
                for (n6 = n3 + 1; n6 <= n4; ++n6) {
                    d2 = dArray[n6];
                    d = dArray2[n6];
                    for (n5 = n6 - 1; n5 >= n3 && !(dArray[n5] <= d2); --n5) {
                        dArray[n5 + 1] = dArray[n5];
                        dArray2[n5 + 1] = dArray2[n5];
                    }
                    dArray[n5 + 1] = d2;
                    dArray2[n5 + 1] = d;
                }
                if (n2 < 0) break;
                n4 = nArray[n2--];
                n3 = nArray[n2--];
                continue;
            }
            int n7 = n3 + n4 >> 1;
            SortUtils.swap(dArray, n7, n3 + 1);
            SortUtils.swap(dArray2, n7, n3 + 1);
            if (dArray[n3] > dArray[n4]) {
                SortUtils.swap(dArray, n3, n4);
                SortUtils.swap(dArray2, n3, n4);
            }
            if (dArray[n3 + 1] > dArray[n4]) {
                SortUtils.swap(dArray, n3 + 1, n4);
                SortUtils.swap(dArray2, n3 + 1, n4);
            }
            if (dArray[n3] > dArray[n3 + 1]) {
                SortUtils.swap(dArray, n3, n3 + 1);
                SortUtils.swap(dArray2, n3, n3 + 1);
            }
            n5 = n3 + 1;
            n6 = n4;
            d2 = dArray[n3 + 1];
            d = dArray2[n3 + 1];
            while (true) {
                if (dArray[++n5] < d2) {
                    continue;
                }
                while (dArray[--n6] > d2) {
                }
                if (n6 < n5) break;
                SortUtils.swap(dArray, n5, n6);
                SortUtils.swap(dArray2, n5, n6);
            }
            dArray[n3 + 1] = dArray[n6];
            dArray[n6] = d2;
            dArray2[n3 + 1] = dArray2[n6];
            dArray2[n6] = d;
            if ((n2 += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (n4 - n5 + 1 >= n6 - n3) {
                nArray[n2] = n4;
                nArray[n2 - 1] = n5;
                n4 = n6 - 1;
                continue;
            }
            nArray[n2] = n6 - 1;
            nArray[n2 - 1] = n3;
            n3 = n5;
        }
    }

    public static void sort(double[] dArray, Object[] objectArray) {
        QuickSort.sort(dArray, objectArray, dArray.length);
    }

    public static void sort(double[] dArray, Object[] objectArray, int n) {
        int n2 = -1;
        int n3 = 0;
        int[] nArray = new int[64];
        int n4 = n - 1;
        while (true) {
            int n5;
            Object object;
            double d;
            int n6;
            if (n4 - n3 < 7) {
                for (n6 = n3 + 1; n6 <= n4; ++n6) {
                    d = dArray[n6];
                    object = objectArray[n6];
                    for (n5 = n6 - 1; n5 >= n3 && !(dArray[n5] <= d); --n5) {
                        dArray[n5 + 1] = dArray[n5];
                        objectArray[n5 + 1] = objectArray[n5];
                    }
                    dArray[n5 + 1] = d;
                    objectArray[n5 + 1] = object;
                }
                if (n2 < 0) break;
                n4 = nArray[n2--];
                n3 = nArray[n2--];
                continue;
            }
            int n7 = n3 + n4 >> 1;
            SortUtils.swap(dArray, n7, n3 + 1);
            SortUtils.swap(objectArray, n7, n3 + 1);
            if (dArray[n3] > dArray[n4]) {
                SortUtils.swap(dArray, n3, n4);
                SortUtils.swap(objectArray, n3, n4);
            }
            if (dArray[n3 + 1] > dArray[n4]) {
                SortUtils.swap(dArray, n3 + 1, n4);
                SortUtils.swap(objectArray, n3 + 1, n4);
            }
            if (dArray[n3] > dArray[n3 + 1]) {
                SortUtils.swap(dArray, n3, n3 + 1);
                SortUtils.swap(objectArray, n3, n3 + 1);
            }
            n5 = n3 + 1;
            n6 = n4;
            d = dArray[n3 + 1];
            object = objectArray[n3 + 1];
            while (true) {
                if (dArray[++n5] < d) {
                    continue;
                }
                while (dArray[--n6] > d) {
                }
                if (n6 < n5) break;
                SortUtils.swap(dArray, n5, n6);
                SortUtils.swap(objectArray, n5, n6);
            }
            dArray[n3 + 1] = dArray[n6];
            dArray[n6] = d;
            objectArray[n3 + 1] = objectArray[n6];
            objectArray[n6] = object;
            if ((n2 += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (n4 - n5 + 1 >= n6 - n3) {
                nArray[n2] = n4;
                nArray[n2 - 1] = n5;
                n4 = n6 - 1;
                continue;
            }
            nArray[n2] = n6 - 1;
            nArray[n2 - 1] = n3;
            n3 = n5;
        }
    }

    public static <T extends Comparable<? super T>> int[] sort(T[] TArray) {
        int[] nArray = new int[TArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        QuickSort.sort(TArray, (int[])nArray);
        return nArray;
    }

    public static <T extends Comparable<? super T>> void sort(T[] TArray, int[] nArray) {
        QuickSort.sort(TArray, (int[])nArray, (int)TArray.length);
    }

    public static <T extends Comparable<? super T>> void sort(T[] TArray, int[] nArray, int n) {
        int n2 = -1;
        int n3 = 0;
        int[] nArray2 = new int[64];
        int n4 = n - 1;
        while (true) {
            int n5;
            int n6;
            T t;
            int n7;
            if (n4 - n3 < 7) {
                for (n7 = n3 + 1; n7 <= n4; ++n7) {
                    t = TArray[n7];
                    n6 = nArray[n7];
                    for (n5 = n7 - 1; n5 >= n3 && TArray[n5].compareTo(t) > 0; --n5) {
                        TArray[n5 + 1] = TArray[n5];
                        nArray[n5 + 1] = nArray[n5];
                    }
                    TArray[n5 + 1] = t;
                    nArray[n5 + 1] = n6;
                }
                if (n2 < 0) break;
                n4 = nArray2[n2--];
                n3 = nArray2[n2--];
                continue;
            }
            int n8 = n3 + n4 >> 1;
            SortUtils.swap(TArray, n8, n3 + 1);
            SortUtils.swap(nArray, n8, n3 + 1);
            if (TArray[n3].compareTo(TArray[n4]) > 0) {
                SortUtils.swap(TArray, n3, n4);
                SortUtils.swap(nArray, n3, n4);
            }
            if (TArray[n3 + 1].compareTo(TArray[n4]) > 0) {
                SortUtils.swap(TArray, n3 + 1, n4);
                SortUtils.swap(nArray, n3 + 1, n4);
            }
            if (TArray[n3].compareTo(TArray[n3 + 1]) > 0) {
                SortUtils.swap(TArray, n3, n3 + 1);
                SortUtils.swap(nArray, n3, n3 + 1);
            }
            n5 = n3 + 1;
            n7 = n4;
            t = TArray[n3 + 1];
            n6 = nArray[n3 + 1];
            while (true) {
                if (TArray[++n5].compareTo(t) < 0) {
                    continue;
                }
                while (TArray[--n7].compareTo(t) > 0) {
                }
                if (n7 < n5) break;
                SortUtils.swap(TArray, n5, n7);
                SortUtils.swap(nArray, n5, n7);
            }
            TArray[n3 + 1] = TArray[n7];
            TArray[n7] = t;
            nArray[n3 + 1] = nArray[n7];
            nArray[n7] = n6;
            if ((n2 += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (n4 - n5 + 1 >= n7 - n3) {
                nArray2[n2] = n4;
                nArray2[n2 - 1] = n5;
                n4 = n7 - 1;
                continue;
            }
            nArray2[n2] = n7 - 1;
            nArray2[n2 - 1] = n3;
            n3 = n5;
        }
    }

    public static <T> void sort(T[] TArray, int[] nArray, int n, Comparator<T> comparator) {
        int n2 = -1;
        int n3 = 0;
        int[] nArray2 = new int[64];
        int n4 = n - 1;
        while (true) {
            int n5;
            int n6;
            T t;
            int n7;
            if (n4 - n3 < 7) {
                for (n7 = n3 + 1; n7 <= n4; ++n7) {
                    t = TArray[n7];
                    n6 = nArray[n7];
                    for (n5 = n7 - 1; n5 >= n3 && comparator.compare(TArray[n5], t) > 0; --n5) {
                        TArray[n5 + 1] = TArray[n5];
                        nArray[n5 + 1] = nArray[n5];
                    }
                    TArray[n5 + 1] = t;
                    nArray[n5 + 1] = n6;
                }
                if (n2 < 0) break;
                n4 = nArray2[n2--];
                n3 = nArray2[n2--];
                continue;
            }
            int n8 = n3 + n4 >> 1;
            SortUtils.swap(TArray, n8, n3 + 1);
            SortUtils.swap(nArray, n8, n3 + 1);
            if (comparator.compare(TArray[n3], TArray[n4]) > 0) {
                SortUtils.swap(TArray, n3, n4);
                SortUtils.swap(nArray, n3, n4);
            }
            if (comparator.compare(TArray[n3 + 1], TArray[n4]) > 0) {
                SortUtils.swap(TArray, n3 + 1, n4);
                SortUtils.swap(nArray, n3 + 1, n4);
            }
            if (comparator.compare(TArray[n3], TArray[n3 + 1]) > 0) {
                SortUtils.swap(TArray, n3, n3 + 1);
                SortUtils.swap(nArray, n3, n3 + 1);
            }
            n5 = n3 + 1;
            n7 = n4;
            t = TArray[n3 + 1];
            n6 = nArray[n3 + 1];
            while (true) {
                if (comparator.compare(TArray[++n5], t) < 0) {
                    continue;
                }
                while (comparator.compare(TArray[--n7], t) > 0) {
                }
                if (n7 < n5) break;
                SortUtils.swap(TArray, n5, n7);
                SortUtils.swap(nArray, n5, n7);
            }
            TArray[n3 + 1] = TArray[n7];
            TArray[n7] = t;
            nArray[n3 + 1] = nArray[n7];
            nArray[n7] = n6;
            if ((n2 += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (n4 - n5 + 1 >= n7 - n3) {
                nArray2[n2] = n4;
                nArray2[n2 - 1] = n5;
                n4 = n7 - 1;
                continue;
            }
            nArray2[n2] = n7 - 1;
            nArray2[n2 - 1] = n3;
            n3 = n5;
        }
    }

    public static <T extends Comparable<? super T>> void sort(T[] TArray, Object[] objectArray) {
        QuickSort.sort(TArray, (Object[])objectArray, (int)TArray.length);
    }

    public static <T extends Comparable<? super T>> void sort(T[] TArray, Object[] objectArray, int n) {
        int n2 = -1;
        int n3 = 0;
        int[] nArray = new int[64];
        int n4 = n - 1;
        while (true) {
            int n5;
            Object object;
            T t;
            int n6;
            if (n4 - n3 < 7) {
                for (n6 = n3 + 1; n6 <= n4; ++n6) {
                    t = TArray[n6];
                    object = objectArray[n6];
                    for (n5 = n6 - 1; n5 >= n3 && TArray[n5].compareTo(t) > 0; --n5) {
                        TArray[n5 + 1] = TArray[n5];
                        objectArray[n5 + 1] = objectArray[n5];
                    }
                    TArray[n5 + 1] = t;
                    objectArray[n5 + 1] = object;
                }
                if (n2 < 0) break;
                n4 = nArray[n2--];
                n3 = nArray[n2--];
                continue;
            }
            int n7 = n3 + n4 >> 1;
            SortUtils.swap(TArray, n7, n3 + 1);
            SortUtils.swap(objectArray, n7, n3 + 1);
            if (TArray[n3].compareTo(TArray[n4]) > 0) {
                SortUtils.swap(TArray, n3, n4);
                SortUtils.swap(objectArray, n3, n4);
            }
            if (TArray[n3 + 1].compareTo(TArray[n4]) > 0) {
                SortUtils.swap(TArray, n3 + 1, n4);
                SortUtils.swap(objectArray, n3 + 1, n4);
            }
            if (TArray[n3].compareTo(TArray[n3 + 1]) > 0) {
                SortUtils.swap(TArray, n3, n3 + 1);
                SortUtils.swap(objectArray, n3, n3 + 1);
            }
            n5 = n3 + 1;
            n6 = n4;
            t = TArray[n3 + 1];
            object = objectArray[n3 + 1];
            while (true) {
                if (TArray[++n5].compareTo(t) < 0) {
                    continue;
                }
                while (TArray[--n6].compareTo(t) > 0) {
                }
                if (n6 < n5) break;
                SortUtils.swap(TArray, n5, n6);
                SortUtils.swap(objectArray, n5, n6);
            }
            TArray[n3 + 1] = TArray[n6];
            TArray[n6] = t;
            objectArray[n3 + 1] = objectArray[n6];
            objectArray[n6] = object;
            if ((n2 += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (n4 - n5 + 1 >= n6 - n3) {
                nArray[n2] = n4;
                nArray[n2 - 1] = n5;
                n4 = n6 - 1;
                continue;
            }
            nArray[n2] = n6 - 1;
            nArray[n2 - 1] = n3;
            n3 = n5;
        }
    }
}

