/*
 * Decompiled with CFR 0.152.
 */
package smile.regression;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;
import java.util.stream.IntStream;
import smile.data.Attribute;
import smile.data.AttributeDataset;
import smile.data.NominalAttribute;
import smile.data.NumericAttribute;
import smile.math.Math;
import smile.regression.Regression;
import smile.regression.RegressionTrainer;
import smile.sort.QuickSort;
import smile.util.MulticoreExecutor;

public class RegressionTree
implements Regression<double[]> {
    private static final long serialVersionUID = 1L;
    private Attribute[] attributes;
    private double[] importance;
    private double[] monotonicRegression;
    private Node root;
    private int nodeSize = 5;
    private int maxNodes = 6;
    private int mtry;
    private int numFeatures;
    private transient int[][] order;

    public RegressionTree(double[][] dArray, double[] dArray2, int n) {
        this(null, dArray, dArray2, n, 5);
    }

    public RegressionTree(double[][] dArray, double[] dArray2, int n, int n2) {
        this(null, dArray, dArray2, n, n2);
    }

    public RegressionTree(Attribute[] attributeArray, double[][] dArray, double[] dArray2, int n) {
        this(attributeArray, dArray, dArray2, n, 5);
    }

    public RegressionTree(AttributeDataset attributeDataset, int n) {
        this(attributeDataset.attributes(), attributeDataset.x(), attributeDataset.y(), n);
    }

    public RegressionTree(Attribute[] attributeArray, double[][] dArray, double[] dArray2, int n, int n2) {
        this(attributeArray, dArray, dArray2, n, n2, dArray[0].length, null, null, null);
    }

    public RegressionTree(AttributeDataset attributeDataset, int n, int n2) {
        this(attributeDataset.attributes(), attributeDataset.x(), attributeDataset.y(), n, n2);
    }

    public RegressionTree(Attribute[] attributeArray, double[][] dArray, double[] dArray2, int n, int n2, int n3, int[][] nArray, int[] nArray2, NodeOutput nodeOutput) {
        this(attributeArray, dArray, dArray2, n, n2, n3, nArray, nArray2, nodeOutput, null);
    }

    public RegressionTree(AttributeDataset attributeDataset, int n, int n2, int n3, int[][] nArray, int[] nArray2, NodeOutput nodeOutput) {
        this(attributeDataset.attributes(), attributeDataset.x(), attributeDataset.y(), n, n2, n3, nArray, nArray2, nodeOutput);
    }

    public RegressionTree(AttributeDataset attributeDataset, int n, int n2, int n3, int[][] nArray, int[] nArray2, NodeOutput nodeOutput, double[] dArray) {
        this(attributeDataset.attributes(), attributeDataset.x(), attributeDataset.y(), n, n2, n3, nArray, nArray2, nodeOutput, dArray);
    }

    public RegressionTree(Attribute[] attributeArray, double[][] dArray, double[] dArray2, int n, int n2, int n3, int[][] nArray, int[] nArray2, NodeOutput nodeOutput, double[] dArray3) {
        int n4;
        int n5;
        int n6;
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", dArray.length, dArray2.length));
        }
        if (n3 < 1 || n3 > dArray[0].length) {
            throw new IllegalArgumentException("Invalid number of variables to split on at a node of the tree: " + n3);
        }
        if (n < 2) {
            throw new IllegalArgumentException("Invalid maximum leaves: " + n);
        }
        if (n2 < 2) {
            throw new IllegalArgumentException("Invalid minimum size of leaf nodes: " + n2);
        }
        if (attributeArray == null) {
            n6 = dArray[0].length;
            attributeArray = new Attribute[n6];
            for (n5 = 0; n5 < n6; ++n5) {
                attributeArray[n5] = new NumericAttribute("V" + (n5 + 1));
            }
        }
        if (dArray3 == null) {
            dArray3 = new double[attributeArray.length];
        }
        this.attributes = attributeArray;
        this.monotonicRegression = dArray3;
        this.maxNodes = n;
        this.nodeSize = n2;
        this.mtry = n3;
        this.importance = new double[attributeArray.length];
        if (nArray != null) {
            this.order = nArray;
        } else {
            n6 = dArray.length;
            n5 = dArray[0].length;
            double[] dArray4 = new double[n6];
            this.order = new int[n5][];
            for (n4 = 0; n4 < n5; ++n4) {
                if (!(attributeArray[n4] instanceof NumericAttribute)) continue;
                for (int i = 0; i < n6; ++i) {
                    dArray4[i] = dArray[i][n4];
                }
                this.order[n4] = QuickSort.sort(dArray4);
            }
        }
        n6 = 0;
        double d = 0.0;
        if (nArray2 == null) {
            n6 = dArray2.length;
            nArray2 = new int[n6];
            for (n4 = 0; n4 < n6; ++n4) {
                nArray2[n4] = 1;
                d += dArray2[n4];
            }
        } else {
            for (n4 = 0; n4 < dArray2.length; ++n4) {
                n6 += nArray2[n4];
                d += (double)nArray2[n4] * dArray2[n4];
            }
        }
        this.root = new Node(d / (double)n6);
        TrainNode trainNode = new TrainNode(this.root, dArray, dArray2, nArray2);
        if (trainNode.findBestSplit()) {
            TrainNode trainNode2;
            PriorityQueue<TrainNode> priorityQueue = new PriorityQueue<TrainNode>();
            priorityQueue.add(trainNode);
            for (int i = 1; i < this.maxNodes && (trainNode2 = (TrainNode)priorityQueue.poll()) != null; ++i) {
                trainNode2.split(priorityQueue);
            }
        }
        if (nodeOutput != null) {
            trainNode.calculateOutput(nodeOutput);
        }
    }

    public RegressionTree(int n, int[][] nArray, double[] dArray, int n2) {
        this(n, nArray, dArray, n2, 5);
    }

    public RegressionTree(int n, int[][] nArray, double[] dArray, int n2, int n3) {
        this(n, nArray, dArray, n2, n3, null, null);
    }

    public RegressionTree(int n, int[][] nArray, double[] dArray, int n2, int n3, int[] nArray2, NodeOutput nodeOutput) {
        SparseBinaryTrainNode sparseBinaryTrainNode;
        int n4;
        if (nArray.length != dArray.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", nArray.length, dArray.length));
        }
        if (n2 < 2) {
            throw new IllegalArgumentException("Invalid maximum number of leaves: " + n2);
        }
        if (n3 < 2) {
            throw new IllegalArgumentException("Invalid minimum size of leaf nodes: " + n3);
        }
        this.maxNodes = n2;
        this.nodeSize = n3;
        this.numFeatures = n;
        this.mtry = n;
        this.importance = new double[n];
        PriorityQueue<SparseBinaryTrainNode> priorityQueue = new PriorityQueue<SparseBinaryTrainNode>();
        int n5 = 0;
        double d = 0.0;
        if (nArray2 == null) {
            n5 = dArray.length;
            nArray2 = new int[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                nArray2[n4] = 1;
                d += dArray[n4];
            }
        } else {
            for (n4 = 0; n4 < dArray.length; ++n4) {
                n5 += nArray2[n4];
                d += (double)nArray2[n4] * dArray[n4];
            }
        }
        this.root = new Node(d / (double)n5);
        SparseBinaryTrainNode sparseBinaryTrainNode2 = new SparseBinaryTrainNode(this.root, nArray, dArray, nArray2);
        if (sparseBinaryTrainNode2.findBestSplit()) {
            priorityQueue.add(sparseBinaryTrainNode2);
        }
        for (int i = 1; i < this.maxNodes && (sparseBinaryTrainNode = (SparseBinaryTrainNode)priorityQueue.poll()) != null; ++i) {
            sparseBinaryTrainNode.split(priorityQueue);
        }
        if (nodeOutput != null) {
            sparseBinaryTrainNode2.calculateOutput(nodeOutput);
        }
    }

    public double[] importance() {
        return this.importance;
    }

    @Override
    public double predict(double[] dArray) {
        return this.root.predict(dArray);
    }

    @Override
    public double predict(int[] nArray) {
        return this.root.predict(nArray);
    }

    public int maxDepth() {
        return this.maxDepth(this.root);
    }

    private int maxDepth(Node node) {
        int n;
        if (node == null) {
            return 0;
        }
        int n2 = this.maxDepth(node.trueChild);
        if (n2 > (n = this.maxDepth(node.falseChild))) {
            return n2 + 1;
        }
        return n + 1;
    }

    public String dot() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("digraph RegressionTree {\n node [shape=box, style=\"filled, rounded\", color=\"black\", fontname=helvetica];\n edge [fontname=helvetica];\n");
        int n = 0;
        LinkedList<DotNode> linkedList = new LinkedList<DotNode>();
        linkedList.add(new DotNode(-1, 0, this.root));
        while (!linkedList.isEmpty()) {
            DotNode dotNode = (DotNode)linkedList.poll();
            int n2 = dotNode.id;
            int n3 = dotNode.parent;
            Node node = dotNode.node;
            if (node.trueChild == null && node.falseChild == null) {
                stringBuilder.append(String.format(" %d [label=<%.4f>, fillcolor=\"#00000000\", shape=ellipse];\n", n2, node.output));
            } else {
                Attribute attribute = this.attributes[node.splitFeature];
                if (attribute.getType() == Attribute.Type.NOMINAL) {
                    stringBuilder.append(String.format(" %d [label=<%s = %s<br/>nscore = %.4f>, fillcolor=\"#00000000\"];\n", n2, attribute.getName(), attribute.toString(node.splitValue), node.splitScore));
                } else if (attribute.getType() == Attribute.Type.NUMERIC) {
                    stringBuilder.append(String.format(" %d [label=<%s &le; %.4f<br/>score = %.4f>, fillcolor=\"#00000000\"];\n", n2, attribute.getName(), node.splitValue, node.splitScore));
                } else {
                    throw new IllegalStateException("Unsupported attribute type: " + (Object)((Object)attribute.getType()));
                }
            }
            if (n3 >= 0) {
                stringBuilder.append(' ').append(n3).append(" -> ").append(n2);
                if (n3 == 0) {
                    if (n2 == 1) {
                        stringBuilder.append(" [labeldistance=2.5, labelangle=45, headlabel=\"True\"]");
                    } else {
                        stringBuilder.append(" [labeldistance=2.5, labelangle=-45, headlabel=\"False\"]");
                    }
                }
                stringBuilder.append(";\n");
            }
            if (node.trueChild != null) {
                linkedList.add(new DotNode(n2, ++n, node.trueChild));
            }
            if (node.falseChild == null) continue;
            linkedList.add(new DotNode(n2, ++n, node.falseChild));
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public Node getRoot() {
        return this.root;
    }

    private class DotNode {
        int parent;
        int id;
        Node node;

        DotNode(int n, int n2, Node node) {
            this.parent = n;
            this.id = n2;
            this.node = node;
        }
    }

    class SparseBinaryTrainNode
    implements Comparable<SparseBinaryTrainNode> {
        Node node;
        SparseBinaryTrainNode trueChild;
        SparseBinaryTrainNode falseChild;
        int[][] x;
        double[] y;
        int[] samples;

        public SparseBinaryTrainNode(Node node, int[][] nArray, double[] dArray, int[] nArray2) {
            this.node = node;
            this.x = nArray;
            this.y = dArray;
            this.samples = nArray2;
        }

        @Override
        public int compareTo(SparseBinaryTrainNode sparseBinaryTrainNode) {
            return (int)Math.signum(sparseBinaryTrainNode.node.splitScore - this.node.splitScore);
        }

        public boolean findBestSplit() {
            double d;
            int n;
            if (this.node.trueChild != null || this.node.falseChild != null) {
                throw new IllegalStateException("Split non-leaf node.");
            }
            int n2 = RegressionTree.this.numFeatures;
            double[] dArray = new double[n2];
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            int n3 = Math.sum(this.samples);
            double d2 = 0.0;
            for (n = 0; n < this.x.length; ++n) {
                if (this.samples[n] == 0) continue;
                d = (double)this.samples[n] * this.y[n];
                d2 += this.y[n];
                int n4 = 0;
                while (n4 < this.x[n].length) {
                    int n5;
                    int n6 = n5 = this.x[n][n4];
                    dArray[n6] = dArray[n6] + d;
                    int n7 = n5;
                    nArray[n7] = nArray[n7] + this.samples[n];
                    nArray2[n5] = n4++;
                }
            }
            this.node.splitScore = 0.0;
            this.node.splitFeature = -1;
            this.node.splitValue = -1.0;
            for (n = 0; n < n2; ++n) {
                double d3;
                double d4;
                double d5;
                d = nArray[n];
                double d6 = (double)n3 - d;
                if (d < (double)RegressionTree.this.nodeSize || d6 < (double)RegressionTree.this.nodeSize || !((d5 = d * (d4 = dArray[n] / d) * d4 + d6 * (d3 = (d2 - dArray[n]) / d6) * d3 - (double)n3 * this.node.output * this.node.output) > this.node.splitScore)) continue;
                this.node.splitFeature = nArray2[n];
                this.node.splitValue = n;
                this.node.splitScore = d5;
                this.node.trueChildOutput = d4;
                this.node.falseChildOutput = d3;
            }
            return this.node.splitFeature != -1;
        }

        public void split(PriorityQueue<SparseBinaryTrainNode> priorityQueue) {
            if (this.node.splitFeature < 0) {
                throw new IllegalStateException("Split a node with invalid feature.");
            }
            if (this.node.trueChild != null || this.node.falseChild != null) {
                throw new IllegalStateException("Split non-leaf node.");
            }
            int n = this.x.length;
            int n2 = 0;
            int n3 = 0;
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            for (int i = 0; i < n; ++i) {
                if (this.samples[i] <= 0) continue;
                if (this.x[i][this.node.splitFeature] == (int)this.node.splitValue) {
                    nArray[i] = this.samples[i];
                    n2 += nArray[i];
                    this.samples[i] = 0;
                    continue;
                }
                nArray2[i] = this.samples[i];
                n3 += this.samples[i];
            }
            this.node.trueChild = new Node(this.node.trueChildOutput);
            this.node.falseChild = new Node(this.node.falseChildOutput);
            this.trueChild = new SparseBinaryTrainNode(this.node.trueChild, this.x, this.y, nArray);
            if (n2 > RegressionTree.this.nodeSize && this.trueChild.findBestSplit()) {
                if (priorityQueue != null) {
                    priorityQueue.add(this.trueChild);
                } else {
                    this.trueChild.split(null);
                }
            }
            this.falseChild = new SparseBinaryTrainNode(this.node.falseChild, this.x, this.y, nArray2);
            if (n3 > RegressionTree.this.nodeSize && this.falseChild.findBestSplit()) {
                if (priorityQueue != null) {
                    priorityQueue.add(this.falseChild);
                } else {
                    this.falseChild.split(null);
                }
            }
            double[] dArray = RegressionTree.this.importance;
            int n4 = this.node.splitFeature;
            dArray[n4] = dArray[n4] + this.node.gain;
        }

        public void calculateOutput(NodeOutput nodeOutput) {
            if (this.node.trueChild == null && this.node.falseChild == null) {
                this.node.output = nodeOutput.calculate(this.samples);
            } else {
                if (this.trueChild != null) {
                    this.trueChild.calculateOutput(nodeOutput);
                }
                if (this.falseChild != null) {
                    this.falseChild.calculateOutput(nodeOutput);
                }
            }
        }
    }

    class TrainNode
    implements Comparable<TrainNode> {
        Node node;
        TrainNode trueChild;
        TrainNode falseChild;
        double[][] x;
        double[] y;
        int[] samples;

        public TrainNode(Node node, double[][] dArray, double[] dArray2, int[] nArray) {
            this.node = node;
            this.x = dArray;
            this.y = dArray2;
            this.samples = nArray;
        }

        @Override
        public int compareTo(TrainNode trainNode) {
            return (int)Math.signum(trainNode.node.splitScore - this.node.splitScore);
        }

        public void calculateOutput(NodeOutput nodeOutput) {
            if (this.node.trueChild == null && this.node.falseChild == null) {
                this.node.output = nodeOutput.calculate(this.samples);
            } else {
                if (this.trueChild != null) {
                    this.trueChild.calculateOutput(nodeOutput);
                }
                if (this.falseChild != null) {
                    this.falseChild.calculateOutput(nodeOutput);
                }
            }
        }

        public boolean findBestSplit() {
            int n = 0;
            for (int n2 : this.samples) {
                n += n2;
            }
            if (n <= RegressionTree.this.nodeSize) {
                return false;
            }
            double d = this.node.output * (double)n;
            int n3 = RegressionTree.this.attributes.length;
            int[] nArray = IntStream.range(0, RegressionTree.this.attributes.length).toArray();
            if (RegressionTree.this.mtry < n3) {
                Math.permutate(nArray);
                for (int i = 0; i < RegressionTree.this.mtry; ++i) {
                    Node node = this.findBestSplit(n, d, nArray[i]);
                    if (!(node.splitScore > this.node.splitScore)) continue;
                    this.node.splitFeature = node.splitFeature;
                    this.node.splitValue = node.splitValue;
                    this.node.splitScore = node.splitScore;
                    this.node.gain = node.gain;
                    this.node.trueChildOutput = node.trueChildOutput;
                    this.node.falseChildOutput = node.falseChildOutput;
                }
            } else {
                ArrayList<SplitTask> arrayList = new ArrayList<SplitTask>(RegressionTree.this.mtry);
                for (int i = 0; i < RegressionTree.this.mtry; ++i) {
                    arrayList.add(new SplitTask(n, d, nArray[i]));
                }
                try {
                    for (Node node : MulticoreExecutor.run(arrayList)) {
                        if (!(node.splitScore > this.node.splitScore)) continue;
                        this.node.splitFeature = node.splitFeature;
                        this.node.splitValue = node.splitValue;
                        this.node.splitScore = node.splitScore;
                        this.node.gain = node.gain;
                        this.node.trueChildOutput = node.trueChildOutput;
                        this.node.falseChildOutput = node.falseChildOutput;
                    }
                }
                catch (Exception exception) {
                    for (int i = 0; i < RegressionTree.this.mtry; ++i) {
                        Node node = this.findBestSplit(n, d, nArray[i]);
                        if (!(node.splitScore > this.node.splitScore)) continue;
                        this.node.splitFeature = node.splitFeature;
                        this.node.splitValue = node.splitValue;
                        this.node.splitScore = node.splitScore;
                        this.node.gain = node.gain;
                        this.node.trueChildOutput = node.trueChildOutput;
                        this.node.falseChildOutput = node.falseChildOutput;
                    }
                }
            }
            return this.node.splitFeature != -1;
        }

        public Node findBestSplit(int n, double d, int n2) {
            Node node = new Node(0.0);
            if (RegressionTree.this.attributes[n2].getType() == Attribute.Type.NOMINAL) {
                double d2;
                int n3;
                int n4 = ((NominalAttribute)RegressionTree.this.attributes[n2]).size();
                double[] dArray = new double[n4];
                int[] nArray = new int[n4];
                for (n3 = 0; n3 < this.x.length; ++n3) {
                    int n5;
                    if (this.samples[n3] <= 0) continue;
                    d2 = (double)this.samples[n3] * this.y[n3];
                    int n6 = n5 = (int)this.x[n3][n2];
                    dArray[n6] = dArray[n6] + d2;
                    int n7 = n5;
                    nArray[n7] = nArray[n7] + this.samples[n3];
                }
                for (n3 = 0; n3 < n4; ++n3) {
                    double d3;
                    double d4;
                    double d5;
                    d2 = nArray[n3];
                    double d6 = (double)n - d2;
                    if (d2 < (double)RegressionTree.this.nodeSize || d6 < (double)RegressionTree.this.nodeSize || !((d5 = d2 * (d4 = dArray[n3] / d2) * d4 + d6 * (d3 = (d - dArray[n3]) / d6) * d3 - (double)n * node.output * node.output) > node.splitScore)) continue;
                    node.splitFeature = n2;
                    node.splitValue = n3;
                    node.splitScore = d5;
                    node.trueChildOutput = d4;
                    node.falseChildOutput = d3;
                }
            } else if (RegressionTree.this.attributes[n2].getType() == Attribute.Type.NUMERIC) {
                double d7 = 0.0;
                int n8 = 0;
                double d8 = Double.NaN;
                for (int n9 : RegressionTree.this.order[n2]) {
                    boolean bl;
                    double d9;
                    if (this.samples[n9] <= 0) continue;
                    if (Double.isNaN(d8) || this.x[n9][n2] == d8) {
                        d8 = this.x[n9][n2];
                        d7 += (double)this.samples[n9] * this.y[n9];
                        n8 += this.samples[n9];
                        continue;
                    }
                    double d10 = n - n8;
                    if (n8 < RegressionTree.this.nodeSize || d10 < (double)RegressionTree.this.nodeSize) {
                        d8 = this.x[n9][n2];
                        d7 += (double)this.samples[n9] * this.y[n9];
                        n8 += this.samples[n9];
                        continue;
                    }
                    double d11 = d7 / (double)n8;
                    double d12 = (d - d7) / d10;
                    double d13 = d9 = (double)n8 * d11 * d11 + d10 * d12 * d12 - (double)n * node.output * node.output;
                    double d14 = RegressionTree.this.monotonicRegression[n2];
                    if (d14 > 0.0) {
                        boolean bl2 = bl = d11 > d12;
                        if (bl) {
                            d13 *= 1.0 - Math.abs(d14);
                        }
                    } else if (d14 < 0.0) {
                        boolean bl3 = bl = d11 < d12;
                        if (bl) {
                            d13 *= 1.0 - Math.abs(d14);
                        }
                    }
                    if (d13 > node.splitScore) {
                        node.gain = d9;
                        node.splitFeature = n2;
                        node.splitValue = (this.x[n9][n2] + d8) / 2.0;
                        node.splitScore = d13;
                        node.trueChildOutput = d11;
                        node.falseChildOutput = d12;
                    }
                    d8 = this.x[n9][n2];
                    d7 += (double)this.samples[n9] * this.y[n9];
                    n8 += this.samples[n9];
                }
            } else {
                throw new IllegalStateException("Unsupported attribute type: " + (Object)((Object)RegressionTree.this.attributes[n2].getType()));
            }
            return node;
        }

        public void split(PriorityQueue<TrainNode> priorityQueue) {
            if (priorityQueue == null) {
                throw new IllegalArgumentException("nextSplits cannot be null");
            }
            if (this.node.splitFeature < 0) {
                throw new IllegalStateException("Split a node with invalid feature.");
            }
            int n = this.x.length;
            int n2 = 0;
            int n3 = 0;
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            if (RegressionTree.this.attributes[this.node.splitFeature].getType() == Attribute.Type.NOMINAL) {
                for (int i = 0; i < n; ++i) {
                    if (this.samples[i] <= 0) continue;
                    if (Math.equals(this.x[i][this.node.splitFeature], this.node.splitValue)) {
                        nArray[i] = this.samples[i];
                        n2 += nArray[i];
                        this.samples[i] = 0;
                        continue;
                    }
                    nArray2[i] = this.samples[i];
                    n3 += this.samples[i];
                }
            } else if (RegressionTree.this.attributes[this.node.splitFeature].getType() == Attribute.Type.NUMERIC) {
                for (int i = 0; i < n; ++i) {
                    if (this.samples[i] <= 0) continue;
                    if (this.x[i][this.node.splitFeature] <= this.node.splitValue) {
                        nArray[i] = this.samples[i];
                        n2 += nArray[i];
                        this.samples[i] = 0;
                        continue;
                    }
                    nArray2[i] = this.samples[i];
                    n3 += this.samples[i];
                }
            } else {
                throw new IllegalStateException("Unsupported attribute type: " + (Object)((Object)RegressionTree.this.attributes[this.node.splitFeature].getType()));
            }
            if (n2 < RegressionTree.this.nodeSize || n3 < RegressionTree.this.nodeSize) {
                this.node.splitFeature = -1;
                this.node.splitValue = Double.NaN;
                this.node.splitScore = 0.0;
                this.node.gain = 0.0;
                return;
            }
            this.node.trueChild = new Node(this.node.trueChildOutput);
            this.node.falseChild = new Node(this.node.falseChildOutput);
            this.trueChild = new TrainNode(this.node.trueChild, this.x, this.y, nArray);
            if (n2 > RegressionTree.this.nodeSize && this.trueChild.findBestSplit()) {
                priorityQueue.add(this.trueChild);
            }
            this.falseChild = new TrainNode(this.node.falseChild, this.x, this.y, nArray2);
            if (n3 > RegressionTree.this.nodeSize && this.falseChild.findBestSplit()) {
                priorityQueue.add(this.falseChild);
            }
            double[] dArray = RegressionTree.this.importance;
            int n4 = this.node.splitFeature;
            dArray[n4] = dArray[n4] + this.node.gain;
        }

        class SplitTask
        implements Callable<Node> {
            int n;
            double sum;
            int j;

            SplitTask(int n, double d, int n2) {
                this.n = n;
                this.sum = d;
                this.j = n2;
            }

            @Override
            public Node call() {
                return TrainNode.this.findBestSplit(this.n, this.sum, this.j);
            }
        }
    }

    class Node
    implements Serializable {
        double output = 0.0;
        int splitFeature = -1;
        double splitValue = Double.NaN;
        double gain = 0.0;
        double splitScore = 0.0;
        Node trueChild;
        Node falseChild;
        double trueChildOutput = 0.0;
        double falseChildOutput = 0.0;

        public Node(double d) {
            this.output = d;
        }

        public double predict(double[] dArray) {
            if (this.trueChild == null && this.falseChild == null) {
                return this.output;
            }
            if (RegressionTree.this.attributes[this.splitFeature].getType() == Attribute.Type.NOMINAL) {
                if (Math.equals(dArray[this.splitFeature], this.splitValue)) {
                    return this.trueChild.predict(dArray);
                }
                return this.falseChild.predict(dArray);
            }
            if (RegressionTree.this.attributes[this.splitFeature].getType() == Attribute.Type.NUMERIC) {
                if (dArray[this.splitFeature] <= this.splitValue) {
                    return this.trueChild.predict(dArray);
                }
                return this.falseChild.predict(dArray);
            }
            throw new IllegalStateException("Unsupported attribute type: " + (Object)((Object)RegressionTree.this.attributes[this.splitFeature].getType()));
        }

        public double predict(int[] nArray) {
            if (this.trueChild == null && this.falseChild == null) {
                return this.output;
            }
            if (nArray[this.splitFeature] == (int)this.splitValue) {
                return this.trueChild.predict(nArray);
            }
            return this.falseChild.predict(nArray);
        }
    }

    public static interface NodeOutput {
        public double calculate(int[] var1);
    }

    public static class Trainer
    extends RegressionTrainer<double[]> {
        private int nodeSize = 1;
        private int maxNodes = 100;
        private int numFeatures = -1;

        public Trainer(int n) {
            if (n < 2) {
                throw new IllegalArgumentException("Invalid maximum number of leaf nodes: " + n);
            }
            this.maxNodes = n;
        }

        public Trainer(Attribute[] attributeArray, int n) {
            super(attributeArray);
            if (n < 2) {
                throw new IllegalArgumentException("Invalid maximum number of leaf nodes: " + n);
            }
            this.maxNodes = n;
        }

        public Trainer(int n, int n2) {
            if (n <= 0) {
                throw new IllegalArgumentException("Invalid number of sparse binary features: " + n);
            }
            if (n2 < 2) {
                throw new IllegalArgumentException("Invalid maximum number of leaf nodes: " + n2);
            }
            this.numFeatures = n;
            this.maxNodes = n2;
        }

        public Trainer setMaxNodes(int n) {
            if (n < 2) {
                throw new IllegalArgumentException("Invalid maximum number of leaf nodes: " + n);
            }
            this.maxNodes = n;
            return this;
        }

        public Trainer setNodeSize(int n) {
            if (n < 2) {
                throw new IllegalArgumentException("Invalid minimum size of leaf nodes: " + n);
            }
            this.nodeSize = n;
            return this;
        }

        public RegressionTree train(double[][] dArray, double[] dArray2) {
            return new RegressionTree(this.attributes, dArray, dArray2, this.maxNodes, this.nodeSize);
        }

        public RegressionTree train(int[][] nArray, double[] dArray) {
            if (this.numFeatures <= 0) {
                return new RegressionTree(Math.max(nArray) + 1, nArray, dArray, this.maxNodes, this.nodeSize);
            }
            return new RegressionTree(this.numFeatures, nArray, dArray, this.maxNodes, this.nodeSize);
        }
    }
}

