/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.Math;
import smile.math.kernel.MercerKernel;

public class GaussianKernel
implements MercerKernel<double[]> {
    private static final long serialVersionUID = 1L;
    private double gamma;

    public GaussianKernel(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("sigma is not positive.");
        }
        this.gamma = 0.5 / (d * d);
    }

    public String toString() {
        return String.format("Gaussian Kernel (\u02e0 = %.4f)", Math.sqrt(0.5 / this.gamma));
    }

    @Override
    public double k(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", dArray.length, dArray2.length));
        }
        return Math.exp(-this.gamma * Math.squaredDistance(dArray, dArray2));
    }
}

