/*
 * Decompiled with CFR 0.152.
 */
package smile.math;

import smile.math.Math;
import smile.math.random.MersenneTwister;
import smile.math.random.UniversalGenerator;

public class Random {
    private UniversalGenerator real;
    private MersenneTwister twister;

    public Random() {
        this.real = new UniversalGenerator();
        this.twister = new MersenneTwister();
    }

    public Random(long l) {
        this.real = new UniversalGenerator(l);
        this.twister = new MersenneTwister(l);
    }

    public double nextDouble() {
        return this.real.nextDouble();
    }

    public void nextDoubles(double[] dArray) {
        this.real.nextDoubles(dArray);
    }

    public double nextDouble(double d, double d2) {
        return d + (d2 - d) * this.nextDouble();
    }

    public void nextDoubles(double[] dArray, double d, double d2) {
        this.real.nextDoubles(dArray);
        double d3 = d2 - d;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = d + d3 * dArray[i];
        }
    }

    public void setSeed(long l) {
        this.real.setSeed(l);
        this.twister.setSeed(l);
    }

    public int nextInt() {
        return this.twister.nextInt();
    }

    public int nextInt(int n) {
        return this.twister.nextInt(n);
    }

    public long nextLong() {
        return this.twister.nextLong();
    }

    public int[] permutate(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        this.permutate(nArray);
        return nArray;
    }

    public void permutate(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = i + this.nextInt(nArray.length - i);
            Math.swap(nArray, i, n);
        }
    }

    public void permutate(float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            int n = i + this.nextInt(fArray.length - i);
            Math.swap(fArray, i, n);
        }
    }

    public void permutate(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            int n = i + this.nextInt(dArray.length - i);
            Math.swap(dArray, i, n);
        }
    }

    public void permutate(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            int n = i + this.nextInt(objectArray.length - i);
            Math.swap(objectArray, i, n);
        }
    }
}

