/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import smile.clustering.BBDTree;
import smile.clustering.ClusteringDistance;
import smile.clustering.PartitionClustering;
import smile.math.Math;
import smile.util.MulticoreExecutor;

public class KMeans
extends PartitionClustering<double[]> {
    private static final long serialVersionUID = 1L;
    double distortion;
    double[][] centroids;

    KMeans() {
    }

    public double distortion() {
        return this.distortion;
    }

    public double[][] centroids() {
        return this.centroids;
    }

    @Override
    public int predict(double[] dArray) {
        double d = Double.MAX_VALUE;
        int n = 0;
        for (int i = 0; i < this.k; ++i) {
            double d2 = Math.squaredDistance(dArray, this.centroids[i]);
            if (!(d2 < d)) continue;
            d = d2;
            n = i;
        }
        return n;
    }

    public KMeans(double[][] dArray, int n) {
        this(dArray, n, 100);
    }

    public KMeans(double[][] dArray, int n, int n2) {
        this(new BBDTree(dArray), dArray, n, n2);
    }

    KMeans(BBDTree bBDTree, double[][] dArray, int n, int n2) {
        int n3;
        int n4;
        if (n < 2) {
            throw new IllegalArgumentException("Invalid number of clusters: " + n);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Invalid maximum number of iterations: " + n2);
        }
        int n5 = dArray.length;
        int n6 = dArray[0].length;
        this.k = n;
        this.distortion = Double.MAX_VALUE;
        this.y = KMeans.seed(dArray, n, ClusteringDistance.EUCLIDEAN);
        this.size = new int[n];
        this.centroids = new double[n][n6];
        for (n4 = 0; n4 < n5; ++n4) {
            int n7 = this.y[n4];
            this.size[n7] = this.size[n7] + 1;
        }
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = 0; n3 < n6; ++n3) {
                double[] dArray2 = this.centroids[this.y[n4]];
                int n8 = n3;
                dArray2[n8] = dArray2[n8] + dArray[n4][n3];
            }
        }
        for (n4 = 0; n4 < n; ++n4) {
            n3 = 0;
            while (n3 < n6) {
                double[] dArray3 = this.centroids[n4];
                int n9 = n3++;
                dArray3[n9] = dArray3[n9] / (double)this.size[n4];
            }
        }
        double[][] dArray4 = new double[n][n6];
        for (n3 = 1; n3 <= n2; ++n3) {
            double d = bBDTree.clustering(this.centroids, dArray4, this.size, this.y);
            for (int i = 0; i < n; ++i) {
                if (this.size[i] <= 0) continue;
                for (int j = 0; j < n6; ++j) {
                    this.centroids[i][j] = dArray4[i][j] / (double)this.size[i];
                }
            }
            if (this.distortion <= d) break;
            this.distortion = d;
        }
    }

    public KMeans(double[][] dArray, int n, int n2, int n3) {
        if (n < 2) {
            throw new IllegalArgumentException("Invalid number of clusters: " + n);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Invalid maximum number of iterations: " + n2);
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("Invalid number of runs: " + n3);
        }
        BBDTree bBDTree = new BBDTree(dArray);
        ArrayList<KMeansThread> arrayList = new ArrayList<KMeansThread>();
        for (int i = 0; i < n3; ++i) {
            arrayList.add(new KMeansThread(bBDTree, dArray, n, n2));
        }
        KMeans kMeans = new KMeans();
        kMeans.distortion = Double.MAX_VALUE;
        try {
            List<KMeans> list = MulticoreExecutor.run(arrayList);
            for (KMeans kMeans2 : list) {
                if (!(kMeans2.distortion < kMeans.distortion)) continue;
                kMeans = kMeans2;
            }
        }
        catch (Exception exception) {
            System.err.println("Failed to run K-Means on multi-core: " + exception);
            for (int i = 0; i < n3; ++i) {
                KMeans kMeans3 = KMeans.lloyd(dArray, n, n2);
                if (!(kMeans3.distortion < kMeans.distortion)) continue;
                kMeans = kMeans3;
            }
        }
        this.k = kMeans.k;
        this.distortion = kMeans.distortion;
        this.centroids = kMeans.centroids;
        this.y = kMeans.y;
        this.size = kMeans.size;
    }

    public static KMeans lloyd(double[][] dArray, int n) {
        return KMeans.lloyd(dArray, n, 100);
    }

    public static KMeans lloyd(double[][] dArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (n < 2) {
            throw new IllegalArgumentException("Invalid number of clusters: " + n);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Invalid maximum number of iterations: " + n2);
        }
        int n7 = dArray.length;
        int n8 = dArray[0].length;
        int[][] nArray = new int[n][n8];
        double d = Double.MAX_VALUE;
        int[] nArray2 = new int[n];
        double[][] dArray2 = new double[n][n8];
        int[] nArray3 = KMeans.seed(dArray, n, ClusteringDistance.EUCLIDEAN_MISSING_VALUES);
        int n9 = MulticoreExecutor.getThreadPoolSize();
        ArrayList<LloydThread> arrayList = null;
        if (n7 >= 1000 && n9 >= 2) {
            arrayList = new ArrayList<LloydThread>(n9 + 1);
            n6 = n7 / n9;
            if (n6 < 100) {
                n6 = 100;
            }
            n5 = 0;
            n4 = n6;
            for (n3 = 0; n3 < n9 - 1; ++n3) {
                arrayList.add(new LloydThread(dArray, dArray2, nArray3, n5, n4));
                n5 += n6;
                n4 += n6;
            }
            arrayList.add(new LloydThread(dArray, dArray2, nArray3, n5, n7));
        }
        for (n6 = 0; n6 < n2; ++n6) {
            double d2;
            Arrays.fill(nArray2, 0);
            for (n5 = 0; n5 < n; ++n5) {
                Arrays.fill(dArray2[n5], 0.0);
                Arrays.fill(nArray[n5], 0);
            }
            for (n5 = 0; n5 < n7; ++n5) {
                int n10 = n4 = nArray3[n5];
                nArray2[n10] = nArray2[n10] + 1;
                for (n3 = 0; n3 < n8; ++n3) {
                    if (Double.isNaN(dArray[n5][n3])) continue;
                    double[] dArray3 = dArray2[n4];
                    int n11 = n3;
                    dArray3[n11] = dArray3[n11] + dArray[n5][n3];
                    int[] nArray4 = nArray[n4];
                    int n12 = n3;
                    nArray4[n12] = nArray4[n12] + 1;
                }
            }
            for (n5 = 0; n5 < n; ++n5) {
                for (n4 = 0; n4 < n8; ++n4) {
                    double[] dArray4 = dArray2[n5];
                    int n13 = n4;
                    dArray4[n13] = dArray4[n13] / (double)nArray[n5][n4];
                }
            }
            double d3 = Double.NaN;
            if (arrayList != null) {
                try {
                    d3 = 0.0;
                    Iterator iterator = MulticoreExecutor.run(arrayList).iterator();
                    while (iterator.hasNext()) {
                        d2 = (Double)iterator.next();
                        d3 += d2;
                    }
                }
                catch (Exception exception) {
                    System.err.println("Failed to run K-Means on multi-core: " + exception);
                    d3 = Double.NaN;
                }
            }
            if (Double.isNaN(d3)) {
                d3 = 0.0;
                for (n3 = 0; n3 < n7; ++n3) {
                    d2 = Double.MAX_VALUE;
                    for (int i = 0; i < n; ++i) {
                        double d4 = KMeans.squaredDistance(dArray[n3], dArray2[i]);
                        if (!(d2 > d4)) continue;
                        nArray3[n3] = i;
                        d2 = d4;
                    }
                    d3 += d2;
                }
            }
            if (d <= d3) break;
            d = d3;
        }
        Arrays.fill(nArray2, 0);
        for (n6 = 0; n6 < n; ++n6) {
            Arrays.fill(dArray2[n6], 0.0);
            Arrays.fill(nArray[n6], 0);
        }
        for (n6 = 0; n6 < n7; ++n6) {
            int n14 = n5 = nArray3[n6];
            nArray2[n14] = nArray2[n14] + 1;
            for (n4 = 0; n4 < n8; ++n4) {
                if (Double.isNaN(dArray[n6][n4])) continue;
                double[] dArray5 = dArray2[n5];
                int n15 = n4;
                dArray5[n15] = dArray5[n15] + dArray[n6][n4];
                int[] nArray5 = nArray[n5];
                int n16 = n4;
                nArray5[n16] = nArray5[n16] + 1;
            }
        }
        for (n6 = 0; n6 < n; ++n6) {
            for (n5 = 0; n5 < n8; ++n5) {
                double[] dArray6 = dArray2[n6];
                int n17 = n5;
                dArray6[n17] = dArray6[n17] / (double)nArray[n6][n5];
            }
        }
        KMeans kMeans = new KMeans();
        kMeans.k = n;
        kMeans.distortion = d;
        kMeans.size = nArray2;
        kMeans.centroids = dArray2;
        kMeans.y = nArray3;
        return kMeans;
    }

    public static KMeans lloyd(double[][] dArray, int n, int n2, int n3) {
        if (n < 2) {
            throw new IllegalArgumentException("Invalid number of clusters: " + n);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Invalid maximum number of iterations: " + n2);
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("Invalid number of runs: " + n3);
        }
        KMeans kMeans = KMeans.lloyd(dArray, n, n2);
        for (int i = 1; i < n3; ++i) {
            KMeans kMeans2 = KMeans.lloyd(dArray, n, n2);
            if (!(kMeans2.distortion < kMeans.distortion)) continue;
            kMeans = kMeans2;
        }
        return kMeans;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("K-Means distortion: %.5f%n", this.distortion));
        stringBuilder.append(String.format("Clusters of %d data points of dimension %d:%n", this.y.length, this.centroids[0].length));
        for (int i = 0; i < this.k; ++i) {
            int n = (int)Math.round(1000.0 * (double)this.size[i] / (double)this.y.length);
            stringBuilder.append(String.format("%3d\t%5d (%2d.%1d%%)%n", i, this.size[i], n / 10, n % 10));
        }
        return stringBuilder.toString();
    }

    static class LloydThread
    implements Callable<Double> {
        final int start;
        final int end;
        final double[][] data;
        final int k;
        final double[][] centroids;
        int[] y;

        LloydThread(double[][] dArray, double[][] dArray2, int[] nArray, int n, int n2) {
            this.data = dArray;
            this.k = dArray2.length;
            this.y = nArray;
            this.centroids = dArray2;
            this.start = n;
            this.end = n2;
        }

        @Override
        public Double call() {
            double d = 0.0;
            for (int i = this.start; i < this.end; ++i) {
                double d2 = Double.MAX_VALUE;
                for (int j = 0; j < this.k; ++j) {
                    double d3 = PartitionClustering.squaredDistance(this.data[i], this.centroids[j]);
                    if (!(d2 > d3)) continue;
                    this.y[i] = j;
                    d2 = d3;
                }
                d += d2;
            }
            return d;
        }
    }

    static class KMeansThread
    implements Callable<KMeans> {
        final BBDTree bbd;
        final double[][] data;
        final int k;
        final int maxIter;

        KMeansThread(BBDTree bBDTree, double[][] dArray, int n, int n2) {
            this.bbd = bBDTree;
            this.data = dArray;
            this.k = n;
            this.maxIter = n2;
        }

        @Override
        public KMeans call() {
            return new KMeans(this.bbd, this.data, this.k, this.maxIter);
        }
    }
}

