/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Map;
import javajs.api.BytePoster;
import javajs.util.AU;
import javajs.util.BArray;
import javajs.util.Base64;
import javajs.util.CompoundDocument;
import javajs.util.DataReader;
import javajs.util.LimitedLineReader;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.PT;
import javajs.util.Rdr;
import javajs.util.SB;
import javajs.util.ZipTools;
import org.jmol.adapter.readers.spartan.SpartanUtil;
import org.jmol.adapter.smarter.Resolver;
import org.jmol.api.GenericFileInterface;
import org.jmol.api.Interface;
import org.jmol.api.JmolFilesReaderInterface;
import org.jmol.io.FileReader;
import org.jmol.io.JmolUtil;
import org.jmol.script.SV;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.JC;
import org.jmol.viewer.JmolAsyncException;
import org.jmol.viewer.Viewer;

public class FileManager
implements BytePoster {
    public static String SIMULATION_PROTOCOL = "http://SIMULATION/";
    public Viewer vwr;
    private SpartanUtil spartanDoc;
    JmolUtil jzu;
    private String pathForAllFiles = "";
    private String nameAsGiven = "zapped";
    private String fullPathName;
    private String lastFullPathName;
    private String lastNameAsGiven = "zapped";
    private String fileName;
    private String lastFileType;
    private URL appletDocumentBaseURL = null;
    private String appletProxy;
    private static final String DELPHI_BINARY_MAGIC_NUMBER = "\u0014\u0000\u0000\u0000";
    public static final String PMESH_BINARY_MAGIC_NUMBER = "PM\u0001\u0000";
    public static final String JPEG_CONTINUE_STRING = " #Jmol...\u0000";
    private static String[] scriptFilePrefixes = new String[]{"/*file*/\"", "FILE0=\"", "FILE1=\""};
    private Map<String, Object> cache = new Hashtable<String, Object>();
    public Map<String, Object> pngjCache;
    public Map<String, byte[]> spardirCache;

    FileManager(Viewer vwr) {
        this.vwr = vwr;
        this.clear();
    }

    public SpartanUtil spartanUtil() {
        return this.spartanDoc == null ? (this.spartanDoc = ((SpartanUtil)Interface.getInterface("org.jmol.adapter.readers.spartan.SpartanUtil", this.vwr, "fm getSpartanUtil()")).set(this)) : this.spartanDoc;
    }

    public JmolUtil getJzu() {
        return this.jzu == null ? (this.jzu = (JmolUtil)Interface.getOption("io.JmolUtil", this.vwr, "file")) : this.jzu;
    }

    void clear() {
        this.setFileInfo(new String[]{this.vwr.getZapName()});
        this.spardirCache = null;
    }

    private void setLoadState(Map<String, Object> htParams) {
        if (this.vwr.getPreserveState()) {
            htParams.put("loadState", this.vwr.g.getLoadState(htParams));
        }
    }

    public String getPathForAllFiles() {
        return this.pathForAllFiles;
    }

    String setPathForAllFiles(String value) {
        if (value.length() > 0 && !value.endsWith("/") && !value.endsWith("|")) {
            value = value + "/";
        }
        this.pathForAllFiles = value;
        return this.pathForAllFiles;
    }

    public void setFileInfo(String[] fileInfo) {
        if (fileInfo == null) {
            this.fullPathName = this.lastFullPathName;
            this.nameAsGiven = this.lastNameAsGiven;
            return;
        }
        this.fullPathName = fileInfo[0];
        this.fileName = fileInfo[Math.min(1, fileInfo.length - 1)];
        this.nameAsGiven = fileInfo[Math.min(2, fileInfo.length - 1)];
        if (!this.nameAsGiven.equals("zapped")) {
            this.lastNameAsGiven = this.nameAsGiven;
            this.lastFullPathName = this.fullPathName;
        }
    }

    public String[] getFileInfo() {
        return new String[]{this.fullPathName, this.fileName, this.nameAsGiven};
    }

    public String getFullPathName(boolean orPrevious) {
        String f;
        String string = f = this.fullPathName != null ? this.fullPathName : this.nameAsGiven;
        return !orPrevious || !f.equals("zapped") && !f.equals("string") ? f : (this.lastFullPathName != null ? this.lastFullPathName : this.lastNameAsGiven);
    }

    public String getFileType() {
        return this.lastFileType;
    }

    public void setFileType(String fileType) {
        this.lastFileType = fileType;
    }

    public String getFileName() {
        return this.fileName != null ? this.fileName : this.nameAsGiven;
    }

    String getAppletDocumentBase() {
        return this.appletDocumentBaseURL == null ? "" : this.appletDocumentBaseURL.toString();
    }

    void setAppletContext(String documentBase) {
        try {
            System.out.println("setting document base to \"" + documentBase + "\"");
            this.appletDocumentBaseURL = documentBase.length() == 0 ? null : new URL((URL)null, documentBase, null);
        }
        catch (MalformedURLException e) {
            System.out.println("error setting document base to " + documentBase);
        }
    }

    void setAppletProxy(String appletProxy) {
        this.appletProxy = appletProxy == null || appletProxy.length() == 0 ? null : appletProxy;
    }

    Object createAtomSetCollectionFromFile(String name, Map<String, Object> htParams, boolean isAppend) {
        if (htParams.get("atomDataOnly") == null) {
            this.setLoadState(htParams);
        }
        String name0 = name;
        int pt = name.indexOf("::");
        if (pt < 0) {
            name = this.vwr.resolveDatabaseFormat(name);
        }
        if (!name0.equals(name) && name0.indexOf("/") < 0 && Viewer.hasDatabasePrefix(name0)) {
            htParams.put("dbName", name0);
        }
        if (name.endsWith("%2D%")) {
            String filter = (String)htParams.get("filter");
            htParams.put("filter", (filter == null ? "" : filter) + "2D");
            name = name.substring(0, name.length() - 4);
        }
        String nameAsGiven = pt >= 0 ? name.substring(pt + 2) : name;
        String fileType = pt >= 0 ? name.substring(0, pt) : null;
        Logger.info("\nFileManager.getAtomSetCollectionFromFile(" + nameAsGiven + ")" + (name.equals(nameAsGiven) ? "" : " //" + name));
        String[] names = this.getClassifiedName(nameAsGiven, true);
        if (names.length == 1) {
            return names[0];
        }
        String fullPathName = names[0];
        String fileName = names[1];
        this.lastFileType = fileType;
        htParams.put("fullPathName", (fileType == null ? "" : fileType + "::") + FileManager.fixDOSName(fullPathName));
        if (this.vwr.getBoolean(603979879) && this.vwr.getBoolean(603979825)) {
            this.vwr.getChimeMessenger().update(fullPathName);
        }
        FileReader fileReader = new FileReader(this.vwr, fileName, fullPathName, nameAsGiven, fileType, null, htParams, isAppend);
        fileReader.run();
        return fileReader.getAtomSetCollection();
    }

    Object createAtomSetCollectionFromFiles(String[] fileNames, Map<String, Object> htParams, boolean isAppend) {
        this.setLoadState(htParams);
        String[] fullPathNames = new String[fileNames.length];
        String[] namesAsGiven = new String[fileNames.length];
        String[] fileTypes = new String[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            int pt = fileNames[i].indexOf("::");
            String nameAsGiven = pt >= 0 ? fileNames[i].substring(pt + 2) : fileNames[i];
            String fileType = pt >= 0 ? fileNames[i].substring(0, pt) : null;
            String[] names = this.getClassifiedName(nameAsGiven, true);
            if (names.length == 1) {
                return names[0];
            }
            fullPathNames[i] = names[0];
            fileNames[i] = FileManager.fixDOSName(names[0]);
            fileTypes[i] = fileType;
            namesAsGiven[i] = nameAsGiven;
        }
        htParams.put("fullPathNames", fullPathNames);
        htParams.put("fileTypes", fileTypes);
        JmolFilesReaderInterface filesReader = this.newFilesReader(fullPathNames, namesAsGiven, fileTypes, null, htParams, isAppend);
        filesReader.run();
        return filesReader.getAtomSetCollection();
    }

    Object createAtomSetCollectionFromString(String strModel, Map<String, Object> htParams, boolean isAppend) {
        this.setLoadState(htParams);
        boolean isAddH = strModel.indexOf("Viewer.AddHydrogens") >= 0;
        String[] fnames = isAddH ? this.getFileInfo() : null;
        FileReader fileReader = new FileReader(this.vwr, "string", null, null, null, strModel.startsWith(JC.BASE64_TAG) ? Base64.decodeBase64(strModel) : (byte[])Rdr.getBR(strModel), htParams, isAppend);
        fileReader.run();
        if (fnames != null) {
            this.setFileInfo(fnames);
        }
        if (!isAppend && !(fileReader.getAtomSetCollection() instanceof String)) {
            this.setFileInfo(new String[]{strModel == "5\n\nC 0 0 0\nH .63 .63 .63\nH -.63 -.63 .63\nH -.63 .63 -.63\nH .63 -.63 -.63" ? "Jmol Model Kit" : "string"});
        }
        return fileReader.getAtomSetCollection();
    }

    Object createAtomSeCollectionFromStrings(String[] arrayModels, SB loadScript, Map<String, Object> htParams, boolean isAppend) {
        if (!htParams.containsKey("isData")) {
            String oldSep = "\"" + this.vwr.getDataSeparator() + "\"";
            String tag = "\"" + (isAppend ? "append" : "model") + " inline\"";
            SB sb = new SB();
            sb.append("set dataSeparator \"~~~next file~~~\";\ndata ").append(tag);
            for (int i = 0; i < arrayModels.length; ++i) {
                if (i > 0) {
                    sb.append("~~~next file~~~");
                }
                sb.append(arrayModels[i]);
            }
            sb.append("end ").append(tag).append(";set dataSeparator ").append(oldSep);
            loadScript.appendSB(sb);
        }
        this.setLoadState(htParams);
        Logger.info("FileManager.getAtomSetCollectionFromStrings(string[])");
        String[] fullPathNames = new String[arrayModels.length];
        DataReader[] readers = new DataReader[arrayModels.length];
        for (int i = 0; i < arrayModels.length; ++i) {
            fullPathNames[i] = "string[" + i + "]";
            readers[i] = FileManager.newDataReader(this.vwr, arrayModels[i]);
        }
        JmolFilesReaderInterface filesReader = this.newFilesReader(fullPathNames, fullPathNames, null, readers, htParams, isAppend);
        filesReader.run();
        return filesReader.getAtomSetCollection();
    }

    Object createAtomSeCollectionFromArrayData(Lst<Object> arrayData, Map<String, Object> htParams, boolean isAppend) {
        Logger.info("FileManager.getAtomSetCollectionFromArrayData(Vector)");
        int nModels = arrayData.size();
        String[] fullPathNames = new String[nModels];
        DataReader[] readers = new DataReader[nModels];
        for (int i = 0; i < nModels; ++i) {
            fullPathNames[i] = "String[" + i + "]";
            readers[i] = FileManager.newDataReader(this.vwr, arrayData.get(i));
        }
        JmolFilesReaderInterface filesReader = this.newFilesReader(fullPathNames, fullPathNames, null, readers, htParams, isAppend);
        filesReader.run();
        return filesReader.getAtomSetCollection();
    }

    static DataReader newDataReader(Viewer vwr, Object data) {
        String reader;
        String string = data instanceof String ? "String" : (AU.isAS(data) ? "Array" : (reader = data instanceof Lst ? "List" : null));
        if (reader == null) {
            return null;
        }
        DataReader dr = (DataReader)Interface.getInterface("javajs.util." + reader + "DataReader", vwr, "file");
        return dr.setData(data);
    }

    private JmolFilesReaderInterface newFilesReader(String[] fullPathNames, String[] namesAsGiven, String[] fileTypes, DataReader[] readers, Map<String, Object> htParams, boolean isAppend) {
        JmolFilesReaderInterface fr = (JmolFilesReaderInterface)Interface.getOption("io.FilesReader", this.vwr, "file");
        fr.set(this, this.vwr, fullPathNames, namesAsGiven, fileTypes, readers, htParams, isAppend);
        return fr;
    }

    Object createAtomSetCollectionFromReader(String fullPathName, String name, Object reader, Map<String, Object> htParams) {
        FileReader fileReader = new FileReader(this.vwr, name, fullPathName, null, null, reader, htParams, false);
        fileReader.run();
        return fileReader.getAtomSetCollection();
    }

    BufferedInputStream getBufferedInputStream(String fullPathName) {
        Object ret = this.getBufferedReaderOrErrorMessageFromName(fullPathName, new String[2], true, true);
        return ret instanceof BufferedInputStream ? (BufferedInputStream)ret : null;
    }

    public Object getBufferedInputStreamOrErrorMessageFromName(String name, String fullName, boolean showMsg, boolean checkOnly, byte[] outputBytes, boolean allowReader, boolean allowCached) {
        byte[] cacheBytes;
        BufferedInputStream bis = null;
        Object ret = null;
        String errorMessage = null;
        allowCached = allowCached || name.startsWith("cache://");
        cacheBytes = allowCached && outputBytes == null ? (cacheBytes = this.getPngjOrDroppedBytes(fullName, name)) : null;
        try {
            if (allowCached && name.indexOf(".png") >= 0 && this.pngjCache == null && !this.vwr.getBoolean(603979960)) {
                this.pngjCache = new Hashtable<String, Object>();
            }
            if (cacheBytes == null) {
                boolean isApplet;
                int iurl;
                boolean isPngjPost;
                boolean isPngjBinaryPost = name.indexOf("?POST?_PNGJBIN_") >= 0;
                boolean bl = isPngjPost = isPngjBinaryPost || name.indexOf("?POST?_PNGJ_") >= 0;
                if (name.indexOf("?POST?_PNG_") > 0 || isPngjPost) {
                    String[] errMsg = new String[1];
                    byte[] bytes = this.vwr.getImageAsBytes(isPngjPost ? "PNGJ" : "PNG", 0, 0, -1, errMsg);
                    if (errMsg[0] != null) {
                        return errMsg[0];
                    }
                    if (isPngjBinaryPost) {
                        outputBytes = bytes;
                        name = PT.rep(name, "?_", "=_");
                    } else {
                        name = new SB().append(name).append("=").appendSB(Base64.getBase64(bytes)).toString();
                    }
                }
                boolean isURL = (iurl = OC.urlTypeIndex(name)) >= 0;
                String post = null;
                if (isURL && (iurl = name.indexOf("?POST?")) >= 0) {
                    post = name.substring(iurl + 6);
                    name = name.substring(0, iurl);
                }
                boolean bl2 = isApplet = this.appletDocumentBaseURL != null;
                if (isApplet || isURL) {
                    URL url;
                    if (isApplet && isURL && this.appletProxy != null) {
                        name = this.appletProxy + "?url=" + this.urlEncode(name);
                    }
                    URL uRL = url = isApplet ? new URL(this.appletDocumentBaseURL, name, null) : new URL((URL)null, name, null);
                    if (checkOnly) {
                        return null;
                    }
                    name = url.toString();
                    if (showMsg && name.toLowerCase().indexOf("password") < 0) {
                        Logger.info("FileManager opening url " + name);
                    }
                    ret = this.vwr.apiPlatform.getURLContents(url, outputBytes, post, false);
                    byte[] bytes = null;
                    if (ret instanceof SB) {
                        SB sb = (SB)ret;
                        if (allowReader && !Rdr.isBase64(sb)) {
                            return Rdr.getBR(sb.toString());
                        }
                        bytes = Rdr.getBytesFromSB(sb);
                    } else if (AU.isAB(ret)) {
                        bytes = (byte[])ret;
                    }
                    if (bytes != null) {
                        ret = Rdr.getBIS(bytes);
                    }
                } else if (!allowCached || (cacheBytes = (byte[])this.cacheGet(name, true)) == null) {
                    if (showMsg) {
                        Logger.info("FileManager opening file " + name);
                    }
                    ret = this.vwr.apiPlatform.getBufferedFileInputStream(name);
                }
                if (ret instanceof String) {
                    return ret;
                }
            }
            BufferedInputStream bufferedInputStream = bis = cacheBytes == null ? (BufferedInputStream)ret : Rdr.getBIS(cacheBytes);
            if (checkOnly) {
                bis.close();
                bis = null;
            }
            return bis;
        }
        catch (Exception e) {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            errorMessage = "" + e;
            return errorMessage;
        }
    }

    public static BufferedReader getBufferedReaderForResource(Viewer vwr, Class<?> resourceClass, String classPath, String resourceName) throws IOException {
        URL url = resourceClass.getResource(resourceName);
        if (url == null) {
            System.err.println("Couldn't find file: " + classPath + resourceName);
            throw new IOException();
        }
        if (vwr == null || !vwr.async) {
            return Rdr.getBufferedReader(new BufferedInputStream((InputStream)url.getContent()), null);
        }
        String string = resourceName = url == null ? vwr.vwrOptions.get("codePath") + classPath + resourceName : url.getFile();
        if (vwr.async) {
            Object bytes = vwr.fm.cacheGet(resourceName, false);
            if (bytes == null) {
                throw new JmolAsyncException(resourceName);
            }
            return Rdr.getBufferedReader(Rdr.getBIS((byte[])bytes), null);
        }
        return (BufferedReader)vwr.fm.getBufferedReaderOrErrorMessageFromName(resourceName, new String[]{null, null}, false, true);
    }

    private String urlEncode(String name) {
        try {
            return URLEncoder.encode(name, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return name;
        }
    }

    Object getFullPathNameOrError(String filename, boolean getStream, String[] ret) {
        String[] names = this.getClassifiedName(JC.fixProtocol(filename), true);
        if (names == null || names[0] == null || names.length < 2) {
            return new String[]{null, "cannot read file name: " + filename};
        }
        String name = names[0];
        String fullPath = FileManager.fixDOSName(names[0]);
        name = Rdr.getZipRoot(name);
        Object errMsg = this.getBufferedInputStreamOrErrorMessageFromName(name, fullPath, false, !getStream, null, false, !getStream);
        ret[0] = fullPath;
        if (errMsg instanceof String) {
            ret[1] = (String)errMsg;
        }
        return errMsg;
    }

    public Object getBufferedReaderOrErrorMessageFromName(String name, String[] fullPathNameReturn, boolean isBinary, boolean doSpecialLoad) {
        String[] names;
        byte[] bytes;
        Object data = this.cacheGet(name = JC.fixProtocol(name), false);
        boolean isBytes = AU.isAB(data);
        byte[] byArray = bytes = isBytes ? (byte[])data : null;
        if (name.startsWith("cache://")) {
            if (data == null) {
                return "cannot read " + name;
            }
            if (isBytes) {
                bytes = (byte[])data;
            } else {
                return Rdr.getBR((String)data);
            }
        }
        if ((names = this.getClassifiedName(name, true)) == null) {
            return "cannot read file name: " + name;
        }
        if (fullPathNameReturn != null) {
            fullPathNameReturn[0] = FileManager.fixDOSName(names[0]);
        }
        return this.getUnzippedReaderOrStreamFromName(names[0], bytes, false, isBinary, false, doSpecialLoad, null);
    }

    public Object getUnzippedReaderOrStreamFromName(String name, Object bytesOrStream, boolean allowZipStream, boolean forceInputStream, boolean isTypeCheckOnly, boolean doSpecialLoad, Map<String, Object> htParams) {
        if (doSpecialLoad && bytesOrStream == null) {
            String[] o;
            String[] stringArray;
            if (name.endsWith(".spt")) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = null;
                stringArray2[1] = null;
                stringArray = stringArray2;
                stringArray2[2] = null;
            } else {
                stringArray = o = name.indexOf(".spardir") < 0 ? null : this.spartanUtil().getFileList(name, isTypeCheckOnly);
            }
            if (o != null) {
                return o;
            }
        }
        name = JC.fixProtocol(name);
        if (bytesOrStream == null) {
            byte[] byArray = this.getCachedPngjBytes(name);
            bytesOrStream = byArray;
            if (byArray != null && htParams != null) {
                htParams.put("sourcePNGJ", Boolean.TRUE);
            }
        }
        String fullName = name = name.replace("#_DOCACHE_", "");
        String[] subFileList = null;
        if (name.indexOf("|") >= 0) {
            subFileList = PT.split(name.replace('\\', '/'), "|");
            if (bytesOrStream == null) {
                Logger.info("FileManager opening zip " + name);
            }
            name = subFileList[0];
        }
        BufferedInputStream t = bytesOrStream == null ? this.getBufferedInputStreamOrErrorMessageFromName(name, fullName, true, false, null, !forceInputStream, true) : (AU.isAB(bytesOrStream) ? Rdr.getBIS((byte[])bytesOrStream) : (BufferedInputStream)bytesOrStream);
        try {
            if (t instanceof String || t instanceof BufferedReader) {
                return t;
            }
            BufferedInputStream bis = t;
            if (Rdr.isGzipS(bis)) {
                bis = ZipTools.getUnzippedInputStream(bis);
            } else if (Rdr.isBZip2S(bis)) {
                bis = ZipTools.getUnzippedInputStreamBZip2(bis);
            }
            if (forceInputStream && subFileList == null) {
                return bis;
            }
            if (Rdr.isCompoundDocumentS(bis)) {
                CompoundDocument doc = new CompoundDocument();
                doc.setDocStream(bis);
                String s = doc.getAllDataFiles("Molecule", "Input").toString();
                return forceInputStream ? Rdr.getBIS(s.getBytes()) : Rdr.getBR(s);
            }
            if (Rdr.isMessagePackS(bis) || Rdr.isPickleS(bis) || Resolver.getBinaryType(bis) != null) {
                return bis;
            }
            if (Rdr.isPngZipStream(bis)) {
                bis = ZipTools.getPngZipStream(bis, true);
            }
            Object o = null;
            if (Rdr.isZipS(bis)) {
                if (allowZipStream) {
                    return ZipTools.newZipInputStream(bis);
                }
                o = ZipTools.getZipFileDirectory(bis, subFileList, 1, forceInputStream);
            } else if (Rdr.isTar(bis)) {
                o = ZipTools.getZipFileDirectory(bis, subFileList, 1, forceInputStream);
            } else if (Rdr.isBinary(bis, 32)) {
                return bis;
            }
            if (o != null) {
                if (!(o instanceof BufferedInputStream)) {
                    return o instanceof String ? Rdr.getBR((String)o) : o;
                }
                bis = ZipTools.getUnzippedInputStream((BufferedInputStream)o);
            }
            return forceInputStream ? bis : Rdr.getBufferedReader(bis, null);
        }
        catch (Exception ioe) {
            return ioe.toString();
        }
    }

    public String[] getZipDirectory(String fileName, boolean addManifest, boolean allowCached) {
        Object t = this.getBufferedInputStreamOrErrorMessageFromName(fileName, fileName, false, false, null, false, allowCached);
        return ZipTools.getZipDirectoryAndClose((BufferedInputStream)t, addManifest ? "JmolManifest" : null);
    }

    public Object getFileAsBytes(String name, OC out) {
        Object bytes;
        if (name == null) {
            return null;
        }
        String fullName = name;
        String[] subFileList = null;
        if (name.indexOf("|") >= 0) {
            subFileList = PT.split(name, "|");
            name = subFileList[0];
        }
        byte[] byArray = bytes = subFileList != null ? null : this.getPngjOrDroppedBytes(fullName, name);
        if (bytes == null) {
            Object t = this.getBufferedInputStreamOrErrorMessageFromName(name, fullName, false, false, null, false, true);
            if (t instanceof String) {
                return "Error:" + t;
            }
            try {
                BufferedInputStream bis = (BufferedInputStream)t;
                bytes = out != null || subFileList == null || subFileList.length <= 1 || !Rdr.isZipS(bis) && !Rdr.isPngZipStream(bis) && !Rdr.isTar(bis) ? Rdr.getStreamAsBytes(bis, out) : (Object)ZipTools.getZipFileContentsAsBytes(bis, subFileList, 1);
                bis.close();
            }
            catch (Exception ioe) {
                return ioe.toString();
            }
        }
        if (out == null || !AU.isAB(bytes)) {
            return bytes;
        }
        out.write((byte[])bytes, 0, -1);
        return ((byte[])bytes).length + " bytes";
    }

    public Object getFileAsMap(String name, String type, boolean asBytes) {
        Object t;
        Hashtable<String, Object> bdata;
        Hashtable<String, Object> hashtable = bdata = asBytes ? null : new Hashtable<String, Object>();
        if (name == null) {
            String[] errMsg = new String[1];
            byte[] bytes = this.vwr.getImageAsBytes(type, -1, -1, -1, errMsg);
            if (errMsg[0] != null) {
                if (asBytes) {
                    return new byte[0];
                }
                bdata.put("_ERROR_", errMsg[0]);
                return bdata;
            }
            if (asBytes) {
                return new byte[0];
            }
            t = Rdr.getBIS(bytes);
        } else {
            String[] data = new String[2];
            t = this.getFullPathNameOrError(name, true, data);
            if (t instanceof String) {
                if (asBytes) {
                    return new byte[0];
                }
                bdata.put("_ERROR_", t);
                return bdata;
            }
            if (!this.checkSecurity(data[0])) {
                if (asBytes) {
                    return new byte[0];
                }
                bdata.put("_ERROR_", "java.io. Security exception: cannot read file " + data[0]);
                return bdata;
            }
        }
        try {
            if (asBytes) {
                return Rdr.streamToBytes((BufferedInputStream)t);
            }
            ZipTools.readFileAsMap((BufferedInputStream)t, bdata, name);
        }
        catch (Exception e) {
            if (asBytes) {
                return new byte[0];
            }
            bdata.clear();
            bdata.put("_ERROR_", "" + e);
        }
        return bdata;
    }

    public boolean getFileDataAsString(String[] data, int nBytesMax, boolean doSpecialLoad, boolean allowBinary, boolean checkProtected) {
        data[1] = "";
        String name = data[0];
        if (name == null) {
            return false;
        }
        Object t = this.getBufferedReaderOrErrorMessageFromName(name, data, false, doSpecialLoad);
        if (t instanceof String) {
            data[1] = (String)t;
            return false;
        }
        if (checkProtected && !this.checkSecurity(data[0])) {
            data[1] = "java.io. Security exception: cannot read file " + data[0];
            return false;
        }
        try {
            if (t instanceof BufferedInputStream && (name.toUpperCase().endsWith(".PNG") || FileManager.isEmbeddable(name))) {
                t = Rdr.getBufferedReader((BufferedInputStream)t, null);
            }
            return Rdr.readAllAsString((BufferedReader)t, nBytesMax, allowBinary, data, 1);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean checkSecurity(String f) {
        if (!f.startsWith("file:")) {
            return true;
        }
        int pt = f.lastIndexOf(47);
        return f.lastIndexOf(":/") != pt - 1 && f.indexOf("/.") < 0 && f.lastIndexOf(46) >= f.lastIndexOf(47);
    }

    public boolean loadImage(Object nameOrBytes, String echoName, boolean forceSync) {
        boolean isPopupImage;
        Object image = null;
        String nameOrError = null;
        byte[] bytes = null;
        boolean bl = isPopupImage = echoName != null && echoName.startsWith("\u0001");
        if (isPopupImage) {
            if (echoName.equals("\u0001closeall\u0001null")) {
                return this.vwr.loadImageData(Boolean.TRUE, "\u0001closeall", "\u0001closeall", null);
            }
            if ("\u0001close".equals(nameOrBytes)) {
                return this.vwr.loadImageData(Boolean.FALSE, "\u0001close", echoName, null);
            }
        }
        if (nameOrBytes instanceof Map) {
            Object object = nameOrBytes = ((Map)nameOrBytes).containsKey("_DATA_") ? ((Map)nameOrBytes).get("_DATA_") : ((Map)nameOrBytes).get("_IMAGE_");
        }
        if (nameOrBytes instanceof SV) {
            nameOrBytes = ((SV)nameOrBytes).value;
        }
        String name = nameOrBytes instanceof String ? (String)nameOrBytes : null;
        boolean isAsynchronous = false;
        if (name != null && name.startsWith(JC.BASE64_TAG)) {
            bytes = Base64.decodeBase64(name);
        } else if (nameOrBytes instanceof BArray) {
            bytes = ((BArray)nameOrBytes).data;
        } else if (echoName == null || nameOrBytes instanceof String) {
            String[] names = this.getClassifiedName((String)nameOrBytes, true);
            String string = nameOrError = names == null ? "cannot read file name: " + nameOrBytes : FileManager.fixDOSName(names[0]);
            if (names != null) {
                image = this.getImage(nameOrError, echoName, forceSync);
            }
            isAsynchronous = image == null;
        } else {
            image = nameOrBytes;
        }
        if (bytes != null) {
            image = this.getImage(bytes, echoName, true);
            isAsynchronous = false;
        }
        if (image instanceof String) {
            nameOrError = (String)image;
            image = null;
        }
        if (!Viewer.isJS && image != null && bytes != null) {
            nameOrError = JC.BASE64_TAG + Base64.getBase64(bytes).toString();
        }
        if (!Viewer.isJS || isPopupImage && nameOrError == null || !isPopupImage && image != null) {
            return this.vwr.loadImageData(image, nameOrError, echoName, null);
        }
        return isAsynchronous;
    }

    public Object getImage(Object nameOrBytes, String echoName, boolean forceSync) {
        return this.getJzu().getImage(this.vwr, nameOrBytes, echoName, forceSync);
    }

    private String[] getClassifiedName(String name, boolean isFullLoad) {
        boolean doSetPathForAllFiles;
        if (name == null) {
            return new String[]{null};
        }
        boolean bl = doSetPathForAllFiles = this.pathForAllFiles.length() > 0;
        if (name.startsWith("?") || name.startsWith("http://?") || name.startsWith("https://?")) {
            if (!Viewer.isJS && (name = this.vwr.dialogAsk("Load", name, null)) == null) {
                return new String[]{isFullLoad ? "#CANCELED#" : null};
            }
            doSetPathForAllFiles = false;
        }
        GenericFileInterface file = null;
        URL url = null;
        String[] names = null;
        if (name.startsWith("cache://")) {
            names = new String[3];
            names[0] = names[2] = name;
            names[1] = FileManager.stripPath(names[0]);
            return names;
        }
        if ((name = this.vwr.resolveDatabaseFormat(name)) == null) {
            return new String[]{null};
        }
        if (name.startsWith("file:///") && name.indexOf(124) == 9) {
            name = name.substring(0, 9) + ':' + name.substring(10);
        }
        if (name.indexOf(":") < 0 && name.indexOf(47) != 0 && name.indexOf(92) != 0) {
            name = FileManager.addDirectory(this.vwr.getDefaultDirectory(), name);
        }
        if (this.appletDocumentBaseURL == null) {
            if (OC.urlTypeIndex(name) >= 0 || this.vwr.haveAccess(Viewer.ACCESS.NONE) || this.vwr.haveAccess(Viewer.ACCESS.READSPT) && !name.endsWith(".spt") && !name.endsWith("/") || !this.vwr.haveAccessInternal(name)) {
                try {
                    url = new URL((URL)null, name, null);
                }
                catch (MalformedURLException e) {
                    return new String[]{isFullLoad ? e.toString() : null};
                }
            } else {
                file = this.vwr.apiPlatform.newFile(name);
                String s = file.getFullPath();
                String fname = file.getName();
                names = new String[]{s == null ? fname : s, fname, s == null ? fname : "file:/" + s.replace('\\', '/')};
            }
        } else {
            try {
                if (name.indexOf(":\\") == 1 || name.indexOf(":/") == 1) {
                    name = "file:/" + name;
                }
                url = new URL(this.appletDocumentBaseURL, name, null);
            }
            catch (MalformedURLException e) {
                return new String[]{isFullLoad ? e.toString() : null};
            }
        }
        if (url != null) {
            names = new String[3];
            names[0] = names[2] = url.toString();
            names[1] = FileManager.stripPath(names[0]);
        }
        if (doSetPathForAllFiles) {
            String name0 = names[0];
            names[0] = this.pathForAllFiles + names[1];
            Logger.info("FileManager substituting " + name0 + " --> " + names[0]);
        }
        String path = names[0];
        if (isFullLoad && OC.isLocal(path) && !path.startsWith("file:/")) {
            int pt;
            if (file == null) {
                path = PT.trim(path.substring(path.indexOf(":") + 1), "/");
            }
            if ((pt = path.length() - names[1].length() - 1) > 0) {
                path = path.substring(0, pt).replace('|', ':');
                FileManager.setLocalPath(this.vwr, path, true);
            }
        }
        return names;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String addDirectory(String defaultDirectory, String name) {
        String string;
        if (defaultDirectory.length() == 0) return name;
        if (defaultDirectory.equals(".")) {
            return name;
        }
        int ch = name.length() > 0 ? (int)name.charAt(0) : 32;
        String s = defaultDirectory.toLowerCase();
        if ((s.endsWith(".zip") || s.endsWith(".tar")) && ch != 124 && ch != 47) {
            defaultDirectory = defaultDirectory + "|";
        }
        StringBuilder stringBuilder = new StringBuilder().append(defaultDirectory);
        if (ch != 47 && ch != 47) {
            char c = defaultDirectory.charAt(defaultDirectory.length() - 1);
            ch = c;
            if (c != '|' && ch != 47) {
                string = "/";
                return stringBuilder.append(string).append(name).toString();
            }
        }
        string = "";
        return stringBuilder.append(string).append(name).toString();
    }

    String getDefaultDirectory(String name) {
        String[] names = this.getClassifiedName(name, true);
        if (names == null) {
            return "";
        }
        name = FileManager.fixPath(names[0]);
        return name == null ? "" : name.substring(0, name.lastIndexOf("/"));
    }

    private static String fixPath(String path) {
        path = FileManager.fixDOSName(path);
        int pt = (path = PT.rep(path, "/./", "/")).lastIndexOf("//") + 1;
        if (pt < 1) {
            pt = path.indexOf(":/") + 1;
        }
        if (pt < 1) {
            pt = path.indexOf("/");
        }
        if (pt < 0) {
            return null;
        }
        String protocol = path.substring(0, pt);
        path = path.substring(pt);
        while ((pt = path.lastIndexOf("/../")) >= 0) {
            int pt0 = path.substring(0, pt).lastIndexOf("/");
            if (pt0 < 0) {
                return PT.rep(protocol + path, "/../", "/");
            }
            path = path.substring(0, pt0) + path.substring(pt + 3);
        }
        if (path.length() == 0) {
            path = "/";
        }
        return protocol + path;
    }

    public String getFilePath(String name, boolean addUrlPrefix, boolean asShortName) {
        String[] names = this.getClassifiedName(name, false);
        return names == null || names.length == 1 ? "" : (asShortName ? names[1] : (addUrlPrefix ? names[2] : (names[0] == null ? "" : FileManager.fixDOSName(names[0]))));
    }

    public static GenericFileInterface getLocalDirectory(Viewer vwr, boolean forDialog) {
        String localDir = (String)vwr.getP(forDialog ? "currentLocalPath" : "defaultDirectoryLocal");
        if (forDialog && localDir.length() == 0) {
            localDir = (String)vwr.getP("defaultDirectoryLocal");
        }
        if (localDir.length() == 0) {
            return Viewer.isJS ? null : vwr.apiPlatform.newFile(System.getProperty("user.dir", "."));
        }
        if (vwr.isApplet && localDir.indexOf("file:/") == 0) {
            localDir = localDir.substring(6);
        }
        GenericFileInterface f = vwr.apiPlatform.newFile(localDir);
        try {
            return f.isDirectory() ? f : f.getParentAsFile();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setLocalPath(Viewer vwr, String path, boolean forDialog) {
        while (path.endsWith("/") || path.endsWith("\\")) {
            path = path.substring(0, path.length() - 1);
        }
        vwr.setStringProperty("currentLocalPath", path);
        if (!forDialog) {
            vwr.setStringProperty("defaultDirectoryLocal", path);
        }
    }

    public static String getLocalPathForWritingFile(Viewer vwr, String file, boolean forDialog) {
        if (file.startsWith("http://") || file.startsWith("https://")) {
            return file;
        }
        if ((file = PT.rep(file, "?", "")).indexOf("file:/") == 0) {
            int pt = file.indexOf(124);
            if (pt > 5 && pt < 10) {
                file = file.substring(0, pt) + ':' + file.substring(pt + 1);
            }
            return file.substring((pt = file.indexOf(58, 5)) > 0 ? pt - 1 : 5);
        }
        if (file.indexOf(47) == 0 || file.indexOf(92) == 0 || file.indexOf(":") >= 0) {
            return file;
        }
        GenericFileInterface dir = null;
        try {
            dir = FileManager.getLocalDirectory(vwr, forDialog);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dir == null ? file : FileManager.fixPath(dir.toString() + "/" + file);
    }

    public static String fixDOSName(String fileName) {
        return fileName.indexOf(":\\") >= 0 ? fileName.replace('\\', '/') : fileName;
    }

    public static String stripPath(String name) {
        int pt = Math.max(name.lastIndexOf("|"), name.lastIndexOf("/"));
        return name.substring(pt + 1);
    }

    public static boolean isScriptType(String fname) {
        return PT.isOneOf(fname.toLowerCase().substring(fname.lastIndexOf(".") + 1), ";pse;spt;png;pngj;jmol;zip;");
    }

    public static String determineSurfaceFileType(BufferedReader bufferedReader) {
        BufferedInputStream is;
        String line = null;
        if (bufferedReader instanceof Rdr.StreamReader && (is = ((Rdr.StreamReader)bufferedReader).getStream()).markSupported()) {
            try {
                is.mark(300);
                byte[] buf = new byte[300];
                is.read(buf, 0, 300);
                is.reset();
                if ((buf[0] & 0xFF) == 131) {
                    return Resolver.checkBCIF(buf, false) ? "BCifDensity" : null;
                }
                if (buf[0] == 80 && buf[1] == 77 && buf[2] == 1 && buf[3] == 0) {
                    return "Pmesh";
                }
                if (buf[208] == 77 && buf[209] == 65 && buf[210] == 80) {
                    return "Mrc";
                }
                if (buf[0] == 20 && buf[1] == 0 && buf[2] == 0 && buf[3] == 0) {
                    return "DelPhi";
                }
                if (buf[36] == 0 && buf[37] == 100) {
                    return "Dsn6";
                }
            }
            catch (IOException buf) {
                // empty catch block
            }
        }
        LimitedLineReader br = null;
        try {
            br = new LimitedLineReader(bufferedReader, 16000);
            line = br.getHeader(0);
        }
        catch (Exception buf) {
            // empty catch block
        }
        if (br == null || line == null || line.length() == 0) {
            return null;
        }
        int pt0 = line.indexOf(0);
        if (pt0 >= 0) {
            if (line.charAt(0) == '\u0083') {
                return line.charAt(10) == 'D' && line.charAt(11) == 'e' && line.charAt(12) == 'n' ? "BCifDensity" : null;
            }
            if (line.indexOf(PMESH_BINARY_MAGIC_NUMBER) == 0) {
                return "Pmesh";
            }
            if (line.indexOf("MAP ") == 208) {
                return "Mrc";
            }
            if (line.indexOf(DELPHI_BINARY_MAGIC_NUMBER) == 0) {
                return "DelPhi";
            }
            if (line.length() > 37 && (line.charAt(36) == '\u0000' && line.charAt(37) == 'd' || line.charAt(36) == '\u0000' && line.charAt(37) == 'd')) {
                return "Dsn6";
            }
        }
        switch (line.charAt(0)) {
            case '@': {
                if (line.indexOf("@text") != 0) break;
                return "Kinemage";
            }
            case '#': {
                if (line.indexOf(".obj") >= 0) {
                    return "Obj";
                }
                if (line.indexOf("MSMS") >= 0) {
                    return "Msms";
                }
                if (line.indexOf("Menu") < 0) break;
                return "MENU";
            }
            case '&': {
                if (line.indexOf("&plot") != 0) break;
                return "Jaguar";
            }
            case '\n': 
            case '\r': {
                if (line.indexOf("ZYX") < 0) break;
                return "Xplor";
            }
        }
        if (line.indexOf("Here is your gzipped map") >= 0) {
            return "UPPSALA" + line;
        }
        if (line.startsWith("data_SERVER")) {
            return "CifDensity";
        }
        if (line.startsWith("4MESHC")) {
            return "Pmesh4";
        }
        if (line.indexOf("! nspins") >= 0) {
            return "CastepDensity";
        }
        if (line.indexOf("<jvxl") >= 0 && line.indexOf("<?xml") >= 0) {
            return "JvxlXml";
        }
        if (line.indexOf("#JVXL+") >= 0) {
            return "Jvxl+";
        }
        if (line.indexOf("#JVXL") >= 0) {
            return "Jvxl";
        }
        if (line.indexOf("#JmolPmesh") >= 0) {
            return "Pmesh";
        }
        if (line.indexOf("#obj") >= 0) {
            return "Obj";
        }
        if (line.indexOf("#pmesh") >= 0) {
            return "Obj";
        }
        if (line.indexOf("<efvet ") >= 0) {
            return "Efvet";
        }
        if (line.indexOf("usemtl") >= 0) {
            return "Obj";
        }
        if (line.indexOf("# object with") == 0) {
            return "Nff";
        }
        if (line.indexOf("PRIMVEC") >= 0 || line.indexOf("BEGIN_DATAGRID_3D") >= 0 || line.indexOf("BEGIN_BANDGRID_3D") >= 0) {
            return "Xsf";
        }
        if (line.indexOf("tiles in x, y") >= 0) {
            return "Ras3D";
        }
        if (line.indexOf(" 0.00000e+00 0.00000e+00      0      0\n") >= 0) {
            return "Uhbd";
        }
        line = br.readLineWithNewline();
        if (line.indexOf("object 1 class gridpositions counts") == 0) {
            return "Apbs";
        }
        String[] tokens = PT.getTokens(line);
        String line2 = br.readLineWithNewline();
        if (tokens.length == 2 && PT.parseInt(tokens[0]) == 3 && PT.parseInt(tokens[1]) != Integer.MIN_VALUE && (tokens = PT.getTokens(line2)).length == 3 && PT.parseInt(tokens[0]) != Integer.MIN_VALUE && PT.parseInt(tokens[1]) != Integer.MIN_VALUE && PT.parseInt(tokens[2]) != Integer.MIN_VALUE) {
            return "PltFormatted";
        }
        String line3 = br.readLineWithNewline();
        if (line.startsWith("v ") && line2.startsWith("v ") && line3.startsWith("v ")) {
            return "Obj";
        }
        int nAtoms = PT.parseInt(line3);
        if (nAtoms == Integer.MIN_VALUE) {
            return line3.indexOf("+") == 0 ? "Jvxl+" : null;
        }
        tokens = PT.getTokens(line3);
        if (tokens[0].indexOf(".") > 0) {
            return line3.length() >= 60 || tokens.length != 3 ? null : "VaspChgcar";
        }
        if (nAtoms >= 0) {
            return tokens.length == 4 || tokens.length == 5 && tokens[4].equals("1") ? "Cube" : null;
        }
        nAtoms = -nAtoms;
        int i = 4 + nAtoms;
        while (--i >= 0) {
            line = br.readLineWithNewline();
            if (line != null) continue;
            return null;
        }
        int nSurfaces = PT.parseInt(line);
        if (nSurfaces == Integer.MIN_VALUE) {
            return null;
        }
        return nSurfaces < 0 ? "Jvxl" : "Cube";
    }

    public static String getManifestScriptPath(String manifest) {
        String ch;
        if (manifest.indexOf("$SCRIPT_PATH$") >= 0) {
            return "";
        }
        String string = ch = manifest.indexOf(10) >= 0 ? "\n" : "\r";
        if (manifest.indexOf(".spt") >= 0) {
            String[] s = PT.split(manifest, ch);
            int i = s.length;
            while (--i >= 0) {
                if (s[i].indexOf(".spt") < 0) continue;
                return "|" + PT.trim(s[i], "\r\n \t");
            }
        }
        return null;
    }

    public static void getFileReferences(String script, Lst<String> fileList, Lst<String> fileListUTF) {
        for (int ipt = 0; ipt < scriptFilePrefixes.length; ++ipt) {
            String tag = scriptFilePrefixes[ipt];
            int i = -1;
            while ((i = script.indexOf(tag, i + 1)) >= 0) {
                String s = PT.getQuotedStringAt(script, i);
                if (s.indexOf("\\u") >= 0) {
                    s = Escape.unescapeUnicode(s);
                }
                fileList.addLast(s);
                if (fileListUTF == null) continue;
                if (s.indexOf("\\u") >= 0) {
                    s = Escape.unescapeUnicode(s);
                }
                fileListUTF.addLast(s);
            }
        }
    }

    public static String setScriptFileReferences(String script, String localPath, String remotePath, String scriptPath) {
        if (localPath != null) {
            script = FileManager.setScriptFileRefs(script, localPath, true);
        }
        if (remotePath != null) {
            script = FileManager.setScriptFileRefs(script, remotePath, false);
        }
        script = PT.rep(script, "\u0001\"", "\"");
        if (scriptPath != null) {
            while (scriptPath.endsWith("/")) {
                scriptPath = scriptPath.substring(0, scriptPath.length() - 1);
            }
            for (int ipt = 0; ipt < scriptFilePrefixes.length; ++ipt) {
                String tag = scriptFilePrefixes[ipt];
                script = PT.rep(script, tag + ".", tag + scriptPath);
            }
        }
        return script;
    }

    private static String setScriptFileRefs(String script, String dataPath, boolean isLocal) {
        if (dataPath == null) {
            return script;
        }
        boolean noPath = dataPath.length() == 0;
        Lst<String> fileNames = new Lst<String>();
        FileManager.getFileReferences(script, fileNames, null);
        Lst<String> oldFileNames = new Lst<String>();
        Lst<String> newFileNames = new Lst<String>();
        int nFiles = fileNames.size();
        for (int iFile = 0; iFile < nFiles; ++iFile) {
            String name0;
            String name = name0 = (String)fileNames.get(iFile);
            int pt = name.indexOf("::");
            String type = "";
            if (pt >= 0) {
                type = name.substring(pt + 2);
                name = name.substring(pt + 2);
            }
            if (isLocal == OC.isLocal(name)) {
                int n = pt = noPath ? -1 : name.indexOf("/" + dataPath + "/");
                if (pt >= 0) {
                    name = name.substring(pt + 1);
                } else {
                    pt = name.lastIndexOf("/");
                    if (pt < 0 && !noPath) {
                        name = "/" + name;
                    }
                    if (pt < 0 || noPath) {
                        ++pt;
                    }
                    name = dataPath + name.substring(pt);
                }
            }
            name = type + name;
            Logger.info("FileManager substituting " + name0 + " --> " + name);
            oldFileNames.addLast("\"" + name0 + "\"");
            newFileNames.addLast("\u0001\"" + name + "\"");
        }
        return PT.replaceStrings(script, oldFileNames, newFileNames);
    }

    void cachePut(String key, Object data) {
        key = FileManager.fixDOSName(key);
        if (Logger.debugging) {
            Logger.debug("cachePut " + key);
        }
        if (data == null || "".equals(data)) {
            this.cache.remove(key);
            return;
        }
        this.cache.put(key, data);
        this.getCachedPngjBytes(key);
    }

    public Object cacheGet(String key, boolean bytesOnly) {
        int pt = (key = FileManager.fixDOSName(key)).indexOf("|");
        if (pt >= 0 && !key.endsWith("##JmolSurfaceInfo##")) {
            key = key.substring(0, pt);
        }
        key = this.getFilePath(key, true, false);
        Object data = null;
        if (data == null) {
            data = this.cache.get(key);
        }
        if (data != null) {
            Logger.info("cacheGet " + key);
        }
        return bytesOnly && data instanceof String ? null : data;
    }

    void cacheClear() {
        Logger.info("cache cleared");
        this.cache.clear();
        if (this.pngjCache == null) {
            return;
        }
        this.pngjCache = null;
        Logger.info("PNGJ cache cleared");
    }

    public int cacheFileByNameAdd(String fileName, boolean isAdd) {
        Object data;
        if (fileName == null || !isAdd && fileName.equalsIgnoreCase("")) {
            this.cacheClear();
            return -1;
        }
        if (isAdd) {
            data = this.getFileAsBytes(fileName = JC.fixProtocol(this.vwr.resolveDatabaseFormat(fileName)), null);
            if (data instanceof String) {
                return 0;
            }
            this.cachePut(fileName, data);
        } else {
            if (fileName.endsWith("*")) {
                return AU.removeMapKeys(this.cache, fileName.substring(0, fileName.length() - 1));
            }
            data = this.cache.remove(FileManager.fixDOSName(fileName));
        }
        return data == null ? 0 : (data instanceof String ? ((String)data).length() : ((byte[])data).length);
    }

    public Map<String, Integer> cacheList() {
        Hashtable<String, Integer> map = new Hashtable<String, Integer>();
        for (Map.Entry<String, Object> entry : this.cache.entrySet()) {
            map.put(entry.getKey(), AU.isAB(entry.getValue()) ? ((byte[])entry.getValue()).length : entry.getValue().toString().length());
        }
        return map;
    }

    public String getCanonicalName(String pathName) {
        String[] names = this.getClassifiedName(pathName, true);
        return names == null ? pathName : names[2];
    }

    public void recachePngjBytes(String fileName, byte[] bytes) {
        if (this.pngjCache == null || !this.pngjCache.containsKey(fileName)) {
            return;
        }
        this.pngjCache.put(fileName, bytes);
        Logger.info("PNGJ recaching " + fileName + " (" + bytes.length + ")");
    }

    private byte[] getPngjOrDroppedBytes(String fullName, String name) {
        byte[] bytes = this.getCachedPngjBytes(fullName);
        return bytes == null ? (byte[])this.cacheGet(name, true) : bytes;
    }

    private byte[] getCachedPngjBytes(String pathName) {
        return pathName == null || this.pngjCache == null || pathName.indexOf(".png") < 0 ? null : this.getJzu().getCachedPngjBytes(this, pathName);
    }

    @Override
    public String postByteArray(String fileName, byte[] bytes) {
        if (fileName.startsWith("cache://")) {
            this.cachePut(fileName, bytes);
            return "OK " + bytes.length + "cached";
        }
        Object ret = this.getBufferedInputStreamOrErrorMessageFromName(fileName, null, false, false, bytes, false, true);
        if (ret instanceof String) {
            return (String)ret;
        }
        try {
            ret = Rdr.getStreamAsBytes((BufferedInputStream)ret, null);
        }
        catch (IOException e) {
            try {
                ((BufferedInputStream)ret).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return ret == null ? "" : Rdr.fixUTF((byte[])ret);
    }

    public static boolean isJmolType(String type) {
        return type.equals("PNG") || type.equals("PNGJ") || type.equals("JMOL") || type.equals("ZIP") || type.equals("ZIPALL");
    }

    public static boolean isEmbeddable(String type) {
        int pt = type.lastIndexOf(46);
        if (pt >= 0) {
            type = type.substring(pt + 1);
        }
        return FileManager.isJmolType(type = type.toUpperCase()) || PT.isOneOf(type, ";JPG;JPEG;POV;IDTF;");
    }

    public String getEmbeddedFileState(String fileName, boolean allowCached, String sptName) {
        if (!FileManager.isEmbeddable(fileName)) {
            return "";
        }
        String[] dir = this.getZipDirectory(fileName, false, allowCached);
        if (dir.length == 0) {
            String state = this.vwr.getFileAsString4(fileName, -1, false, true, false, "file");
            return state.indexOf("**** Jmol Embedded Script ****") < 0 ? "" : FileManager.getEmbeddedScript(state);
        }
        for (int i = 0; i < dir.length; ++i) {
            if (dir[i].indexOf(sptName) < 0) continue;
            String[] data = new String[]{fileName + "|" + dir[i], null};
            this.getFileDataAsString(data, -1, false, false, false);
            return data[1];
        }
        return "";
    }

    public static String stripTypePrefix(String fileName) {
        int pt = fileName.indexOf("::");
        return pt < 0 || pt >= 20 ? fileName : fileName.substring(pt + 2);
    }

    public static String getEmbeddedScript(String s) {
        if (s == null) {
            return s;
        }
        int pt = s.indexOf("**** Jmol Embedded Script ****");
        if (pt < 0) {
            return s;
        }
        int pt1 = s.lastIndexOf("/*", pt);
        int pt2 = s.indexOf((s.charAt(pt1 + 2) == '*' ? "*" : "") + "*/", pt);
        if (pt1 >= 0 && pt2 >= pt) {
            s = s.substring(pt + "**** Jmol Embedded Script ****".length(), pt2) + "\n";
        }
        while ((pt1 = s.indexOf(JPEG_CONTINUE_STRING)) >= 0) {
            s = s.substring(0, pt1) + s.substring(pt1 + JPEG_CONTINUE_STRING.length() + 4);
        }
        if (Logger.debugging) {
            Logger.debug(s);
        }
        return s;
    }

    public boolean isZipStream(Object br) {
        return ZipTools.isZipStream(br);
    }
}

