/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.JmolDataManager;
import org.jmol.c.VDW;
import org.jmol.script.T;
import org.jmol.util.BSUtil;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.viewer.JmolStateCreator;
import org.jmol.viewer.Viewer;

public class DataManager
implements JmolDataManager {
    private Map<String, Object[]> dataValues = new Hashtable<String, Object[]>();
    private Viewer vwr;

    @Override
    public DataManager set(Viewer vwr) {
        this.vwr = vwr;
        return this;
    }

    @Override
    public void clear() {
        this.dataValues.clear();
    }

    @Override
    public void setData(String type, Object[] data, int atomCount, int actualAtomCount, int matchField, int matchFieldColumnCount, int field, int fieldColumnCount) {
        try {
            int i;
            BS bs;
            Object oldValue;
            if (type == null) {
                this.clear();
                return;
            }
            if ((type = type.toLowerCase()).equals("element_vdw")) {
                this.setVDW(data);
                return;
            }
            int newType = DataManager.getType(data);
            data[3] = newType;
            Object newVal = data[1];
            if (newType == -1) {
                newType = this.getTypeFor(newVal);
                data[3] = newType;
            }
            if (data[2] == null || atomCount <= 0) {
                this.dataValues.put(type, data);
                return;
            }
            if (newType == -1) {
                Logger.error("Cannot determine data type for " + newVal);
                return;
            }
            double[] d = null;
            double[][] dd = null;
            String stringData = null;
            double[] dData = null;
            double[][] ddData = null;
            String[] tokens = null;
            boolean createNew = matchField != 0 || field != Integer.MIN_VALUE && field != Integer.MAX_VALUE;
            Object[] oldData = this.dataValues.get(type);
            Object object = oldValue = oldData == null ? null : oldData[1];
            if (newType != 2) {
                double[] dArray = d = oldData == null || createNew ? new double[actualAtomCount] : AU.ensureLengthD((double[])oldValue, actualAtomCount);
                if (d == oldValue || !type.startsWith("property_") || !type.startsWith("property_atom.")) {
                    // empty if block
                }
            }
            switch (newType) {
                case 0: {
                    stringData = (String)newVal;
                    break;
                }
                case 1: {
                    dData = (double[])newVal;
                    break;
                }
                case 2: {
                    ddData = (double[][])newVal;
                }
            }
            if (field == Integer.MIN_VALUE && (tokens = PT.getTokens(stringData)).length > 1) {
                field = 0;
            }
            if (field == Integer.MIN_VALUE) {
                bs = (BS)data[2];
                DataManager.setSelected(PT.parseDouble(stringData), bs, d);
            } else if (field == 0 || field == Integer.MAX_VALUE) {
                bs = (BS)data[2];
                if (dData != null) {
                    int n = dData.length;
                    if (n == bs.cardinality()) {
                        DataManager.fillSparseArray(dData, bs, d);
                    } else {
                        i = bs.nextSetBit(0);
                        while (i >= 0 && i < n) {
                            d[i] = dData[i];
                            i = bs.nextSetBit(i + 1);
                        }
                    }
                } else if (stringData != null) {
                    Parser.parseDoubleArrayBsData(tokens == null ? PT.getTokens(stringData) : tokens, bs, d);
                } else if (ddData != null) {
                    int n = ddData.length;
                    double[][] dArray = dd = oldData == null || createNew ? AU.newDouble2(actualAtomCount) : (double[][])AU.ensureLength(oldValue, actualAtomCount);
                    if (n == bs.cardinality()) {
                        i = bs.nextSetBit(0);
                        int pt = 0;
                        while (i >= 0) {
                            dd[i] = new double[actualAtomCount];
                            DataManager.fillSparseArray(ddData[pt], bs, dd[i]);
                            i = bs.nextSetBit(i + 1);
                            ++pt;
                        }
                    } else {
                        i = bs.nextSetBit(0);
                        while (i >= 0 && i < n) {
                            dd[i] = ddData[i];
                            i = bs.nextSetBit(i + 1);
                        }
                    }
                }
            } else if (matchField <= 0) {
                bs = (BS)data[2];
                Parser.parseDoubleArrayFromMatchAndField(stringData, bs, 0, 0, null, field, fieldColumnCount, d, 1);
            } else {
                int[] iData = (int[])data[2];
                Parser.parseDoubleArrayFromMatchAndField(stringData, null, matchField, matchFieldColumnCount, iData, field, fieldColumnCount, d, 1);
                bs = new BS();
                i = iData.length;
                while (--i >= 0) {
                    if (iData[i] < 0) continue;
                    bs.set(iData[i]);
                }
            }
            if (oldData != null && oldData[2] instanceof BS && !createNew) {
                bs.or((BS)oldData[2]);
            }
            data[2] = bs;
            if (dd != null) {
                data[3] = 2;
                data[1] = dd;
            } else {
                data[3] = 1;
                data[1] = d;
            }
            if (type.indexOf("property_atom.") == 0) {
                int tok = T.getSettableTokFromString(type = type.substring(14));
                if (tok == 0) {
                    Logger.error("Unknown atom property: " + type);
                    return;
                }
                int nValues = bs.cardinality();
                double[] fValues = new double[nValues];
                int n = 0;
                int i2 = bs.nextSetBit(0);
                while (n < nValues) {
                    fValues[n++] = d[i2];
                    i2 = bs.nextSetBit(i2 + 1);
                }
                this.vwr.setAtomProperty(bs, tok, 0, 0.0, null, fValues, null);
                return;
            }
            this.dataValues.put(type, data);
        }
        catch (Exception e) {
            Logger.error("DataManager failed :" + e);
            e.printStackTrace();
        }
    }

    private int getTypeFor(Object newVal) {
        return newVal instanceof String ? 0 : (AU.isAD(newVal) ? 1 : (AU.isADD(newVal) ? 2 : (AU.isADDD(newVal) ? 3 : -1)));
    }

    private void setVDW(Object[] data) {
        String stringData = ((String)data[1]).trim();
        if (stringData.length() == 0) {
            this.vwr.userVdwMars = null;
            this.vwr.userVdws = null;
            this.vwr.bsUserVdws = null;
        } else {
            if (this.vwr.bsUserVdws == null) {
                this.vwr.setUserVdw(this.vwr.defaultVdw);
            }
            Parser.parseDoubleArrayFromMatchAndField(stringData, this.vwr.bsUserVdws, 1, 0, (int[])data[2], 2, 0, this.vwr.userVdws, 1);
            int i = this.vwr.userVdws.length;
            while (--i >= 0) {
                this.vwr.userVdwMars[i] = (int)Math.floor(this.vwr.userVdws[i] * 1000.0);
            }
        }
    }

    private static void fillSparseArray(double[] doubleData, BS bs, double[] f) {
        int i = bs.nextSetBit(0);
        int pt = 0;
        while (i >= 0) {
            f[i] = doubleData[pt];
            i = bs.nextSetBit(i + 1);
            ++pt;
        }
    }

    private static int getType(Object[] data) {
        return data == null ? 0 : (Integer)data[3];
    }

    private static void setSelected(double f, BS bs, double[] data) {
        int i0;
        boolean isAll = bs == null;
        int i = i0 = isAll ? 0 : bs.nextSetBit(0);
        while (i >= 0 && i < data.length) {
            data[i] = f;
            i = isAll ? i + 1 : bs.nextSetBit(i + 1);
        }
    }

    @Override
    public Object getData(String label, BS bsSelected, int dataType) {
        if (label == null) {
            return null;
        }
        if (label.endsWith("*")) {
            Lst<String> list = new Lst<String>();
            label = label.substring(0, label.length() - 1);
            int len = label.length();
            for (String key : this.dataValues.keySet()) {
                if (len != 0 && (key.length() < len || !key.substring(0, len).equalsIgnoreCase(label))) continue;
                list.addLast(key);
            }
            return list;
        }
        if (this.dataValues.size() == 0) {
            return null;
        }
        label = label.toLowerCase();
        switch (dataType) {
            case -2: 
            case -1: {
                if (!label.equals("types")) {
                    return this.dataValues.get(label);
                }
                String[] info = new String[]{"types", ""};
                int nv = 0;
                for (String name : this.dataValues.keySet()) {
                    info[1] = info[1] + (nv++ > 0 ? "\n" : "") + name;
                }
                return info;
            }
        }
        Object[] data = this.dataValues.get(label);
        int oldType = DataManager.getType(data);
        if (oldType != dataType) {
            return null;
        }
        Object oldData = data[1];
        if (bsSelected == null && oldData != null) {
            return oldData;
        }
        switch (oldType) {
            case 3: {
                double[][][] ddd = (double[][][])oldData;
                double[][][] dddnew = AU.newDouble3(bsSelected.cardinality(), 0);
                int i = 0;
                int n = ddd.length;
                int p = bsSelected.nextSetBit(0);
                while (p >= 0 && i < n) {
                    dddnew[i++] = p < ddd.length ? ddd[p] : (double[][])null;
                    p = bsSelected.nextSetBit(p + 1);
                }
                return dddnew;
            }
            case 2: {
                double[][] dd = (double[][])oldData;
                double[][] ddnew = AU.newDouble2(bsSelected.cardinality());
                int i = 0;
                int n = dd.length;
                int p = bsSelected.nextSetBit(0);
                while (p >= 0 && i < n) {
                    ddnew[i++] = p < dd.length ? dd[p] : null;
                    p = bsSelected.nextSetBit(p + 1);
                }
                return ddnew;
            }
            case 1: {
                double[] d = (double[])oldData;
                double[] dnew = new double[bsSelected.cardinality()];
                int i = 0;
                int n = d.length;
                int p = bsSelected.nextSetBit(0);
                while (p >= 0 && i < n) {
                    dnew[i++] = p < d.length ? d[p] : 0.0;
                    p = bsSelected.nextSetBit(p + 1);
                }
                return dnew;
            }
        }
        return null;
    }

    @Override
    public void deleteModelAtoms(int firstAtomIndex, int nAtoms, BS bsDeleted) {
        if (this.dataValues.size() == 0) {
            return;
        }
        for (String name : this.dataValues.keySet()) {
            if (name.indexOf("property_") != 0) continue;
            Object[] obj = this.dataValues.get(name);
            BSUtil.deleteBits((BS)obj[2], bsDeleted);
            obj[1] = AU.deleteElements(obj[1], firstAtomIndex, nAtoms);
        }
    }

    @Override
    public String getDefaultVdwNameOrData(VDW type, BS bs) {
        SB sb = new SB();
        sb.append(type.getVdwLabel()).append("\n");
        boolean isAll = bs == null;
        int i0 = isAll ? 1 : bs.nextSetBit(0);
        int i1 = isAll ? Elements.elementNumberMax : bs.length();
        int i = i0;
        while (i < i1 && i >= 0) {
            sb.appendI(i).appendC('\t').appendD(type == VDW.USER ? this.vwr.userVdws[i] : (double)Elements.getVanderwaalsMar(i, type) / 1000.0).appendC('\t').append(Elements.elementSymbolFromNumber(i)).appendC('\n');
            i = isAll ? i + 1 : bs.nextSetBit(i + 1);
        }
        return bs == null ? sb.toString() : "\n  DATA \"element_vdw\"\n" + sb.append("  end \"element_vdw\";\n\n").toString();
    }

    @Override
    public boolean getDataState(JmolStateCreator sc, SB sb) {
        if (this.dataValues.size() == 0) {
            return false;
        }
        boolean haveData = false;
        for (String name : this.dataValues.keySet()) {
            Object[] obj;
            Object data;
            if (name.indexOf("property_") == 0) {
                Object[] obj2 = this.dataValues.get(name);
                if (obj2.length > 4 && !((Boolean)obj2[4]).booleanValue()) continue;
                int type = DataManager.getType(obj2);
                haveData = true;
                data = obj2[1];
                if (data != null && type == 1) {
                    sc.getAtomicPropertyStateBufferD(sb, 18, (BS)obj2[2], name, (double[])data);
                    sb.append("\n");
                    continue;
                }
                sb.append("\n").append(Escape.encapsulateData(name, data, -1));
                continue;
            }
            int type = name.indexOf("data2d") == 0 ? 2 : (name.indexOf("data3d") == 0 ? 3 : -1);
            if (type == -1 || (data = (obj = this.dataValues.get(name))[1]) == null || DataManager.getType(obj) != type) continue;
            haveData = true;
            sb.append("\n").append(Escape.encapsulateData(name, data, type));
        }
        return haveData;
    }

    @Override
    public Object[] createFileData(String strModel) {
        Object[] o = new Object[4];
        o[0] = "model";
        o[1] = strModel;
        o[3] = 0;
        return o;
    }
}

