/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.M3d;
import javajs.util.P3d;
import javajs.util.Qd;
import javajs.util.T3d;
import javajs.util.V3d;
import org.jmol.util.Logger;
import org.jmol.util.MeshSlicer;

public class MeshCapper {
    private MeshSlicer slicer;
    private boolean dumping;
    private Map<Integer, CapVertex> capMap;
    private Lst<CapVertex> vertices;
    private Lst<CapVertex[]> lstRegions;
    private static final int DESCENDER = 0;
    private static final int ASCENDER = 1;
    private static final int LAST = 2;
    private int nTriangles;
    private int nRegions;
    private Lst<int[]> lstTriangles;
    private int nPoints;
    M3d m3;
    M3d m3inv;

    public MeshCapper set(MeshSlicer slicer) {
        this.slicer = slicer;
        this.dumping = Logger.debugging;
        return this;
    }

    void clear() {
        this.capMap = new Hashtable<Integer, CapVertex>();
        this.vertices = new Lst();
    }

    public int[][] triangulateFaces(int[][] faces, P3d[] vertices, int[][] faceTriangles) {
        this.lstTriangles = new Lst();
        P3d[] points = new P3d[10];
        for (int[] face : faces) {
            int npts = face.length;
            if (points.length < npts) {
                points = new P3d[npts];
            }
            int n0 = this.lstTriangles.size();
            int i = npts;
            while (--i >= 0) {
                points[i] = vertices[face[i]];
            }
            this.triangulatePolygon(points, npts);
            int n1 = this.lstTriangles.size();
            int[] ft = new int[n1 - n0];
            if (faceTriangles != null) {
                faceTriangles[f] = ft;
            }
            for (int i2 = n0; i2 < n1; ++i2) {
                int[] t = (int[])this.lstTriangles.get(i2);
                ft[i2 - n0] = i2;
                int j = 3;
                while (--j >= 0) {
                    t[j] = face[t[j]];
                }
                t[3] = -t[3];
            }
        }
        int[][] triangles = AU.newInt2(this.lstTriangles.size());
        this.lstTriangles.toArray((T[])triangles);
        return triangles;
    }

    public int[][] triangulatePolygon(P3d[] points, int nPoints) {
        boolean haveList;
        this.clear();
        boolean bl = haveList = nPoints >= 0;
        if (!haveList || this.lstTriangles == null) {
            this.lstTriangles = new Lst();
        }
        this.nPoints = haveList ? nPoints : points.length;
        nPoints = this.nPoints;
        CapVertex v0 = null;
        for (int i = 0; i < nPoints; ++i) {
            if (points[i] == null) {
                return null;
            }
            CapVertex v = new CapVertex(points[i], i);
            this.vertices.addLast(v);
            if (v0 != null) {
                v0.link(v);
            }
            v0 = v;
        }
        v0.link((CapVertex)this.vertices.get(0));
        this.createCap(null);
        if (haveList) {
            return null;
        }
        int[][] a = AU.newInt2(this.lstTriangles.size());
        int i = this.lstTriangles.size();
        while (--i >= 0) {
            a[i] = (int[])this.lstTriangles.get(i);
        }
        return a;
    }

    void addEdge(int ipt1, int ipt2, int thisSet) {
        CapVertex v1 = this.addPoint(thisSet, ipt1);
        CapVertex v2 = this.addPoint(thisSet, ipt2);
        v1.link(v2);
    }

    private CapVertex addPoint(int thisSet, int i) {
        Integer ii = i;
        CapVertex v = this.capMap.get(ii);
        if (v == null) {
            T3d pt = this.slicer.m.vs[i];
            i = this.slicer.addIntersectionVertex(pt, 0.0, -1, thisSet, null, -1, -1);
            v = new CapVertex(pt, i);
            this.vertices.addLast(v);
            this.capMap.put(ii, v);
        }
        if (this.dumping) {
            Logger.info(i + "\t" + this.slicer.m.vs[i]);
        }
        return v;
    }

    private T3d getInputPoint(CapVertex v) {
        return this.slicer == null ? P3d.newP(v) : this.slicer.m.vs[v.ipt];
    }

    private void outputTriangle(int ipt1, int ipt2, int ipt3) {
        if (this.slicer == null) {
            int mask = 0;
            if (this.isEdge(ipt1, ipt2)) {
                mask |= 1;
            }
            if (this.isEdge(ipt2, ipt3)) {
                mask |= 2;
            }
            if (this.isEdge(ipt3, ipt1)) {
                mask |= 4;
            }
            this.lstTriangles.addLast(new int[]{ipt1, ipt2, ipt3, mask});
        } else {
            this.slicer.addTriangle(ipt1, ipt2, ipt3);
        }
    }

    private boolean isEdge(int i, int j) {
        return j == (i + 1) % this.nPoints;
    }

    void createCap(V3d norm) {
        CapVertex v0;
        V3d vac;
        this.capMap = null;
        this.lstRegions = new Lst();
        CapVertex[] vs = new CapVertex[this.vertices.size()];
        if (vs.length < 3) {
            return;
        }
        if (Logger.debugging) {
            Logger.info("MeshCapper using " + vs.length + " vertices");
        }
        this.vertices.toArray(vs);
        this.vertices = null;
        V3d vab = V3d.newVsub(vs[0], vs[1]);
        if (norm == null) {
            vac = V3d.newVsub(vs[0], vs[vs.length - 1]);
        } else {
            vac = V3d.newV(norm);
            vac.cross(vac, vab);
        }
        Qd q = Qd.getQuaternionFrameV(vab, vac, null, false);
        this.m3 = q.getMatrix();
        this.m3inv = M3d.newM3(this.m3);
        this.m3inv.invert();
        int i = vs.length;
        while (--i >= 0) {
            this.m3inv.rotate(vs[i]);
        }
        this.fixEndsAndSortVertices(vs);
        CapVertex v = v0 = vs[0];
        try {
            while ((v = this.process(v)) != v0) {
            }
        }
        catch (Exception e) {
            System.out.println("MeshCapper exception " + e);
            e.printStackTrace();
        }
        if (this.slicer != null) {
            this.clear();
        }
        if (Logger.debugging) {
            Logger.info("MeshCapper created " + this.nTriangles + " triangles " + this.nRegions + " regions");
        }
    }

    private void fixEndsAndSortVertices(CapVertex[] vs) {
        int n;
        Lst<CapVertex> v0s = new Lst<CapVertex>();
        Lst<CapVertex> v1s = new Lst<CapVertex>();
        int i = n = vs.length;
        while (--i >= 0) {
            if (vs[i].next == null) {
                v0s.addLast(vs[i]);
                continue;
            }
            if (vs[i].prev != null) continue;
            v1s.addLast(vs[i]);
        }
        i = v0s.size();
        while (--i >= 0) {
            CapVertex v0 = (CapVertex)v0s.get(i);
            CapVertex v1 = this.findNearestVertex(v1s, v0);
            if (v1 == null) {
                System.out.println("MESHCAPPER OHOH");
                continue;
            }
            v0.link(v1);
            if (!(v0.distanceSquared(v1) < 1.0E-6)) continue;
            v1.link(null);
        }
        Arrays.sort(vs, new MeshCapperSorter());
        i = n;
        while (--i >= 0) {
            vs[i].yxNext = vs[(i + 1) % n];
        }
        vs[n - 1].yxNext = vs[0];
    }

    private CapVertex findNearestVertex(Lst<CapVertex> v1s, CapVertex v0) {
        double min = Double.MAX_VALUE;
        CapVertex vmin = null;
        int imin = -1;
        int i = v1s.size();
        while (--i >= 0) {
            CapVertex v1 = (CapVertex)v1s.get(i);
            double d = v1.distanceSquared(v0);
            if (!(d < min)) continue;
            min = d;
            vmin = v1;
            imin = i;
        }
        if (imin >= 0) {
            v1s.removeItemAt(imin);
        }
        return vmin;
    }

    private CapVertex process(CapVertex v) {
        boolean isAscending;
        CapVertex q = v.yxNext;
        v.yxNext = null;
        if (this.dumping) {
            Logger.info(v.toString());
        }
        if (v.prev == v.next) {
            return q;
        }
        boolean isDescending = v.prev.region != null;
        boolean bl = isAscending = v.next.region != null;
        if (this.dumping) {
            Logger.info("#" + (isAscending ? v.next.id : "    ") + "    " + (isDescending ? v.prev.id : "") + "\n#" + (isAscending ? "   \\" : "    ") + (isDescending ? "    /\n" : "\n") + "#    " + v.id);
        }
        if (!isDescending && !isAscending) {
            CapVertex last = this.getLastPoint(v);
            if (last == null) {
                this.newRegion(v);
                return q;
            }
            CapVertex p = this.processSplit(v, last);
            p.yxNext = q;
            q = p;
            isAscending = true;
        }
        if (isDescending) {
            this.processMonotonic(v, true);
        }
        if (isAscending) {
            this.processMonotonic(v, false);
        }
        if (isDescending && isAscending) {
            if (v.prev.prev == v.next) {
                this.lstRegions.removeObj(v.region);
                this.addTriangle(v.prev, v, v.next, "end");
                MeshCapper.clearV(v.prev);
                MeshCapper.clearV(v.next);
            } else {
                v.region = null;
            }
        }
        return q;
    }

    private static void clearV(CapVertex v) {
        if (v != null) {
            v.clear();
        }
    }

    private void processMonotonic(CapVertex v, boolean isDescending) {
        CapVertex vEdge = isDescending ? v.prev : v.next;
        v.region = vEdge.region;
        CapVertex last = v.region[2];
        if (last == v) {
            this.lstRegions.removeObj(v.region);
            return;
        }
        if (last == vEdge) {
            CapVertex v2;
            CapVertex v1 = last;
            CapVertex capVertex = v2 = isDescending ? v1.prev : v1.next;
            while (v2 != v && v2.yxNext == null && isDescending == v.x > v.interpolateX(v2, v1)) {
                if (isDescending) {
                    this.addTriangle(v2, v1, v, "same desc " + v.ipt);
                    v1 = v2;
                    v2 = v2.prev;
                    continue;
                }
                this.addTriangle(v, v1, v2, "same asc " + v.ipt);
                v1 = v2;
                v2 = v2.next;
            }
        } else {
            CapVertex v2 = vEdge;
            do {
                CapVertex v1 = v2;
                if (isDescending) {
                    v2 = v1.prev;
                    this.addTriangle(v2, v1, v, "opp desc " + v.id);
                    continue;
                }
                v2 = v1.next;
                this.addTriangle(v, v1, v2, "opp asc " + v.id);
            } while (v2 != last && v2 != v && v2.yxNext == null);
            if (last.region == null) {
                this.lstRegions.removeObj(v.region);
                CapVertex capVertex = isDescending ? last.prev : last.next;
                last.region = capVertex.region;
                v.region = capVertex.region;
            }
        }
        CapVertex capVertex = v;
        v.region[isDescending ? 0 : 1] = capVertex;
        v.region[2] = capVertex;
    }

    private CapVertex processSplit(CapVertex v, CapVertex last) {
        CapVertex pv = last.cloneV();
        if (this.dumping) {
            pv.id = pv.id + "a";
        }
        CapVertex p = v.cloneV();
        if (this.dumping) {
            p.id = p.id + "a";
        }
        if (last.region == null) {
            last.region = last.next.region;
            pv.region = last.prev.region;
        } else {
            this.newRegion(last);
            CapVertex cv = last;
            while (cv.next.region != null) {
                cv.next.region = cv.region;
                cv.region[0] = cv = cv.next;
            }
        }
        CapVertex[] r = pv.region;
        if (r[2] == last) {
            r[2] = pv;
        }
        r[0] = pv;
        if (r[1] == last) {
            r[1] = pv;
        }
        v.link(last);
        pv.prev.link(pv);
        pv.link(p);
        p.link(p.next);
        return p;
    }

    private void newRegion(CapVertex v) {
        ++this.nRegions;
        v.region = new CapVertex[]{v, v, v};
        this.lstRegions.addLast(v.region);
    }

    private CapVertex getLastPoint(CapVertex v) {
        CapVertex closest = null;
        double ymin = Double.MAX_VALUE;
        int i = this.lstRegions.size();
        while (--i >= 0) {
            boolean isOK;
            CapVertex[] r = (CapVertex[])this.lstRegions.get(i);
            CapVertex d = r[0];
            if (d == r[1]) continue;
            boolean isEdge = d.region != null;
            boolean bl = isOK = (isEdge ? v.interpolateX(d, d.next) : d.x) < v.x;
            if (isEdge && closest != null && closest.x != d.x && isOK == closest.x < d.x) {
                closest = null;
                ymin = Double.MAX_VALUE;
            }
            if (!isOK) continue;
            CapVertex a = r[1];
            isEdge = a.region != null;
            boolean bl2 = isOK = (isEdge ? v.interpolateX(a, a.prev) : a.x) >= v.x;
            if (isEdge && closest != null && closest.x != a.x && isOK == closest.x > a.x) {
                closest = null;
                ymin = Double.MAX_VALUE;
            }
            if (!isOK || !(r[2].y < ymin)) continue;
            ymin = r[2].y;
            closest = r[2];
        }
        return closest;
    }

    private boolean checkWinding(CapVertex v0, CapVertex v1, CapVertex v2) {
        return (v1.x - v0.x) * (v2.y - v0.y) > (v1.y - v0.y) * (v2.x - v0.x);
    }

    private void addTriangle(CapVertex v0, CapVertex v1, CapVertex v2, String note) {
        ++this.nTriangles;
        if (this.checkWinding(v0, v1, v2)) {
            if (this.dumping) {
                this.drawTriangle(this.nTriangles, v0, v1, v2, "red");
            }
            this.outputTriangle(v0.ipt, v1.ipt, v2.ipt);
        } else if (this.dumping) {
            Logger.info("#!!!BAD WINDING " + note);
        }
        v1.link(null);
    }

    private void drawTriangle(int index, CapVertex v0, CapVertex v1, CapVertex v2, String color) {
        T3d p0 = this.getInputPoint(v0);
        T3d p1 = this.getInputPoint(v1);
        T3d p2 = this.getInputPoint(v2);
        Logger.info("draw " + color + index + "/* " + v0.id + " " + v1.id + " " + v2.id + " */" + p0 + p1 + p2 + " color " + color);
    }

    private class CapVertex
    extends T3d
    implements Cloneable {
        int ipt;
        String id = "";
        protected CapVertex yxNext;
        CapVertex prev;
        CapVertex next;
        CapVertex[] region;

        CapVertex(T3d p, int i) {
            this.ipt = i;
            this.id = "" + i;
            this.setT(p);
        }

        public CapVertex cloneV() {
            try {
                return (CapVertex)this.clone();
            }
            catch (Exception e) {
                return null;
            }
        }

        protected double interpolateX(CapVertex v1, CapVertex v2) {
            double dy12 = v2.y - v1.y;
            double dx12 = v2.x - v1.x;
            return dy12 != 0.0 ? v1.x + (this.y - v1.y) * dx12 / dy12 : (dx12 > 0.0 ? Double.MAX_VALUE : -1.7976931348623157E308);
        }

        protected void link(CapVertex v) {
            if (v == null) {
                this.prev.next = this.next;
                this.next.prev = this.prev;
                this.clear();
            } else {
                this.next = v;
                v.prev = this;
            }
        }

        protected void clear() {
            this.prev = null;
            this.next = null;
            this.yxNext = null;
            this.region = null;
        }

        private String dumpRegion() {
            String s = "\n#REGION d=" + this.region[0].id + " a=" + this.region[1].id + " last=" + this.region[2].id + "\n# ";
            CapVertex v = this.region[1];
            while (true) {
                s = s + v.id + " ";
                if (v == this.region[0]) break;
                v = v.next;
            }
            return s + "\n";
        }

        @Override
        public String toString() {
            T3d c;
            T3d t3d = c = MeshCapper.this.m3 == null ? this : new P3d();
            if (MeshCapper.this.m3 != null) {
                MeshCapper.this.m3.rotate2(this, c);
            }
            return "draw p" + this.id + " {" + c.x + " " + c.y + " " + c.z + "} # " + (this.prev == null ? "null" : this.prev.id) + (this.next == null ? " null" : " " + this.next.id) + (this.region == null ? "" : this.dumpRegion());
        }
    }

    public class MeshCapperSorter
    implements Comparator<CapVertex> {
        @Override
        public int compare(CapVertex v1, CapVertex v2) {
            return v1.y < v2.y ? 1 : (v1.y > v2.y || v1.x < v2.x ? -1 : (v1.x > v2.x ? 1 : 0));
        }
    }
}

