/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3d;
import javajs.util.P3d;
import javajs.util.PT;
import javajs.util.Qd;
import javajs.util.SB;
import javajs.util.T3d;
import javajs.util.V3d;
import org.jmol.bspt.Bspt;
import org.jmol.bspt.CubeIterator;
import org.jmol.modelset.Atom;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.util.Point3fi;
import org.jmol.util.Vibration;

class PointGroup {
    private static final int[] axesMaxN = new int[]{15, 0, 0, 1, 3, 1, 10, 0, 1, 0, 6, 0, 1, 0, 0, 0, 15, 10, 6, 6, 10, 0, 1};
    private static final int[] nUnique = new int[]{1, 0, 0, 2, 2, 4, 2, 0, 4, 0, 4, 0, 4, 0, 0, 0, 1, 2, 2, 4, 2, 0, 4};
    private static final int s3 = 3;
    private static final int s4 = 4;
    private static final int s5 = 5;
    private static final int s6 = 6;
    private static final int s8 = 8;
    private static final int s10 = 10;
    private static final int s12 = 12;
    private static final int firstProper = 14;
    private static final int c2 = 16;
    private static final int c3 = 17;
    private static final int c4 = 18;
    private static final int c5 = 19;
    private static final int c6 = 20;
    private static final int c8 = 22;
    private static final int maxAxis = axesMaxN.length;
    private boolean isAtoms;
    String drawInfo;
    Map<String, Object> info;
    String textInfo;
    private CubeIterator iter;
    private String drawType = "";
    private int drawIndex;
    private double scale = Double.NaN;
    private int[] nAxes = new int[maxAxis];
    private Operation[][] axes = new Operation[maxAxis][];
    private int nAtoms;
    private double radius;
    private double distanceTolerance = 0.25;
    private double distanceTolerance2;
    private double linearTolerance = 8.0;
    private double cosTolerance = 0.99;
    private String name = "C_1?";
    private Operation principalAxis;
    private Operation principalPlane;
    private static final int CONVENTION_SCHOENFLIES = 0;
    private static final int CONVENTION_HERMANN_MAUGUIN = 1;
    private int convention = 0;
    private final V3d vTemp = new V3d();
    private int centerAtomIndex = -1;
    private boolean haveInversionCenter;
    private T3d center;
    private T3d[] points;
    private int[] elements;
    private int[] atomMap;
    private BS bsAtoms;
    private boolean haveVibration;
    private boolean localEnvOnly;
    private boolean isLinear;
    private double sppa;
    int maxAtoms = 250;
    int maxElement = 0;
    int[] eCounts;
    static final int OPERATION_PLANE = 0;
    static final int OPERATION_PROPER_AXIS = 1;
    static final int OPERATION_IMPROPER_AXIS = 2;
    static final int OPERATION_INVERSION_CENTER = 3;
    static final String[] typeNames = new String[]{"plane", "proper axis", "improper axis", "center of inversion"};
    static final M3d mInv = M3d.newA9(new double[]{-1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, -1.0});
    int nOps = 0;
    private static final String[] SF2HM = "Cn,1,2,3,4,5,6,7,8,9,10,11,12|Cnv,m,2m,3m,4mm,5m,6mm,7m,8mm,9m,10mm,11m,12mm,\u221em|Sn,,-1,-6,-4,(-10),-3,(-14),-8,(-18),-5,(-22),(-12)|Cnh,m,2/m,-6,4/m,-10,6/m,-14,8/m,-18,10/m,-22,12/m|Dn,,222,32,422,52,622,72,822,92,(10)22,(11)2,(12)22|Dnd,,-42m,-3m,-82m,-5m,(-12)2m,-7m,(-16)2m,-9m,(-20)2m,(-11)m,(-24)2m|Dnh,,mmm,-6m2,4/mmm,(-10)m2,6/mmm,(-14)m2,8/mmm,(-18)m2,10/mmm,(-22)m2,12/mmm,\u221e/mm|Ci,-1|Cs,m|T,23|Th,m-3|Td,-43m|O,432|Oh,m-3m".split("\\|");
    private static Map<String, String> htSFToHM;

    String getName() {
        return this.getConventionalName(this.name);
    }

    String getHermannMauguinName() {
        return PointGroup.getHMfromSFName(this.name);
    }

    String getConventionalName(String name) {
        return this.convention == 1 ? PointGroup.getHMfromSFName(name) : name;
    }

    static PointGroup getPointGroup(PointGroup pgLast, T3d center, T3d[] atomset, BS bsAtoms, boolean haveVibration, double distanceTolerance, double linearTolerance, int maxAtoms, boolean localEnvOnly, boolean isHM, double sppa) {
        PointGroup pg = new PointGroup(isHM);
        if (distanceTolerance <= 0.0) {
            distanceTolerance = 0.01f;
        }
        if (linearTolerance <= 0.0) {
            linearTolerance = 0.5;
        }
        if (maxAtoms <= 0) {
            maxAtoms = 250;
        }
        pg.distanceTolerance = distanceTolerance;
        pg.distanceTolerance2 = distanceTolerance * distanceTolerance;
        pg.linearTolerance = linearTolerance;
        pg.maxAtoms = maxAtoms;
        pg.isAtoms = bsAtoms != null;
        pg.bsAtoms = pg.isAtoms ? bsAtoms : BSUtil.newBitSet2(0, atomset.length);
        pg.haveVibration = haveVibration;
        pg.center = center;
        pg.localEnvOnly = localEnvOnly;
        pg.sppa = sppa;
        if (Logger.debugging) {
            pgLast = null;
        }
        return pg.set(pgLast, atomset) ? pg : pgLast;
    }

    private PointGroup(boolean isHM) {
        this.convention = isHM ? 1 : 0;
    }

    private boolean isEqual(PointGroup pg) {
        if (pg == null) {
            return false;
        }
        if (this.convention != pg.convention || this.linearTolerance != pg.linearTolerance || this.distanceTolerance != pg.distanceTolerance || this.nAtoms != pg.nAtoms || this.localEnvOnly != pg.localEnvOnly || this.haveVibration != pg.haveVibration || this.bsAtoms == null ? pg.bsAtoms != null : !this.bsAtoms.equals(pg.bsAtoms)) {
            return false;
        }
        for (int i = 0; i < this.nAtoms; ++i) {
            if (this.elements[i] == pg.elements[i] && this.points[i].equals(pg.points[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean set(PointGroup pgLast, T3d[] atomset) {
        this.cosTolerance = Math.cos(this.linearTolerance / 180.0 * Math.PI);
        if (!this.getPointsAndElements(atomset)) {
            Logger.error("Too many atoms for point group calculation");
            this.name = "point group not determined -- ac > " + this.maxAtoms + " -- select fewer atoms and try again.";
            return true;
        }
        this.getElementCounts();
        if (this.haveVibration) {
            P3d[] atomVibs = new P3d[this.points.length];
            int i = this.points.length;
            while (--i >= 0) {
                atomVibs[i] = P3d.newP(this.points[i]);
                Vibration v = ((Atom)this.points[i]).getVibrationVector();
                if (v == null) continue;
                atomVibs[i].add(v);
            }
            this.points = atomVibs;
        }
        if (this.isEqual(pgLast)) {
            return false;
        }
        try {
            this.findInversionCenter();
            this.isLinear = this.isLinear(this.points);
            if (this.isLinear) {
                this.name = this.haveInversionCenter ? "D(infinity)h" : "C(infinity)v";
                this.vTemp.sub2(this.points[1], this.points[0]);
                this.addAxis(16, this.vTemp);
                this.principalAxis = this.axes[16][0];
                if (this.haveInversionCenter) {
                    this.axes[0] = new Operation[1];
                    int n = this.nAxes[0];
                    this.nAxes[0] = n + 1;
                    Operation operation = new Operation(this.vTemp);
                    this.axes[0][n] = operation;
                    this.principalPlane = operation;
                }
                boolean atomVibs = true;
                return atomVibs;
            }
            this.axes[0] = new Operation[15];
            int nPlanes = 0;
            this.findCAxes();
            nPlanes = this.findPlanes();
            this.findAdditionalAxes(nPlanes);
            int n = this.getHighestOrder();
            if (this.nAxes[17] > 1) {
                this.name = this.nAxes[19] > 1 ? (this.haveInversionCenter ? "Ih" : "I") : (this.nAxes[18] > 1 ? (this.haveInversionCenter ? "Oh" : "O") : (nPlanes > 0 ? (this.haveInversionCenter ? "Th" : "Td") : "T"));
            } else if (n < 2) {
                if (nPlanes == 1) {
                    this.name = "Cs";
                    boolean bl = true;
                    return bl;
                }
                if (this.haveInversionCenter) {
                    this.name = "Ci";
                    boolean bl = true;
                    return bl;
                }
                this.name = "C1";
            } else if (n % 2 == 1 && this.nAxes[16] > 0 || n % 2 == 0 && this.nAxes[16] > 1) {
                this.principalAxis = this.setPrincipalAxis(n, nPlanes);
                if (nPlanes == 0) {
                    this.name = n < 14 ? "S" + n : "D" + (n - 14);
                } else {
                    n = n < 14 ? (n /= 2) : (n -= 14);
                    this.name = nPlanes == n ? "D" + n + "d" : "D" + n + "h";
                }
            } else if (nPlanes == 0) {
                this.principalAxis = this.axes[n][0];
                this.name = n < 14 ? "S" + n : "C" + (n - 14);
            } else if (nPlanes == n - 14) {
                this.principalAxis = this.axes[n][0];
                this.name = "C" + nPlanes + "v";
            } else {
                this.principalAxis = this.axes[n < 14 ? n + 14 : n][0];
                this.principalPlane = this.axes[0][0];
                n = n < 14 ? (n /= 2) : (n -= 14);
                this.name = "C" + n + "h";
            }
        }
        catch (Exception e) {
            this.name = "??";
        }
        finally {
            Logger.info("Point group found: " + this.name);
        }
        return true;
    }

    private Operation setPrincipalAxis(int n, int nPlanes) {
        Operation principalPlane = this.setPrincipalPlane(n, nPlanes);
        if (nPlanes == 0 && n < 14 || this.nAxes[n] == 1) {
            return this.axes[n][0];
        }
        if (principalPlane == null) {
            return null;
        }
        for (int i = 0; i < this.nAxes[16]; ++i) {
            if (!this.isParallel(principalPlane.normalOrAxis, this.axes[16][i].normalOrAxis)) continue;
            if (i != 0) {
                Operation o = this.axes[16][0];
                this.axes[16][0] = this.axes[16][i];
                this.axes[16][i] = o;
            }
            return this.axes[16][0];
        }
        return null;
    }

    private Operation setPrincipalPlane(int n, int nPlanes) {
        if (nPlanes == 1) {
            this.principalPlane = this.axes[0][0];
            return this.principalPlane;
        }
        if (nPlanes == 0 || nPlanes == n - 14) {
            return null;
        }
        for (int i = 0; i < nPlanes; ++i) {
            int nPerp = 0;
            for (int j = 0; j < nPlanes; ++j) {
                if (!this.isPerpendicular(this.axes[0][i].normalOrAxis, this.axes[0][j].normalOrAxis) || ++nPerp <= 2) continue;
                if (i != 0) {
                    Operation o = this.axes[0][0];
                    this.axes[0][0] = this.axes[0][i];
                    this.axes[0][i] = o;
                }
                this.principalPlane = this.axes[0][0];
                return this.principalPlane;
            }
        }
        return null;
    }

    private boolean getPointsAndElements(T3d[] atomset) {
        boolean needCenter;
        int ac = this.bsAtoms.cardinality();
        if (this.isAtoms && ac > this.maxAtoms) {
            return false;
        }
        this.points = new P3d[ac];
        this.elements = new int[ac];
        if (ac == 0) {
            return true;
        }
        int atomIndexMax = 0;
        int i = this.bsAtoms.nextSetBit(0);
        while (i >= 0) {
            T3d p = atomset[i];
            if (p instanceof Node) {
                atomIndexMax = Math.max(atomIndexMax, ((Point3fi)p).i);
            }
            i = this.bsAtoms.nextSetBit(i + 1);
        }
        this.atomMap = new int[atomIndexMax + 1];
        this.nAtoms = 0;
        boolean bl = needCenter = this.center == null;
        if (needCenter) {
            this.center = new P3d();
        }
        Bspt bspt = new Bspt(3, 0);
        int i2 = this.bsAtoms.nextSetBit(0);
        while (i2 >= 0) {
            T3d p = atomset[i2];
            if (p instanceof Node) {
                int bondIndex = this.localEnvOnly ? 1 : 1 + Math.max(3, ((Node)((Object)p)).getCovalentBondCount());
                this.elements[this.nAtoms] = ((Node)((Object)p)).getElementNumber() * bondIndex;
                this.atomMap[((Point3fi)p).i] = this.nAtoms + 1;
            } else {
                Point3fi newPt = new Point3fi();
                newPt.setT(p);
                newPt.i = -1 - this.nAtoms;
                if (p instanceof Point3fi) {
                    this.elements[this.nAtoms] = Math.max(0, ((Point3fi)p).sD);
                }
                p = newPt;
            }
            bspt.addTuple(p);
            if (needCenter) {
                this.center.add(p);
            }
            this.points[this.nAtoms] = p;
            i2 = this.bsAtoms.nextSetBit(i2 + 1);
            ++this.nAtoms;
        }
        this.iter = bspt.allocateCubeIterator();
        if (needCenter) {
            this.center.scale(1.0 / (double)this.nAtoms);
        }
        i2 = this.nAtoms;
        while (--i2 >= 0) {
            double r2 = this.center.distanceSquared(this.points[i2]);
            if (this.isAtoms && r2 < this.distanceTolerance2) {
                this.centerAtomIndex = i2;
            }
            this.radius = Math.max(this.radius, r2);
        }
        this.radius = Math.sqrt(this.radius);
        if (this.radius < 1.5 && this.distanceTolerance > 0.15) {
            this.distanceTolerance = this.radius / 10.0;
            this.distanceTolerance2 = this.distanceTolerance * this.distanceTolerance;
            System.out.println("PointGroup calculation adjusting distanceTolerance to " + this.distanceTolerance);
        }
        return true;
    }

    private void findInversionCenter() {
        this.haveInversionCenter = this.checkOperation(null, this.center, -1);
        if (this.haveInversionCenter) {
            this.axes[1] = new Operation[1];
            this.axes[1][0] = new Operation();
        }
    }

    private boolean checkOperation(Qd q, T3d center, int iOrder) {
        int n;
        P3d pt = new P3d();
        int nFound = 0;
        boolean isInversion = iOrder < 14;
        int i = n = this.points.length;
        block0: while (--i >= 0 && nFound < n) {
            if (i == this.centerAtomIndex) continue;
            T3d a1 = this.points[i];
            int e1 = this.elements[i];
            if (q != null) {
                pt.sub2(a1, center);
                q.transform2(pt, pt).add(center);
            } else {
                pt.setT(a1);
            }
            if (isInversion) {
                this.vTemp.sub2(center, pt);
                pt.scaleAdd2(2.0, this.vTemp, pt);
            }
            if ((q != null || isInversion) && pt.distanceSquared(a1) < this.distanceTolerance2) {
                ++nFound;
                continue;
            }
            this.iter.initialize(pt, this.distanceTolerance, false);
            while (this.iter.hasMoreElements()) {
                T3d a2 = this.iter.nextElement();
                if (a2 == a1) continue;
                int j = this.getPointIndex(((Point3fi)a2).i);
                if (this.centerAtomIndex >= 0 && j == this.centerAtomIndex || j >= this.elements.length || this.elements[j] != e1 || !(pt.distanceSquared(a2) < this.distanceTolerance2)) continue;
                ++nFound;
                continue block0;
            }
            return false;
        }
        return true;
    }

    private int getPointIndex(int j) {
        return (j < 0 ? -j : this.atomMap[j]) - 1;
    }

    private boolean isLinear(T3d[] atoms) {
        V3d v1 = null;
        if (atoms.length < 2) {
            return false;
        }
        int i = atoms.length;
        while (--i >= 0) {
            if (i == this.centerAtomIndex) continue;
            if (v1 == null) {
                v1 = new V3d();
                v1.sub2(atoms[i], this.center);
                v1.normalize();
                this.vTemp.setT(v1);
                continue;
            }
            this.vTemp.sub2(atoms[i], this.center);
            this.vTemp.normalize();
            if (this.isParallel(v1, this.vTemp)) continue;
            return false;
        }
        return true;
    }

    private boolean isParallel(V3d v1, V3d v2) {
        return Math.abs(v1.dot(v2)) >= this.cosTolerance;
    }

    private boolean isPerpendicular(V3d v1, V3d v2) {
        return Math.abs(v1.dot(v2)) <= 1.0 - this.cosTolerance;
    }

    private void getElementCounts() {
        int i = this.points.length;
        while (--i >= 0) {
            int e1 = this.elements[i];
            if (e1 <= this.maxElement) continue;
            this.maxElement = e1;
        }
        this.eCounts = new int[++this.maxElement];
        i = this.points.length;
        while (--i >= 0) {
            int n = this.elements[i];
            this.eCounts[n] = this.eCounts[n] + 1;
        }
    }

    private int findCAxes() {
        int i;
        int i2;
        int j;
        V3d v1 = new V3d();
        V3d v2 = new V3d();
        V3d v3 = new V3d();
        int i3 = this.points.length;
        while (--i3 >= 0) {
            if (i3 == this.centerAtomIndex) continue;
            T3d a1 = this.points[i3];
            int e1 = this.elements[i3];
            j = this.points.length;
            while (--j > i3) {
                int iOrder;
                double order;
                boolean isIntegerOrder;
                T3d a2 = this.points[j];
                if (this.elements[j] != e1) continue;
                v1.sub2(a1, this.center);
                v2.sub2(a2, this.center);
                v1.normalize();
                v2.normalize();
                if (this.isParallel(v1, v2)) {
                    this.getAllAxes(v1);
                    continue;
                }
                if (this.nAxes[16] < axesMaxN[16]) {
                    v3.ave(a1, a2);
                    v3.sub(this.center);
                    this.getAllAxes(v3);
                }
                if (!(isIntegerOrder = (order = Math.PI * 2 / v1.angle(v2)) - (double)(iOrder = (int)Math.floor(order + (double)0.01f)) <= (double)0.02f) || (iOrder += 14) >= maxAxis || this.nAxes[iOrder] >= axesMaxN[iOrder]) continue;
                v3.cross(v1, v2);
                this.checkAxisOrder(iOrder, v3, this.center);
            }
        }
        V3d[] vs = new V3d[this.nAxes[16] * 2];
        for (int i4 = 0; i4 < vs.length; ++i4) {
            vs[i4] = new V3d();
        }
        int n = 0;
        for (i2 = 0; i2 < this.nAxes[16]; ++i2) {
            vs[n++].setT(this.axes[16][i2].normalOrAxis);
            vs[n].setT(this.axes[16][i2].normalOrAxis);
            vs[n++].scale(-1.0);
        }
        i2 = vs.length;
        while (--i2 >= 2) {
            j = i2;
            while (--j >= 1) {
                int k = j;
                while (--k >= 0) {
                    v3.add2(vs[i2], vs[j]);
                    v3.add(vs[k]);
                    if (v3.length() < 1.0) continue;
                    this.checkAxisOrder(17, v3, this.center);
                }
            }
        }
        int nMin = Integer.MAX_VALUE;
        int iMin = -1;
        for (i = 0; i < this.maxElement; ++i) {
            if (this.eCounts[i] >= nMin || this.eCounts[i] <= 2) continue;
            nMin = this.eCounts[i];
            iMin = i;
        }
        block8: for (i = 0; i < this.points.length - 2; ++i) {
            if (this.elements[i] != iMin) continue;
            for (int j2 = i + 1; j2 < this.points.length - 1; ++j2) {
                if (this.elements[j2] != iMin) continue;
                for (int k = j2 + 1; k < this.points.length; ++k) {
                    if (this.elements[k] != iMin) continue;
                    v1.sub2(this.points[i], this.points[j2]);
                    v2.sub2(this.points[i], this.points[k]);
                    v1.normalize();
                    v2.normalize();
                    v3.cross(v1, v2);
                    this.getAllAxes(v3);
                    v1.add2(this.points[i], this.points[j2]);
                    v1.add(this.points[k]);
                    v1.normalize();
                    if (!this.isParallel(v1, v3)) {
                        this.getAllAxes(v1);
                    }
                    if (this.nAxes[19] == axesMaxN[19]) break block8;
                }
            }
        }
        vs = new V3d[this.maxElement];
        i = this.points.length;
        while (--i >= 0) {
            int e1 = this.elements[i];
            if (vs[e1] == null) {
                vs[e1] = new V3d();
            } else if (this.haveInversionCenter) continue;
            vs[e1].add(this.points[i]);
        }
        if (!this.haveInversionCenter) {
            for (i = 0; i < this.maxElement; ++i) {
                if (vs[i] == null) continue;
                vs[i].scale(1.0 / (double)this.eCounts[i]);
            }
        }
        for (i = 0; i < this.maxElement; ++i) {
            if (vs[i] == null) continue;
            for (int j3 = 0; j3 < this.maxElement; ++j3) {
                if (i == j3 || vs[j3] == null) continue;
                if (this.haveInversionCenter) {
                    v1.cross(vs[i], vs[j3]);
                } else {
                    v1.sub2(vs[i], vs[j3]);
                }
                this.checkAxisOrder(16, v1, this.center);
            }
        }
        return this.getHighestOrder();
    }

    private void getAllAxes(V3d v3) {
        for (int o = 16; o < maxAxis; ++o) {
            if (this.nAxes[o] >= axesMaxN[o]) continue;
            this.checkAxisOrder(o, v3, this.center);
        }
    }

    private int getHighestOrder() {
        int n = 0;
        n = 14;
        while (--n > 1 && this.nAxes[n] == 0) {
        }
        if (n > 1) {
            return n + 14 < maxAxis && this.nAxes[n + 14] > 0 ? n + 14 : n;
        }
        n = maxAxis;
        while (--n > 1 && this.nAxes[n] == 0) {
        }
        return n;
    }

    private boolean checkAxisOrder(int iOrder, V3d v, T3d center) {
        switch (iOrder) {
            case 22: {
                if (this.nAxes[17] > 0) {
                    return false;
                }
            }
            case 18: 
            case 20: {
                if (this.nAxes[19] <= 0) break;
                return false;
            }
            case 17: {
                if (this.nAxes[22] <= 0) break;
                return false;
            }
            case 19: {
                if (this.nAxes[18] <= 0 && this.nAxes[20] <= 0 && this.nAxes[22] <= 0) break;
                return false;
            }
        }
        v.normalize();
        if (this.haveAxis(iOrder, v)) {
            return false;
        }
        Qd q = PointGroup.getQuaternion(v, iOrder);
        if (!this.checkOperation(q, center, iOrder)) {
            return false;
        }
        this.addAxis(iOrder, v);
        switch (iOrder) {
            case 16: {
                this.checkAxisOrder(4, v, center);
                break;
            }
            case 17: {
                this.checkAxisOrder(3, v, center);
                if (!this.haveInversionCenter) break;
                this.addAxis(6, v);
                break;
            }
            case 18: {
                this.addAxis(16, v);
                this.checkAxisOrder(4, v, center);
                this.checkAxisOrder(8, v, center);
                break;
            }
            case 19: {
                this.checkAxisOrder(5, v, center);
                if (!this.haveInversionCenter) break;
                this.addAxis(10, v);
                break;
            }
            case 20: {
                this.addAxis(16, v);
                this.addAxis(17, v);
                this.checkAxisOrder(3, v, center);
                this.checkAxisOrder(6, v, center);
                this.checkAxisOrder(12, v, center);
                break;
            }
            case 22: {
                this.addAxis(16, v);
                this.addAxis(18, v);
            }
        }
        return true;
    }

    private void addAxis(int iOrder, V3d v) {
        if (this.haveAxis(iOrder, v)) {
            return;
        }
        if (this.axes[iOrder] == null) {
            this.axes[iOrder] = new Operation[axesMaxN[iOrder]];
        }
        int n = iOrder;
        int n2 = this.nAxes[n];
        this.nAxes[n] = n2 + 1;
        this.axes[iOrder][n2] = new Operation(v, iOrder);
    }

    private boolean haveAxis(int iOrder, V3d v) {
        if (this.nAxes[iOrder] == axesMaxN[iOrder]) {
            return true;
        }
        if (this.nAxes[iOrder] > 0) {
            int i = this.nAxes[iOrder];
            while (--i >= 0) {
                if (!this.isParallel(v, this.axes[iOrder][i].normalOrAxis)) continue;
                return true;
            }
        }
        return false;
    }

    private int findPlanes() {
        P3d pt = new P3d();
        V3d v1 = new V3d();
        V3d v2 = new V3d();
        V3d v3 = new V3d();
        int nPlanes = 0;
        boolean haveAxes = this.getHighestOrder() > 1;
        int i = this.points.length;
        while (--i >= 0) {
            if (i == this.centerAtomIndex) continue;
            T3d a1 = this.points[i];
            int e1 = this.elements[i];
            int j = this.points.length;
            while (--j > i) {
                if (haveAxes && this.elements[j] != e1) continue;
                T3d a2 = this.points[j];
                pt.add2(a1, a2);
                pt.scale(0.5);
                v1.sub2(a1, this.center);
                v2.sub2(a2, this.center);
                v1.normalize();
                v2.normalize();
                if (!this.isParallel(v1, v2)) {
                    v3.cross(v1, v2);
                    v3.normalize();
                    nPlanes = this.getPlane(v3);
                }
                v3.sub2(a2, a1);
                v3.normalize();
                nPlanes = this.getPlane(v3);
                if (nPlanes != axesMaxN[0]) continue;
                return nPlanes;
            }
        }
        if (haveAxes) {
            for (i = 16; i < maxAxis; ++i) {
                for (int j = 0; j < this.nAxes[i]; ++j) {
                    nPlanes = this.getPlane(this.axes[i][j].normalOrAxis);
                }
            }
        }
        return nPlanes;
    }

    private int getPlane(V3d v3) {
        if (!this.haveAxis(0, v3) && this.checkOperation(Qd.newVA(v3, 180.0), this.center, -1)) {
            int n = this.nAxes[0];
            this.nAxes[0] = n + 1;
            this.axes[0][n] = new Operation(v3);
        }
        return this.nAxes[0];
    }

    private void findAdditionalAxes(int nPlanes) {
        Operation[] planes = this.axes[0];
        int Cn = 0;
        if (nPlanes > 1 && (Cn = nPlanes + 14) < maxAxis && this.nAxes[Cn] == 0) {
            this.vTemp.cross(planes[0].normalOrAxis, planes[1].normalOrAxis);
            if (!this.checkAxisOrder(Cn, this.vTemp, this.center) && nPlanes > 2) {
                this.vTemp.cross(planes[1].normalOrAxis, planes[2].normalOrAxis);
                this.checkAxisOrder(Cn - 1, this.vTemp, this.center);
            }
        }
        if (this.nAxes[16] == 0 && nPlanes > 2) {
            for (int i = 0; i < nPlanes - 1; ++i) {
                for (int j = i + 1; j < nPlanes; ++j) {
                    this.vTemp.add2(planes[1].normalOrAxis, planes[2].normalOrAxis);
                    this.checkAxisOrder(16, this.vTemp, this.center);
                }
            }
        }
    }

    static Qd getQuaternion(V3d v, int iOrder) {
        return Qd.newVA(v, (iOrder < 14 ? 180 : 0) + (iOrder == 0 ? 0 : 360 / (iOrder % 14)));
    }

    Object getInfo(int modelIndex, String drawID, boolean asInfo, String type, int index, double scaleFactor) {
        String ctype;
        boolean asDraw = drawID != null;
        this.info = asInfo ? new Hashtable() : null;
        V3d v = new V3d();
        if (scaleFactor == 0.0) {
            scaleFactor = 1.0;
        }
        this.scale = scaleFactor;
        int[][] nType = new int[4][2];
        for (int i = 1; i < maxAxis; ++i) {
            int j = this.nAxes[i];
            while (--j >= 0) {
                int[] nArray = nType[this.axes[i][j].type];
                nArray[0] = nArray[0] + 1;
            }
        }
        SB sb = new SB().append("# ").appendI(this.nAtoms).append(" atoms\n");
        String name = this.getConventionalName(this.name);
        if (asDraw) {
            Operation op;
            int i;
            drawID = "draw " + drawID;
            boolean haveType = type != null && type.length() > 0;
            type = haveType ? type : "";
            this.drawType = type;
            this.drawIndex = index;
            boolean anyProperAxis = type.equalsIgnoreCase(this.getConventionalName("Cn"));
            boolean anyImproperAxis = type.equalsIgnoreCase(this.getConventionalName("Sn"));
            sb.append("set perspectivedepth off;\n");
            String m = "_" + modelIndex + "_";
            if (!haveType) {
                sb.append(drawID + "pg0").append(m).append("* delete;draw pgva").append(m).append("* delete;draw pgvp").append(m).append("* delete;");
            }
            if (!haveType || type.equalsIgnoreCase("Ci")) {
                sb.append(drawID + "pg0").append(m).append(this.haveInversionCenter ? "inv " : " ").append(Escape.eP(this.center)).append(this.haveInversionCenter ? "\"i\";\n" : ";\n");
            }
            double offset = 0.1;
            for (i = 2; i < maxAxis; ++i) {
                boolean isProper;
                if (i == 14) {
                    offset = 0.1;
                }
                if (this.nAxes[i] == 0) continue;
                String sglabel = !this.isLinear ? this.axes[i][0].getLabel(false) : "C_infinity";
                String label = !this.isLinear ? this.axes[i][0].getLabel(true) : "C_infinity";
                double scale = scaleFactor * 1.05 * this.radius + (offset += 0.25) * 80.0 / this.sppa;
                boolean bl = isProper = i >= 14;
                if (haveType && !type.equalsIgnoreCase(label) && (!anyProperAxis || !isProper) && (!anyImproperAxis || isProper)) continue;
                for (int j = 0; j < this.nAxes[i]; ++j) {
                    if (index > 0 && j + 1 != index) continue;
                    op = this.axes[i][j];
                    v.add2(op.normalOrAxis, this.center);
                    sb.append(drawID + "pgva").append(m).append(sglabel).append("_").appendI(j + 1).append(" width 0.05 scale ").appendD(op.type == 2 ? -scale : scale).append(" ").append(Escape.eP(v));
                    v.scaleAdd2(-2.0, op.normalOrAxis, v);
                    boolean isPA = !this.isLinear && this.principalAxis != null && op.index == this.principalAxis.index;
                    sb.append(Escape.eP(v)).append("\"").append(label).append(isPA ? "" : "").append("\" color ").append(isPA ? "red" : (op.type == 2 ? "blue" : "orange")).append(";\n");
                }
            }
            if (!haveType || type.equalsIgnoreCase(this.getConventionalName("Cs"))) {
                for (int j = 0; j < this.nAxes[0]; ++j) {
                    if (index > 0 && j + 1 != index) continue;
                    op = this.axes[0][j];
                    sb.append(drawID + "pgvp").append(m).appendI(j + 1).append("disk scale ").appendD(scaleFactor * this.radius * 2.0).append(" CIRCLE PLANE ").append(Escape.eP(this.center));
                    v.add2(op.normalOrAxis, this.center);
                    sb.append(Escape.eP(v)).append(" color translucent yellow;\n");
                    v.add2(op.normalOrAxis, this.center);
                    sb.append(drawID + "pgvp").append(m).appendI(j + 1).append("ring width 0.05 scale ").appendD(scaleFactor * this.radius * 2.0).append(" arc ").append(Escape.eP(v));
                    v.scaleAdd2(-2.0, op.normalOrAxis, v);
                    sb.append(Escape.eP(v));
                    v.add3(0.011f, 0.012f, 0.013f);
                    sb.append(Escape.eP(v)).append("{0 360 0.5} color ").append(this.principalPlane != null && op.index == this.principalPlane.index ? "red" : "blue").append(";\n");
                }
            }
            sb.append("# name=").append(name);
            sb.append(", n" + this.getConventionalName("Ci") + "=").appendI(this.haveInversionCenter ? 1 : 0);
            sb.append(", n" + this.getConventionalName("Cs") + "=").appendI(this.nAxes[0]);
            sb.append(", n" + this.getConventionalName("Cn") + "=").appendI(nType[1][0]);
            sb.append(", n" + this.getConventionalName("Sn") + "=").appendI(nType[2][0]);
            sb.append(": ");
            i = maxAxis;
            while (--i >= 2) {
                if (this.nAxes[i] <= 0) continue;
                String axisName = this.getConventionalName((i < 14 ? "S" : "C") + i % 14);
                sb.append(" n").append(axisName);
                sb.append("=").appendI(this.nAxes[i]);
            }
            sb.append(";\n");
            sb.append("print '" + name + "';\n");
            this.drawInfo = sb.toString();
            if (Logger.debugging) {
                Logger.info(this.drawInfo);
            }
            return this.drawInfo;
        }
        int n = 0;
        int nTotal = 1;
        int nElements = 0;
        String string = ctype = this.haveInversionCenter ? this.getConventionalName("Ci") : "center";
        if (this.haveInversionCenter) {
            ++nTotal;
            ++nElements;
        }
        if (asInfo) {
            if (this.center != null) {
                this.info.put(ctype, this.center);
                if (this.haveInversionCenter) {
                    this.info.put("center", this.center);
                }
                this.info.put(ctype, this.center);
            }
        } else {
            sb.append("\n\n").append(name).append("\t").append(ctype).append("\t").append(Escape.eP(this.center));
        }
        int i = maxAxis;
        while (--i >= 0) {
            if (this.nAxes[i] <= 0) continue;
            n = nUnique[i];
            String label = this.axes[i][0].getLabel(true);
            String sglabel = this.axes[i][0].getLabel(false);
            if (asInfo) {
                this.info.put("n" + sglabel, this.nAxes[i]);
            } else {
                sb.append("\n\n").append(name).append("\tn").append(label).append("\t").appendI(this.nAxes[i]).append("\t").appendI(n);
            }
            nTotal += (n *= this.nAxes[i]);
            nElements += this.nAxes[i];
            int[] nArray = nType[this.axes[i][0].type];
            nArray[1] = nArray[1] + n;
            Lst<V3d> vinfo = asInfo ? new Lst<V3d>() : null;
            Lst<M3d> minfo = asInfo ? new Lst<M3d>() : null;
            for (int j = 0; j < this.nAxes[i]; ++j) {
                Operation aop = this.axes[i][j];
                if (asInfo) {
                    vinfo.addLast(aop.normalOrAxis);
                    minfo.addLast(aop.getM3());
                    continue;
                }
                sb.append("\n").append(name).append("\t").append(sglabel).append("_").appendI(j + 1).append("\t").appendO(aop.normalOrAxis);
            }
            if (!asInfo) continue;
            this.info.put(sglabel, vinfo);
            this.info.put(sglabel + "_m", minfo);
        }
        if (!asInfo) {
            sb.append("\n");
            sb.append("\n").append(name).append("\ttype\tnElements\tnUnique");
            sb.append("\n").append(name).append("\t" + this.getConventionalName("E") + "\t  1\t  1");
            n = this.haveInversionCenter ? 1 : 0;
            sb.append("\n").append(name).append("\t" + this.getConventionalName("Ci") + "\t  ").appendI(n).append("\t  ").appendI(n);
            sb.append("\n").append(name).append("\t" + this.getConventionalName("Cs") + "\t");
            PT.rightJustify(sb, "    ", this.nAxes[0] + "\t");
            PT.rightJustify(sb, "    ", this.nAxes[0] + "\n");
            sb.append(name).append("\t" + this.getConventionalName("Cn") + "\t");
            PT.rightJustify(sb, "    ", nType[1][0] + "\t");
            PT.rightJustify(sb, "    ", nType[1][1] + "\n");
            sb.append(name).append("\t" + this.getConventionalName("Sn") + "\t");
            PT.rightJustify(sb, "    ", nType[2][0] + "\t");
            PT.rightJustify(sb, "    ", nType[2][1] + "\n");
            sb.append(name).append("\t\tTOTAL\t");
            PT.rightJustify(sb, "    ", nTotal + "\n");
            this.textInfo = sb.toString();
            return this.textInfo;
        }
        this.info.put("name", this.name);
        this.info.put("hmName", this.getHermannMauguinName());
        this.info.put("nAtoms", this.nAtoms);
        this.info.put("nTotal", nTotal);
        this.info.put("nElements", nElements);
        this.info.put("nCi", this.haveInversionCenter ? 1 : 0);
        if (this.haveInversionCenter) {
            this.info.put("Ci_m", M3d.newM3(mInv));
        }
        this.info.put("nCs", this.nAxes[0]);
        this.info.put("nCn", nType[1][0]);
        this.info.put("nSn", nType[2][0]);
        this.info.put("distanceTolerance", this.distanceTolerance);
        this.info.put("linearTolerance", this.linearTolerance);
        this.info.put("points", this.points);
        this.info.put("detail", sb.toString().replace('\n', ';'));
        if (this.principalAxis != null && this.principalAxis.index > 0) {
            this.info.put("principalAxis", this.principalAxis.normalOrAxis);
        }
        if (this.principalPlane != null && this.principalPlane.index > 0) {
            this.info.put("principalPlane", this.principalPlane.normalOrAxis);
        }
        return this.info;
    }

    boolean isDrawType(String type, int index, double scale) {
        return this.drawInfo != null && this.drawType.equals(type == null ? "" : type) && this.drawIndex == index && this.scale == scale;
    }

    public static String getHMfromSFName(String name) {
        String hm;
        if (htSFToHM == null) {
            htSFToHM = new Hashtable<String, String>();
            String[] syms = SF2HM;
            PointGroup.addNames("E", "1");
            PointGroup.addNames("Ci", "-1");
            PointGroup.addNames("Cn", "n");
            PointGroup.addNames("Sn", "-n");
            for (int i = 0; i < syms.length; ++i) {
                String[] list = syms[i].split(",");
                String sym = list[0];
                if (list.length == 2) {
                    PointGroup.addNames(sym, list[1]);
                    continue;
                }
                String type = sym.substring(0, 1);
                String ext = sym.substring(2, sym.length());
                for (int n = 1; n < 13; ++n) {
                    String val = list[n];
                    if (val.length() <= 0) continue;
                    PointGroup.addNames(type + n + ext, val);
                    System.out.println(type + n + ext + "\t" + val);
                }
                if (list.length != 14) continue;
                PointGroup.addNames(type + "\u221e" + ext, list[13]);
            }
        }
        return (hm = htSFToHM.get(name)) == null ? name : hm;
    }

    private static void addNames(String sch, String hm) {
        htSFToHM.put(sch, hm);
        htSFToHM.put(hm, sch);
    }

    private class Operation {
        int type;
        int order;
        int index;
        V3d normalOrAxis;
        private int typeOrder;
        M3d mat;

        Operation() {
            this.index = ++PointGroup.this.nOps;
            this.type = 3;
            this.order = 1;
            this.typeOrder = 1;
            if (Logger.debugging) {
                Logger.debug("new operation -- " + typeNames[this.type]);
            }
        }

        Operation(V3d v, int i) {
            this.index = ++PointGroup.this.nOps;
            this.type = i < 14 ? 2 : 1;
            this.typeOrder = i;
            this.order = i % 14;
            this.normalOrAxis = Qd.newVA(v, 180.0).getNormal();
            if (Logger.debugging) {
                Logger.debug("new operation -- " + (this.order == i ? "S" : "C") + this.order + " " + this.normalOrAxis);
            }
        }

        Operation(V3d v) {
            if (v == null) {
                return;
            }
            this.index = ++PointGroup.this.nOps;
            this.type = 0;
            this.normalOrAxis = Qd.newVA(v, 180.0).getNormal();
            if (Logger.debugging) {
                Logger.debug("new operation -- plane " + this.normalOrAxis);
            }
        }

        String getLabel(boolean conventional) {
            String s;
            switch (this.type) {
                case 0: {
                    s = "Cs";
                    break;
                }
                case 2: {
                    s = "S" + this.order;
                    break;
                }
                default: {
                    s = "C" + this.order;
                }
            }
            return conventional ? PointGroup.this.getConventionalName(s) : s;
        }

        public M3d getM3() {
            if (this.mat != null) {
                return this.mat;
            }
            M3d m = M3d.newM3(PointGroup.getQuaternion(this.normalOrAxis, this.typeOrder).getMatrix());
            if (this.type == 0 || this.type == 2) {
                m.mul(mInv);
            }
            m.clean();
            this.mat = m;
            return this.mat;
        }

        public String toString() {
            return this.getLabel(false) + " " + this.normalOrAxis;
        }
    }
}

