/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.M4d;
import javajs.util.P3d;
import javajs.util.P3i;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3d;
import javajs.util.V3d;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.modelset.Atom;
import org.jmol.script.T;
import org.jmol.shape.Mesh;
import org.jmol.shapesurface.PMeshWriter;
import org.jmol.util.C;
import org.jmol.util.ColorEncoder;
import org.jmol.util.GData;
import org.jmol.util.Logger;
import org.jmol.util.MeshSurface;
import org.jmol.util.SimpleUnitCell;
import org.jmol.viewer.Viewer;

public class IsosurfaceMesh
extends Mesh {
    public JvxlData jvxlData;
    public int vertexIncrement = 1;
    public int firstRealVertex = -1;
    public int dataType;
    public boolean hasGridPoints;
    Object calculatedArea;
    Object calculatedVolume;
    Object info;
    private Map<Integer, Integer> assocGridPointMap;
    private Map<Integer, V3d> assocGridPointNormals;
    private int mergeAssociatedNormalCount;
    P3d[] centers;
    double[] contourValues;
    short[] contourColixes;
    public ColorEncoder colorEncoder;
    BS bsVdw;
    public boolean colorPhased;
    public double[] probeValues;

    @Override
    public double getResolution() {
        return 1.0 / this.jvxlData.pointsPerAngstrom;
    }

    IsosurfaceMesh(Viewer vwr, String thisID, short colix, int index) {
        this.mesh1(vwr, thisID, colix, index);
        this.jvxlData = new JvxlData();
        this.checkByteCount = 2;
        this.jvxlData.version = Viewer.getJmolVersion();
    }

    void clearType(String meshType, boolean iAddGridPoints) {
        this.clear(meshType);
        this.jvxlData.clear();
        this.assocGridPointMap = null;
        this.assocGridPointNormals = null;
        this.bsVdw = null;
        this.calculatedVolume = null;
        this.calculatedArea = null;
        this.centers = null;
        this.colorEncoder = null;
        this.colorPhased = false;
        this.colorsExplicit = false;
        this.firstRealVertex = -1;
        this.hasGridPoints = iAddGridPoints;
        this.isColorSolid = true;
        this.mergeAssociatedNormalCount = 0;
        this.nSets = 0;
        this.pcs = null;
        this.showPoints = iAddGridPoints;
        this.surfaceSet = null;
        this.vcs = null;
        this.vertexColorMap = null;
        this.vertexIncrement = 1;
        this.vertexSets = null;
        this.vvs = null;
    }

    void allocVertexColixes() {
        if (this.vcs == null) {
            this.vcs = new short[this.vc];
            int i = this.vc;
            while (--i >= 0) {
                this.vcs[i] = this.colix;
            }
        }
        this.isColorSolid = false;
    }

    int addVertexCopy(T3d vertex, double value, int assocVertex, boolean associateNormals, boolean asCopy) {
        int vPt = this.addVCVal(vertex, value, asCopy);
        switch (assocVertex) {
            case -1: {
                if (this.firstRealVertex >= 0) break;
                this.firstRealVertex = vPt;
                break;
            }
            case -2: {
                this.hasGridPoints = true;
                break;
            }
            case -3: {
                this.vertexIncrement = 3;
                break;
            }
            default: {
                if (this.firstRealVertex < 0) {
                    this.firstRealVertex = vPt;
                }
                if (!associateNormals) break;
                if (this.assocGridPointMap == null) {
                    this.assocGridPointMap = new Hashtable<Integer, Integer>();
                }
                this.assocGridPointMap.put(vPt, assocVertex + this.mergeAssociatedNormalCount);
            }
        }
        return vPt;
    }

    @Override
    public void setTranslucent(boolean isTranslucent, double iLevel) {
        this.colix = C.getColixTranslucent3(this.colix, isTranslucent, iLevel);
        if (this.vcs != null) {
            int i = this.vc;
            while (--i >= 0) {
                this.vcs[i] = C.getColixTranslucent3(this.vcs[i], isTranslucent, iLevel);
            }
        }
    }

    public void setMerged(boolean TF) {
        this.isMerged = TF;
        this.mergePolygonCount0 = TF ? this.pc : 0;
        int n = this.mergeVertexCount0 = TF ? this.vc : 0;
        if (TF) {
            this.mergeAssociatedNormalCount += this.jvxlData.nPointsX * this.jvxlData.nPointsY * this.jvxlData.nPointsZ;
            this.assocGridPointNormals = null;
        }
    }

    @Override
    protected void sumVertexNormals(T3d[] vertices, V3d[] vectorSums) {
        IsosurfaceMesh.sumVertexNormals2(this, vertices, vectorSums);
        if (this.assocGridPointMap != null && vectorSums.length > 0 && !this.isMerged) {
            if (this.assocGridPointNormals == null) {
                this.assocGridPointNormals = new Hashtable<Integer, V3d>();
            }
            for (Map.Entry<Integer, Integer> entry : this.assocGridPointMap.entrySet()) {
                Integer gridPoint = entry.getValue();
                if (!this.assocGridPointNormals.containsKey(gridPoint)) {
                    this.assocGridPointNormals.put(gridPoint, V3d.new3(0.0, 0.0, 0.0));
                }
                this.assocGridPointNormals.get(gridPoint).add(vectorSums[entry.getKey()]);
            }
            for (Map.Entry<Integer, Integer> entry : this.assocGridPointMap.entrySet()) {
                vectorSums[entry.getKey().intValue()] = this.assocGridPointNormals.get(entry.getValue());
            }
        }
    }

    P3d[] getCenters() {
        if (this.centers != null) {
            return this.centers;
        }
        this.centers = new P3d[this.pc];
        for (int i = 0; i < this.pc; ++i) {
            int[] p = this.pis[i];
            if (p == null) continue;
            P3d pt = this.centers[i] = P3d.newP(this.vs[p[0]]);
            pt.add(this.vs[p[1]]);
            pt.add(this.vs[p[2]]);
            pt.scale(0.3333333333333333);
        }
        return this.centers;
    }

    public Lst<Object>[] getContours() {
        int i;
        Lst<Object>[] vContours;
        int n = this.jvxlData.nContours;
        if (n == 0 || this.pis == null) {
            return null;
        }
        boolean bl = this.havePlanarContours = this.jvxlData.jvxlPlane != null;
        if (this.havePlanarContours) {
            return null;
        }
        if (n < 0) {
            n = -1 - n;
        }
        if ((vContours = this.jvxlData.vContours) != null) {
            for (int i2 = 0; i2 < n; ++i2) {
                if (vContours[i2].size() > 6) {
                    return this.jvxlData.vContours;
                }
                JvxlCoder.set3dContourVector(vContours[i2], this.pis, this.vs);
            }
            return this.jvxlData.vContours;
        }
        vContours = new Lst[n];
        for (i = 0; i < n; ++i) {
            vContours[i] = new Lst();
        }
        if (this.jvxlData.contourValuesUsed == null) {
            double dv = (this.jvxlData.valueMappedToBlue - this.jvxlData.valueMappedToRed) / (double)(n + 1);
            for (int i3 = 0; i3 < n; ++i3) {
                double value = this.jvxlData.valueMappedToRed + (double)(i3 + 1) * dv;
                IsosurfaceMesh.get3dContour(this, vContours[i3], value, this.jvxlData.contourColixes[i3]);
            }
            Logger.info(n + " contour lines; separation = " + dv);
        } else {
            for (i = 0; i < n; ++i) {
                double value = this.jvxlData.contourValuesUsed[i];
                IsosurfaceMesh.get3dContour(this, vContours[i], value, this.jvxlData.contourColixes[i]);
            }
        }
        this.jvxlData.contourColixes = new short[n];
        this.jvxlData.contourValues = new double[n];
        for (int i4 = 0; i4 < n; ++i4) {
            this.jvxlData.contourValues[i4] = ((Number)vContours[i4].get(2)).doubleValue();
            this.jvxlData.contourColixes[i4] = ((short[])vContours[i4].get(3))[0];
        }
        this.jvxlData.vContours = vContours;
        return vContours;
    }

    public Object getPmeshData(boolean isBinary) {
        PMeshWriter mw = (PMeshWriter)Interface.getInterface("org.jmol.shapesurface.PMeshWriter", this.vwr, "script");
        return mw.write(this, isBinary);
    }

    private static void get3dContour(IsosurfaceMesh m, Lst<Object> v, double value, short colix) {
        BS bsContour = BS.newN(m.pc);
        SB fData = new SB();
        int color = C.getArgb(colix);
        IsosurfaceMesh.setContourVector(v, m.pc, bsContour, value, colix, color, fData);
        for (int i = 0; i < m.pc; ++i) {
            if (m.setABC(i) == null) continue;
            IsosurfaceMesh.addContourPoints(v, bsContour, i, fData, m.vs, m.vvs, m.iA, m.iB, m.iC, value);
        }
    }

    public static void setContourVector(Lst<Object> v, int nPolygons, BS bsContour, double value, short colix, int color, SB fData) {
        v.add(0, nPolygons);
        v.add(1, bsContour);
        v.add(2, value);
        v.add(3, new short[]{colix});
        v.add(4, new int[]{color});
        v.add(5, fData);
    }

    public static void addContourPoints(Lst<Object> v, BS bsContour, int i, SB fData, T3d[] vertices, double[] vertexValues, int iA, int iB, int iC, double value) {
        double f2;
        P3d pt1 = null;
        P3d pt2 = null;
        int type = 0;
        double f1 = IsosurfaceMesh.checkPt(vertexValues, iA, iB, value);
        if (!Double.isNaN(f1)) {
            pt1 = IsosurfaceMesh.getContourPoint(vertices, iA, iB, f1);
            type |= 1;
        }
        double d = f2 = f1 == 1.0 ? Double.NaN : IsosurfaceMesh.checkPt(vertexValues, iB, iC, value);
        if (!Double.isNaN(f2)) {
            pt2 = IsosurfaceMesh.getContourPoint(vertices, iB, iC, f2);
            if (type == 0) {
                pt1 = pt2;
                f1 = f2;
            }
            type |= 2;
        }
        switch (type) {
            case 0: {
                return;
            }
            case 1: {
                if (f1 == 0.0) {
                    return;
                }
            }
            case 2: {
                double d2 = f2 = f2 == 1.0 ? Double.NaN : IsosurfaceMesh.checkPt(vertexValues, iC, iA, value);
                if (Double.isNaN(f2)) break;
                pt2 = IsosurfaceMesh.getContourPoint(vertices, iC, iA, f2);
                type |= 4;
            }
        }
        switch (type) {
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                return;
            }
        }
        bsContour.set(i);
        JvxlCoder.appendContourTriangleIntersection(type, f1, f2, fData);
        v.addLast(pt1);
        v.addLast(pt2);
    }

    private static double checkPt(double[] vertexValues, int i, int j, double v) {
        double v2;
        double v1 = vertexValues[i];
        return v == v1 ? 0.0 : (v == (v2 = vertexValues[j]) ? 1.0 : (v1 < v == v < v2 ? (v - v1) / (v2 - v1) : Double.NaN));
    }

    private static P3d getContourPoint(T3d[] vertices, int i, int j, double f) {
        P3d pt = new P3d();
        pt.sub2(vertices[j], vertices[i]);
        pt.scaleAdd2(f, pt, vertices[i]);
        return pt;
    }

    public void setDiscreteColixes(double[] values, short[] colixes) {
        if (values != null) {
            this.jvxlData.contourValues = values;
        }
        if (values == null || values.length == 0) {
            this.jvxlData.contourValues = this.jvxlData.contourValuesUsed;
            values = this.jvxlData.contourValuesUsed;
        }
        if (colixes == null && this.jvxlData.contourColixes != null) {
            colixes = this.jvxlData.contourColixes;
        } else {
            this.jvxlData.contourColixes = colixes;
            this.jvxlData.contourColors = C.getHexCodes(colixes);
        }
        if (this.vs == null || this.vvs == null || values == null) {
            return;
        }
        int n = values.length;
        double vMax = values[n - 1];
        this.colorCommand = null;
        boolean haveColixes = colixes != null && colixes.length > 0;
        boolean bl = this.isColorSolid = haveColixes && this.jvxlData.jvxlPlane != null;
        if (this.jvxlData.vContours != null) {
            if (haveColixes) {
                for (int i = 0; i < this.jvxlData.vContours.length; ++i) {
                    short colix;
                    ((short[])this.jvxlData.vContours[i].get((int)3))[0] = colix = colixes[i % colixes.length];
                    ((int[])this.jvxlData.vContours[i].get((int)4))[0] = C.getArgb(colix);
                }
            }
            return;
        }
        short defaultColix = 0;
        this.pcs = new short[this.pc];
        this.colorsExplicit = false;
        block1: for (int i = 0; i < this.pc; ++i) {
            int[] p = this.pis[i];
            if (p == null) continue;
            this.pcs[i] = defaultColix;
            double v = (this.vvs[p[0]] + this.vvs[p[1]] + this.vvs[p[2]]) / 3.0;
            int j = n;
            while (--j >= 0) {
                if (!(v >= values[j]) || !(v < vMax)) continue;
                this.pcs[i] = haveColixes ? colixes[j % colixes.length] : (short)0;
                continue block1;
            }
        }
    }

    Map<String, Object> getContourList(Viewer vwr) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("values", this.jvxlData.contourValuesUsed == null ? this.jvxlData.contourValues : this.jvxlData.contourValuesUsed);
        Lst<P3d> colors = new Lst<P3d>();
        if (this.jvxlData.contourColixes != null) {
            for (int i = 0; i < this.jvxlData.contourColixes.length; ++i) {
                colors.addLast(CU.colorPtFromInt(C.getArgb(this.jvxlData.contourColixes[i]), null));
            }
            ht.put("colors", colors);
        }
        return ht;
    }

    void deleteContours() {
        this.jvxlData.contourValuesUsed = null;
        this.jvxlData.contourValues = null;
        this.jvxlData.contourColixes = null;
        this.jvxlData.vContours = null;
    }

    void setVertexColorMap() {
        this.vertexColorMap = new Hashtable();
        short lastColix = -999;
        BS bs = null;
        int i = this.vc;
        while (--i >= 0) {
            String color;
            short c = this.vcs[i];
            if (c != lastColix && (bs = (BS)this.vertexColorMap.get(color = C.getHexCode(lastColix = c))) == null) {
                bs = new BS();
                this.vertexColorMap.put(color, bs);
            }
            bs.set(i);
        }
    }

    void setVertexColixesForAtoms(Viewer vwr, short[] colixes, int[] atomMap, BS bs) {
        this.jvxlData.vertexDataOnly = true;
        this.jvxlData.vertexColors = new int[this.vc];
        this.jvxlData.nVertexColors = this.vc;
        Atom[] atoms = vwr.ms.at;
        GData gdata = vwr.gdata;
        for (int i = this.mergeVertexCount0; i < this.vc; ++i) {
            short colix;
            int iAtom = this.vertexSource[i];
            if (iAtom < 0 || !bs.get(iAtom)) continue;
            this.vcs[i] = C.copyColixTranslucency(this.colix, atoms[iAtom].colixAtom);
            this.jvxlData.vertexColors[i] = gdata.getColorArgbOrGray(this.vcs[i]);
            short s = colix = colixes == null ? (short)0 : colixes[atomMap[iAtom]];
            if (colix == 0) {
                colix = atoms[iAtom].colixAtom;
            }
            this.vcs[i] = C.copyColixTranslucency(this.colix, colix);
        }
    }

    void colorVertices(short colix, BS bs, boolean isAtoms) {
        int i;
        if (this.vertexSource == null) {
            return;
        }
        colix = C.copyColixTranslucency(this.colix, colix);
        BS bsVertices = isAtoms ? new BS() : bs;
        this.checkAllocColixes();
        if (isAtoms) {
            for (i = 0; i < this.vc; ++i) {
                int pt = this.vertexSource[i];
                if (pt < 0 || !bs.get(pt)) continue;
                this.vcs[i] = colix;
                if (bsVertices == null) continue;
                bsVertices.set(i);
            }
        } else {
            for (i = 0; i < this.vc; ++i) {
                if (!bsVertices.get(i)) continue;
                this.vcs[i] = colix;
            }
        }
        if (!isAtoms) {
            return;
        }
        String color = C.getHexCode(colix);
        if (this.vertexColorMap == null) {
            this.vertexColorMap = new Hashtable();
        }
        IsosurfaceMesh.addColorToMap(this.vertexColorMap, color, bs);
    }

    void checkAllocColixes() {
        if (this.vcs == null || this.vertexColorMap == null && this.isColorSolid) {
            this.allocVertexColixes();
        }
        this.isColorSolid = false;
    }

    private static void addColorToMap(Map<String, BS> colorMap, String color, BS bs) {
        BS bsMap = null;
        for (Map.Entry<String, BS> entry : colorMap.entrySet()) {
            if (entry.getKey() == color) {
                bsMap = entry.getValue();
                bsMap.or(bs);
                continue;
            }
            entry.getValue().andNot(bs);
        }
        if (bsMap == null) {
            colorMap.put(color, bs);
        }
    }

    void setJvxlColorMap(boolean isAll) {
        this.jvxlData.diameter = this.diameter;
        this.jvxlData.color = C.getHexCode(this.colix);
        this.jvxlData.meshColor = this.meshColix == 0 ? null : C.getHexCode(this.meshColix);
        this.jvxlData.translucency = (this.colix & 0x7800) == 30720 ? -1.0 : C.getColixTranslucencyFractional(this.colix);
        this.jvxlData.rendering = this.getRendering().substring(1);
        String string = this.jvxlData.colorScheme = this.colorEncoder == null ? null : this.colorEncoder.getColorScheme();
        if (this.jvxlData.vertexColors == null) {
            int n = this.jvxlData.nVertexColors = this.vertexColorMap == null ? 0 : this.vertexColorMap.size();
        }
        if (this.vertexColorMap == null || this.vertexSource == null || !isAll) {
            return;
        }
        if (this.jvxlData.vertexColorMap == null) {
            this.jvxlData.vertexColorMap = new Hashtable<String, BS>();
        }
        for (Map.Entry entry : this.vertexColorMap.entrySet()) {
            BS bsMap = (BS)entry.getValue();
            if (bsMap.isEmpty()) continue;
            String color = (String)entry.getKey();
            BS bs = new BS();
            for (int i = 0; i < this.vc; ++i) {
                if (!bsMap.get(this.vertexSource[i])) continue;
                bs.set(i);
            }
            IsosurfaceMesh.addColorToMap(this.jvxlData.vertexColorMap, color, bs);
        }
        this.jvxlData.nVertexColors = this.jvxlData.vertexColorMap.size();
        if (this.jvxlData.vertexColorMap.size() == 0) {
            this.jvxlData.vertexColorMap = null;
        }
    }

    void setColorCommand() {
        if (this.colorEncoder == null || (this.colorCommand = this.colorEncoder.getColorScheme()) == null) {
            return;
        }
        if (this.colorCommand.equals("inherit")) {
            this.colorCommand = "#inherit;";
            return;
        }
        this.colorCommand = "color $" + PT.esc(this.thisID) + PT.esc(this.colorCommand) + " range " + (this.jvxlData.isColorReversed ? this.jvxlData.valueMappedToBlue + " " + this.jvxlData.valueMappedToRed : this.jvxlData.valueMappedToRed + " " + this.jvxlData.valueMappedToBlue);
    }

    boolean setColorsFromJvxlData(int colorRgb) {
        double translucencyLevel;
        this.diameter = this.jvxlData.diameter;
        if (colorRgb != -1) {
            if (colorRgb != Integer.MIN_VALUE && colorRgb != Integer.MAX_VALUE) {
                this.colix = C.getColix(colorRgb);
            } else if (this.jvxlData.color != null) {
                this.colix = C.getColixS(this.jvxlData.color);
            }
        }
        if (this.colix == 0) {
            this.colix = (short)5;
        }
        this.colix = C.getColixTranslucent3(this.colix, this.jvxlData.translucency != 0.0, this.jvxlData.translucency);
        double d = translucencyLevel = this.jvxlData.translucency == 0.0 ? Double.NaN : this.jvxlData.translucency;
        if (this.jvxlData.meshColor != null) {
            this.meshColix = C.getColixS(this.jvxlData.meshColor);
        }
        this.setJvxlDataRendering();
        boolean bl = this.isColorSolid = !this.jvxlData.isBicolorMap && this.jvxlData.vertexColors == null && this.jvxlData.vertexColorMap == null;
        if (this.colorEncoder == null) {
            return false;
        }
        if (this.jvxlData.vertexColorMap == null) {
            if (this.jvxlData.colorScheme != null) {
                String colorScheme = this.jvxlData.colorScheme;
                boolean isTranslucent = colorScheme.startsWith("translucent ");
                if (isTranslucent) {
                    colorScheme = colorScheme.substring(12);
                    translucencyLevel = Double.NaN;
                }
                this.colorEncoder.setColorScheme(colorScheme, isTranslucent);
                this.remapColors(null, null, translucencyLevel);
            }
        } else {
            if (this.jvxlData.baseColor != null) {
                int i = this.vc;
                while (--i >= 0) {
                    this.vcs[i] = this.colix;
                }
            }
            for (Map.Entry<String, BS> entry : this.jvxlData.vertexColorMap.entrySet()) {
                BS bsMap = entry.getValue();
                short colix = C.copyColixTranslucency(this.colix, C.getColixS(entry.getKey()));
                int i = bsMap.nextSetBit(0);
                while (i >= 0) {
                    this.vcs[i] = colix;
                    i = bsMap.nextSetBit(i + 1);
                }
            }
        }
        return true;
    }

    void setJvxlDataRendering() {
        if (this.jvxlData.rendering != null) {
            String[] tokens = PT.getTokens(this.jvxlData.rendering);
            for (int i = 0; i < tokens.length; ++i) {
                this.setTokenProperty(T.getTokFromName(tokens[i]), true);
            }
        }
    }

    void remapColors(Viewer vwr, ColorEncoder ce, double translucentLevel) {
        int i;
        if (ce == null) {
            ce = this.colorEncoder;
        }
        if (ce == null) {
            ce = this.colorEncoder = new ColorEncoder(null, vwr);
        }
        this.colorEncoder = ce;
        this.setColorCommand();
        if (Double.isNaN(translucentLevel)) {
            translucentLevel = C.getColixTranslucencyLevel(this.colix);
        } else {
            this.colix = C.getColixTranslucent3(this.colix, true, translucentLevel);
        }
        double min = ce.lo;
        double max = ce.hi;
        boolean inherit = this.vertexSource != null && ce.currentPalette == 15;
        this.vertexColorMap = null;
        this.pcs = null;
        this.colorsExplicit = false;
        this.jvxlData.baseColor = null;
        this.jvxlData.vertexCount = this.vc;
        if (this.vvs == null || this.jvxlData.vertexCount == 0) {
            return;
        }
        if (this.vcs == null || this.vcs.length != this.vc) {
            this.allocVertexColixes();
        }
        if (inherit) {
            this.jvxlData.vertexDataOnly = true;
            this.jvxlData.vertexColors = new int[this.vc];
            this.jvxlData.nVertexColors = this.vc;
            Atom[] atoms = vwr.ms.at;
            GData gdata = vwr.gdata;
            for (int i2 = this.mergeVertexCount0; i2 < this.vc; ++i2) {
                int pt = this.vertexSource[i2];
                if (pt < 0 || pt >= atoms.length) continue;
                this.vcs[i2] = C.copyColixTranslucency(this.colix, atoms[pt].colixAtom);
                this.jvxlData.vertexColors[i2] = gdata.getColorArgbOrGray(this.vcs[i2]);
            }
            return;
        }
        this.jvxlData.vertexColors = null;
        this.jvxlData.vertexColorMap = null;
        if (this.jvxlData.isBicolorMap) {
            for (int i3 = this.mergeVertexCount0; i3 < this.vc; ++i3) {
                this.vcs[i3] = C.copyColixTranslucency(this.colix, this.vvs[i3] < 0.0 ? this.jvxlData.minColorIndex : this.jvxlData.maxColorIndex);
            }
            return;
        }
        this.jvxlData.isColorReversed = ce.isReversed;
        if (max != Double.MAX_VALUE) {
            this.jvxlData.valueMappedToRed = min;
            this.jvxlData.valueMappedToBlue = max;
        }
        ce.setRange(this.jvxlData.valueMappedToRed, this.jvxlData.valueMappedToBlue, this.jvxlData.isColorReversed);
        boolean isTranslucent = C.isColixTranslucent(this.colix);
        if (ce.isTranslucent) {
            if (!isTranslucent) {
                this.colix = C.getColixTranslucent3(this.colix, true, 0.5);
            }
            isTranslucent = false;
        }
        this.vcs = AU.ensureLengthShort(this.vcs, this.vc);
        int i4 = this.vc;
        while (--i4 >= this.mergeVertexCount0) {
            this.vcs[i4] = ce.getColorIndex(this.vvs[i4]);
        }
        this.setTranslucent(isTranslucent, translucentLevel);
        this.colorEncoder = ce;
        Lst<Object>[] contours = this.getContours();
        if (contours != null) {
            i = contours.length;
            while (--i >= 0) {
                double value = ((Number)contours[i].get(2)).doubleValue();
                short[] colix = (short[])contours[i].get(3);
                colix[0] = ce.getColorIndex(value);
                int[] color = (int[])contours[i].get(4);
                color[0] = C.getArgb(colix[0]);
            }
        }
        if (this.contourValues != null) {
            this.contourColixes = new short[this.contourValues.length];
            for (i = 0; i < this.contourValues.length; ++i) {
                this.contourColixes[i] = ce.getColorIndex(this.contourValues[i]);
            }
            this.setDiscreteColixes(null, null);
        }
        this.jvxlData.isJvxlPrecisionColor = true;
        JvxlCoder.jvxlCreateColorData(this.jvxlData, this.vvs);
        this.setColorCommand();
        this.isColorSolid = false;
    }

    public void reinitializeLightingAndColor(Viewer vwr) {
        this.initialize(this.lighting, null, null);
        if (this.colorEncoder != null || this.jvxlData.isBicolorMap) {
            this.vcs = null;
            this.remapColors(vwr, null, Double.NaN);
        }
    }

    @Override
    public P3d[] getBoundingBox() {
        return this.jvxlData.boundingBox;
    }

    @Override
    public void setBoundingBox(P3d[] pts) {
        this.jvxlData.boundingBox = pts;
    }

    protected void merge(MeshData m) {
        int nV = this.vc + (m == null ? 0 : m.vc);
        if (this.pis == null) {
            this.pis = new int[0][0];
        }
        if (m != null && m.pis == null) {
            m.pis = new int[0][0];
        }
        int nP = (this.bsSlabDisplay == null || this.pc == 0 ? this.pc : this.bsSlabDisplay.cardinality()) + (m == null || m.pc == 0 ? 0 : (m.bsSlabDisplay == null ? m.pc : m.bsSlabDisplay.cardinality()));
        if (this.vs == null) {
            this.vs = new P3d[0];
        }
        this.vs = (T3d[])AU.ensureLength(this.vs, nV);
        this.vvs = AU.ensureLengthD(this.vvs, nV);
        boolean haveSources = this.vertexSource != null && (m == null || m.vertexSource != null);
        this.vertexSource = AU.ensureLengthI(this.vertexSource, nV);
        int[][] newPolygons = AU.newInt2(nP);
        int ipt = IsosurfaceMesh.mergePolygons(this, 0, 0, newPolygons);
        if (m != null) {
            ipt = IsosurfaceMesh.mergePolygons(m, ipt, this.vc, newPolygons);
            int i = 0;
            while (i < m.vc) {
                this.vs[this.vc] = m.vs[i];
                this.vvs[this.vc] = m.vvs[i];
                if (haveSources) {
                    this.vertexSource[this.vc] = m.vertexSource[i];
                }
                ++i;
                ++this.vc;
            }
        }
        this.pc = this.polygonCount0 = nP;
        this.vc = this.vertexCount0 = nV;
        if (nP > 0) {
            this.resetSlab();
        }
        this.pis = newPolygons;
    }

    private static int mergePolygons(MeshSurface m, int ipt, int vertexCount, int[][] newPolygons) {
        for (int i = 0; i < m.pc; ++i) {
            int[] p = m.pis[i];
            if (p == null || m.bsSlabDisplay != null && !m.bsSlabDisplay.get(i)) continue;
            newPolygons[ipt++] = m.pis[i];
            if (vertexCount <= 0) continue;
            int j = 0;
            while (j < 3) {
                int n = j++;
                p[n] = p[n] + vertexCount;
            }
        }
        return ipt;
    }

    @Override
    public SymmetryInterface getUnitCell() {
        return this.unitCell != null || (this.unitCell = this.vwr.ms.am[this.modelIndex].biosymmetry) != null || (this.unitCell = this.vwr.ms.getUnitCell(this.modelIndex)) != null || this.oabc != null && (this.unitCell = this.vwr.getSymTemp().getUnitCell(this.oabc, true, null)) != null ? this.unitCell : null;
    }

    void fixLattice() {
        if (this.getUnitCell() == null) {
            return;
        }
        P3i minXYZ = new P3i();
        P3i maxXYZ = P3i.new3((int)this.lattice.x, (int)this.lattice.y, (int)this.lattice.z);
        this.jvxlData.fixedLattice = this.lattice;
        this.lattice = null;
        SimpleUnitCell.setMinMaxLatticeParameters((int)this.unitCell.getUnitCellInfoType(6), minXYZ, maxXYZ, 0);
        int nCells = (maxXYZ.x - minXYZ.x) * (maxXYZ.y - minXYZ.y) * (maxXYZ.z - minXYZ.z);
        P3d latticeOffset = new P3d();
        int vc0 = this.vc;
        int vcNew = nCells * this.vc;
        this.vs = AU.arrayCopyPt(this.vs, vcNew);
        this.vvs = this.vvs == null ? null : AU.ensureLengthD(this.vvs, vcNew);
        int pc0 = this.pc;
        int pcNew = nCells * this.pc;
        this.pis = AU.arrayCopyII(this.pis, pcNew);
        int off = 0;
        this.normixes = AU.arrayCopyShort(this.normixes, vcNew);
        for (int tx = minXYZ.x; tx < maxXYZ.x; ++tx) {
            for (int ty = minXYZ.y; ty < maxXYZ.y; ++ty) {
                for (int tz = minXYZ.z; tz < maxXYZ.z; ++tz) {
                    int i;
                    if (tx == 0 && ty == 0 && tz == 0) continue;
                    latticeOffset.set(tx, ty, tz);
                    this.unitCell.toCartesian(latticeOffset, false);
                    for (i = 0; i < vc0; ++i) {
                        this.normixes[this.vc] = this.normixes[i];
                        P3d v = P3d.newP(this.vs[i]);
                        v.add(latticeOffset);
                        this.addVCVal(v, this.vvs[i], false);
                    }
                    off += vc0;
                    for (i = 0; i < pc0; ++i) {
                        int[] p = AU.arrayCopyI(this.pis[i], -1);
                        p[0] = p[0] + off;
                        p[1] = p[1] + off;
                        p[2] = p[2] + off;
                        this.addPolygon(p, null);
                    }
                }
            }
        }
        P3d xyzMin = new P3d();
        P3d xyzMax = new P3d();
        this.setBox(xyzMin, xyzMax);
        this.jvxlData.boundingBox = new P3d[]{xyzMin, xyzMax};
    }

    @Override
    protected double getMinDistance2ForVertexGrouping() {
        double d2;
        if (this.jvxlData.boundingBox != null && this.jvxlData.boundingBox[0] != null && (d2 = this.jvxlData.boundingBox[1].distanceSquared(this.jvxlData.boundingBox[0])) < 5.0) {
            return 1.0E-10;
        }
        return 1.0E-8;
    }

    @Override
    public BS getVisibleVertexBitSet() {
        BS bs = this.getVisibleVBS();
        if (this.jvxlData.thisSet != null) {
            for (int i = 0; i < this.vc; ++i) {
                if (this.jvxlData.thisSet.get(this.vertexSets[i])) continue;
                bs.clear(i);
            }
        }
        return bs;
    }

    public void updateCoordinates(M4d m, BS bs) {
        boolean doUpdate;
        boolean bl = doUpdate = bs == null || this.isModelConnected;
        if (!doUpdate) {
            for (int i = 0; i < this.connectedAtoms.length; ++i) {
                if (this.connectedAtoms[i] < 0 || !bs.get(this.connectedAtoms[i])) continue;
                doUpdate = true;
                break;
            }
        }
        if (!doUpdate) {
            return;
        }
        if (this.isModelConnected) {
            this.mat4 = this.vwr.ms.am[this.modelIndex].mat4;
        } else {
            if (this.mat4 == null) {
                this.mat4 = M4d.newM4(null);
            }
            this.mat4.mul2(m, this.mat4);
        }
        this.recalcAltVertices = true;
    }

    double[] getDataMinMax() {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        int i = this.vvs.length;
        while (--i >= 0) {
            double v = this.vvs[i];
            if (v < min) {
                min = v;
            }
            if (!(v > max)) continue;
            max = v;
        }
        return new double[]{min, max};
    }

    double[] getDataRange() {
        double[] dArray;
        if (this.jvxlData.jvxlPlane != null && this.colorEncoder == null) {
            dArray = null;
        } else {
            double[] dArray2 = new double[4];
            dArray2[0] = this.jvxlData.mappedDataMin;
            dArray2[1] = this.jvxlData.mappedDataMax;
            dArray2[2] = this.jvxlData.isColorReversed ? this.jvxlData.valueMappedToBlue : this.jvxlData.valueMappedToRed;
            dArray = dArray2;
            dArray2[3] = this.jvxlData.isColorReversed ? this.jvxlData.valueMappedToRed : this.jvxlData.valueMappedToBlue;
        }
        return dArray;
    }

    @Override
    public Object getInfo(boolean isAll) {
        BS bs;
        T3d[] valid;
        Hashtable info = (Hashtable)super.getInfo(isAll);
        if (isAll && (valid = this.getValidVertices(bs = new BS())) != null) {
            info.put("allVertices", info.get("vertices"));
            info.put("vertices", valid);
            Object values = info.get("vertexValues");
            if (values != null) {
                double[] v = this.getValidValues(bs);
                info.put("allValues", values);
                info.put("vertexValues", v);
            }
        }
        return info;
    }

    public double[] getValidValues(BS bs) {
        if (bs == null) {
            bs = new BS();
            this.getInvalidBS(bs);
        }
        int n = this.vc - bs.cardinality();
        double[] v = new double[n];
        int pt = 0;
        int i = bs.nextClearBit(0);
        while (i >= 0 && i < this.vc) {
            v[pt++] = this.vvs[i];
            i = bs.nextClearBit(i + 1);
        }
        return v;
    }

    public T3d[] getValidVertices(BS bs) {
        boolean allowNull;
        boolean bl = allowNull = bs != null;
        if (bs == null) {
            bs = new BS();
        }
        this.getInvalidBS(bs);
        int n = this.vc - bs.cardinality();
        if (n == this.vc && allowNull) {
            return null;
        }
        T3d[] pa = new P3d[n];
        int pt = 0;
        int i = bs.nextClearBit(0);
        while (i >= 0 && pt < n) {
            pa[pt++] = this.vs[i];
            i = bs.nextClearBit(i + 1);
        }
        return pa;
    }

    private void getInvalidBS(BS bs) {
        BS[] excluded = this.jvxlData.jvxlExcluded;
        BS invalid = excluded[1];
        BS thisSet = this.jvxlData.thisSet;
        if (invalid != null) {
            bs.or(invalid);
        }
        if (thisSet != null) {
            int i = this.vc;
            while (--i >= 0) {
                if (thisSet.get(this.vertexSets[i])) continue;
                bs.set(i);
            }
        }
    }
}

